/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.support.dispute.agent.refund;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import haveno.common.crypto.KeyRing;
import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.alert.PrivateNotificationManager;
import haveno.core.locale.Res;
import haveno.core.support.SupportType;
import haveno.core.support.dispute.Dispute;
import haveno.core.support.dispute.DisputeList;
import haveno.core.support.dispute.DisputeManager;
import haveno.core.support.dispute.DisputeSession;
import haveno.core.support.dispute.arbitration.arbitrator.ArbitratorManager;
import haveno.core.support.dispute.refund.RefundManager;
import haveno.core.support.dispute.refund.RefundSession;
import haveno.core.trade.TradeManager;
import haveno.core.user.Preferences;
import haveno.core.util.coin.CoinFormatter;
import haveno.desktop.common.view.FxmlView;
import haveno.desktop.main.overlays.popups.Popup;
import haveno.desktop.main.overlays.windows.ContractWindow;
import haveno.desktop.main.overlays.windows.DisputeSummaryWindow;
import haveno.desktop.main.overlays.windows.TradeDetailsWindow;
import haveno.desktop.main.support.dispute.agent.DisputeAgentView;

@FxmlView
public class RefundAgentView
extends DisputeAgentView {
    @Inject
    public RefundAgentView(RefundManager refundManager, KeyRing keyRing, TradeManager tradeManager, @Named(value="BTC") CoinFormatter formatter, Preferences preferences, DisputeSummaryWindow disputeSummaryWindow, PrivateNotificationManager privateNotificationManager, ContractWindow contractWindow, TradeDetailsWindow tradeDetailsWindow, AccountAgeWitnessService accountAgeWitnessService, ArbitratorManager arbitratorService, @Named(value="useDevPrivilegeKeys") boolean useDevPrivilegeKeys) {
        super((DisputeManager<? extends DisputeList<Dispute>>)refundManager, keyRing, tradeManager, formatter, preferences, disputeSummaryWindow, privateNotificationManager, contractWindow, tradeDetailsWindow, accountAgeWitnessService, arbitratorService, useDevPrivilegeKeys);
    }

    @Override
    protected SupportType getType() {
        return SupportType.REFUND;
    }

    @Override
    protected DisputeSession getConcreteDisputeChatSession(Dispute dispute) {
        return new RefundSession(dispute, this.disputeManager.isTrader(dispute));
    }

    @Override
    protected void onCloseDispute(Dispute dispute) {
        long protocolVersion = dispute.getContract().getOfferPayload().getProtocolVersion();
        if (protocolVersion >= 2L) {
            this.chatPopup.closeChat();
            this.disputeSummaryWindow.show(dispute);
        } else {
            ((Popup)new Popup().warning(Res.get((String)"support.wrongVersion", (Object[])new Object[]{protocolVersion}))).show();
        }
    }
}

