/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.support.dispute.agent;

import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.materialdesignicons.MaterialDesignIcon;
import haveno.common.crypto.KeyRing;
import haveno.common.util.Utilities;
import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.alert.PrivateNotificationManager;
import haveno.core.locale.Res;
import haveno.core.support.dispute.Dispute;
import haveno.core.support.dispute.DisputeList;
import haveno.core.support.dispute.DisputeManager;
import haveno.core.support.dispute.DisputeValidation;
import haveno.core.support.dispute.agent.MultipleHolderNameDetection;
import haveno.core.support.dispute.arbitration.arbitrator.ArbitratorManager;
import haveno.core.trade.TradeManager;
import haveno.core.user.DontShowAgainLookup;
import haveno.core.user.Preferences;
import haveno.core.util.coin.CoinFormatter;
import haveno.desktop.components.AutoTooltipTableColumn;
import haveno.desktop.main.overlays.popups.Popup;
import haveno.desktop.main.overlays.windows.ContractWindow;
import haveno.desktop.main.overlays.windows.DisputeSummaryWindow;
import haveno.desktop.main.overlays.windows.TradeDetailsWindow;
import haveno.desktop.main.support.dispute.DisputeView;
import haveno.desktop.util.FormBuilder;
import java.util.List;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.collections.ListChangeListener;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import javafx.scene.text.Text;
import org.jetbrains.annotations.NotNull;

public abstract class DisputeAgentView
extends DisputeView
implements MultipleHolderNameDetection.Listener {
    private final MultipleHolderNameDetection multipleHolderNameDetection;
    private ListChangeListener<DisputeValidation.ValidationException> validationExceptionListener;

    public DisputeAgentView(DisputeManager<? extends DisputeList<Dispute>> disputeManager, KeyRing keyRing, TradeManager tradeManager, CoinFormatter formatter, Preferences preferences, DisputeSummaryWindow disputeSummaryWindow, PrivateNotificationManager privateNotificationManager, ContractWindow contractWindow, TradeDetailsWindow tradeDetailsWindow, AccountAgeWitnessService accountAgeWitnessService, ArbitratorManager arbitratorManager, boolean useDevPrivilegeKeys) {
        super(disputeManager, keyRing, tradeManager, formatter, preferences, disputeSummaryWindow, privateNotificationManager, contractWindow, tradeDetailsWindow, accountAgeWitnessService, arbitratorManager, useDevPrivilegeKeys);
        this.multipleHolderNameDetection = new MultipleHolderNameDetection(disputeManager);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.filterTextField.setText("open");
        this.sendPrivateNotificationButton.setVisible(true);
        this.sendPrivateNotificationButton.setManaged(true);
        this.reportButton.setVisible(true);
        this.reportButton.setManaged(true);
        this.fullReportButton.setVisible(true);
        this.fullReportButton.setManaged(true);
        this.multipleHolderNameDetection.detectMultipleHolderNames();
        this.validationExceptionListener = c -> {
            c.next();
            if (c.wasAdded()) {
                this.showWarningForValidationExceptions(c.getAddedSubList());
            }
        };
    }

    protected void showWarningForValidationExceptions(List<? extends DisputeValidation.ValidationException> exceptions) {
        exceptions.stream().filter(ex -> ex.getDispute() != null).filter(ex -> !ex.getDispute().isClosed()).filter(ex -> DontShowAgainLookup.showAgain((String)this.getKey((DisputeValidation.ValidationException)ex))).forEach(ex -> ((Popup)((Popup)((Popup)new Popup().width(900.0)).warning(this.getValidationExceptionMessage((DisputeValidation.ValidationException)ex))).dontShowAgainId(this.getKey((DisputeValidation.ValidationException)ex))).show());
    }

    private String getKey(DisputeValidation.ValidationException exception) {
        Dispute dispute = exception.getDispute();
        if (dispute != null) {
            return "ValExcPopup-" + dispute.getTradeId() + "-" + dispute.getTraderId();
        }
        return "ValExcPopup-" + exception.toString();
    }

    private String getValidationExceptionMessage(DisputeValidation.ValidationException exception) {
        Dispute dispute = exception.getDispute();
        if (dispute != null && exception instanceof DisputeValidation.AddressException) {
            return this.getAddressExceptionMessage(dispute);
        }
        if (exception.getMessage() != null && !exception.getMessage().isEmpty()) {
            return exception.getMessage();
        }
        return exception.toString();
    }

    @NotNull
    private String getAddressExceptionMessage(Dispute dispute) {
        return Res.get((String)"support.warning.disputesWithInvalidDonationAddress", (Object[])new Object[]{dispute.getDonationAddressOfDelayedPayoutTx(), dispute.getTradeId(), ""});
    }

    @Override
    protected void activate() {
        super.activate();
        this.multipleHolderNameDetection.addListener((MultipleHolderNameDetection.Listener)this);
        if (this.multipleHolderNameDetection.hasSuspiciousDisputesDetected()) {
            this.suspiciousDisputeDetected();
        }
        this.disputeManager.getValidationExceptions().addListener(this.validationExceptionListener);
        this.showWarningForValidationExceptions((List<? extends DisputeValidation.ValidationException>)this.disputeManager.getValidationExceptions());
    }

    @Override
    protected void deactivate() {
        super.deactivate();
        this.multipleHolderNameDetection.removeListener((MultipleHolderNameDetection.Listener)this);
        this.disputeManager.getValidationExceptions().removeListener(this.validationExceptionListener);
    }

    public void onSuspiciousDisputeDetected() {
        this.suspiciousDisputeDetected();
    }

    @Override
    protected DisputeView.FilterResult getFilterResult(Dispute dispute, String filterString) {
        if (!dispute.getAgentPubKeyRing().equals((Object)this.keyRing.getPubKeyRing())) {
            return DisputeView.FilterResult.NO_MATCH;
        }
        return super.getFilterResult(dispute, filterString);
    }

    @Override
    protected void handleOnProcessDispute(Dispute dispute) {
        this.onCloseDispute(dispute);
    }

    @Override
    protected void setupTable() {
        super.setupTable();
        this.tableView.getColumns().add(this.getAlertColumn());
    }

    protected abstract void onCloseDispute(Dispute var1);

    private void suspiciousDisputeDetected() {
        this.alertIconLabel.setVisible(true);
        this.alertIconLabel.setManaged(true);
        this.alertIconLabel.setTooltip(new Tooltip("You have suspicious disputes where the same trader used different account holder names.\nClick for more information."));
        this.alertIconLabel.setOnMouseClicked(e -> {
            String reportForAllDisputes = this.multipleHolderNameDetection.getReportForAllDisputes();
            ((Popup)((Popup)((Popup)((Popup)new Popup().width(1100.0)).warning(this.getReportMessage(reportForAllDisputes, "traders"))).actionButtonText(Res.get((String)"shared.copyToClipboard"))).onAction(() -> Utilities.copyToClipboard((String)reportForAllDisputes))).show();
        });
    }

    private TableColumn<Dispute, Dispute> getAlertColumn() {
        AutoTooltipTableColumn<Dispute, Dispute> column = new AutoTooltipTableColumn<Dispute, Dispute>(this, "Alert"){
            {
                this.setMinWidth(50.0);
            }
        };
        column.setCellValueFactory(dispute -> new ReadOnlyObjectWrapper((Object)((Dispute)dispute.getValue())));
        column.setCellFactory(c -> new TableCell<Dispute, Dispute>(){
            Label alertIconLabel;

            public void updateItem(Dispute dispute, boolean empty) {
                if (dispute != null && !empty) {
                    if (!DisputeAgentView.this.showAlertAtDispute(dispute)) {
                        this.setGraphic(null);
                        if (this.alertIconLabel != null) {
                            this.alertIconLabel.setOnMouseClicked(null);
                        }
                        return;
                    }
                    if (this.alertIconLabel != null) {
                        this.alertIconLabel.setOnMouseClicked(null);
                    }
                    this.alertIconLabel = new Label();
                    Text icon = FormBuilder.getIconForLabel((GlyphIcons)MaterialDesignIcon.ALERT_CIRCLE_OUTLINE, "1.5em", this.alertIconLabel);
                    icon.getStyleClass().add((Object)"alert-icon");
                    HBox.setMargin((Node)this.alertIconLabel, (Insets)new Insets(4.0, 0.0, 0.0, 10.0));
                    this.alertIconLabel.setMouseTransparent(false);
                    this.setGraphic((Node)this.alertIconLabel);
                    this.alertIconLabel.setOnMouseClicked(e -> {
                        List realNameAccountInfoList = DisputeAgentView.this.multipleHolderNameDetection.getDisputesForTrader(dispute);
                        String reportForDisputeOfTrader = DisputeAgentView.this.multipleHolderNameDetection.getReportForDisputeOfTrader(realNameAccountInfoList);
                        String key = MultipleHolderNameDetection.getAckKey((Dispute)dispute);
                        ((Popup)((Popup)((Popup)((Popup)((Popup)((Popup)((Popup)new Popup().width(1100.0)).warning(DisputeAgentView.this.getReportMessage(reportForDisputeOfTrader, "this trader"))).actionButtonText(Res.get((String)"shared.copyToClipboard"))).onAction(() -> {
                            Utilities.copyToClipboard((String)reportForDisputeOfTrader);
                            if (!DontShowAgainLookup.showAgain((String)key)) {
                                this.setGraphic(null);
                            }
                        })).dontShowAgainId(key)).dontShowAgainText("Is not suspicious")).onClose(() -> {
                            if (!DontShowAgainLookup.showAgain((String)key)) {
                                this.setGraphic(null);
                            }
                        })).show();
                    });
                } else {
                    this.setGraphic(null);
                    if (this.alertIconLabel != null) {
                        this.alertIconLabel.setOnMouseClicked(null);
                    }
                }
            }
        });
        column.setComparator((o1, o2) -> Boolean.compare(this.showAlertAtDispute((Dispute)o1), this.showAlertAtDispute((Dispute)o2)));
        column.setSortable(true);
        return column;
    }

    private boolean showAlertAtDispute(Dispute dispute) {
        return DontShowAgainLookup.showAgain((String)MultipleHolderNameDetection.getAckKey((Dispute)dispute)) && !this.multipleHolderNameDetection.getDisputesForTrader(dispute).isEmpty();
    }

    private String getReportMessage(String report, String subString) {
        return "You have dispute cases where " + subString + " used different account holder names.\n\nThis might be not critical in case of small variations of the same name (e.g. first name and last name are swapped), but if the name is completely different you should request information from the trader why they used a different name and request proof that the person with the real name is aware of the trade. It can be that the trader uses the account of their wife/husband, but it also could be a case of a stolen bank account or money laundering.\n\nPlease check below the list of the names which have been detected. Search with the trade ID for the dispute case or check out the alert icon at each dispute in the list (you might need to remove the 'open' filter) and evaluate if it might be a fraudulent account (buyer role is more likely to be fraudulent). If you find suspicious disputes, please notify the developers and provide the contract json data to them so they can ban those traders.\n\n" + Utilities.toTruncatedString((Object)report, (int)700, (boolean)false);
    }

    @Override
    protected void maybeAddProcessColumnsForAgent() {
        this.tableView.getColumns().add(this.getProcessColumn());
        this.tableView.getColumns().add(this.getChatColumn());
    }

    @Override
    protected boolean senderFlag() {
        return true;
    }
}

