/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.support.dispute;

import com.jfoenix.controls.JFXBadge;
import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.materialdesignicons.MaterialDesignIcon;
import haveno.common.UserThread;
import haveno.common.crypto.KeyRing;
import haveno.common.crypto.PubKeyRing;
import haveno.common.util.Utilities;
import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.alert.PrivateNotificationManager;
import haveno.core.locale.CurrencyUtil;
import haveno.core.locale.Res;
import haveno.core.support.SupportType;
import haveno.core.support.dispute.Dispute;
import haveno.core.support.dispute.DisputeList;
import haveno.core.support.dispute.DisputeManager;
import haveno.core.support.dispute.DisputeResult;
import haveno.core.support.dispute.DisputeSession;
import haveno.core.support.dispute.agent.DisputeAgentLookupMap;
import haveno.core.support.dispute.arbitration.ArbitrationManager;
import haveno.core.support.dispute.arbitration.arbitrator.ArbitratorManager;
import haveno.core.support.dispute.mediation.MediationManager;
import haveno.core.support.messages.ChatMessage;
import haveno.core.trade.Contract;
import haveno.core.trade.HavenoUtils;
import haveno.core.trade.Trade;
import haveno.core.trade.TradeManager;
import haveno.core.user.Preferences;
import haveno.core.util.FormattingUtils;
import haveno.core.util.coin.CoinFormatter;
import haveno.desktop.common.view.ActivatableView;
import haveno.desktop.components.AutoTooltipButton;
import haveno.desktop.components.AutoTooltipLabel;
import haveno.desktop.components.AutoTooltipTableColumn;
import haveno.desktop.components.HyperlinkWithIcon;
import haveno.desktop.components.InputTextField;
import haveno.desktop.components.PeerInfoIconDispute;
import haveno.desktop.components.PeerInfoIconMap;
import haveno.desktop.main.overlays.popups.Popup;
import haveno.desktop.main.overlays.windows.ContractWindow;
import haveno.desktop.main.overlays.windows.DisputeSummaryWindow;
import haveno.desktop.main.overlays.windows.SendLogFilesWindow;
import haveno.desktop.main.overlays.windows.SendPrivateNotificationWindow;
import haveno.desktop.main.overlays.windows.TradeDetailsWindow;
import haveno.desktop.main.overlays.windows.VerifyDisputeResultSignatureWindow;
import haveno.desktop.main.support.dispute.DisputeChatPopup;
import haveno.desktop.util.DisplayUtils;
import haveno.desktop.util.FormBuilder;
import haveno.desktop.util.GUIUtil;
import haveno.network.p2p.NodeAddress;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.util.Callback;
import javafx.util.Duration;
import javax.annotation.Nullable;
import org.fxmisc.easybind.EasyBind;
import org.fxmisc.easybind.Subscription;

public abstract class DisputeView
extends ActivatableView<VBox, Void>
implements DisputeChatPopup.ChatCallback {
    protected final DisputeManager<? extends DisputeList<Dispute>> disputeManager;
    protected final KeyRing keyRing;
    private final TradeManager tradeManager;
    protected final CoinFormatter formatter;
    protected final Preferences preferences;
    protected final DisputeSummaryWindow disputeSummaryWindow;
    private final PrivateNotificationManager privateNotificationManager;
    private final ContractWindow contractWindow;
    private final TradeDetailsWindow tradeDetailsWindow;
    private final AccountAgeWitnessService accountAgeWitnessService;
    private final ArbitratorManager arbitratorManager;
    private final boolean useDevPrivilegeKeys;
    protected TableView<Dispute> tableView;
    private SortedList<Dispute> sortedList;
    protected Dispute selectedDispute;
    private Subscription selectedDisputeSubscription;
    protected FilteredList<Dispute> filteredList;
    protected InputTextField filterTextField;
    private ChangeListener<String> filterTextFieldListener;
    protected AutoTooltipButton sigCheckButton;
    protected AutoTooltipButton reOpenButton;
    protected AutoTooltipButton closeButton;
    protected AutoTooltipButton sendPrivateNotificationButton;
    protected AutoTooltipButton reportButton;
    protected AutoTooltipButton fullReportButton;
    private final Map<String, ListChangeListener<ChatMessage>> disputeChatMessagesListeners = new HashMap<String, ListChangeListener<ChatMessage>>();
    @Nullable
    private ListChangeListener<Dispute> disputesListener;
    protected Label alertIconLabel;
    protected TableColumn<Dispute, Dispute> stateColumn;
    private Map<String, ListChangeListener<ChatMessage>> listenerByDispute = new HashMap<String, ListChangeListener<ChatMessage>>();
    private Map<String, Button> chatButtonByDispute = new HashMap<String, Button>();
    private Map<String, JFXBadge> chatBadgeByDispute = new HashMap<String, JFXBadge>();
    private Map<String, JFXBadge> newBadgeByDispute = new HashMap<String, JFXBadge>();
    private final PeerInfoIconMap avatarMap = new PeerInfoIconMap();
    protected DisputeChatPopup chatPopup;

    public DisputeView(DisputeManager<? extends DisputeList<Dispute>> disputeManager, KeyRing keyRing, TradeManager tradeManager, CoinFormatter formatter, Preferences preferences, DisputeSummaryWindow disputeSummaryWindow, PrivateNotificationManager privateNotificationManager, ContractWindow contractWindow, TradeDetailsWindow tradeDetailsWindow, AccountAgeWitnessService accountAgeWitnessService, ArbitratorManager arbitratorManager, boolean useDevPrivilegeKeys) {
        this.disputeManager = disputeManager;
        this.keyRing = keyRing;
        this.tradeManager = tradeManager;
        this.formatter = formatter;
        this.preferences = preferences;
        this.disputeSummaryWindow = disputeSummaryWindow;
        this.privateNotificationManager = privateNotificationManager;
        this.contractWindow = contractWindow;
        this.tradeDetailsWindow = tradeDetailsWindow;
        this.accountAgeWitnessService = accountAgeWitnessService;
        this.arbitratorManager = arbitratorManager;
        this.useDevPrivilegeKeys = useDevPrivilegeKeys;
        this.chatPopup = new DisputeChatPopup(disputeManager, formatter, preferences, this);
    }

    @Override
    public void initialize() {
        this.filterTextField = new InputTextField();
        this.filterTextField.setPromptText(Res.get((String)"shared.filter"));
        Tooltip tooltip = new Tooltip();
        tooltip.setShowDelay(Duration.millis((double)100.0));
        tooltip.setShowDuration(Duration.seconds((double)10.0));
        this.filterTextField.setTooltip(tooltip);
        this.filterTextFieldListener = (observable, oldValue, newValue) -> this.applyFilteredListPredicate(this.filterTextField.getText());
        HBox.setHgrow((Node)this.filterTextField, (Priority)Priority.ALWAYS);
        this.alertIconLabel = new Label();
        Text icon = FormBuilder.getIconForLabel((GlyphIcons)MaterialDesignIcon.ALERT_CIRCLE_OUTLINE, "2em", this.alertIconLabel);
        icon.getStyleClass().add((Object)"alert-icon");
        HBox.setMargin((Node)this.alertIconLabel, (Insets)new Insets(4.0, 0.0, 0.0, 10.0));
        this.alertIconLabel.setMouseTransparent(false);
        this.alertIconLabel.setVisible(false);
        this.alertIconLabel.setManaged(false);
        this.reOpenButton = new AutoTooltipButton(Res.get((String)"support.reOpenButton.label"));
        this.reOpenButton.setDisable(true);
        this.reOpenButton.setVisible(false);
        this.reOpenButton.setManaged(false);
        HBox.setHgrow((Node)this.reOpenButton, (Priority)Priority.NEVER);
        this.reOpenButton.setOnAction(e -> this.reOpenDisputeFromButton());
        this.closeButton = new AutoTooltipButton(Res.get((String)"support.closeTicket"));
        this.closeButton.setDisable(true);
        this.closeButton.setVisible(false);
        this.closeButton.setManaged(false);
        HBox.setHgrow((Node)this.closeButton, (Priority)Priority.NEVER);
        this.closeButton.setOnAction(e -> this.closeDisputeFromButton());
        this.sendPrivateNotificationButton = new AutoTooltipButton(Res.get((String)"support.sendNotificationButton.label"));
        this.sendPrivateNotificationButton.setDisable(true);
        this.sendPrivateNotificationButton.setVisible(false);
        this.sendPrivateNotificationButton.setManaged(false);
        HBox.setHgrow((Node)this.sendPrivateNotificationButton, (Priority)Priority.NEVER);
        this.sendPrivateNotificationButton.setOnAction(e -> this.sendPrivateNotification());
        this.reportButton = new AutoTooltipButton(Res.get((String)"support.reportButton.label"));
        this.reportButton.setVisible(false);
        this.reportButton.setManaged(false);
        HBox.setHgrow((Node)this.reportButton, (Priority)Priority.NEVER);
        this.reportButton.setOnAction(e -> this.showCompactReport());
        this.fullReportButton = new AutoTooltipButton(Res.get((String)"support.fullReportButton.label"));
        this.fullReportButton.setVisible(false);
        this.fullReportButton.setManaged(false);
        HBox.setHgrow((Node)this.fullReportButton, (Priority)Priority.NEVER);
        this.fullReportButton.setOnAction(e -> this.showFullReport());
        this.sigCheckButton = new AutoTooltipButton(Res.get((String)"support.sigCheck.button"));
        HBox.setHgrow((Node)this.sigCheckButton, (Priority)Priority.NEVER);
        this.sigCheckButton.setOnAction(e -> new VerifyDisputeResultSignatureWindow(this.arbitratorManager).show());
        Pane spacer = new Pane();
        HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
        HBox filterBox = new HBox();
        filterBox.setSpacing(5.0);
        filterBox.getChildren().addAll((Object[])new Node[]{this.filterTextField, this.alertIconLabel, spacer, this.reOpenButton, this.closeButton, this.sendPrivateNotificationButton, this.reportButton, this.fullReportButton, this.sigCheckButton});
        VBox.setVgrow((Node)filterBox, (Priority)Priority.NEVER);
        this.tableView = new TableView();
        GUIUtil.applyTableStyle(this.tableView);
        VBox.setVgrow(this.tableView, (Priority)Priority.SOMETIMES);
        this.tableView.setMinHeight(150.0);
        ((VBox)this.root).getChildren().addAll((Object[])new Node[]{filterBox, this.tableView});
        this.setupTable();
    }

    @Override
    protected void activate() {
        this.filterTextField.textProperty().addListener(this.filterTextFieldListener);
        ObservableList disputesAsObservableList = this.disputeManager.getDisputesAsObservableList();
        this.filteredList = new FilteredList(disputesAsObservableList);
        this.applyFilteredListPredicate(this.filterTextField.getText());
        this.sortedList = new SortedList(this.filteredList);
        this.sortedList.comparatorProperty().bind((ObservableValue)this.tableView.comparatorProperty());
        this.tableView.setItems(this.sortedList);
        this.tableView.setRowFactory(tv -> {
            TableRow row = new TableRow();
            row.setOnMouseClicked(event -> {
                if (event.getClickCount() == 2 && !row.isEmpty()) {
                    if (!this.canViewChatMessages((Dispute)row.getItem())) {
                        return;
                    }
                    this.openChat((Dispute)row.getItem());
                }
            });
            return row;
        });
        this.selectedDisputeSubscription = EasyBind.subscribe((ObservableValue)this.tableView.getSelectionModel().selectedItemProperty(), this::onSelectDispute);
        Dispute selectedItem = (Dispute)this.tableView.getSelectionModel().getSelectedItem();
        if (selectedItem != null) {
            this.tableView.getSelectionModel().select((Object)selectedItem);
        } else if (this.sortedList.size() > 0) {
            this.tableView.getSelectionModel().select(0);
        }
        GUIUtil.requestFocus(this.tableView);
    }

    @Override
    protected void deactivate() {
        this.filterTextField.textProperty().removeListener(this.filterTextFieldListener);
        this.sortedList.comparatorProperty().unbind();
        this.selectedDisputeSubscription.unsubscribe();
    }

    protected void setupReOpenDisputeListener() {
        this.disputesListener = c -> {
            c.next();
            if (c.wasAdded()) {
                this.onDisputesAdded(c.getAddedSubList());
            } else if (c.wasRemoved()) {
                this.onDisputesRemoved(c.getRemoved());
            }
        };
    }

    protected void activateReOpenDisputeListener() {
        this.onDisputesAdded((List<? extends Dispute>)this.disputeManager.getDisputesAsObservableList());
        this.disputeManager.getDisputesAsObservableList().addListener(this.disputesListener);
        this.disputeManager.getDisputesAsObservableList().forEach(dispute -> {
            ObservableList chatMessages;
            if (dispute.isClosed() && !(chatMessages = dispute.getChatMessages()).isEmpty() && !((ChatMessage)chatMessages.get(chatMessages.size() - 1)).isResultMessage(dispute) && dispute.unreadMessageCount(this.senderFlag()) > 0L) {
                this.onSelectDispute((Dispute)dispute);
                this.reOpenDispute();
            }
        });
    }

    protected void deactivateReOpenDisputeListener() {
        this.onDisputesRemoved((List<? extends Dispute>)this.disputeManager.getDisputesAsObservableList());
        this.disputeManager.getDisputesAsObservableList().removeListener(this.disputesListener);
    }

    protected abstract SupportType getType();

    protected abstract DisputeSession getConcreteDisputeChatSession(Dispute var1);

    protected abstract boolean senderFlag();

    protected void applyFilteredListPredicate(String filterString) {
        AtomicReference<FilterResult> filterResult = new AtomicReference<FilterResult>(FilterResult.NO_FILTER);
        this.filteredList.setPredicate(dispute -> {
            filterResult.set(this.getFilterResult((Dispute)dispute, filterString));
            return filterResult.get() != FilterResult.NO_MATCH;
        });
        if (filterResult.get() == FilterResult.NO_MATCH) {
            this.filterTextField.getTooltip().setText("No matches found");
        } else if (filterResult.get() == FilterResult.NO_FILTER) {
            this.filterTextField.getTooltip().setText("No filter applied");
        } else if (filterResult.get() == FilterResult.OPEN_DISPUTES) {
            this.filterTextField.getTooltip().setText("Show all open disputes");
        } else {
            this.filterTextField.getTooltip().setText("Data matching filter string: " + filterResult.get().getDisplayString());
        }
    }

    protected FilterResult getFilterResult(Dispute dispute, String filterTerm) {
        String filter = filterTerm.toLowerCase();
        if (filter.isEmpty()) {
            return FilterResult.NO_FILTER;
        }
        if (filter.equalsIgnoreCase("open")) {
            return !dispute.isClosed() || dispute.unreadMessageCount(this.senderFlag()) > 0L ? FilterResult.OPEN_DISPUTES : FilterResult.NO_MATCH;
        }
        if (dispute.getTradeId().toLowerCase().contains(filter)) {
            return FilterResult.TRADE_ID;
        }
        if (DisplayUtils.formatDate(dispute.getOpeningDate()).toLowerCase().contains(filter)) {
            return FilterResult.OPENING_DATE;
        }
        if (dispute.getContract().getBuyerNodeAddress().getFullAddress().contains(filter)) {
            return FilterResult.BUYER_NODE_ADDRESS;
        }
        if (dispute.getContract().getSellerNodeAddress().getFullAddress().contains(filter)) {
            return FilterResult.SELLER_NODE_ADDRESS;
        }
        if (dispute.getBuyerPaymentAccountPayload() != null && dispute.getBuyerPaymentAccountPayload().getPaymentDetails().toLowerCase().contains(filter)) {
            return FilterResult.BUYER_ACCOUNT_DETAILS;
        }
        if (dispute.getSellerPaymentAccountPayload() != null && dispute.getSellerPaymentAccountPayload().getPaymentDetails().toLowerCase().contains(filter)) {
            return FilterResult.SELLER_ACCOUNT_DETAILS;
        }
        if (dispute.getPayoutTxId() != null && dispute.getPayoutTxId().contains(filter)) {
            return FilterResult.PAYOUT_TX;
        }
        if (dispute.getDelayedPayoutTxId() != null && dispute.getDelayedPayoutTxId().contains(filter)) {
            return FilterResult.DEL_PAYOUT_TX;
        }
        DisputeResult disputeResult = (DisputeResult)dispute.getDisputeResultProperty().get();
        if (disputeResult != null) {
            ChatMessage chatMessage = disputeResult.getChatMessage();
            if (chatMessage != null && chatMessage.getMessage().toLowerCase().contains(filter)) {
                return FilterResult.RESULT_MESSAGE;
            }
            if (disputeResult.getReason().name().toLowerCase().contains(filter)) {
                return FilterResult.REASON;
            }
        }
        if (dispute.getContractAsJson().toLowerCase().contains(filter)) {
            return FilterResult.JSON;
        }
        return FilterResult.NO_MATCH;
    }

    protected void reOpenDisputeFromButton() {
        this.reOpenDispute();
        this.disputeManager.addMediationReOpenedMessage(this.selectedDispute, false);
    }

    protected void closeDisputeFromButton() {
        Optional tradeOptional = this.disputeManager.findTrade(this.selectedDispute);
        if (tradeOptional.isPresent() && ((Trade)tradeOptional.get()).getPayoutTxId() != null && ((Trade)tradeOptional.get()).getPayoutTxId().length() > 0) {
            this.selectedDispute.setIsClosed();
            this.disputeManager.requestPersistence();
            this.onSelectDispute(this.selectedDispute);
        } else {
            ((Popup)new Popup().warning(Res.get((String)"support.warning.traderCloseOwnDisputeWarning"))).show();
        }
    }

    protected void handleOnProcessDispute(Dispute dispute) {
    }

    protected void reOpenDispute() {
        if (this.selectedDispute != null && this.selectedDispute.isClosed()) {
            this.selectedDispute.reOpen();
            this.handleOnProcessDispute(this.selectedDispute);
            this.disputeManager.requestPersistence();
            this.onSelectDispute(this.selectedDispute);
        }
    }

    protected void onOpenContract(Dispute dispute) {
        dispute.setDisputeSeen(this.senderFlag());
        this.contractWindow.show(dispute);
    }

    private void onSelectDispute(Dispute dispute) {
        if (dispute == null) {
            this.selectedDispute = null;
        } else if (this.selectedDispute != dispute) {
            this.selectedDispute = dispute;
        }
        this.reOpenButton.setDisable(this.selectedDispute == null || !this.selectedDispute.isClosed());
        this.closeButton.setDisable(this.selectedDispute == null || this.selectedDispute.isClosed());
        this.sendPrivateNotificationButton.setDisable(this.selectedDispute == null);
    }

    private void onDisputesAdded(List<? extends Dispute> addedDisputes) {
        addedDisputes.forEach(dispute -> {
            ListChangeListener listener = c -> {
                c.next();
                if (c.wasAdded()) {
                    c.getAddedSubList().forEach(chatMessage -> {
                        if (dispute.isClosed()) {
                            if (chatMessage.isResultMessage(dispute)) {
                                this.onSelectDispute(null);
                            } else {
                                this.onSelectDispute((Dispute)dispute);
                                this.reOpenDispute();
                            }
                        }
                    });
                }
            };
            dispute.getChatMessages().addListener(listener);
            this.disputeChatMessagesListeners.put(dispute.getId(), (ListChangeListener<ChatMessage>)listener);
        });
    }

    private void onDisputesRemoved(List<? extends Dispute> removedDisputes) {
        removedDisputes.forEach(dispute -> {
            String id = dispute.getId();
            if (this.disputeChatMessagesListeners.containsKey(id)) {
                ListChangeListener<ChatMessage> listener = this.disputeChatMessagesListeners.get(id);
                dispute.getChatMessages().removeListener(listener);
                this.disputeChatMessagesListeners.remove(id);
            }
        });
    }

    private void sendPrivateNotification() {
        if (this.selectedDispute != null) {
            Contract contract;
            PubKeyRing pubKeyRing = this.selectedDispute.getTraderPubKeyRing();
            NodeAddress nodeAddress = pubKeyRing.equals((Object)(contract = this.selectedDispute.getContract()).getBuyerPubKeyRing()) ? contract.getBuyerNodeAddress() : contract.getSellerNodeAddress();
            new SendPrivateNotificationWindow(this.privateNotificationManager, pubKeyRing, nodeAddress, this.useDevPrivilegeKeys).show();
        }
    }

    private void showCompactReport() {
        HashMap<String, List> map = new HashMap<String, List>();
        HashMap<String, List> disputesByReason = new HashMap<String, List>();
        this.disputeManager.getDisputesAsObservableList().forEach(dispute -> {
            String tradeId = dispute.getTradeId();
            if (!map.containsKey(tradeId)) {
                map.put(tradeId, new ArrayList());
            }
            List list = (List)map.get(tradeId);
            list.add(dispute);
        });
        ArrayList<List> allDisputes = new ArrayList<List>();
        map.forEach((key, value) -> allDisputes.add((List)value));
        allDisputes.sort(Comparator.comparing(o -> !o.isEmpty() ? ((Dispute)o.get(0)).getOpeningDate() : new Date(0L)));
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder csvStringBuilder = new StringBuilder();
        csvStringBuilder.append("Dispute nr").append(";").append("Closed during cycle").append(";").append("Status").append(";").append("Trade date").append(";").append("Trade ID").append(";").append("Offer version").append(";").append("Opening date").append(";").append("Close date").append(";").append("Duration").append(";").append("Currency").append(";").append("Trade amount").append(";").append("Payment method").append(";").append("Buyer account details").append(";").append("Seller account details").append(";").append("Buyer address").append(";").append("Seller address").append(";").append("Buyer security deposit").append(";").append("Seller security deposit").append(";").append("Dispute opened by").append(";").append("Payout to buyer").append(";").append("Payout to seller").append(";").append("Winner").append(";").append("Reason").append(";").append("Summary notes").append(";").append("Summary notes (other trader)");
        SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy MM dd HH:mm:ss");
        AtomicInteger disputeIndex = new AtomicInteger();
        allDisputes.forEach(disputesPerTrade -> {
            if (disputesPerTrade.size() > 0) {
                Dispute dispute1;
                DisputeResult disputeResult1;
                Dispute firstDispute = (Dispute)disputesPerTrade.get(0);
                Date openingDate = firstDispute.getOpeningDate();
                Contract contract = firstDispute.getContract();
                String buyersRole = contract.isBuyerMakerAndSellerTaker() ? "Buyer as maker" : "Buyer as taker";
                String sellersRole = contract.isBuyerMakerAndSellerTaker() ? "Seller as taker" : "Seller as maker";
                String opener = firstDispute.isDisputeOpenerIsBuyer() ? buyersRole : sellersRole;
                DisputeResult disputeResult = (DisputeResult)firstDispute.getDisputeResultProperty().get();
                String winner = disputeResult != null && disputeResult.getWinner() == DisputeResult.Winner.BUYER ? "Buyer" : "Seller";
                String buyerPayoutAmount = disputeResult != null ? HavenoUtils.formatXmr((BigInteger)disputeResult.getBuyerPayoutAmountBeforeCost(), (boolean)true) : "";
                String sellerPayoutAmount = disputeResult != null ? HavenoUtils.formatXmr((BigInteger)disputeResult.getSellerPayoutAmountBeforeCost(), (boolean)true) : "";
                int index = disputeIndex.incrementAndGet();
                String tradeDateString = dateFormatter.format(firstDispute.getTradeDate());
                String openingDateString = dateFormatter.format(openingDate);
                int cycleIndex = 0;
                stringBuilder.append("\n").append("Dispute nr.: ").append(index).append("\n");
                if (cycleIndex > 0) {
                    stringBuilder.append("Closed during cycle: ").append(cycleIndex).append("\n");
                }
                stringBuilder.append("Trade date: ").append(tradeDateString).append("\n").append("Opening date: ").append(openingDateString).append("\n");
                String tradeId = firstDispute.getTradeId();
                csvStringBuilder.append("\n").append(index).append(";");
                if (cycleIndex > 0) {
                    csvStringBuilder.append(cycleIndex).append(";");
                } else {
                    csvStringBuilder.append(";");
                }
                csvStringBuilder.append(firstDispute.isClosed() ? "Closed" : "Open").append(";").append(tradeDateString).append(";").append(firstDispute.getShortTradeId()).append(";").append(tradeId, tradeId.length() - 3, tradeId.length()).append(";").append(openingDateString).append(";");
                String summaryNotes = "";
                if (disputeResult != null) {
                    Date closeDate = disputeResult.getCloseDate();
                    long duration = closeDate.getTime() - openingDate.getTime();
                    String closeDateString = dateFormatter.format(closeDate);
                    String durationAsWords = FormattingUtils.formatDurationAsWords((long)duration);
                    stringBuilder.append("Close date: ").append(closeDateString).append("\n").append("Dispute duration: ").append(durationAsWords).append("\n");
                    csvStringBuilder.append(closeDateString).append(";").append(durationAsWords).append(";");
                } else {
                    csvStringBuilder.append(";").append(";");
                }
                String paymentMethod = Res.get((String)contract.getPaymentMethodId());
                String currency = CurrencyUtil.getNameAndCode((String)contract.getOfferPayload().getCurrencyCode());
                String tradeAmount = HavenoUtils.formatXmr((BigInteger)contract.getTradeAmount(), (boolean)true);
                String buyerDeposit = HavenoUtils.formatXmr((BigInteger)contract.getOfferPayload().getBuyerSecurityDepositForTradeAmount(contract.getTradeAmount()), (boolean)true);
                String sellerDeposit = HavenoUtils.formatXmr((BigInteger)contract.getOfferPayload().getSellerSecurityDepositForTradeAmount(contract.getTradeAmount()), (boolean)true);
                stringBuilder.append("Payment method: ").append(paymentMethod).append("\n").append("Currency: ").append(currency).append("\n").append("Trade amount: ").append(tradeAmount).append("\n").append("Buyer/seller security deposit %: ").append(buyerDeposit).append("/").append(sellerDeposit).append("\n").append("Dispute opened by: ").append(opener).append("\n").append("Payout to buyer/seller (winner): ").append(buyerPayoutAmount).append("/").append(sellerPayoutAmount).append(" (").append(winner).append(")\n");
                String buyerPaymentAccountPayload = firstDispute.getBuyerPaymentAccountPayload() == null ? null : Utilities.toTruncatedString((Object)firstDispute.getBuyerPaymentAccountPayload().getPaymentDetails().replace("\n", " ").replace(";", "."), (int)100);
                String sellerPaymentAccountPayload = firstDispute.getSellerPaymentAccountPayload() == null ? null : Utilities.toTruncatedString((Object)firstDispute.getSellerPaymentAccountPayload().getPaymentDetails().replace("\n", " ").replace(";", "."), (int)100);
                String buyerNodeAddress = contract.getBuyerNodeAddress().getFullAddress();
                String sellerNodeAddress = contract.getSellerNodeAddress().getFullAddress();
                csvStringBuilder.append(currency).append(";").append(tradeAmount.replace(" BTC", "")).append(";").append(paymentMethod).append(";").append(buyerPaymentAccountPayload).append(";").append(sellerPaymentAccountPayload).append(";").append(buyerNodeAddress.replace(".onion:9999", "")).append(";").append(sellerNodeAddress.replace(".onion:9999", "")).append(";").append(buyerDeposit.replace(" BTC", "")).append(";").append(sellerDeposit.replace(" BTC", "")).append(";").append(opener).append(";").append(buyerPayoutAmount.replace(" BTC", "")).append(";").append(sellerPayoutAmount.replace(" BTC", "")).append(";").append(winner).append(";");
                if (disputeResult != null) {
                    DisputeResult.Reason reason = disputeResult.getReason();
                    if (((DisputeResult)firstDispute.disputeResultProperty().get()).getReason() != null) {
                        disputesByReason.putIfAbsent(reason.name(), new ArrayList());
                        ((List)disputesByReason.get(reason.name())).add(firstDispute);
                        stringBuilder.append("Reason: ").append(reason.name()).append("\n");
                        csvStringBuilder.append(reason.name()).append(";");
                    } else {
                        csvStringBuilder.append(";");
                    }
                    summaryNotes = (String)disputeResult.getSummaryNotesProperty().get();
                    stringBuilder.append("Summary notes: ").append(summaryNotes).append("\n");
                    csvStringBuilder.append(summaryNotes).append(";");
                } else {
                    csvStringBuilder.append(";");
                }
                if (disputesPerTrade.size() > 1 && (disputeResult1 = (DisputeResult)(dispute1 = (Dispute)disputesPerTrade.get(1)).getDisputeResultProperty().get()) != null) {
                    String summaryNotes1 = (String)disputeResult1.getSummaryNotesProperty().get();
                    if (!summaryNotes1.equals(summaryNotes)) {
                        stringBuilder.append("Summary notes (different message to other trader was used): ").append(summaryNotes1).append("\n");
                        csvStringBuilder.append(summaryNotes1).append(";");
                    } else {
                        csvStringBuilder.append(";");
                    }
                }
            }
        });
        stringBuilder.append("\n").append("Summary of reasons for disputes: ").append("\n");
        disputesByReason.forEach((k, v) -> stringBuilder.append((String)k).append(": ").append(v.size()).append("\n"));
        String message = stringBuilder.toString();
        ((Popup)((Popup)((Popup)((Popup)((Popup)((Popup)((Popup)((Popup)new Popup().headLine("Report for " + allDisputes.size() + " disputes")).maxMessageLength(500)).information(message)).width(1200.0)).actionButtonText("Copy to clipboard")).onAction(() -> Utilities.copyToClipboard((String)message))).secondaryActionButtonText("Copy as csv data")).onSecondaryAction(() -> Utilities.copyToClipboard((String)csvStringBuilder.toString()))).show();
    }

    private void showFullReport() {
        HashMap<String, List> map = new HashMap<String, List>();
        this.disputeManager.getDisputesAsObservableList().forEach(dispute -> {
            String tradeId = dispute.getTradeId();
            if (!map.containsKey(tradeId)) {
                map.put(tradeId, new ArrayList());
            }
            List list = (List)map.get(tradeId);
            list.add(dispute);
        });
        ArrayList<List> disputeGroups = new ArrayList<List>();
        map.forEach((key, value) -> disputeGroups.add((List)value));
        disputeGroups.sort(Comparator.comparing(o -> !o.isEmpty() ? ((Dispute)o.get(0)).getOpeningDate() : new Date(0L)));
        StringBuilder stringBuilder = new StringBuilder();
        disputeGroups.forEach(disputeGroup -> {
            Dispute dispute0 = (Dispute)disputeGroup.get(0);
            stringBuilder.append("##########################################################################################/\n").append("## Trade ID: ").append(dispute0.getTradeId()).append("\n").append("## Date: ").append(DisplayUtils.formatDateTime(dispute0.getOpeningDate())).append("\n").append("## Is support ticket: ").append(dispute0.isSupportTicket()).append("\n");
            if (dispute0.disputeResultProperty().get() != null && ((DisputeResult)dispute0.disputeResultProperty().get()).getReason() != null) {
                stringBuilder.append("## Reason: ").append(((DisputeResult)dispute0.disputeResultProperty().get()).getReason()).append("\n");
            }
            stringBuilder.append("##########################################################################################/\n").append("\n");
            disputeGroup.forEach(dispute -> {
                stringBuilder.append("*******************************************************************************************\n").append("** Trader's ID: ").append(dispute.getTraderId()).append("\n*******************************************************************************************\n").append("\n");
                dispute.getChatMessages().forEach(m -> {
                    String role = m.isSenderIsTrader() ? ">> Trader's msg: " : "<< Arbitrator's msg: ";
                    stringBuilder.append(role).append(m.getMessage()).append("\n");
                });
                stringBuilder.append("\n");
            });
            stringBuilder.append("\n");
        });
        String message = stringBuilder.toString();
        ((Popup)((Popup)((Popup)((Popup)((Popup)((Popup)new Popup().headLine("Detailed text dump for " + disputeGroups.size() + " disputes")).maxMessageLength(1000)).information(message)).width(1200.0)).actionButtonText("Copy to clipboard")).onAction(() -> Utilities.copyToClipboard((String)message))).show();
    }

    protected void setupTable() {
        this.tableView.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        AutoTooltipLabel placeholder = new AutoTooltipLabel(Res.get((String)"support.noTickets"));
        placeholder.setWrapText(true);
        this.tableView.setPlaceholder((Node)placeholder);
        this.tableView.getSelectionModel().clearSelection();
        this.tableView.getColumns().add(this.getContractColumn());
        this.maybeAddProcessColumnsForAgent();
        TableColumn<Dispute, Dispute> dateColumn = this.getDateColumn();
        this.tableView.getColumns().add(dateColumn);
        TableColumn<Dispute, Dispute> tradeIdColumn = this.getTradeIdColumn();
        this.tableView.getColumns().add(tradeIdColumn);
        TableColumn<Dispute, Dispute> buyerOnionAddressColumn = this.getBuyerOnionAddressColumn();
        this.tableView.getColumns().add(buyerOnionAddressColumn);
        TableColumn<Dispute, Dispute> sellerOnionAddressColumn = this.getSellerOnionAddressColumn();
        this.tableView.getColumns().add(sellerOnionAddressColumn);
        TableColumn<Dispute, Dispute> marketColumn = this.getMarketColumn();
        this.tableView.getColumns().add(marketColumn);
        this.tableView.getColumns().add(this.getRoleColumn());
        this.maybeAddAgentColumn();
        this.stateColumn = this.getStateColumn();
        this.tableView.getColumns().add(this.stateColumn);
        this.maybeAddChatColumnForClient();
        tradeIdColumn.setComparator(Comparator.comparing(Dispute::getTradeId));
        dateColumn.setComparator(Comparator.comparing(Dispute::getOpeningDate));
        buyerOnionAddressColumn.setComparator(Comparator.comparing(this::getBuyerOnionAddressColumnLabel));
        sellerOnionAddressColumn.setComparator(Comparator.comparing(this::getSellerOnionAddressColumnLabel));
        marketColumn.setComparator((o1, o2) -> CurrencyUtil.getCurrencyPair((String)o1.getContract().getOfferPayload().getCurrencyCode()).compareTo(o2.getContract().getOfferPayload().getCurrencyCode()));
        this.stateColumn.setComparator(Comparator.comparing(this::getDisputeStateText));
        dateColumn.setSortType(TableColumn.SortType.DESCENDING);
        this.tableView.getSortOrder().add(dateColumn);
    }

    protected void maybeAddProcessColumnsForAgent() {
    }

    protected void maybeAddChatColumnForClient() {
    }

    protected void maybeAddAgentColumn() {
    }

    protected NodeAddress getAgentNodeAddress(Contract contract) {
        return null;
    }

    private TableColumn<Dispute, Dispute> getContractColumn() {
        AutoTooltipTableColumn<Dispute, Dispute> column = new AutoTooltipTableColumn<Dispute, Dispute>(this, Res.get((String)"shared.details")){
            {
                this.setMaxWidth(80.0);
                this.setMinWidth(65.0);
                this.setSortable(false);
            }
        };
        column.setCellValueFactory(dispute -> new ReadOnlyObjectWrapper((Object)((Dispute)dispute.getValue())));
        column.setCellFactory((Callback)new Callback<TableColumn<Dispute, Dispute>, TableCell<Dispute, Dispute>>(){

            public TableCell<Dispute, Dispute> call(TableColumn<Dispute, Dispute> column) {
                return new TableCell<Dispute, Dispute>(){

                    public void updateItem(Dispute item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null && !empty) {
                            Button button = FormBuilder.getRegularIconButton((GlyphIcons)MaterialDesignIcon.INFORMATION_OUTLINE);
                            JFXBadge badge = new JFXBadge((Node)new Label(""), Pos.BASELINE_RIGHT);
                            badge.setPosition(Pos.TOP_RIGHT);
                            badge.setVisible(item.isNew());
                            badge.setText("New");
                            badge.getStyleClass().add((Object)"new");
                            DisputeView.this.newBadgeByDispute.put(item.getId(), badge);
                            HBox hBox = new HBox(new Node[]{button, badge});
                            this.setGraphic((Node)hBox);
                            button.setOnAction(e -> {
                                DisputeView.this.tableView.getSelectionModel().select(this.getIndex());
                                DisputeView.this.onOpenContract(item);
                                item.setDisputeSeen(DisputeView.this.senderFlag());
                                badge.setVisible(item.isNew());
                            });
                        } else {
                            this.setGraphic(null);
                        }
                    }
                };
            }
        });
        return column;
    }

    protected TableColumn<Dispute, Dispute> getProcessColumn() {
        AutoTooltipTableColumn<Dispute, Dispute> column = new AutoTooltipTableColumn<Dispute, Dispute>(this, Res.get((String)"support.process")){
            {
                this.setMaxWidth(50.0);
                this.setMinWidth(50.0);
                this.getStyleClass().addAll((Object[])new String[]{"avatar-column"});
                this.setSortable(false);
            }
        };
        column.setCellValueFactory(dispute -> new ReadOnlyObjectWrapper((Object)((Dispute)dispute.getValue())));
        column.setCellFactory((Callback)new Callback<TableColumn<Dispute, Dispute>, TableCell<Dispute, Dispute>>(){

            public TableCell<Dispute, Dispute> call(TableColumn<Dispute, Dispute> column) {
                return new TableCell<Dispute, Dispute>(){

                    public void updateItem(Dispute item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null && !empty) {
                            Button button = FormBuilder.getRegularIconButton((GlyphIcons)MaterialDesignIcon.GAVEL);
                            button.setOnAction(e -> {
                                DisputeView.this.tableView.getSelectionModel().select(this.getIndex());
                                DisputeView.this.handleOnProcessDispute(item);
                                item.setDisputeSeen(DisputeView.this.senderFlag());
                                DisputeView.this.newBadgeByDispute.get(item.getId()).setVisible(item.isNew());
                            });
                            HBox hBox = new HBox(new Node[]{button});
                            hBox.setAlignment(Pos.CENTER);
                            this.setGraphic((Node)hBox);
                        } else {
                            this.setGraphic(null);
                        }
                    }
                };
            }
        });
        return column;
    }

    protected TableColumn<Dispute, Dispute> getChatColumn() {
        AutoTooltipTableColumn<Dispute, Dispute> column = new AutoTooltipTableColumn<Dispute, Dispute>(this, Res.get((String)"support.chat")){
            {
                this.setMaxWidth(40.0);
                this.setMinWidth(40.0);
                this.getStyleClass().addAll((Object[])new String[]{"avatar-column"});
                this.setSortable(false);
            }
        };
        column.setCellValueFactory(dispute -> new ReadOnlyObjectWrapper((Object)((Dispute)dispute.getValue())));
        column.setCellFactory((Callback)new Callback<TableColumn<Dispute, Dispute>, TableCell<Dispute, Dispute>>(){

            public TableCell<Dispute, Dispute> call(TableColumn<Dispute, Dispute> column) {
                return new TableCell<Dispute, Dispute>(){
                    Subscription subscription;

                    public void updateItem(Dispute item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null && !empty) {
                            Trade trade;
                            JFXBadge chatBadge;
                            Button button;
                            String id;
                            if (this.subscription != null) {
                                this.subscription.unsubscribe();
                                this.subscription = null;
                            }
                            if (!DisputeView.this.chatButtonByDispute.containsKey(id = item.getId())) {
                                button = FormBuilder.getIconButton((GlyphIcons)MaterialDesignIcon.COMMENT_MULTIPLE_OUTLINE);
                                DisputeView.this.chatButtonByDispute.put(id, button);
                                button.setTooltip(new Tooltip(Res.get((String)"tradeChat.openChat")));
                            } else {
                                button = DisputeView.this.chatButtonByDispute.get(id);
                            }
                            if (!DisputeView.this.chatBadgeByDispute.containsKey(id)) {
                                chatBadge = new JFXBadge((Node)button);
                                DisputeView.this.chatBadgeByDispute.put(id, chatBadge);
                                chatBadge.setPosition(Pos.TOP_RIGHT);
                            } else {
                                chatBadge = DisputeView.this.chatBadgeByDispute.get(id);
                            }
                            button.setOnAction(e -> {
                                DisputeView.this.tableView.getSelectionModel().select(this.getIndex());
                                DisputeView.this.openChat(item);
                            });
                            if (!DisputeView.this.listenerByDispute.containsKey(id)) {
                                ListChangeListener listener = c -> DisputeView.this.updateChatMessageCount(item, chatBadge);
                                DisputeView.this.listenerByDispute.put(id, (ListChangeListener<ChatMessage>)listener);
                                item.getChatMessages().addListener(listener);
                            }
                            if ((trade = DisputeView.this.tradeManager.getTrade(item.getTradeId())) == null) {
                                DisputeView.this.log.warn("Dispute's trade is null for trade {}", (Object)item.getTradeId());
                            } else {
                                this.subscription = EasyBind.subscribe((ObservableValue)trade.disputeStateProperty(), disputeState -> {
                                    chatBadge.setDisable(!DisputeView.this.canViewChatMessages(item));
                                    DisputeView.this.updateChatMessageCount(item, chatBadge);
                                });
                            }
                            DisputeView.this.updateChatMessageCount(item, chatBadge);
                            this.setGraphic((Node)chatBadge);
                        } else {
                            this.setGraphic(null);
                            if (this.subscription != null) {
                                this.subscription.unsubscribe();
                                this.subscription = null;
                            }
                        }
                    }
                };
            }
        });
        return column;
    }

    private TableColumn<Dispute, Dispute> getDateColumn() {
        AutoTooltipTableColumn<Dispute, Dispute> column = new AutoTooltipTableColumn<Dispute, Dispute>(this, Res.get((String)"shared.date")){
            {
                this.setMinWidth(100.0);
                this.setPrefWidth(150.0);
            }
        };
        column.setCellValueFactory(dispute -> new ReadOnlyObjectWrapper((Object)((Dispute)dispute.getValue())));
        column.setCellFactory((Callback)new Callback<TableColumn<Dispute, Dispute>, TableCell<Dispute, Dispute>>(this){

            public TableCell<Dispute, Dispute> call(TableColumn<Dispute, Dispute> column) {
                return new TableCell<Dispute, Dispute>(this){

                    public void updateItem(Dispute item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null && !empty) {
                            this.setText(DisplayUtils.formatDateTime(item.getOpeningDate()));
                        } else {
                            this.setText("");
                        }
                    }
                };
            }
        });
        return column;
    }

    private TableColumn<Dispute, Dispute> getTradeIdColumn() {
        AutoTooltipTableColumn<Dispute, Dispute> column = new AutoTooltipTableColumn<Dispute, Dispute>(this, Res.get((String)"shared.tradeId")){
            {
                this.setMinWidth(50.0);
                this.setPrefWidth(100.0);
            }
        };
        column.setCellValueFactory(dispute -> new ReadOnlyObjectWrapper((Object)((Dispute)dispute.getValue())));
        column.setCellFactory((Callback)new Callback<TableColumn<Dispute, Dispute>, TableCell<Dispute, Dispute>>(){

            public TableCell<Dispute, Dispute> call(TableColumn<Dispute, Dispute> column) {
                return new TableCell<Dispute, Dispute>(){
                    private HyperlinkWithIcon field;

                    public void updateItem(Dispute item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null && !empty) {
                            Optional tradeOptional = DisputeView.this.tradeManager.getOpenTrade(item.getTradeId());
                            if (tradeOptional.isPresent()) {
                                this.field = new HyperlinkWithIcon(item.getShortTradeId());
                                this.field.setMouseTransparent(false);
                                this.field.setTooltip(new Tooltip(Res.get((String)"tooltip.openPopupForDetails")));
                                this.field.setOnAction(event -> DisputeView.this.tradeDetailsWindow.show((Trade)tradeOptional.get()));
                                this.setGraphic((Node)this.field);
                                this.setText("");
                            } else {
                                this.setText(item.getShortTradeId());
                                this.setGraphic(null);
                                if (this.field != null) {
                                    this.field.setOnAction(null);
                                }
                            }
                        } else {
                            this.setGraphic(null);
                            this.setText("");
                            if (this.field != null) {
                                this.field.setOnAction(null);
                            }
                        }
                    }
                };
            }
        });
        return column;
    }

    private TableColumn<Dispute, Dispute> getBuyerOnionAddressColumn() {
        AutoTooltipTableColumn<Dispute, Dispute> column = new AutoTooltipTableColumn<Dispute, Dispute>(this, Res.get((String)"support.buyerAddress")){
            {
                this.setMinWidth(160.0);
            }
        };
        column.setCellValueFactory(dispute -> new ReadOnlyObjectWrapper((Object)((Dispute)dispute.getValue())));
        column.setCellFactory((Callback)new Callback<TableColumn<Dispute, Dispute>, TableCell<Dispute, Dispute>>(){

            public TableCell<Dispute, Dispute> call(TableColumn<Dispute, Dispute> column) {
                return new TableCell<Dispute, Dispute>(){

                    public void updateItem(Dispute item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null && !empty) {
                            this.setText(DisputeView.this.getBuyerOnionAddressColumnLabel(item));
                            PeerInfoIconDispute peerInfoIconDispute = DisputeView.this.createAvatar(((TableRow)this.tableRowProperty().get()).getIndex(), item, true);
                            this.setGraphic((Node)peerInfoIconDispute);
                        } else {
                            this.setText("");
                            this.setGraphic(null);
                        }
                    }
                };
            }
        });
        return column;
    }

    private TableColumn<Dispute, Dispute> getSellerOnionAddressColumn() {
        AutoTooltipTableColumn<Dispute, Dispute> column = new AutoTooltipTableColumn<Dispute, Dispute>(this, Res.get((String)"support.sellerAddress")){
            {
                this.setMinWidth(160.0);
            }
        };
        column.setCellValueFactory(dispute -> new ReadOnlyObjectWrapper((Object)((Dispute)dispute.getValue())));
        column.setCellFactory((Callback)new Callback<TableColumn<Dispute, Dispute>, TableCell<Dispute, Dispute>>(){

            public TableCell<Dispute, Dispute> call(TableColumn<Dispute, Dispute> column) {
                return new TableCell<Dispute, Dispute>(){

                    public void updateItem(Dispute item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null && !empty) {
                            this.setText(DisputeView.this.getSellerOnionAddressColumnLabel(item));
                            PeerInfoIconDispute peerInfoIconDispute = DisputeView.this.createAvatar(((TableRow)this.tableRowProperty().get()).getIndex(), item, false);
                            this.setGraphic((Node)peerInfoIconDispute);
                        } else {
                            this.setText("");
                            this.setGraphic(null);
                        }
                    }
                };
            }
        });
        return column;
    }

    private String getBuyerOnionAddressColumnLabel(Dispute item) {
        Contract contract = item.getContract();
        if (contract != null) {
            NodeAddress buyerNodeAddress = contract.getBuyerNodeAddress();
            if (buyerNodeAddress != null) {
                String nrOfDisputes = this.disputeManager.getNrOfDisputes(true, contract);
                long accountAge = this.accountAgeWitnessService.getAccountAge(item.getBuyerPaymentAccountPayload(), contract.getBuyerPubKeyRing());
                String age = DisplayUtils.formatAccountAge(accountAge);
                Object postFix = CurrencyUtil.isTraditionalCurrency((String)item.getContract().getOfferPayload().getCurrencyCode()) ? " / " + age : "";
                return buyerNodeAddress.getAddressForDisplay() + " (" + nrOfDisputes + (String)postFix + ")";
            }
            return Res.get((String)"shared.na");
        }
        return Res.get((String)"shared.na");
    }

    private String getSellerOnionAddressColumnLabel(Dispute item) {
        Contract contract = item.getContract();
        if (contract != null) {
            NodeAddress sellerNodeAddress = contract.getSellerNodeAddress();
            if (sellerNodeAddress != null) {
                String nrOfDisputes = this.disputeManager.getNrOfDisputes(false, contract);
                long accountAge = this.accountAgeWitnessService.getAccountAge(item.getSellerPaymentAccountPayload(), contract.getSellerPubKeyRing());
                String age = DisplayUtils.formatAccountAge(accountAge);
                Object postFix = CurrencyUtil.isTraditionalCurrency((String)item.getContract().getOfferPayload().getCurrencyCode()) ? " / " + age : "";
                return sellerNodeAddress.getAddressForDisplay() + " (" + nrOfDisputes + (String)postFix + ")";
            }
            return Res.get((String)"shared.na");
        }
        return Res.get((String)"shared.na");
    }

    private TableColumn<Dispute, Dispute> getMarketColumn() {
        AutoTooltipTableColumn<Dispute, Dispute> column = new AutoTooltipTableColumn<Dispute, Dispute>(this, Res.get((String)"shared.market")){
            {
                this.setMinWidth(80.0);
            }
        };
        column.setCellValueFactory(dispute -> new ReadOnlyObjectWrapper((Object)((Dispute)dispute.getValue())));
        column.setCellFactory((Callback)new Callback<TableColumn<Dispute, Dispute>, TableCell<Dispute, Dispute>>(this){

            public TableCell<Dispute, Dispute> call(TableColumn<Dispute, Dispute> column) {
                return new TableCell<Dispute, Dispute>(this){

                    public void updateItem(Dispute item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null && !empty) {
                            this.setText(CurrencyUtil.getCurrencyPair((String)item.getContract().getOfferPayload().getCurrencyCode()));
                        } else {
                            this.setText("");
                        }
                    }
                };
            }
        });
        return column;
    }

    private TableColumn<Dispute, Dispute> getRoleColumn() {
        AutoTooltipTableColumn<Dispute, Dispute> column = new AutoTooltipTableColumn<Dispute, Dispute>(this, Res.get((String)"support.role")){
            {
                this.setMinWidth(130.0);
            }
        };
        column.setCellValueFactory(dispute -> new ReadOnlyObjectWrapper((Object)((Dispute)dispute.getValue())));
        column.setCellFactory((Callback)new Callback<TableColumn<Dispute, Dispute>, TableCell<Dispute, Dispute>>(this){

            public TableCell<Dispute, Dispute> call(TableColumn<Dispute, Dispute> column) {
                return new TableCell<Dispute, Dispute>(this){

                    public void updateItem(Dispute item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null && !empty) {
                            this.setText(item.getRoleString());
                        } else {
                            this.setText("");
                        }
                    }
                };
            }
        });
        return column;
    }

    protected TableColumn<Dispute, Dispute> getAgentColumn() {
        AutoTooltipTableColumn<Dispute, Dispute> column = new AutoTooltipTableColumn<Dispute, Dispute>(this, Res.get((String)"support.agent")){
            {
                this.setMinWidth(70.0);
            }
        };
        column.setCellValueFactory(dispute -> new ReadOnlyObjectWrapper((Object)((Dispute)dispute.getValue())));
        column.setCellFactory((Callback)new Callback<TableColumn<Dispute, Dispute>, TableCell<Dispute, Dispute>>(){

            public TableCell<Dispute, Dispute> call(TableColumn<Dispute, Dispute> column) {
                return new TableCell<Dispute, Dispute>(){

                    public void updateItem(Dispute item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null && !empty) {
                            NodeAddress agentNodeAddress = DisputeView.this.getAgentNodeAddress(item.getContract());
                            if (agentNodeAddress == null) {
                                this.setText(Res.get((String)"shared.na"));
                                return;
                            }
                            String MatrixUserName = DisputeAgentLookupMap.getMatrixUserName((String)agentNodeAddress.getFullAddress());
                            this.setText(MatrixUserName);
                        } else {
                            this.setText("");
                        }
                    }
                };
            }
        });
        return column;
    }

    private TableColumn<Dispute, Dispute> getStateColumn() {
        AutoTooltipTableColumn<Dispute, Dispute> column = new AutoTooltipTableColumn<Dispute, Dispute>(this, Res.get((String)"support.state")){
            {
                this.setMinWidth(50.0);
            }
        };
        column.setCellValueFactory(dispute -> new ReadOnlyObjectWrapper((Object)((Dispute)dispute.getValue())));
        column.setCellFactory((Callback)new Callback<TableColumn<Dispute, Dispute>, TableCell<Dispute, Dispute>>(){

            public TableCell<Dispute, Dispute> call(TableColumn<Dispute, Dispute> column) {
                return new TableCell<Dispute, Dispute>(){
                    ReadOnlyBooleanProperty closedProperty;
                    ChangeListener<Boolean> listener;
                    Subscription subscription;

                    public void updateItem(Dispute item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        UserThread.execute(() -> {
                            if (item != null && !empty) {
                                Trade trade;
                                if (this.closedProperty != null) {
                                    this.closedProperty.removeListener(this.listener);
                                }
                                if (this.subscription != null) {
                                    this.subscription.unsubscribe();
                                    this.subscription = null;
                                }
                                this.listener = (observable, oldValue, newValue) -> {
                                    this.setText(DisputeView.this.getDisputeStateText(item));
                                    if (this.getTableRow() != null) {
                                        this.getTableRow().setOpacity(newValue != false && item.getBadgeCountProperty().get() == 0 ? 0.4 : 1.0);
                                    }
                                    if (item.isClosed() && item == DisputeView.this.chatPopup.getSelectedDispute()) {
                                        DisputeView.this.chatPopup.closeChat();
                                    }
                                };
                                this.closedProperty = item.isClosedProperty();
                                this.closedProperty.addListener(this.listener);
                                boolean isClosed = item.isClosed();
                                this.setText(DisputeView.this.getDisputeStateText(item));
                                if (this.getTableRow() != null) {
                                    this.getTableRow().setOpacity(isClosed && item.getBadgeCountProperty().get() == 0 ? 0.4 : 1.0);
                                }
                                if ((trade = DisputeView.this.tradeManager.getTrade(item.getTradeId())) == null) {
                                    DisputeView.this.log.warn("Dispute's trade is null for trade {}", (Object)item.getTradeId());
                                } else {
                                    this.subscription = EasyBind.subscribe((ObservableValue)trade.disputeStateProperty(), disputeState -> this.setText(DisputeView.this.getDisputeStateText(item)));
                                }
                            } else {
                                if (this.closedProperty != null) {
                                    this.closedProperty.removeListener(this.listener);
                                    this.closedProperty = null;
                                }
                                if (this.subscription != null) {
                                    this.subscription.unsubscribe();
                                    this.subscription = null;
                                }
                                this.setText("");
                            }
                        });
                    }
                };
            }
        });
        return column;
    }

    private String getDisputeStateText(Dispute dispute) {
        Trade trade = this.tradeManager.getTrade(dispute.getTradeId());
        if (trade == null) {
            this.log.warn("Dispute's trade is null for trade {}, defaulting to dispute state text 'closed'", (Object)dispute.getTradeId());
            return Res.get((String)"support.closed");
        }
        if (dispute.isClosed()) {
            return Res.get((String)"support.closed");
        }
        switch (trade.getDisputeState()) {
            case NO_DISPUTE: {
                return Res.get((String)"shared.pending");
            }
            case DISPUTE_PREPARING: {
                return Res.get((String)"support.preparing");
            }
            case DISPUTE_REQUESTED: {
                return Res.get((String)"support.requested");
            }
        }
        return Res.get((String)"support.open");
    }

    private void openChat(Dispute dispute) {
        this.chatPopup.openChat(dispute, this.getConcreteDisputeChatSession(dispute), this.getCounterpartyName());
        dispute.setDisputeSeen(this.senderFlag());
        this.newBadgeByDispute.get(dispute.getId()).setVisible(dispute.isNew());
        this.updateChatMessageCount(dispute, this.chatBadgeByDispute.get(dispute.getId()));
    }

    private void updateChatMessageCount(Dispute dispute, JFXBadge chatBadge) {
        UserThread.execute(() -> {
            if (chatBadge == null) {
                return;
            }
            if (this.chatPopup.isChatShown() && this.selectedDispute != null && dispute.getId().equals(this.selectedDispute.getId())) {
                chatBadge.setText("");
                chatBadge.setEnabled(false);
                chatBadge.refreshBadge();
                UserThread.execute(() -> dispute.setChatMessagesSeen(this.senderFlag()));
                return;
            }
            if (this.canViewChatMessages(dispute) && dispute.unreadMessageCount(this.senderFlag()) > 0L) {
                chatBadge.setText(String.valueOf(dispute.unreadMessageCount(this.senderFlag())));
                chatBadge.setEnabled(true);
            } else {
                chatBadge.setText("");
                chatBadge.setEnabled(false);
            }
            chatBadge.refreshBadge();
            dispute.refreshAlertLevel(this.senderFlag());
        });
    }

    private String getCounterpartyName() {
        if (this.senderFlag()) {
            return Res.get((String)"offerbook.trader");
        }
        return this.disputeManager instanceof MediationManager ? Res.get((String)"shared.mediator") : Res.get((String)"shared.refundAgent");
    }

    private PeerInfoIconDispute createAvatar(Integer tableRowId, Dispute dispute, boolean isBuyer) {
        NodeAddress nodeAddress = isBuyer ? dispute.getContract().getBuyerNodeAddress() : dispute.getContract().getSellerNodeAddress();
        String key = tableRowId + nodeAddress.getAddressForDisplay() + (isBuyer ? "BUYER" : "SELLER");
        Long accountAge = isBuyer ? this.accountAgeWitnessService.getAccountAge(dispute.getBuyerPaymentAccountPayload(), dispute.getContract().getBuyerPubKeyRing()) : this.accountAgeWitnessService.getAccountAge(dispute.getSellerPaymentAccountPayload(), dispute.getContract().getSellerPubKeyRing());
        PeerInfoIconDispute peerInfoIcon = new PeerInfoIconDispute(nodeAddress, this.disputeManager.getNrOfDisputes(isBuyer, dispute.getContract()), accountAge, this.preferences);
        this.avatarMap.put(key, peerInfoIcon);
        return peerInfoIcon;
    }

    @Override
    public void onCloseDisputeFromChatWindow(Dispute dispute) {
        if (dispute.getDisputeState() == Dispute.State.NEW || dispute.getDisputeState().isOpen()) {
            this.handleOnProcessDispute(dispute);
        } else {
            this.closeDisputeFromButton();
        }
    }

    @Override
    public void onSendLogsFromChatWindow(Dispute dispute) {
        if (!(this.disputeManager instanceof ArbitrationManager)) {
            return;
        }
        ArbitrationManager arbitrationManager = (ArbitrationManager)this.disputeManager;
        new SendLogFilesWindow(dispute.getTradeId(), dispute.getTraderId(), arbitrationManager).show();
    }

    private boolean canViewChatMessages(Dispute dispute) {
        return this.disputeManager.canSendChatMessages(dispute) || dispute.isClosed();
    }

    public Dispute getSelectedDispute() {
        return this.selectedDispute;
    }

    public static enum FilterResult {
        NO_MATCH("No Match"),
        NO_FILTER("No filter text"),
        OPEN_DISPUTES("Open disputes"),
        TRADE_ID("Trade ID"),
        OPENING_DATE("Opening date"),
        BUYER_NODE_ADDRESS("Buyer node address"),
        SELLER_NODE_ADDRESS("Seller node address"),
        BUYER_ACCOUNT_DETAILS("Buyer account details"),
        SELLER_ACCOUNT_DETAILS("Seller account details"),
        DEPOSIT_TX("Deposit tx ID"),
        PAYOUT_TX("Payout tx ID"),
        DEL_PAYOUT_TX("Delayed payout tx ID"),
        RESULT_MESSAGE("Result message"),
        REASON("Reason"),
        JSON("Contract as json");

        private final String displayString;

        private FilterResult(String displayString) {
            this.displayString = displayString;
        }

        public String getDisplayString() {
            return this.displayString;
        }
    }
}

