/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.support.dispute;

import haveno.common.UserThread;
import haveno.core.locale.Res;
import haveno.core.support.SupportManager;
import haveno.core.support.SupportSession;
import haveno.core.support.dispute.Dispute;
import haveno.core.support.dispute.DisputeList;
import haveno.core.support.dispute.DisputeManager;
import haveno.core.support.dispute.DisputeSession;
import haveno.core.user.Preferences;
import haveno.core.util.coin.CoinFormatter;
import haveno.desktop.components.AutoTooltipButton;
import haveno.desktop.main.MainView;
import haveno.desktop.main.shared.ChatView;
import haveno.desktop.util.CssTheme;
import haveno.desktop.util.DisplayUtils;
import java.util.Date;
import javafx.beans.value.ChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.StackPane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;

public class DisputeChatPopup {
    private Stage chatPopupStage;
    protected final DisputeManager<? extends DisputeList<Dispute>> disputeManager;
    protected final CoinFormatter formatter;
    protected final Preferences preferences;
    private final ChatCallback chatCallback;
    private double chatPopupStageXPosition = -1.0;
    private double chatPopupStageYPosition = -1.0;
    private Dispute selectedDispute;

    DisputeChatPopup(DisputeManager<? extends DisputeList<Dispute>> disputeManager, CoinFormatter formatter, Preferences preferences, ChatCallback chatCallback) {
        this.disputeManager = disputeManager;
        this.formatter = formatter;
        this.preferences = preferences;
        this.chatCallback = chatCallback;
    }

    public boolean isChatShown() {
        return this.chatPopupStage != null;
    }

    public void closeChat() {
        if (this.chatPopupStage != null) {
            this.chatPopupStage.close();
        }
        this.selectedDispute = null;
    }

    public void openChat(Dispute selectedDispute, DisputeSession concreteDisputeSession, String counterpartyName) {
        this.closeChat();
        this.selectedDispute = selectedDispute;
        selectedDispute.getChatMessages().forEach(m -> m.setWasDisplayed(true));
        this.disputeManager.requestPersistence();
        ChatView chatView = new ChatView((SupportManager)this.disputeManager, counterpartyName);
        chatView.setAllowAttachments(true);
        chatView.setDisplayHeader(false);
        chatView.initialize();
        AnchorPane pane = new AnchorPane(new Node[]{chatView});
        pane.setPrefSize(760.0, 500.0);
        AnchorPane.setLeftAnchor((Node)chatView, (Double)10.0);
        AnchorPane.setRightAnchor((Node)chatView, (Double)10.0);
        AnchorPane.setTopAnchor((Node)chatView, (Double)-20.0);
        AnchorPane.setBottomAnchor((Node)chatView, (Double)10.0);
        pane.getStyleClass().add((Object)"dispute-chat-border");
        if (selectedDispute.isClosed()) {
            chatView.display((SupportSession)concreteDisputeSession, null, pane.widthProperty());
        } else if (this.disputeManager.isAgent(selectedDispute)) {
            AutoTooltipButton closeDisputeButton = new AutoTooltipButton(Res.get((String)"support.closeTicket"));
            closeDisputeButton.setDefaultButton(true);
            closeDisputeButton.setOnAction(e -> this.chatCallback.onCloseDisputeFromChatWindow(selectedDispute));
            chatView.display((SupportSession)concreteDisputeSession, (Node)closeDisputeButton, pane.widthProperty());
        } else {
            MenuButton menuButton = new MenuButton(Res.get((String)"support.moreButton"));
            MenuItem menuItem1 = new MenuItem(Res.get((String)"support.uploadTraderChat"));
            MenuItem menuItem2 = new MenuItem(Res.get((String)"support.sendLogFiles"));
            menuItem1.setOnAction(e -> this.doTextAttachment(chatView));
            this.setChatUploadEnabledState(menuItem1);
            menuItem2.setOnAction(e -> this.chatCallback.onSendLogsFromChatWindow(selectedDispute));
            menuButton.getItems().addAll((Object[])new MenuItem[]{menuItem1, menuItem2});
            menuButton.getStyleClass().add((Object)"jfx-button");
            menuButton.setStyle("-fx-min-width: 95; -fx-padding: 0 10 0 10;");
            chatView.display((SupportSession)concreteDisputeSession, (Node)menuButton, pane.widthProperty());
        }
        chatView.activate();
        chatView.scrollToBottom();
        this.chatPopupStage = new Stage();
        this.chatPopupStage.setTitle(Res.get((String)"disputeChat.chatWindowTitle", (Object[])new Object[]{selectedDispute.getShortTradeId()}) + " " + selectedDispute.getRoleString());
        StackPane owner = MainView.getRootContainer();
        Scene rootScene = owner.getScene();
        this.chatPopupStage.initOwner(rootScene.getWindow());
        this.chatPopupStage.initModality(Modality.NONE);
        this.chatPopupStage.initStyle(StageStyle.DECORATED);
        this.chatPopupStage.setOnHiding(event -> {
            chatView.deactivate();
            selectedDispute.getChatMessages().forEach(m -> m.setWasDisplayed(true));
            this.disputeManager.requestPersistence();
            this.chatPopupStage = null;
        });
        Scene scene = new Scene((Parent)pane);
        CssTheme.loadSceneStyles(scene, this.preferences.getCssTheme(), false);
        scene.addEventHandler(KeyEvent.KEY_RELEASED, ev -> {
            if (ev.getCode() == KeyCode.ESCAPE) {
                ev.consume();
                this.chatPopupStage.hide();
            }
        });
        this.chatPopupStage.setScene(scene);
        this.chatPopupStage.setOpacity(0.0);
        this.chatPopupStage.show();
        ChangeListener xPositionListener = (observable, oldValue, newValue) -> {
            this.chatPopupStageXPosition = (Double)newValue;
        };
        this.chatPopupStage.xProperty().addListener(xPositionListener);
        ChangeListener yPositionListener = (observable, oldValue, newValue) -> {
            this.chatPopupStageYPosition = (Double)newValue;
        };
        this.chatPopupStage.yProperty().addListener(yPositionListener);
        if (this.chatPopupStageXPosition == -1.0) {
            Window rootSceneWindow = rootScene.getWindow();
            double titleBarHeight = rootSceneWindow.getHeight() - rootScene.getHeight();
            this.chatPopupStage.setX((double)Math.round(rootSceneWindow.getX() + (owner.getWidth() - this.chatPopupStage.getWidth() / 4.0 * 3.0)));
            this.chatPopupStage.setY((double)Math.round(rootSceneWindow.getY() + titleBarHeight + (owner.getHeight() - this.chatPopupStage.getHeight() / 4.0 * 3.0)));
        } else {
            this.chatPopupStage.setX(this.chatPopupStageXPosition);
            this.chatPopupStage.setY(this.chatPopupStageYPosition);
        }
        UserThread.execute(() -> this.chatPopupStage.setOpacity(1.0));
    }

    private void doTextAttachment(ChatView chatView) {
        this.disputeManager.findTrade(this.selectedDispute).ifPresent(t -> {
            ObservableList chatMessages = t.getChatMessages();
            if (chatMessages.size() > 0) {
                StringBuilder stringBuilder = new StringBuilder();
                chatMessages.forEach(i -> {
                    boolean isMyMsg = i.isSenderIsTrader();
                    Object metaData = DisplayUtils.formatDateTime(new Date(i.getDate()));
                    if (!i.isSystemMessage()) {
                        metaData = (isMyMsg ? "Sent " : "Received ") + (String)metaData + (isMyMsg ? "" : " from Trader");
                    }
                    stringBuilder.append((String)metaData).append("\n").append(i.getMessage()).append("\n\n");
                });
                String fileName = this.selectedDispute.getShortTradeId() + "_" + this.selectedDispute.getRoleStringForLogFile() + "_TraderChat.txt";
                chatView.onAttachText(stringBuilder.toString(), fileName);
            }
        });
    }

    private void setChatUploadEnabledState(MenuItem menuItem) {
        this.disputeManager.findTrade(this.selectedDispute).ifPresentOrElse(t -> menuItem.setDisable(t.getChatMessages().size() == 0), () -> menuItem.setDisable(true));
    }

    public Dispute getSelectedDispute() {
        return this.selectedDispute;
    }

    public static interface ChatCallback {
        public void onCloseDisputeFromChatWindow(Dispute var1);

        public void onSendLogsFromChatWindow(Dispute var1);
    }
}

