/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.support;

import com.google.inject.Inject;
import haveno.common.UserThread;
import haveno.common.app.DevEnv;
import haveno.common.crypto.KeyRing;
import haveno.common.crypto.PubKeyRing;
import haveno.core.locale.Res;
import haveno.core.support.dispute.arbitration.ArbitrationManager;
import haveno.core.support.dispute.arbitration.arbitrator.Arbitrator;
import haveno.core.support.dispute.arbitration.arbitrator.ArbitratorManager;
import haveno.core.support.dispute.mediation.MediationManager;
import haveno.core.support.dispute.mediation.mediator.Mediator;
import haveno.core.support.dispute.mediation.mediator.MediatorManager;
import haveno.core.support.dispute.refund.RefundManager;
import haveno.core.support.dispute.refund.refundagent.RefundAgent;
import haveno.core.support.dispute.refund.refundagent.RefundAgentManager;
import haveno.desktop.Navigation;
import haveno.desktop.common.view.ActivatableView;
import haveno.desktop.common.view.CachingViewLoader;
import haveno.desktop.common.view.FxmlView;
import haveno.desktop.common.view.View;
import haveno.desktop.common.view.ViewLoader;
import haveno.desktop.main.MainView;
import haveno.desktop.main.offer.signedoffer.SignedOfferView;
import haveno.desktop.main.overlays.popups.Popup;
import haveno.desktop.main.support.dispute.agent.arbitration.ArbitratorView;
import haveno.desktop.main.support.dispute.agent.mediation.MediatorView;
import haveno.desktop.main.support.dispute.agent.refund.RefundAgentView;
import haveno.desktop.main.support.dispute.client.arbitration.ArbitrationClientView;
import haveno.desktop.main.support.dispute.client.mediation.MediationClientView;
import haveno.desktop.main.support.dispute.client.refund.RefundClientView;
import haveno.network.p2p.NodeAddress;
import javafx.beans.value.ChangeListener;
import javafx.collections.MapChangeListener;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javax.annotation.Nullable;

@FxmlView
public class SupportView
extends ActivatableView<TabPane, Void> {
    private Tab tradersMediationDisputesTab;
    private Tab tradersRefundDisputesTab;
    @Nullable
    private Tab tradersArbitrationDisputesTab;
    private Tab mediatorTab;
    private Tab refundAgentTab;
    @Nullable
    private Tab arbitratorTab;
    @Nullable
    private Tab signedOfferTab;
    private final Navigation navigation;
    private final ArbitratorManager arbitratorManager;
    private final MediatorManager mediatorManager;
    private final RefundAgentManager refundAgentManager;
    private final ArbitrationManager arbitrationManager;
    private final MediationManager mediationManager;
    private final RefundManager refundManager;
    private final KeyRing keyRing;
    private Navigation.Listener navigationListener;
    private ChangeListener<Tab> tabChangeListener;
    private Tab currentTab;
    private final ViewLoader viewLoader;
    private MapChangeListener<NodeAddress, Arbitrator> arbitratorMapChangeListener;
    private MapChangeListener<NodeAddress, Mediator> mediatorMapChangeListener;
    private MapChangeListener<NodeAddress, RefundAgent> refundAgentMapChangeListener;

    @Inject
    public SupportView(CachingViewLoader viewLoader, Navigation navigation, ArbitratorManager arbitratorManager, MediatorManager mediatorManager, RefundAgentManager refundAgentManager, ArbitrationManager arbitrationManager, MediationManager mediationManager, RefundManager refundManager, KeyRing keyRing) {
        this.viewLoader = viewLoader;
        this.navigation = navigation;
        this.arbitratorManager = arbitratorManager;
        this.mediatorManager = mediatorManager;
        this.refundAgentManager = refundAgentManager;
        this.arbitrationManager = arbitrationManager;
        this.mediationManager = mediationManager;
        this.refundManager = refundManager;
        this.keyRing = keyRing;
    }

    @Override
    public void initialize() {
        this.tradersMediationDisputesTab = new Tab();
        this.tradersMediationDisputesTab.setClosable(false);
        this.tradersRefundDisputesTab = new Tab();
        this.tradersRefundDisputesTab.setClosable(false);
        this.tradersArbitrationDisputesTab = new Tab();
        this.tradersArbitrationDisputesTab.setClosable(false);
        ((TabPane)this.root).getTabs().add((Object)this.tradersArbitrationDisputesTab);
        this.updateAgentTabs();
        this.tradersMediationDisputesTab.setText(Res.get((String)"support.tab.mediation.support"));
        this.tradersRefundDisputesTab.setText(Res.get((String)"support.tab.refund.support"));
        this.tradersArbitrationDisputesTab.setText(Res.get((String)"support.tab.arbitration.support"));
        this.navigationListener = (viewPath, data) -> {
            if (viewPath.size() == 3 && viewPath.indexOf(SupportView.class) == 1) {
                UserThread.execute(() -> this.loadView(viewPath.tip()));
            }
        };
        this.tabChangeListener = (ov, oldValue, newValue) -> {
            if (newValue == this.tradersArbitrationDisputesTab) {
                this.navigation.navigateTo(MainView.class, SupportView.class, ArbitrationClientView.class);
            } else if (newValue == this.tradersMediationDisputesTab) {
                this.navigation.navigateTo(MainView.class, SupportView.class, MediationClientView.class);
            } else if (newValue == this.tradersRefundDisputesTab) {
                this.navigation.navigateTo(MainView.class, SupportView.class, RefundClientView.class);
            } else if (newValue == this.arbitratorTab) {
                this.navigation.navigateTo(MainView.class, SupportView.class, ArbitratorView.class);
            } else if (newValue == this.signedOfferTab) {
                this.navigation.navigateTo(MainView.class, SupportView.class, SignedOfferView.class);
            } else if (newValue == this.mediatorTab) {
                this.navigation.navigateTo(MainView.class, SupportView.class, MediatorView.class);
            } else if (newValue == this.refundAgentTab) {
                this.navigation.navigateTo(MainView.class, SupportView.class, RefundAgentView.class);
            }
        };
        this.arbitratorMapChangeListener = change -> this.updateAgentTabs();
        this.mediatorMapChangeListener = change -> this.updateAgentTabs();
        this.refundAgentMapChangeListener = change -> this.updateAgentTabs();
    }

    private void updateAgentTabs() {
        PubKeyRing myPubKeyRing = this.keyRing.getPubKeyRing();
        boolean isActiveArbitrator = this.arbitratorManager.getObservableMap().values().stream().anyMatch(e -> e.getPubKeyRing() != null && e.getPubKeyRing().equals((Object)myPubKeyRing));
        boolean hasDisputesAsArbitrator = this.arbitrationManager.getDisputesAsObservableList().stream().anyMatch(d -> d.getAgentPubKeyRing().equals((Object)myPubKeyRing));
        if (isActiveArbitrator || hasDisputesAsArbitrator) {
            if (this.arbitratorTab == null) {
                this.arbitratorTab = new Tab();
                this.arbitratorTab.setClosable(false);
                ((TabPane)this.root).getTabs().add((Object)this.arbitratorTab);
            }
            if (this.signedOfferTab == null) {
                this.signedOfferTab = new Tab();
                this.signedOfferTab.setClosable(false);
                ((TabPane)this.root).getTabs().add((Object)this.signedOfferTab);
            }
        }
        boolean isActiveMediator = this.mediatorManager.getObservableMap().values().stream().anyMatch(e -> e.getPubKeyRing() != null && e.getPubKeyRing().equals((Object)myPubKeyRing));
        if (this.mediatorTab == null) {
            boolean hasDisputesAsMediator = this.mediationManager.getDisputesAsObservableList().stream().anyMatch(d -> d.getAgentPubKeyRing().equals((Object)myPubKeyRing));
            if (isActiveMediator || hasDisputesAsMediator) {
                this.mediatorTab = new Tab();
                this.mediatorTab.setClosable(false);
                ((TabPane)this.root).getTabs().add((Object)this.mediatorTab);
            }
        }
        boolean isActiveRefundAgent = this.refundAgentManager.getObservableMap().values().stream().anyMatch(e -> e.getPubKeyRing() != null && e.getPubKeyRing().equals((Object)myPubKeyRing));
        if (this.refundAgentTab == null) {
            boolean hasDisputesAsRefundAgent = this.refundManager.getDisputesAsObservableList().stream().anyMatch(d -> d.getAgentPubKeyRing().equals((Object)myPubKeyRing));
            if (isActiveRefundAgent || hasDisputesAsRefundAgent) {
                this.refundAgentTab = new Tab();
                this.refundAgentTab.setClosable(false);
                ((TabPane)this.root).getTabs().add((Object)this.refundAgentTab);
            }
        }
        if (this.arbitratorTab != null) {
            this.arbitratorTab.setText(Res.get((String)"support.tab.ArbitratorsSupportTickets", (Object[])new Object[]{Res.get((String)"shared.arbitrator")}));
        }
        if (this.signedOfferTab != null) {
            this.signedOfferTab.setText(Res.get((String)"support.tab.SignedOffers"));
        }
        if (this.mediatorTab != null) {
            this.mediatorTab.setText(Res.get((String)"support.tab.ArbitratorsSupportTickets", (Object[])new Object[]{Res.get((String)"shared.mediator")}));
        }
        if (this.refundAgentTab != null) {
            this.refundAgentTab.setText(Res.get((String)"support.tab.ArbitratorsSupportTickets", (Object[])new Object[]{Res.get((String)"shared.refundAgentForSupportStaff")}));
        }
    }

    @Override
    protected void activate() {
        this.arbitratorManager.updateMap();
        this.arbitratorManager.getObservableMap().addListener(this.arbitratorMapChangeListener);
        this.mediatorManager.updateMap();
        this.mediatorManager.getObservableMap().addListener(this.mediatorMapChangeListener);
        this.refundAgentManager.updateMap();
        this.refundAgentManager.getObservableMap().addListener(this.refundAgentMapChangeListener);
        this.updateAgentTabs();
        ((TabPane)this.root).getSelectionModel().selectedItemProperty().addListener(this.tabChangeListener);
        this.navigation.addListener(this.navigationListener);
        if (((TabPane)this.root).getSelectionModel().getSelectedItem() == this.tradersMediationDisputesTab) {
            this.navigation.navigateTo(MainView.class, SupportView.class, MediationClientView.class);
        } else if (((TabPane)this.root).getSelectionModel().getSelectedItem() == this.tradersArbitrationDisputesTab) {
            this.navigation.navigateTo(MainView.class, SupportView.class, ArbitrationClientView.class);
        } else if (((TabPane)this.root).getSelectionModel().getSelectedItem() == this.tradersRefundDisputesTab) {
            this.navigation.navigateTo(MainView.class, SupportView.class, RefundClientView.class);
        } else if (this.arbitratorTab != null) {
            this.navigation.navigateTo(MainView.class, SupportView.class, ArbitratorView.class);
        } else if (this.signedOfferTab != null) {
            this.navigation.navigateTo(MainView.class, SupportView.class, SignedOfferView.class);
        } else if (this.mediatorTab != null) {
            this.navigation.navigateTo(MainView.class, SupportView.class, MediatorView.class);
        } else if (this.refundAgentTab != null) {
            this.navigation.navigateTo(MainView.class, SupportView.class, RefundAgentView.class);
        }
        String key = "supportInfo";
        if (!DevEnv.isDevMode()) {
            ((Popup)((Popup)((Popup)new Popup().backgroundInfo(Res.get((String)"support.backgroundInfo"))).width(900.0)).dontShowAgainId(key)).show();
        }
    }

    @Override
    protected void deactivate() {
        this.arbitratorManager.getObservableMap().removeListener(this.arbitratorMapChangeListener);
        this.mediatorManager.getObservableMap().removeListener(this.mediatorMapChangeListener);
        this.refundAgentManager.getObservableMap().removeListener(this.refundAgentMapChangeListener);
        ((TabPane)this.root).getSelectionModel().selectedItemProperty().removeListener(this.tabChangeListener);
        this.navigation.removeListener(this.navigationListener);
        this.currentTab = null;
    }

    private void loadView(Class<? extends View> viewClass) {
        View view;
        if (this.currentTab != null) {
            this.currentTab.setContent(null);
        }
        this.currentTab = (view = this.viewLoader.load(viewClass)) instanceof MediationClientView ? this.tradersMediationDisputesTab : (view instanceof ArbitrationClientView ? this.tradersArbitrationDisputesTab : (view instanceof RefundClientView ? this.tradersRefundDisputesTab : (view instanceof ArbitratorView ? this.arbitratorTab : (view instanceof SignedOfferView ? this.signedOfferTab : (view instanceof MediatorView ? this.mediatorTab : (view instanceof RefundAgentView ? this.refundAgentTab : null))))));
        if (this.currentTab != null) {
            this.currentTab.setContent(view.getRoot());
            ((TabPane)this.root).getSelectionModel().select((Object)this.currentTab);
        }
    }
}

