/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.shared;

import com.google.common.io.ByteStreams;
import de.jensd.fx.fontawesome.AwesomeDude;
import de.jensd.fx.fontawesome.AwesomeIcon;
import de.jensd.fx.glyphs.materialdesignicons.MaterialDesignIcon;
import de.jensd.fx.glyphs.materialdesignicons.MaterialDesignIconView;
import haveno.common.Timer;
import haveno.common.UserThread;
import haveno.common.util.Utilities;
import haveno.core.locale.Res;
import haveno.core.support.SupportManager;
import haveno.core.support.SupportSession;
import haveno.core.support.dispute.Attachment;
import haveno.core.support.messages.ChatMessage;
import haveno.desktop.components.AutoTooltipButton;
import haveno.desktop.components.AutoTooltipLabel;
import haveno.desktop.components.BusyAnimation;
import haveno.desktop.components.HavenoTextArea;
import haveno.desktop.components.TableGroupHeadline;
import haveno.desktop.main.overlays.notifications.Notification;
import haveno.desktop.main.overlays.popups.Popup;
import haveno.desktop.util.DisplayUtils;
import haveno.desktop.util.GUIUtil;
import haveno.desktop.util.Layout;
import haveno.network.p2p.network.Connection;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.transformation.SortedList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.TextArea;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.text.TextAlignment;
import javafx.stage.FileChooser;
import javafx.util.Callback;
import javax.annotation.Nullable;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.fxmisc.easybind.EasyBind;
import org.fxmisc.easybind.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChatView
extends AnchorPane {
    private static final Logger log = LoggerFactory.getLogger(ChatView.class);
    private TextArea inputTextArea;
    private Button sendButton;
    private ListView<ChatMessage> messageListView;
    private Label sendMsgInfoLabel;
    private BusyAnimation sendMsgBusyAnimation;
    private TableGroupHeadline tableGroupHeadline;
    private VBox messagesInputBox;
    Node extraButton;
    private ReadOnlyDoubleProperty widthProperty;
    boolean allowAttachments;
    boolean displayHeader;
    private ChatMessage chatMessage;
    private ObservableList<ChatMessage> chatMessages;
    private ListChangeListener<ChatMessage> disputeDirectMessageListListener;
    private Subscription inputTextAreaTextSubscription;
    private final List<Attachment> tempAttachments = new ArrayList<Attachment>();
    private ChangeListener<Boolean> storedInMailboxPropertyListener;
    private ChangeListener<Boolean> acknowledgedPropertyListener;
    private ChangeListener<String> sendMessageErrorPropertyListener;
    private EventHandler<KeyEvent> keyEventEventHandler;
    private SupportManager supportManager;
    private Optional<SupportSession> optionalSupportSession = Optional.empty();
    private String counterpartyName;

    public ChatView(SupportManager supportManager, String counterpartyName) {
        this.supportManager = supportManager;
        this.counterpartyName = counterpartyName;
        this.allowAttachments = true;
        this.displayHeader = true;
    }

    public void initialize() {
        this.disputeDirectMessageListListener = c -> this.scrollToBottom();
        this.keyEventEventHandler = event -> {
            if (Utilities.isAltOrCtrlPressed((KeyCode)KeyCode.ENTER, (KeyEvent)event)) {
                this.optionalSupportSession.ifPresent(supportSession -> {
                    if (supportSession.chatIsOpen() && this.inputTextArea.isFocused()) {
                        this.onTrySendMessage();
                    }
                });
            }
        };
    }

    public void activate() {
        this.addEventHandler(KeyEvent.KEY_RELEASED, this.keyEventEventHandler);
    }

    public void deactivate() {
        this.removeEventHandler(KeyEvent.KEY_RELEASED, this.keyEventEventHandler);
        this.removeListenersOnSessionChange();
    }

    public void display(SupportSession supportSession, ReadOnlyDoubleProperty widthProperty) {
        this.display(supportSession, null, widthProperty);
    }

    public void display(final SupportSession supportSession, @Nullable Node extraButton, ReadOnlyDoubleProperty widthProperty) {
        this.optionalSupportSession = Optional.of(supportSession);
        this.removeListenersOnSessionChange();
        this.getChildren().clear();
        this.extraButton = extraButton;
        this.widthProperty = widthProperty;
        this.tableGroupHeadline = new TableGroupHeadline();
        this.tableGroupHeadline.setText(Res.get((String)"support.messages"));
        AnchorPane.setTopAnchor((Node)this.tableGroupHeadline, (Double)10.0);
        AnchorPane.setRightAnchor((Node)this.tableGroupHeadline, (Double)0.0);
        AnchorPane.setBottomAnchor((Node)this.tableGroupHeadline, (Double)0.0);
        AnchorPane.setLeftAnchor((Node)this.tableGroupHeadline, (Double)0.0);
        this.chatMessages = supportSession.getObservableChatMessageList();
        SortedList sortedList = new SortedList(this.chatMessages);
        sortedList.setComparator(Comparator.comparing(o -> new Date(o.getDate())));
        this.messageListView = new ListView((ObservableList)sortedList);
        this.messageListView.setId("message-list-view");
        this.messageListView.setMinHeight(150.0);
        AnchorPane.setTopAnchor(this.messageListView, (Double)30.0);
        AnchorPane.setRightAnchor(this.messageListView, (Double)0.0);
        AnchorPane.setLeftAnchor(this.messageListView, (Double)0.0);
        VBox.setVgrow((Node)this, (Priority)Priority.ALWAYS);
        this.inputTextArea = new HavenoTextArea();
        this.inputTextArea.setPrefHeight(70.0);
        this.inputTextArea.setWrapText(true);
        this.inputTextArea.getStyleClass().add((Object)"input-with-border");
        if (!supportSession.isDisputeAgent()) {
            this.inputTextArea.setPromptText(Res.get((String)"support.input.prompt"));
        }
        this.sendButton = new AutoTooltipButton(Res.get((String)"support.send"));
        this.sendButton.setDefaultButton(true);
        this.sendButton.setOnAction(e -> this.onTrySendMessage());
        this.sendButton.setStyle("-fx-pref-width: 125; -fx-min-width: 110; -fx-padding: 3 3 3 3;");
        this.inputTextAreaTextSubscription = EasyBind.subscribe((ObservableValue)this.inputTextArea.textProperty(), t -> this.sendButton.setDisable(t.isEmpty()));
        AutoTooltipButton uploadButton = new AutoTooltipButton(Res.get((String)"support.addAttachments"));
        uploadButton.setOnAction(e -> this.onRequestUpload());
        AutoTooltipButton clipboardButton = new AutoTooltipButton(Res.get((String)"shared.copyToClipboard"));
        clipboardButton.setOnAction(arg_0 -> this.lambda$display$7((Button)clipboardButton, arg_0));
        uploadButton.setStyle("-fx-pref-width: 125; -fx-min-width: 110; -fx-padding: 3 3 3 3;");
        clipboardButton.setStyle("-fx-pref-width: 125; -fx-min-width: 110; -fx-padding: 3 3 3 3;");
        this.sendMsgInfoLabel = new AutoTooltipLabel();
        this.sendMsgInfoLabel.setVisible(false);
        this.sendMsgInfoLabel.setManaged(false);
        this.sendMsgInfoLabel.setPadding(new Insets(5.0, 0.0, 0.0, 0.0));
        this.sendMsgBusyAnimation = new BusyAnimation(false);
        if (this.displayHeader) {
            this.getChildren().add((Object)this.tableGroupHeadline);
        }
        if (supportSession.chatIsOpen()) {
            HBox buttonBox = new HBox();
            buttonBox.setSpacing(10.0);
            if (this.allowAttachments) {
                buttonBox.getChildren().addAll((Object[])new Node[]{this.sendButton, uploadButton, clipboardButton, this.sendMsgBusyAnimation, this.sendMsgInfoLabel});
            } else {
                buttonBox.getChildren().addAll((Object[])new Node[]{this.sendButton, this.sendMsgBusyAnimation, this.sendMsgInfoLabel});
            }
            if (extraButton != null) {
                Pane spacer = new Pane();
                HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
                buttonBox.getChildren().addAll((Object[])new Node[]{spacer, extraButton});
            }
            this.messagesInputBox = new VBox();
            this.messagesInputBox.setSpacing(10.0);
            this.messagesInputBox.getChildren().addAll((Object[])new Node[]{this.inputTextArea, buttonBox});
            VBox.setVgrow((Node)buttonBox, (Priority)Priority.ALWAYS);
            AnchorPane.setRightAnchor((Node)this.messagesInputBox, (Double)0.0);
            AnchorPane.setBottomAnchor((Node)this.messagesInputBox, (Double)5.0);
            AnchorPane.setLeftAnchor((Node)this.messagesInputBox, (Double)0.0);
            AnchorPane.setBottomAnchor(this.messageListView, (Double)120.0);
            this.getChildren().addAll((Object[])new Node[]{this.messageListView, this.messagesInputBox});
        } else {
            AnchorPane.setBottomAnchor(this.messageListView, (Double)0.0);
            this.getChildren().add(this.messageListView);
        }
        this.messageListView.setCellFactory((Callback)new Callback<ListView<ChatMessage>, ListCell<ChatMessage>>(){

            public ListCell<ChatMessage> call(ListView<ChatMessage> list) {
                return new ListCell<ChatMessage>(){
                    ChangeListener<Boolean> sendMsgBusyAnimationListener;
                    Pane bg = new Pane();
                    ImageView arrow = new ImageView();
                    Label headerLabel = new AutoTooltipLabel();
                    Label messageLabel = new AutoTooltipLabel();
                    Label copyLabel = new Label();
                    HBox attachmentsBox = new HBox();
                    AnchorPane messageAnchorPane = new AnchorPane();
                    Label statusIcon = new Label();
                    Label statusInfoLabel = new Label();
                    HBox statusHBox = new HBox();
                    double arrowWidth = 15.0;
                    double attachmentsBoxHeight = 20.0;
                    double border = 10.0;
                    double bottomBorder = 25.0;
                    double padding = this.border + 10.0;
                    double msgLabelPaddingRight = this.padding + 20.0;
                    {
                        this.bg.setMinHeight(30.0);
                        this.messageLabel.setWrapText(true);
                        this.headerLabel.setTextAlignment(TextAlignment.CENTER);
                        this.attachmentsBox.setSpacing(5.0);
                        this.statusIcon.getStyleClass().add((Object)"small-text");
                        this.statusInfoLabel.getStyleClass().add((Object)"small-text");
                        this.statusInfoLabel.setPadding(new Insets(3.0, 0.0, 0.0, 0.0));
                        this.copyLabel.setTooltip(new Tooltip(Res.get((String)"shared.copyToClipboard")));
                        this.statusHBox.setSpacing(5.0);
                        this.statusHBox.getChildren().addAll((Object[])new Node[]{this.statusIcon, this.statusInfoLabel});
                        this.messageAnchorPane.getChildren().addAll((Object[])new Node[]{this.bg, this.arrow, this.headerLabel, this.messageLabel, this.copyLabel, this.attachmentsBox, this.statusHBox});
                    }

                    protected void updateItem(ChatMessage message, boolean empty) {
                        UserThread.execute(() -> {
                            super.updateItem((Object)message, empty);
                            if (message != null && !empty) {
                                this.copyLabel.setOnMouseClicked(e -> {
                                    Utilities.copyToClipboard((String)this.messageLabel.getText());
                                    Tooltip tp = new Tooltip(Res.get((String)"shared.copiedToClipboard"));
                                    Node node = (Node)e.getSource();
                                    UserThread.runAfter(() -> tp.hide(), (long)1L);
                                    tp.show(node, e.getScreenX() + Layout.PADDING, e.getScreenY() + Layout.PADDING);
                                });
                                this.messageLabel.setOnMouseClicked(event -> {
                                    if (2 > event.getClickCount()) {
                                        return;
                                    }
                                    GUIUtil.showSelectableTextModal(this.headerLabel.getText(), this.messageLabel.getText());
                                });
                                if (!this.messageAnchorPane.prefWidthProperty().isBound()) {
                                    this.messageAnchorPane.prefWidthProperty().bind((ObservableValue)ChatView.this.messageListView.widthProperty().subtract(this.padding + GUIUtil.getScrollbarWidth(ChatView.this.messageListView)));
                                }
                                AnchorPane.clearConstraints((Node)this.bg);
                                AnchorPane.clearConstraints((Node)this.headerLabel);
                                AnchorPane.clearConstraints((Node)this.arrow);
                                AnchorPane.clearConstraints((Node)this.messageLabel);
                                AnchorPane.clearConstraints((Node)this.copyLabel);
                                AnchorPane.clearConstraints((Node)this.statusHBox);
                                AnchorPane.clearConstraints((Node)this.attachmentsBox);
                                AnchorPane.setTopAnchor((Node)this.bg, (Double)15.0);
                                AnchorPane.setBottomAnchor((Node)this.bg, (Double)this.bottomBorder);
                                AnchorPane.setTopAnchor((Node)this.headerLabel, (Double)0.0);
                                AnchorPane.setBottomAnchor((Node)this.arrow, (Double)(this.bottomBorder + 5.0));
                                AnchorPane.setTopAnchor((Node)this.messageLabel, (Double)25.0);
                                AnchorPane.setTopAnchor((Node)this.copyLabel, (Double)25.0);
                                AnchorPane.setBottomAnchor((Node)this.attachmentsBox, (Double)(this.bottomBorder + 10.0));
                                boolean senderIsTrader = message.isSenderIsTrader();
                                final boolean isMyMsg = supportSession.isClient() == senderIsTrader;
                                this.arrow.setVisible(!message.isSystemMessage());
                                this.arrow.setManaged(!message.isSystemMessage());
                                this.statusHBox.setVisible(false);
                                this.headerLabel.getStyleClass().removeAll((Object[])new String[]{"message-header", "my-message-header", "success-text", "highlight-static"});
                                this.messageLabel.getStyleClass().removeAll((Object[])new String[]{"my-message", "message"});
                                this.copyLabel.getStyleClass().removeAll((Object[])new String[]{"my-message", "message"});
                                if (message.isSystemMessage()) {
                                    this.headerLabel.getStyleClass().addAll((Object[])new String[]{"message-header", "success-text"});
                                    this.bg.setId("message-bubble-green");
                                    this.messageLabel.getStyleClass().add((Object)"my-message");
                                    this.copyLabel.getStyleClass().add((Object)"my-message");
                                    message.addWeakMessageStateListener(() -> UserThread.execute(() -> this.updateMsgState(message)));
                                    this.updateMsgState(message);
                                } else if (isMyMsg) {
                                    this.headerLabel.getStyleClass().add((Object)"my-message-header");
                                    this.bg.setId("message-bubble-blue");
                                    this.messageLabel.getStyleClass().add((Object)"my-message");
                                    this.copyLabel.getStyleClass().add((Object)"my-message");
                                    if (supportSession.isClient()) {
                                        this.arrow.setId("bubble_arrow_blue_left");
                                    } else {
                                        this.arrow.setId("bubble_arrow_blue_right");
                                    }
                                    if (this.sendMsgBusyAnimationListener != null) {
                                        ChatView.this.sendMsgBusyAnimation.isRunningProperty().removeListener(this.sendMsgBusyAnimationListener);
                                    }
                                    this.sendMsgBusyAnimationListener = (observable, oldValue, newValue) -> {
                                        if (!newValue.booleanValue()) {
                                            UserThread.execute(() -> this.updateMsgState(message));
                                        }
                                    };
                                    ChatView.this.sendMsgBusyAnimation.isRunningProperty().addListener(this.sendMsgBusyAnimationListener);
                                    message.addWeakMessageStateListener(() -> UserThread.execute(() -> this.updateMsgState(message)));
                                    this.updateMsgState(message);
                                } else {
                                    this.headerLabel.getStyleClass().add((Object)"message-header");
                                    this.bg.setId("message-bubble-grey");
                                    this.messageLabel.getStyleClass().add((Object)"message");
                                    this.copyLabel.getStyleClass().add((Object)"message");
                                    if (supportSession.isClient()) {
                                        this.arrow.setId("bubble_arrow_grey_right");
                                    } else {
                                        this.arrow.setId("bubble_arrow_grey_left");
                                    }
                                }
                                if (message.isSystemMessage()) {
                                    AnchorPane.setLeftAnchor((Node)this.headerLabel, (Double)this.padding);
                                    AnchorPane.setRightAnchor((Node)this.headerLabel, (Double)this.padding);
                                    AnchorPane.setLeftAnchor((Node)this.bg, (Double)this.border);
                                    AnchorPane.setRightAnchor((Node)this.bg, (Double)this.border);
                                    AnchorPane.setLeftAnchor((Node)this.messageLabel, (Double)this.padding);
                                    AnchorPane.setRightAnchor((Node)this.messageLabel, (Double)this.msgLabelPaddingRight);
                                    AnchorPane.setRightAnchor((Node)this.copyLabel, (Double)this.padding);
                                    AnchorPane.setLeftAnchor((Node)this.attachmentsBox, (Double)this.padding);
                                    AnchorPane.setRightAnchor((Node)this.attachmentsBox, (Double)this.padding);
                                    AnchorPane.setLeftAnchor((Node)this.statusHBox, (Double)this.padding);
                                } else if (senderIsTrader) {
                                    AnchorPane.setLeftAnchor((Node)this.headerLabel, (Double)(this.padding + this.arrowWidth));
                                    AnchorPane.setLeftAnchor((Node)this.bg, (Double)(this.border + this.arrowWidth));
                                    AnchorPane.setRightAnchor((Node)this.bg, (Double)this.border);
                                    AnchorPane.setLeftAnchor((Node)this.arrow, (Double)this.border);
                                    AnchorPane.setLeftAnchor((Node)this.messageLabel, (Double)(this.padding + this.arrowWidth));
                                    AnchorPane.setRightAnchor((Node)this.messageLabel, (Double)this.msgLabelPaddingRight);
                                    AnchorPane.setRightAnchor((Node)this.copyLabel, (Double)this.padding);
                                    AnchorPane.setLeftAnchor((Node)this.attachmentsBox, (Double)(this.padding + this.arrowWidth));
                                    AnchorPane.setRightAnchor((Node)this.attachmentsBox, (Double)this.padding);
                                    AnchorPane.setRightAnchor((Node)this.statusHBox, (Double)this.padding);
                                } else {
                                    AnchorPane.setRightAnchor((Node)this.headerLabel, (Double)(this.padding + this.arrowWidth));
                                    AnchorPane.setRightAnchor((Node)this.bg, (Double)(this.border + this.arrowWidth));
                                    AnchorPane.setLeftAnchor((Node)this.bg, (Double)this.border);
                                    AnchorPane.setRightAnchor((Node)this.arrow, (Double)this.border);
                                    AnchorPane.setLeftAnchor((Node)this.messageLabel, (Double)this.padding);
                                    AnchorPane.setRightAnchor((Node)this.messageLabel, (Double)(this.msgLabelPaddingRight + this.arrowWidth));
                                    AnchorPane.setRightAnchor((Node)this.copyLabel, (Double)(this.padding + this.arrowWidth));
                                    AnchorPane.setLeftAnchor((Node)this.attachmentsBox, (Double)this.padding);
                                    AnchorPane.setRightAnchor((Node)this.attachmentsBox, (Double)(this.padding + this.arrowWidth));
                                    AnchorPane.setLeftAnchor((Node)this.statusHBox, (Double)this.padding);
                                }
                                AnchorPane.setBottomAnchor((Node)this.statusHBox, (Double)7.0);
                                Object metaData = DisplayUtils.formatDateTime(new Date(message.getDate()));
                                if (!message.isSystemMessage()) {
                                    metaData = (isMyMsg ? "Sent " : "Received ") + (String)metaData + (String)(isMyMsg ? "" : " from " + ChatView.this.counterpartyName);
                                }
                                this.headerLabel.setText((String)metaData);
                                this.messageLabel.setText(message.getMessage());
                                this.attachmentsBox.getChildren().clear();
                                if (ChatView.this.allowAttachments && message.getAttachments() != null && message.getAttachments().size() > 0) {
                                    AnchorPane.setBottomAnchor((Node)this.messageLabel, (Double)(this.bottomBorder + this.attachmentsBoxHeight + 10.0));
                                    this.attachmentsBox.getChildren().add((Object)new AutoTooltipLabel(this, Res.get((String)"support.attachments") + " "){
                                        {
                                            super(text);
                                            this.setPadding(new Insets(0.0, 0.0, 3.0, 0.0));
                                            if (isMyMsg) {
                                                this.getStyleClass().add((Object)"my-message");
                                            } else {
                                                this.getStyleClass().add((Object)"message");
                                            }
                                        }
                                    });
                                    message.getAttachments().forEach(attachment -> {
                                        Label icon = new Label();
                                        this.setPadding(new Insets(0.0, 0.0, 3.0, 0.0));
                                        if (isMyMsg) {
                                            icon.getStyleClass().add((Object)"attachment-icon");
                                        } else {
                                            icon.getStyleClass().add((Object)"attachment-icon-black");
                                        }
                                        AwesomeDude.setIcon((Label)icon, (AwesomeIcon)AwesomeIcon.FILE_TEXT);
                                        icon.setPadding(new Insets(-2.0, 0.0, 0.0, 0.0));
                                        icon.setTooltip(new Tooltip(attachment.getFileName()));
                                        icon.setOnMouseClicked(event -> ChatView.this.onOpenAttachment((Attachment)attachment));
                                        this.attachmentsBox.getChildren().add((Object)icon);
                                    });
                                } else {
                                    AnchorPane.setBottomAnchor((Node)this.messageLabel, (Double)(this.bottomBorder + 10.0));
                                }
                                this.copyLabel.getStyleClass().addAll((Object[])new String[]{"icon", "copy-icon-disputes"});
                                MaterialDesignIconView copyIcon = new MaterialDesignIconView(MaterialDesignIcon.CONTENT_COPY, "16.0");
                                this.copyLabel.setGraphic((Node)copyIcon);
                                this.setGraphic((Node)this.messageAnchorPane);
                            } else {
                                if (ChatView.this.sendMsgBusyAnimation != null && this.sendMsgBusyAnimationListener != null) {
                                    ChatView.this.sendMsgBusyAnimation.isRunningProperty().removeListener(this.sendMsgBusyAnimationListener);
                                }
                                this.messageAnchorPane.prefWidthProperty().unbind();
                                this.copyLabel.setOnMouseClicked(null);
                                this.messageLabel.setOnMouseClicked(null);
                                this.setGraphic(null);
                            }
                        });
                    }

                    private void updateMsgState(ChatMessage message) {
                        boolean visible;
                        AwesomeIcon icon = null;
                        String text = null;
                        this.statusIcon.getStyleClass().add((Object)"status-icon");
                        this.statusInfoLabel.getStyleClass().add((Object)"status-icon");
                        this.statusHBox.setOpacity(1.0);
                        log.debug("updateMsgState msg-{}, ack={}, arrived={}", new Object[]{message.getMessage(), message.acknowledgedProperty().get(), message.arrivedProperty().get()});
                        if (message.acknowledgedProperty().get()) {
                            visible = true;
                            icon = AwesomeIcon.OK_SIGN;
                            text = Res.get((String)"support.acknowledged");
                        } else if (message.storedInMailboxProperty().get()) {
                            visible = true;
                            icon = AwesomeIcon.ENVELOPE;
                            text = Res.get((String)"support.savedInMailbox");
                        } else if (message.ackErrorProperty().get() != null) {
                            visible = true;
                            icon = AwesomeIcon.EXCLAMATION_SIGN;
                            text = Res.get((String)"support.error", (Object[])new Object[]{message.ackErrorProperty().get()});
                            this.statusIcon.getStyleClass().add((Object)"error-text");
                            this.statusInfoLabel.getStyleClass().add((Object)"error-text");
                        } else if (message.arrivedProperty().get()) {
                            visible = true;
                            icon = AwesomeIcon.MAIL_REPLY;
                            text = Res.get((String)"support.transient");
                        } else {
                            visible = false;
                            log.debug("updateMsgState called but no msg state available. message={}", (Object)message);
                        }
                        this.statusHBox.setVisible(visible);
                        if (visible) {
                            AwesomeDude.setIcon((Label)this.statusIcon, (AwesomeIcon)icon, (String)"14");
                            this.statusIcon.setTooltip(new Tooltip(text));
                            this.statusInfoLabel.setText(text);
                        }
                    }
                };
            }
        });
        this.addListenersOnSessionChange(widthProperty);
        this.scrollToBottom();
    }

    private void onTrySendMessage() {
        if (this.supportManager.isBootstrapped()) {
            String text = this.inputTextArea.getText();
            if (!text.isEmpty()) {
                if (text.length() < 5000) {
                    this.onSendMessage(text);
                } else {
                    ((Popup)new Popup().information(Res.get((String)"popup.warning.messageTooLong"))).show();
                }
            }
        } else {
            ((Popup)new Popup().information(Res.get((String)"popup.warning.notFullyConnected"))).show();
        }
    }

    private void onRequestUpload() {
        if (!this.allowAttachments) {
            return;
        }
        int totalSize = this.tempAttachments.stream().mapToInt(a -> a.getBytes().length).sum();
        if (this.tempAttachments.size() < 3) {
            FileChooser fileChooser = new FileChooser();
            int maxMsgSize = Connection.getPermittedMessageSize();
            int maxSizeInKB = maxMsgSize / 1024;
            fileChooser.setTitle(Res.get((String)"support.openFile", (Object[])new Object[]{maxSizeInKB}));
            File result = fileChooser.showOpenDialog(this.getScene().getWindow());
            if (result != null) {
                try {
                    URL url = result.toURI().toURL();
                    try (InputStream inputStream = url.openStream();){
                        byte[] filesAsBytes = ByteStreams.toByteArray((InputStream)inputStream);
                        int size = filesAsBytes.length;
                        int newSize = totalSize + size;
                        if (newSize > maxMsgSize) {
                            ((Popup)new Popup().warning(Res.get((String)"support.attachmentTooLarge", (Object[])new Object[]{newSize / 1024, maxSizeInKB}))).show();
                        } else if (size > maxMsgSize) {
                            ((Popup)new Popup().warning(Res.get((String)"support.maxSize", (Object[])new Object[]{maxSizeInKB}))).show();
                        } else {
                            this.tempAttachments.add(new Attachment(result.getName(), filesAsBytes));
                            this.inputTextArea.setText(this.inputTextArea.getText() + "\n[" + Res.get((String)"support.attachment") + " " + result.getName() + "]");
                        }
                    }
                    catch (IOException e) {
                        log.error(ExceptionUtils.getStackTrace((Throwable)e));
                    }
                }
                catch (MalformedURLException e2) {
                    log.error(ExceptionUtils.getStackTrace((Throwable)e2));
                }
            }
        } else {
            ((Popup)new Popup().warning(Res.get((String)"support.tooManyAttachments"))).show();
        }
    }

    public void onAttachText(String textAttachment, String name) {
        if (!this.allowAttachments) {
            return;
        }
        try {
            byte[] filesAsBytes = textAttachment.getBytes("UTF8");
            int size = filesAsBytes.length;
            int maxMsgSize = Connection.getPermittedMessageSize();
            int maxSizeInKB = maxMsgSize / 1024;
            if (size > maxMsgSize) {
                ((Popup)new Popup().warning(Res.get((String)"support.attachmentTooLarge", (Object[])new Object[]{size / 1024, maxSizeInKB}))).show();
            } else {
                this.tempAttachments.add(new Attachment(name, filesAsBytes));
                this.inputTextArea.setText(this.inputTextArea.getText() + "\n[" + Res.get((String)"support.attachment") + " " + name + "]");
            }
        }
        catch (Exception e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    private void copyChatMessagesToClipboard(Button sourceBtn) {
        this.optionalSupportSession.ifPresent(session -> {
            StringBuilder stringBuilder = new StringBuilder();
            this.chatMessages.forEach(i -> {
                Object metaData = DisplayUtils.formatDateTime(new Date(i.getDate()));
                metaData = (String)metaData + (i.isSystemMessage() ? " (System message)" : (i.isSenderIsTrader() ? " (from Trader)" : " (from Agent)"));
                stringBuilder.append((String)metaData).append("\n").append(i.getMessage()).append("\n\n");
            });
            Utilities.copyToClipboard((String)stringBuilder.toString());
            ((Notification)((Notification)new Notification().notification(Res.get((String)"shared.copiedToClipboard"))).hideCloseButton()).autoClose().show();
        });
    }

    private void onOpenAttachment(Attachment attachment) {
        if (!this.allowAttachments) {
            return;
        }
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle(Res.get((String)"support.save"));
        fileChooser.setInitialFileName(attachment.getFileName());
        File file = fileChooser.showSaveDialog(this.getScene().getWindow());
        if (file != null) {
            try (FileOutputStream fileOutputStream = new FileOutputStream(file.getAbsolutePath());){
                fileOutputStream.write(attachment.getBytes());
            }
            catch (IOException e) {
                log.error("Error opening attachment: {}\n", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    private void onSendMessage(String inputText) {
        if (this.chatMessage != null) {
            this.chatMessage.acknowledgedProperty().removeListener(this.acknowledgedPropertyListener);
            this.chatMessage.storedInMailboxProperty().removeListener(this.storedInMailboxPropertyListener);
            this.chatMessage.sendMessageErrorProperty().removeListener(this.sendMessageErrorPropertyListener);
        }
        this.chatMessage = this.sendDisputeDirectMessage(inputText, new ArrayList<Attachment>(this.tempAttachments));
        this.tempAttachments.clear();
        this.scrollToBottom();
        this.inputTextArea.setDisable(true);
        this.inputTextArea.clear();
        this.chatMessage.startAckTimer();
        Timer timer = UserThread.runAfter(() -> {
            this.sendMsgInfoLabel.setVisible(true);
            this.sendMsgInfoLabel.setManaged(true);
            this.sendMsgInfoLabel.setText(Res.get((String)"support.sendingMessage"));
            this.sendMsgBusyAnimation.play();
        }, (long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
        this.acknowledgedPropertyListener = (observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.sendMsgInfoLabel.setVisible(false);
                this.hideSendMsgInfo(timer);
            }
        };
        this.storedInMailboxPropertyListener = (observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.sendMsgInfoLabel.setVisible(true);
                this.sendMsgInfoLabel.setManaged(true);
                this.sendMsgInfoLabel.setText(Res.get((String)"support.receiverNotOnline"));
                this.hideSendMsgInfo(timer);
            }
        };
        this.sendMessageErrorPropertyListener = (observable, oldValue, newValue) -> {
            if (newValue != null) {
                this.sendMsgInfoLabel.setVisible(true);
                this.sendMsgInfoLabel.setManaged(true);
                this.sendMsgInfoLabel.setText(Res.get((String)"support.sendMessageError", (Object[])new Object[]{newValue}));
                this.hideSendMsgInfo(timer);
            }
        };
        if (this.chatMessage != null) {
            this.chatMessage.acknowledgedProperty().addListener(this.acknowledgedPropertyListener);
            this.chatMessage.storedInMailboxProperty().addListener(this.storedInMailboxPropertyListener);
            this.chatMessage.sendMessageErrorProperty().addListener(this.sendMessageErrorPropertyListener);
        }
    }

    private ChatMessage sendDisputeDirectMessage(String text, ArrayList<Attachment> attachments) {
        return this.optionalSupportSession.map(supportSession -> {
            ChatMessage message = new ChatMessage(this.supportManager.getSupportType(), supportSession.getTradeId(), supportSession.getClientId(), supportSession.isClient(), text, this.supportManager.getMyAddress(), attachments);
            this.supportManager.addAndPersistChatMessage(message);
            return this.supportManager.sendChatMessage(message);
        }).orElse(null);
    }

    private void hideSendMsgInfo(Timer timer) {
        timer.stop();
        this.inputTextArea.setDisable(false);
        UserThread.runAfter(() -> {
            this.sendMsgInfoLabel.setVisible(false);
            this.sendMsgInfoLabel.setManaged(false);
        }, (long)5L);
        this.sendMsgBusyAnimation.stop();
    }

    public void scrollToBottom() {
        UserThread.execute(() -> {
            if (this.messageListView != null && !this.messageListView.getItems().isEmpty()) {
                int lastIndex = this.messageListView.getItems().size();
                this.messageListView.scrollTo(lastIndex);
            }
        });
    }

    public void setInputBoxVisible(boolean visible) {
        if (this.messagesInputBox != null) {
            this.messagesInputBox.setVisible(visible);
            this.messagesInputBox.setManaged(visible);
            AnchorPane.setBottomAnchor(this.messageListView, (Double)(visible ? 120.0 : 0.0));
        }
    }

    public void removeInputBox() {
        this.getChildren().remove((Object)this.messagesInputBox);
    }

    private void addListenersOnSessionChange(ReadOnlyDoubleProperty widthProperty) {
        if (this.tableGroupHeadline != null) {
            this.tableGroupHeadline.prefWidthProperty().bind((ObservableValue)widthProperty);
            this.messageListView.prefWidthProperty().bind((ObservableValue)widthProperty);
            this.prefWidthProperty().bind((ObservableValue)widthProperty);
            this.chatMessages.addListener(this.disputeDirectMessageListListener);
            this.inputTextAreaTextSubscription = EasyBind.subscribe((ObservableValue)this.inputTextArea.textProperty(), t -> this.sendButton.setDisable(t.isEmpty()));
        }
    }

    private void removeListenersOnSessionChange() {
        if (this.chatMessages != null && this.disputeDirectMessageListListener != null) {
            this.chatMessages.removeListener(this.disputeDirectMessageListListener);
        }
        if (this.chatMessage != null) {
            if (this.acknowledgedPropertyListener != null) {
                this.chatMessage.arrivedProperty().removeListener(this.acknowledgedPropertyListener);
            }
            if (this.storedInMailboxPropertyListener != null) {
                this.chatMessage.storedInMailboxProperty().removeListener(this.storedInMailboxPropertyListener);
            }
        }
        if (this.messageListView != null) {
            this.messageListView.prefWidthProperty().unbind();
        }
        if (this.tableGroupHeadline != null) {
            this.tableGroupHeadline.prefWidthProperty().unbind();
        }
        this.prefWidthProperty().unbind();
        if (this.inputTextAreaTextSubscription != null) {
            this.inputTextAreaTextSubscription.unsubscribe();
        }
    }

    public Node getExtraButton() {
        return this.extraButton;
    }

    public ReadOnlyDoubleProperty getWidthProperty() {
        return this.widthProperty;
    }

    public void setAllowAttachments(boolean allowAttachments) {
        this.allowAttachments = allowAttachments;
    }

    public void setDisplayHeader(boolean displayHeader) {
        this.displayHeader = displayHeader;
    }

    private /* synthetic */ void lambda$display$7(Button clipboardButton, ActionEvent e) {
        this.copyChatMessagesToClipboard(clipboardButton);
    }
}

