/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.settings.preferences;

import com.google.inject.Inject;
import haveno.core.locale.LanguageUtil;
import haveno.core.support.dispute.arbitration.arbitrator.ArbitratorManager;
import haveno.core.support.dispute.mediation.mediator.MediatorManager;
import haveno.core.user.Preferences;
import haveno.desktop.common.model.ActivatableViewModel;
import java.util.stream.Collectors;

public class PreferencesViewModel
extends ActivatableViewModel {
    private final ArbitratorManager arbitratorManager;
    private final MediatorManager mediationManager;
    private final Preferences preferences;

    @Inject
    public PreferencesViewModel(Preferences preferences, ArbitratorManager arbitratorManager, MediatorManager mediationManager) {
        this.preferences = preferences;
        this.arbitratorManager = arbitratorManager;
        this.mediationManager = mediationManager;
    }

    boolean needsSupportLanguageWarning() {
        return !this.arbitratorManager.isAgentAvailableForLanguage(this.preferences.getUserLanguage()) || !this.mediationManager.isAgentAvailableForLanguage(this.preferences.getUserLanguage());
    }

    String getArbitrationLanguages() {
        return this.arbitratorManager.getObservableMap().values().stream().flatMap(arbitrator -> arbitrator.getLanguageCodes().stream()).distinct().map(LanguageUtil::getDisplayName).collect(Collectors.joining(", "));
    }

    public String getMediationLanguages() {
        return this.mediationManager.getObservableMap().values().stream().flatMap(mediator -> mediator.getLanguageCodes().stream()).distinct().map(LanguageUtil::getDisplayName).collect(Collectors.joining(", "));
    }
}

