/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.settings.preferences;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import haveno.common.UserThread;
import haveno.common.app.DevEnv;
import haveno.common.config.Config;
import haveno.common.util.Tuple2;
import haveno.common.util.Tuple3;
import haveno.common.util.Utilities;
import haveno.core.filter.Filter;
import haveno.core.filter.FilterManager;
import haveno.core.locale.Country;
import haveno.core.locale.CountryUtil;
import haveno.core.locale.CryptoCurrency;
import haveno.core.locale.CurrencyUtil;
import haveno.core.locale.LanguageUtil;
import haveno.core.locale.Res;
import haveno.core.locale.TradeCurrency;
import haveno.core.locale.TraditionalCurrency;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.validation.XmrValidator;
import haveno.core.trade.HavenoUtils;
import haveno.core.user.DontShowAgainLookup;
import haveno.core.user.Preferences;
import haveno.core.user.User;
import haveno.core.util.FormattingUtils;
import haveno.core.util.ParsingUtils;
import haveno.core.util.validation.InputValidator;
import haveno.core.util.validation.IntegerValidator;
import haveno.core.util.validation.RegexValidator;
import haveno.core.util.validation.RegexValidatorFactory;
import haveno.desktop.common.view.ActivatableViewAndModel;
import haveno.desktop.common.view.FxmlView;
import haveno.desktop.components.AutoTooltipButton;
import haveno.desktop.components.AutoTooltipLabel;
import haveno.desktop.components.InputTextField;
import haveno.desktop.components.PasswordTextField;
import haveno.desktop.components.TitledGroupBg;
import haveno.desktop.main.overlays.popups.Popup;
import haveno.desktop.main.overlays.windows.EditCustomExplorerWindow;
import haveno.desktop.main.settings.preferences.PreferencesViewModel;
import haveno.desktop.util.FormBuilder;
import haveno.desktop.util.GUIUtil;
import haveno.desktop.util.ImageUtil;
import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.Separator;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleButton;
import javafx.scene.image.ImageView;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.util.Callback;
import javafx.util.StringConverter;
import org.apache.commons.lang3.StringUtils;

@FxmlView
public class PreferencesView
extends ActivatableViewAndModel<GridPane, PreferencesViewModel> {
    private final User user;
    private TextField xmrExplorerTextField;
    private ComboBox<String> userLanguageComboBox;
    private ComboBox<Country> userCountryComboBox;
    private ComboBox<TradeCurrency> preferredTradeCurrencyComboBox;
    private ToggleButton showOwnOffersInOfferBook;
    private ToggleButton useAnimations;
    private ToggleButton useDarkMode;
    private ToggleButton sortMarketCurrenciesNumerically;
    private ToggleButton avoidStandbyMode;
    private ToggleButton useSoundForNotifications;
    private ToggleButton useCustomFee;
    private ToggleButton autoConfirmXmrToggle;
    private ToggleButton hideNonAccountPaymentMethodsToggle;
    private ToggleButton denyApiTakerToggle;
    private ToggleButton notifyOnPreReleaseToggle;
    private int gridRow = 0;
    private int displayCurrenciesGridRowIndex = 0;
    private InputTextField ignoreTradersListInputTextField;
    private InputTextField autoConfRequiredConfirmationsTf;
    private InputTextField autoConfServiceAddressTf;
    private InputTextField autoConfTradeLimitTf;
    private InputTextField clearDataAfterDaysInputTextField;
    private InputTextField rpcUserTextField;
    private InputTextField blockNotifyPortTextField;
    private PasswordTextField rpcPwTextField;
    private ChangeListener<Boolean> autoConfServiceAddressFocusOutListener;
    private ChangeListener<Boolean> autoConfRequiredConfirmationsFocusOutListener;
    private final Preferences preferences;
    private final FilterManager filterManager;
    private final File storageDir;
    private ListView<TraditionalCurrency> traditionalCurrenciesListView;
    private ComboBox<TraditionalCurrency> traditionalCurrenciesComboBox;
    private ListView<CryptoCurrency> cryptoCurrenciesListView;
    private ComboBox<CryptoCurrency> cryptoCurrenciesComboBox;
    private Button resetDontShowAgainButton;
    private Button editCustomBtcExplorer;
    private ObservableList<String> languageCodes;
    private ObservableList<Country> countries;
    private ObservableList<TraditionalCurrency> traditionalCurrencies;
    private ObservableList<TraditionalCurrency> allTraditionalCurrencies;
    private ObservableList<CryptoCurrency> cryptoCurrencies;
    private ObservableList<CryptoCurrency> allCryptoCurrencies;
    private ObservableList<TradeCurrency> tradeCurrencies;
    private InputTextField deviationInputTextField;
    private ChangeListener<String> deviationListener;
    private ChangeListener<String> ignoreTradersListListener;
    private ChangeListener<String> rpcUserListener;
    private ChangeListener<String> rpcPwListener;
    private ChangeListener<String> blockNotifyPortListener;
    private ChangeListener<String> clearDataAfterDaysListener;
    private ChangeListener<String> autoConfTradeLimitListener;
    private ChangeListener<String> autoConfServiceAddressListener;
    private ChangeListener<Boolean> deviationFocusedListener;
    private final boolean displayStandbyModeFeature;
    private ChangeListener<Filter> filterChangeListener;
    private boolean hideXmrAutoConf = true;

    @Inject
    public PreferencesView(PreferencesViewModel model, Preferences preferences, FilterManager filterManager, Config config, User user, @Named(value="storageDir") File storageDir) {
        super(model);
        this.user = user;
        this.preferences = preferences;
        this.filterManager = filterManager;
        this.storageDir = storageDir;
        this.displayStandbyModeFeature = Utilities.isLinux() || Utilities.isOSX() || Utilities.isWindows();
    }

    @Override
    public void initialize() {
        this.languageCodes = FXCollections.observableArrayList((Collection)LanguageUtil.getUserLanguageCodes());
        this.countries = FXCollections.observableArrayList((Collection)CountryUtil.getAllCountries());
        this.traditionalCurrencies = this.preferences.getTraditionalCurrenciesAsObservable();
        this.cryptoCurrencies = this.preferences.getCryptoCurrenciesAsObservable();
        this.tradeCurrencies = this.preferences.getTradeCurrenciesAsObservable();
        this.allTraditionalCurrencies = FXCollections.observableArrayList((Collection)CurrencyUtil.getAllSortedTraditionalCurrencies());
        this.allTraditionalCurrencies.removeAll(this.traditionalCurrencies);
        this.initializeGeneralOptions();
        this.initializeDisplayOptions();
        this.initializeSeparator();
        this.initializeAutoConfirmOptions();
        this.initializeDisplayCurrencies();
    }

    @Override
    protected void activate() {
        String key = "sensitiveDataRemovalInfo";
        if (DontShowAgainLookup.showAgain((String)key) && (this.preferences.getClearDataAfterDays() == 0 || this.preferences.getClearDataAfterDays() == 99999)) {
            ((Popup)((Popup)((Popup)((Popup)((Popup)new Popup().headLine(Res.get((String)"setting.info.headline"))).backgroundInfo(Res.get((String)"settings.preferences.sensitiveDataRemoval.msg"))).actionButtonText(Res.get((String)"shared.iUnderstand"))).onAction(() -> {
                DontShowAgainLookup.dontShowAgain((String)key, (boolean)true);
                this.preferences.setClearDataAfterDays(60);
                this.clearDataAfterDaysInputTextField.setText(String.valueOf(this.preferences.getClearDataAfterDays()));
            })).closeButtonText(Res.get((String)"shared.cancel"))).show();
        }
        this.allCryptoCurrencies = FXCollections.observableArrayList((Collection)CurrencyUtil.getActiveSortedCryptoCurrencies((FilterManager)this.filterManager));
        this.allCryptoCurrencies.removeAll(this.cryptoCurrencies);
        this.activateGeneralOptions();
        this.activateDisplayCurrencies();
        this.activateDisplayPreferences();
        this.activateAutoConfirmPreferences();
    }

    @Override
    protected void deactivate() {
        this.deactivateGeneralOptions();
        this.deactivateDisplayCurrencies();
        this.deactivateDisplayPreferences();
        this.deactivateAutoConfirmPreferences();
    }

    private void initializeGeneralOptions() {
        int titledGroupBgRowSpan = this.displayStandbyModeFeature ? 8 : 7;
        TitledGroupBg titledGroupBg = FormBuilder.addTitledGroupBg((GridPane)this.root, this.gridRow, titledGroupBgRowSpan, Res.get((String)"setting.preferences.general"));
        GridPane.setColumnSpan((Node)titledGroupBg, (Integer)1);
        this.userLanguageComboBox = FormBuilder.addComboBox((GridPane)this.root, this.gridRow, Res.get((String)"shared.language"), 20.0);
        this.userCountryComboBox = FormBuilder.addComboBox((GridPane)this.root, ++this.gridRow, Res.get((String)"shared.country"));
        this.userCountryComboBox.setButtonCell(GUIUtil.getComboBoxButtonCell(Res.get((String)"shared.country"), this.userCountryComboBox, false));
        Tuple2<TextField, Button> xmrExp = FormBuilder.addTextFieldWithEditButton((GridPane)this.root, ++this.gridRow, Res.get((String)"setting.preferences.explorer"));
        this.xmrExplorerTextField = (TextField)xmrExp.first;
        this.editCustomBtcExplorer = (Button)xmrExp.second;
        this.deviationInputTextField = FormBuilder.addInputTextField((GridPane)this.root, ++this.gridRow, Res.get((String)"setting.preferences.deviation"));
        this.deviationListener = (observable, oldValue, newValue) -> {
            try {
                double value = ParsingUtils.parsePercentStringToDouble((String)newValue);
                double maxDeviation = 0.5;
                if (value <= 0.5) {
                    this.preferences.setMaxPriceDistanceInPercent(value);
                } else {
                    ((Popup)new Popup().warning(Res.get((String)"setting.preferences.deviationToLarge", (Object[])new Object[]{50.0}))).show();
                    UserThread.runAfter(() -> this.deviationInputTextField.setText(FormattingUtils.formatToPercentWithSymbol((double)this.preferences.getMaxPriceDistanceInPercent())), (long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
                }
            }
            catch (NumberFormatException t) {
                this.log.error("Exception at parseDouble deviation: " + t.toString());
                UserThread.runAfter(() -> this.deviationInputTextField.setText(FormattingUtils.formatToPercentWithSymbol((double)this.preferences.getMaxPriceDistanceInPercent())), (long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
            }
        };
        this.deviationFocusedListener = (observable1, oldValue1, newValue1) -> {
            if (oldValue1.booleanValue() && !newValue1.booleanValue()) {
                UserThread.runAfter(() -> this.deviationInputTextField.setText(FormattingUtils.formatToPercentWithSymbol((double)this.preferences.getMaxPriceDistanceInPercent())), (long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
            }
        };
        this.ignoreTradersListInputTextField = FormBuilder.addInputTextField((GridPane)this.root, ++this.gridRow, Res.get((String)"setting.preferences.ignorePeers"));
        RegexValidator regexValidator = RegexValidatorFactory.addressRegexValidator();
        this.ignoreTradersListInputTextField.setValidator((InputValidator)regexValidator);
        this.ignoreTradersListInputTextField.setErrorMessage(Res.get((String)"validation.invalidAddressList"));
        this.ignoreTradersListListener = (observable, oldValue, newValue) -> {
            if (regexValidator.validate((String)newValue).isValid && !newValue.equals(oldValue)) {
                this.preferences.setIgnoreTradersList(Arrays.asList(StringUtils.deleteWhitespace((String)newValue).split(",")));
            }
        };
        this.clearDataAfterDaysInputTextField = FormBuilder.addInputTextField((GridPane)this.root, ++this.gridRow, Res.get((String)"setting.preferences.clearDataAfterDays"));
        IntegerValidator clearDataAfterDaysValidator = new IntegerValidator();
        clearDataAfterDaysValidator.setMinValue(1);
        clearDataAfterDaysValidator.setMaxValue(99999);
        this.clearDataAfterDaysInputTextField.setValidator((InputValidator)clearDataAfterDaysValidator);
        this.clearDataAfterDaysListener = (observable, oldValue, newValue) -> {
            try {
                int value = Integer.parseInt(newValue);
                if (!newValue.equals(oldValue)) {
                    this.preferences.setClearDataAfterDays(value);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        };
        if (this.displayStandbyModeFeature) {
            this.avoidStandbyMode = FormBuilder.addSlideToggleButton((GridPane)this.root, ++this.gridRow, Res.get((String)"setting.preferences.avoidStandbyMode"));
        }
        this.useSoundForNotifications = FormBuilder.addSlideToggleButton((GridPane)this.root, ++this.gridRow, Res.get((String)"setting.preferences.useSoundForNotifications"), -5.0);
    }

    private void initializeSeparator() {
        Separator separator = new Separator(Orientation.VERTICAL);
        separator.setPadding(new Insets(0.0, 10.0, 0.0, 10.0));
        GridPane.setColumnIndex((Node)separator, (Integer)1);
        GridPane.setHalignment((Node)separator, (HPos)HPos.CENTER);
        GridPane.setRowIndex((Node)separator, (Integer)0);
        GridPane.setRowSpan((Node)separator, (Integer)Integer.MAX_VALUE);
        ((GridPane)this.root).getChildren().add((Object)separator);
    }

    private void initializeDisplayCurrencies() {
        TitledGroupBg titledGroupBg = FormBuilder.addTitledGroupBg((GridPane)this.root, this.displayCurrenciesGridRowIndex, 8, Res.get((String)"setting.preferences.currenciesInList"), this.hideXmrAutoConf ? 0.0 : 40.0);
        GridPane.setColumnIndex((Node)titledGroupBg, (Integer)2);
        GridPane.setColumnSpan((Node)titledGroupBg, (Integer)2);
        this.preferredTradeCurrencyComboBox = FormBuilder.addComboBox((GridPane)this.root, this.displayCurrenciesGridRowIndex++, Res.get((String)"setting.preferences.prefCurrency"), 20.0);
        GridPane.setColumnIndex(this.preferredTradeCurrencyComboBox, (Integer)2);
        this.preferredTradeCurrencyComboBox.setConverter((StringConverter)new StringConverter<TradeCurrency>(this){

            public String toString(TradeCurrency object) {
                return object.getName() + " (" + object.getCode() + ")";
            }

            public TradeCurrency fromString(String string) {
                return null;
            }
        });
        this.preferredTradeCurrencyComboBox.setButtonCell(GUIUtil.getTradeCurrencyButtonCell("", "", (Map<String, Integer>)FXCollections.emptyObservableMap()));
        this.preferredTradeCurrencyComboBox.setCellFactory(GUIUtil.getTradeCurrencyCellFactory("", "", (Map<String, Integer>)FXCollections.emptyObservableMap()));
        Tuple3 traditionalTuple = FormBuilder.addTopLabelListView((GridPane)this.root, this.displayCurrenciesGridRowIndex, Res.get((String)"setting.preferences.displayTraditional"));
        int listRowSpan = 6;
        GridPane.setColumnIndex((Node)((Node)traditionalTuple.third), (Integer)2);
        GridPane.setRowSpan((Node)((Node)traditionalTuple.third), (Integer)listRowSpan);
        GridPane.setValignment((Node)((Node)traditionalTuple.third), (VPos)VPos.TOP);
        GridPane.setMargin((Node)((Node)traditionalTuple.third), (Insets)new Insets(10.0, 0.0, 0.0, 0.0));
        this.traditionalCurrenciesListView = (ListView)traditionalTuple.second;
        this.traditionalCurrenciesListView.setMinHeight(308.0);
        this.traditionalCurrenciesListView.setPrefHeight(342.0);
        AutoTooltipLabel placeholder = new AutoTooltipLabel(Res.get((String)"setting.preferences.noTraditional"));
        placeholder.setWrapText(true);
        this.traditionalCurrenciesListView.setPlaceholder((Node)placeholder);
        this.traditionalCurrenciesListView.setCellFactory((Callback)new Callback<ListView<TraditionalCurrency>, ListCell<TraditionalCurrency>>(){

            public ListCell<TraditionalCurrency> call(ListView<TraditionalCurrency> list) {
                return new ListCell<TraditionalCurrency>(){
                    final Label label = new AutoTooltipLabel();
                    final ImageView icon = ImageUtil.getImageViewById("image-remove");
                    final Button removeButton = new AutoTooltipButton("", (Node)this.icon);
                    final AnchorPane pane = new AnchorPane(new Node[]{this.label, this.removeButton});
                    {
                        this.label.setLayoutY(5.0);
                        this.removeButton.setId("icon-button");
                        AnchorPane.setRightAnchor((Node)this.removeButton, (Double)-30.0);
                    }

                    public void updateItem(TraditionalCurrency item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null && !empty) {
                            this.label.setText(item.getNameAndCode());
                            this.removeButton.setOnAction(e -> {
                                if (item.equals((Object)PreferencesView.this.preferences.getPreferredTradeCurrency())) {
                                    ((Popup)new Popup().warning(Res.get((String)"setting.preferences.cannotRemovePrefCurrency"))).show();
                                } else {
                                    PreferencesView.this.preferences.removeTraditionalCurrency(item);
                                    if (!PreferencesView.this.allTraditionalCurrencies.contains((Object)item)) {
                                        PreferencesView.this.allTraditionalCurrencies.add((Object)item);
                                        PreferencesView.this.allTraditionalCurrencies.sort(TradeCurrency::compareTo);
                                    }
                                }
                            });
                            this.setGraphic((Node)this.pane);
                        } else {
                            this.setGraphic(null);
                            this.removeButton.setOnAction(null);
                        }
                    }
                };
            }
        });
        Tuple3 cryptoCurrenciesTuple = FormBuilder.addTopLabelListView((GridPane)this.root, this.displayCurrenciesGridRowIndex, Res.get((String)"setting.preferences.displayCryptos"));
        GridPane.setColumnIndex((Node)((Node)cryptoCurrenciesTuple.third), (Integer)3);
        GridPane.setRowSpan((Node)((Node)cryptoCurrenciesTuple.third), (Integer)listRowSpan);
        GridPane.setValignment((Node)((Node)cryptoCurrenciesTuple.third), (VPos)VPos.TOP);
        GridPane.setMargin((Node)((Node)cryptoCurrenciesTuple.third), (Insets)new Insets(0.0, 0.0, 0.0, 20.0));
        this.cryptoCurrenciesListView = (ListView)cryptoCurrenciesTuple.second;
        this.cryptoCurrenciesListView.setMinHeight(308.0);
        this.cryptoCurrenciesListView.setPrefHeight(342.0);
        placeholder = new AutoTooltipLabel(Res.get((String)"setting.preferences.noCryptos"));
        placeholder.setWrapText(true);
        this.cryptoCurrenciesListView.setPlaceholder((Node)placeholder);
        this.cryptoCurrenciesListView.setCellFactory((Callback)new Callback<ListView<CryptoCurrency>, ListCell<CryptoCurrency>>(){

            public ListCell<CryptoCurrency> call(ListView<CryptoCurrency> list) {
                return new ListCell<CryptoCurrency>(){
                    final Label label = new AutoTooltipLabel();
                    final ImageView icon = ImageUtil.getImageViewById("image-remove");
                    final Button removeButton = new AutoTooltipButton("", (Node)this.icon);
                    final AnchorPane pane = new AnchorPane(new Node[]{this.label, this.removeButton});
                    {
                        this.label.setLayoutY(5.0);
                        this.removeButton.setId("icon-button");
                        AnchorPane.setRightAnchor((Node)this.removeButton, (Double)-30.0);
                    }

                    public void updateItem(CryptoCurrency item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null && !empty) {
                            this.label.setText(item.getNameAndCode());
                            this.removeButton.setOnAction(e -> {
                                if (item.equals((Object)PreferencesView.this.preferences.getPreferredTradeCurrency())) {
                                    ((Popup)new Popup().warning(Res.get((String)"setting.preferences.cannotRemovePrefCurrency"))).show();
                                } else {
                                    PreferencesView.this.preferences.removeCryptoCurrency(item);
                                    if (!PreferencesView.this.allCryptoCurrencies.contains((Object)item)) {
                                        PreferencesView.this.allCryptoCurrencies.add((Object)item);
                                        PreferencesView.this.allCryptoCurrencies.sort(TradeCurrency::compareTo);
                                    }
                                }
                            });
                            this.setGraphic((Node)this.pane);
                        } else {
                            this.setGraphic(null);
                            this.removeButton.setOnAction(null);
                        }
                    }
                };
            }
        });
        this.traditionalCurrenciesComboBox = FormBuilder.addComboBox((GridPane)this.root, this.displayCurrenciesGridRowIndex + listRowSpan);
        GridPane.setColumnIndex(this.traditionalCurrenciesComboBox, (Integer)2);
        GridPane.setValignment(this.traditionalCurrenciesComboBox, (VPos)VPos.TOP);
        this.traditionalCurrenciesComboBox.setPromptText(Res.get((String)"setting.preferences.addTraditional"));
        this.traditionalCurrenciesComboBox.setButtonCell((ListCell)new ListCell<TraditionalCurrency>(this){

            protected void updateItem(TraditionalCurrency item, boolean empty) {
                super.updateItem((Object)item, empty);
                this.setVisible(item != null || !empty);
                if (empty || item == null) {
                    this.setText(Res.get((String)"setting.preferences.addTraditional"));
                } else {
                    this.setText(item.getNameAndCode());
                }
            }
        });
        this.traditionalCurrenciesComboBox.setConverter((StringConverter)new StringConverter<TraditionalCurrency>(this){

            public String toString(TraditionalCurrency tradeCurrency) {
                return tradeCurrency.getNameAndCode();
            }

            public TraditionalCurrency fromString(String s) {
                return null;
            }
        });
        this.cryptoCurrenciesComboBox = FormBuilder.addComboBox((GridPane)this.root, this.displayCurrenciesGridRowIndex + listRowSpan);
        GridPane.setColumnIndex(this.cryptoCurrenciesComboBox, (Integer)3);
        GridPane.setValignment(this.cryptoCurrenciesComboBox, (VPos)VPos.TOP);
        GridPane.setMargin(this.cryptoCurrenciesComboBox, (Insets)new Insets(23.0, 0.0, 0.0, 20.0));
        this.cryptoCurrenciesComboBox.setPromptText(Res.get((String)"setting.preferences.addCrypto"));
        this.cryptoCurrenciesComboBox.setButtonCell((ListCell)new ListCell<CryptoCurrency>(this){

            protected void updateItem(CryptoCurrency item, boolean empty) {
                super.updateItem((Object)item, empty);
                this.setVisible(item != null || !empty);
                if (empty || item == null) {
                    this.setText(Res.get((String)"setting.preferences.addCrypto"));
                } else {
                    this.setText(item.getNameAndCode());
                }
            }
        });
        this.cryptoCurrenciesComboBox.setConverter((StringConverter)new StringConverter<CryptoCurrency>(this){

            public String toString(CryptoCurrency tradeCurrency) {
                return tradeCurrency.getNameAndCode();
            }

            public CryptoCurrency fromString(String s) {
                return null;
            }
        });
        this.displayCurrenciesGridRowIndex += listRowSpan;
    }

    private void initializeDisplayOptions() {
        TitledGroupBg titledGroupBg = FormBuilder.addTitledGroupBg((GridPane)this.root, ++this.gridRow, 7, Res.get((String)"setting.preferences.displayOptions"), 40.0);
        GridPane.setColumnSpan((Node)titledGroupBg, (Integer)1);
        this.showOwnOffersInOfferBook = FormBuilder.addSlideToggleButton((GridPane)this.root, this.gridRow, Res.get((String)"setting.preferences.showOwnOffers"), 60.0);
        this.useAnimations = FormBuilder.addSlideToggleButton((GridPane)this.root, ++this.gridRow, Res.get((String)"setting.preferences.useAnimations"));
        this.useDarkMode = FormBuilder.addSlideToggleButton((GridPane)this.root, ++this.gridRow, Res.get((String)"setting.preferences.useDarkMode"));
        this.sortMarketCurrenciesNumerically = FormBuilder.addSlideToggleButton((GridPane)this.root, ++this.gridRow, Res.get((String)"setting.preferences.sortWithNumOffers"));
        this.hideNonAccountPaymentMethodsToggle = FormBuilder.addSlideToggleButton((GridPane)this.root, ++this.gridRow, Res.get((String)"setting.preferences.onlyShowPaymentMethodsFromAccount"));
        this.resetDontShowAgainButton = FormBuilder.addButton((GridPane)this.root, ++this.gridRow, Res.get((String)"setting.preferences.resetAllFlags"), 0.0);
        this.resetDontShowAgainButton.getStyleClass().add((Object)"compact-button");
        this.resetDontShowAgainButton.setMaxWidth(Double.MAX_VALUE);
        GridPane.setHgrow((Node)this.resetDontShowAgainButton, (Priority)Priority.ALWAYS);
        GridPane.setColumnIndex((Node)this.resetDontShowAgainButton, (Integer)0);
    }

    private void initializeAutoConfirmOptions() {
        GridPane autoConfirmGridPane = new GridPane();
        GridPane.setHgrow((Node)autoConfirmGridPane, (Priority)Priority.ALWAYS);
        if (!this.hideXmrAutoConf) {
            ((GridPane)this.root).add((Node)autoConfirmGridPane, 2, this.displayCurrenciesGridRowIndex, 2, 10);
        }
        FormBuilder.addTitledGroupBg(autoConfirmGridPane, 0, 4, Res.get((String)"setting.preferences.autoConfirmXMR"), 0.0);
        int localRowIndex = 0;
        this.autoConfirmXmrToggle = FormBuilder.addSlideToggleButton(autoConfirmGridPane, localRowIndex, Res.get((String)"setting.preferences.autoConfirmEnabled"), 20.0);
        this.autoConfRequiredConfirmationsTf = FormBuilder.addInputTextField(autoConfirmGridPane, ++localRowIndex, Res.get((String)"setting.preferences.autoConfirmRequiredConfirmations"));
        this.autoConfRequiredConfirmationsTf.setValidator((InputValidator)new IntegerValidator(1, DevEnv.isDevMode() ? 100000000 : 1000));
        this.autoConfTradeLimitTf = FormBuilder.addInputTextField(autoConfirmGridPane, ++localRowIndex, Res.get((String)"setting.preferences.autoConfirmMaxTradeSize"));
        this.autoConfTradeLimitTf.setValidator((InputValidator)new XmrValidator());
        this.autoConfServiceAddressTf = FormBuilder.addInputTextField(autoConfirmGridPane, ++localRowIndex, Res.get((String)"setting.preferences.autoConfirmServiceAddresses"));
        GridPane.setHgrow((Node)this.autoConfServiceAddressTf, (Priority)Priority.ALWAYS);
        if (!this.hideXmrAutoConf) {
            this.displayCurrenciesGridRowIndex += 4;
        }
        this.autoConfServiceAddressListener = (observable, oldValue, newValue) -> {
            if (!newValue.equals(oldValue)) {
                RegexValidator onionRegex = RegexValidatorFactory.onionAddressRegexValidator();
                RegexValidator localhostRegex = RegexValidatorFactory.localhostAddressRegexValidator();
                RegexValidator localnetRegex = RegexValidatorFactory.localnetAddressRegexValidator();
                List serviceAddressesRaw = Arrays.asList(StringUtils.deleteWhitespace((String)newValue).split(","));
                if (serviceAddressesRaw.size() == 1 && serviceAddressesRaw.get(0).isEmpty()) {
                    serviceAddressesRaw = this.preferences.getDefaultXmrTxProofServices();
                }
                ArrayList serviceAddressesParsed = new ArrayList();
                serviceAddressesRaw.forEach(addr -> {
                    addr = addr.replaceAll("http://", "").replaceAll("https://", "");
                    if (onionRegex.validate((String)addr).isValid) {
                        this.log.info("Using Tor for onion hostname: {}", addr);
                        serviceAddressesParsed.add(addr);
                    } else if (localhostRegex.validate((String)addr).isValid) {
                        this.log.info("Using HTTP without Tor for Loopback address: {}", addr);
                        serviceAddressesParsed.add("http://" + addr);
                    } else if (localnetRegex.validate((String)addr).isValid) {
                        this.log.info("Using HTTP without Tor for LAN address: {}", addr);
                        serviceAddressesParsed.add("http://" + addr);
                    } else {
                        this.log.info("Using HTTPS with Tor for Clearnet address: {}", addr);
                        serviceAddressesParsed.add("https://" + addr);
                    }
                });
                this.preferences.setAutoConfServiceAddresses("XMR", serviceAddressesParsed);
            }
        };
        this.autoConfTradeLimitListener = (observable, oldValue, newValue) -> {
            if (!newValue.equals(oldValue) && this.autoConfTradeLimitTf.getValidator().validate((String)newValue).isValid) {
                BigInteger amount = HavenoUtils.parseXmr((String)newValue);
                this.preferences.setAutoConfTradeLimit("XMR", amount.longValueExact());
            }
        };
        this.autoConfServiceAddressFocusOutListener = (observable, oldValue, newValue) -> {
            if (oldValue.booleanValue() && !newValue.booleanValue()) {
                this.log.info("Service address focus out, check and re-display default option");
                if (this.autoConfServiceAddressTf.getText().isEmpty()) {
                    this.preferences.findAutoConfirmSettings("XMR").ifPresent(autoConfirmSettings -> {
                        List serviceAddresses = autoConfirmSettings.getServiceAddresses();
                        this.autoConfServiceAddressTf.setText(String.join((CharSequence)", ", serviceAddresses));
                    });
                }
            }
        };
        this.autoConfRequiredConfirmationsFocusOutListener = (observable, oldValue, newValue) -> {
            if (oldValue.booleanValue() && !newValue.booleanValue()) {
                String txt = this.autoConfRequiredConfirmationsTf.getText();
                if (this.autoConfRequiredConfirmationsTf.getValidator().validate((String)txt).isValid) {
                    int requiredConfirmations = Integer.parseInt(txt);
                    this.preferences.setAutoConfRequiredConfirmations("XMR", requiredConfirmations);
                } else {
                    this.preferences.findAutoConfirmSettings("XMR").ifPresent(e -> this.autoConfRequiredConfirmationsTf.setText(String.valueOf(e.getRequiredConfirmations())));
                }
            }
        };
        this.filterChangeListener = (observable, oldValue, newValue) -> autoConfirmGridPane.setDisable(newValue != null && newValue.isDisableAutoConf());
        autoConfirmGridPane.setDisable(this.filterManager.getFilter() != null && this.filterManager.getFilter().isDisableAutoConf());
    }

    private void activateGeneralOptions() {
        this.ignoreTradersListInputTextField.setText(String.join((CharSequence)", ", this.preferences.getIgnoreTradersList()));
        this.clearDataAfterDaysInputTextField.setText(String.valueOf(this.preferences.getClearDataAfterDays()));
        this.userLanguageComboBox.setItems(this.languageCodes);
        this.userLanguageComboBox.getSelectionModel().select((Object)this.preferences.getUserLanguage());
        this.userLanguageComboBox.setConverter((StringConverter)new StringConverter<String>(this){

            public String toString(String code) {
                return LanguageUtil.getDisplayName((String)code);
            }

            public String fromString(String string) {
                return null;
            }
        });
        this.userLanguageComboBox.setOnAction(e -> {
            String selectedItem = (String)this.userLanguageComboBox.getSelectionModel().getSelectedItem();
            if (selectedItem != null) {
                this.preferences.setUserLanguage(selectedItem);
                ((Popup)((Popup)new Popup().information(Res.get((String)"settings.preferences.languageChange"))).closeButtonText(Res.get((String)"shared.ok"))).show();
                if (((PreferencesViewModel)this.model).needsSupportLanguageWarning()) {
                    ((Popup)((Popup)new Popup().warning(Res.get((String)"settings.preferences.supportLanguageWarning", (Object[])new Object[]{((PreferencesViewModel)this.model).getArbitrationLanguages()}))).closeButtonText(Res.get((String)"shared.ok"))).show();
                }
            }
        });
        this.userCountryComboBox.setItems(this.countries);
        this.userCountryComboBox.getSelectionModel().select((Object)this.preferences.getUserCountry());
        this.userCountryComboBox.setConverter((StringConverter)new StringConverter<Country>(this){

            public String toString(Country country) {
                return CountryUtil.getNameByCode((String)country.code);
            }

            public Country fromString(String string) {
                return null;
            }
        });
        this.userCountryComboBox.setOnAction(e -> {
            Country country = (Country)this.userCountryComboBox.getSelectionModel().getSelectedItem();
            if (country != null) {
                this.preferences.setUserCountry(country);
            }
        });
        this.xmrExplorerTextField.setText(this.preferences.getBlockChainExplorer().name);
        this.deviationInputTextField.setText(FormattingUtils.formatToPercentWithSymbol((double)this.preferences.getMaxPriceDistanceInPercent()));
        this.deviationInputTextField.textProperty().addListener(this.deviationListener);
        this.deviationInputTextField.focusedProperty().addListener(this.deviationFocusedListener);
        this.ignoreTradersListInputTextField.textProperty().addListener(this.ignoreTradersListListener);
        this.clearDataAfterDaysInputTextField.textProperty().addListener(this.clearDataAfterDaysListener);
    }

    private void activateDisplayCurrencies() {
        this.preferredTradeCurrencyComboBox.setItems(this.tradeCurrencies);
        this.preferredTradeCurrencyComboBox.getSelectionModel().select((Object)this.preferences.getPreferredTradeCurrency());
        this.preferredTradeCurrencyComboBox.setVisibleRowCount(12);
        this.preferredTradeCurrencyComboBox.setOnAction(e -> {
            TradeCurrency selectedItem = (TradeCurrency)this.preferredTradeCurrencyComboBox.getSelectionModel().getSelectedItem();
            if (selectedItem != null) {
                this.preferences.setPreferredTradeCurrency(selectedItem);
            }
        });
        this.traditionalCurrenciesComboBox.setItems(this.allTraditionalCurrencies);
        this.traditionalCurrenciesListView.setItems(this.traditionalCurrencies);
        this.traditionalCurrenciesComboBox.setOnHiding(e -> {
            TraditionalCurrency selectedItem = (TraditionalCurrency)this.traditionalCurrenciesComboBox.getSelectionModel().getSelectedItem();
            if (selectedItem != null) {
                this.preferences.addTraditionalCurrency(selectedItem);
                if (this.allTraditionalCurrencies.contains((Object)selectedItem)) {
                    UserThread.execute(() -> {
                        this.traditionalCurrenciesComboBox.getSelectionModel().clearSelection();
                        this.allTraditionalCurrencies.remove((Object)selectedItem);
                    });
                }
            }
        });
        this.cryptoCurrenciesComboBox.setItems(this.allCryptoCurrencies);
        this.cryptoCurrenciesListView.setItems(this.cryptoCurrencies);
        this.cryptoCurrenciesComboBox.setOnHiding(e -> {
            CryptoCurrency selectedItem = (CryptoCurrency)this.cryptoCurrenciesComboBox.getSelectionModel().getSelectedItem();
            if (selectedItem != null) {
                this.preferences.addCryptoCurrency(selectedItem);
                if (this.allCryptoCurrencies.contains((Object)selectedItem)) {
                    UserThread.execute(() -> {
                        this.cryptoCurrenciesComboBox.getSelectionModel().clearSelection();
                        this.allCryptoCurrencies.remove((Object)selectedItem);
                    });
                }
            }
        });
    }

    private void activateDisplayPreferences() {
        this.showOwnOffersInOfferBook.setSelected(this.preferences.isShowOwnOffersInOfferBook());
        this.showOwnOffersInOfferBook.setOnAction(e -> this.preferences.setShowOwnOffersInOfferBook(this.showOwnOffersInOfferBook.isSelected()));
        this.useAnimations.setSelected(this.preferences.isUseAnimations());
        this.useAnimations.setOnAction(e -> this.preferences.setUseAnimations(this.useAnimations.isSelected()));
        this.useDarkMode.setSelected(this.preferences.getCssTheme() == 1);
        this.useDarkMode.setOnAction(e -> this.preferences.setCssTheme(this.useDarkMode.isSelected()));
        this.sortMarketCurrenciesNumerically.setSelected(this.preferences.isSortMarketCurrenciesNumerically());
        this.sortMarketCurrenciesNumerically.setOnAction(e -> this.preferences.setSortMarketCurrenciesNumerically(this.sortMarketCurrenciesNumerically.isSelected()));
        boolean disableToggle = false;
        if (this.user.getPaymentAccounts() != null) {
            Set supportedPaymentMethods = this.user.getPaymentAccounts().stream().map(PaymentAccount::getPaymentMethod).collect(Collectors.toSet());
            disableToggle = supportedPaymentMethods.isEmpty();
        }
        this.hideNonAccountPaymentMethodsToggle.setSelected(this.preferences.isHideNonAccountPaymentMethods() && !disableToggle);
        this.hideNonAccountPaymentMethodsToggle.setOnAction(e -> this.preferences.setHideNonAccountPaymentMethods(this.hideNonAccountPaymentMethodsToggle.isSelected()));
        this.hideNonAccountPaymentMethodsToggle.setDisable(disableToggle);
        this.resetDontShowAgainButton.setOnAction(e -> this.preferences.resetDontShowAgain());
        this.editCustomBtcExplorer.setOnAction(e -> {
            EditCustomExplorerWindow urlWindow = new EditCustomExplorerWindow("XMR", this.preferences.getBlockChainExplorer(), this.preferences.getBlockChainExplorers());
            ((EditCustomExplorerWindow)((EditCustomExplorerWindow)((EditCustomExplorerWindow)((EditCustomExplorerWindow)urlWindow.actionButtonText(Res.get((String)"shared.save"))).onAction(() -> {
                this.preferences.setBlockChainExplorer(urlWindow.getEditedBlockChainExplorer());
                this.xmrExplorerTextField.setText(this.preferences.getBlockChainExplorer().name);
            })).closeButtonText(Res.get((String)"shared.cancel"))).onClose(urlWindow::hide)).show();
        });
        if (this.displayStandbyModeFeature) {
            this.avoidStandbyMode.setSelected(!this.preferences.isUseStandbyMode());
            this.avoidStandbyMode.setOnAction(e -> this.preferences.setUseStandbyMode(!this.avoidStandbyMode.isSelected()));
        } else {
            this.preferences.setUseStandbyMode(false);
        }
        this.useSoundForNotifications.setSelected(this.preferences.isUseSoundForNotifications());
        this.useSoundForNotifications.setOnAction(e -> this.preferences.setUseSoundForNotifications(this.useSoundForNotifications.isSelected()));
    }

    private void activateAutoConfirmPreferences() {
        this.preferences.findAutoConfirmSettings("XMR").ifPresent(autoConfirmSettings -> {
            this.autoConfirmXmrToggle.setSelected(autoConfirmSettings.isEnabled());
            this.autoConfRequiredConfirmationsTf.setText(String.valueOf(autoConfirmSettings.getRequiredConfirmations()));
            this.autoConfTradeLimitTf.setText(HavenoUtils.formatXmr((long)autoConfirmSettings.getTradeLimit()));
            this.autoConfServiceAddressTf.setText(String.join((CharSequence)", ", autoConfirmSettings.getServiceAddresses()));
            this.autoConfRequiredConfirmationsTf.focusedProperty().addListener(this.autoConfRequiredConfirmationsFocusOutListener);
            this.autoConfTradeLimitTf.textProperty().addListener(this.autoConfTradeLimitListener);
            this.autoConfServiceAddressTf.textProperty().addListener(this.autoConfServiceAddressListener);
            this.autoConfServiceAddressTf.focusedProperty().addListener(this.autoConfServiceAddressFocusOutListener);
            this.autoConfirmXmrToggle.setOnAction(e -> this.preferences.setAutoConfEnabled(autoConfirmSettings.getCurrencyCode(), this.autoConfirmXmrToggle.isSelected()));
            this.filterManager.filterProperty().addListener(this.filterChangeListener);
        });
    }

    private void deactivateGeneralOptions() {
        this.userLanguageComboBox.setOnAction(null);
        this.userCountryComboBox.setOnAction(null);
        this.editCustomBtcExplorer.setOnAction(null);
        this.deviationInputTextField.textProperty().removeListener(this.deviationListener);
        this.deviationInputTextField.focusedProperty().removeListener(this.deviationFocusedListener);
        this.ignoreTradersListInputTextField.textProperty().removeListener(this.ignoreTradersListListener);
        this.clearDataAfterDaysInputTextField.textProperty().removeListener(this.clearDataAfterDaysListener);
    }

    private void deactivateDisplayCurrencies() {
        this.preferredTradeCurrencyComboBox.setOnAction(null);
    }

    private void deactivateDisplayPreferences() {
        this.useAnimations.setOnAction(null);
        this.useDarkMode.setOnAction(null);
        this.sortMarketCurrenciesNumerically.setOnAction(null);
        this.hideNonAccountPaymentMethodsToggle.setOnAction(null);
        this.showOwnOffersInOfferBook.setOnAction(null);
        this.resetDontShowAgainButton.setOnAction(null);
        if (this.displayStandbyModeFeature) {
            this.avoidStandbyMode.setOnAction(null);
        }
    }

    private void deactivateAutoConfirmPreferences() {
        this.preferences.findAutoConfirmSettings("XMR").ifPresent(autoConfirmSettings -> {
            this.autoConfirmXmrToggle.setOnAction(null);
            this.autoConfTradeLimitTf.textProperty().removeListener(this.autoConfTradeLimitListener);
            this.autoConfServiceAddressTf.textProperty().removeListener(this.autoConfServiceAddressListener);
            this.autoConfServiceAddressTf.focusedProperty().removeListener(this.autoConfServiceAddressFocusOutListener);
            this.autoConfRequiredConfirmationsTf.focusedProperty().removeListener(this.autoConfRequiredConfirmationsFocusOutListener);
            this.filterManager.filterProperty().removeListener(this.filterChangeListener);
        });
    }
}

