/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.settings.network;

import haveno.common.ClockWatcher;
import haveno.core.locale.Res;
import haveno.core.util.FormattingUtils;
import haveno.desktop.util.DisplayUtils;
import haveno.network.p2p.network.Connection;
import haveno.network.p2p.network.ConnectionState;
import haveno.network.p2p.network.OutboundConnection;
import haveno.network.p2p.network.PeerType;
import haveno.network.p2p.network.Statistic;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.fxmisc.easybind.EasyBind;
import org.fxmisc.easybind.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class P2pNetworkListItem {
    private static final Logger log = LoggerFactory.getLogger(P2pNetworkListItem.class);
    private final Statistic statistic;
    private final Connection connection;
    private final Subscription sentBytesSubscription;
    private final Subscription receivedBytesSubscription;
    private final Subscription onionAddressSubscription;
    private final Subscription roundTripTimeSubscription;
    private final ClockWatcher clockWatcher;
    private final StringProperty lastActivity = new SimpleStringProperty();
    private final StringProperty sentBytes = new SimpleStringProperty();
    private final StringProperty receivedBytes = new SimpleStringProperty();
    private final StringProperty peerType = new SimpleStringProperty();
    private final StringProperty connectionType = new SimpleStringProperty();
    private final StringProperty roundTripTime = new SimpleStringProperty();
    private final StringProperty onionAddress = new SimpleStringProperty();
    private final ClockWatcher.Listener listener;

    P2pNetworkListItem(Connection connection, ClockWatcher clockWatcher) {
        this.connection = connection;
        this.clockWatcher = clockWatcher;
        this.statistic = connection.getStatistic();
        this.sentBytesSubscription = EasyBind.subscribe((ObservableValue)this.statistic.sentBytesProperty(), e -> this.sentBytes.set((Object)FormattingUtils.formatBytes((long)((Long)e))));
        this.receivedBytesSubscription = EasyBind.subscribe((ObservableValue)this.statistic.receivedBytesProperty(), e -> this.receivedBytes.set((Object)FormattingUtils.formatBytes((long)((Long)e))));
        this.onionAddressSubscription = EasyBind.subscribe((ObservableValue)connection.getPeersNodeAddressProperty(), nodeAddress -> this.onionAddress.set((Object)(nodeAddress != null ? nodeAddress.getFullAddress() : Res.get((String)"settings.net.notKnownYet"))));
        this.roundTripTimeSubscription = EasyBind.subscribe((ObservableValue)this.statistic.roundTripTimeProperty(), roundTripTime -> this.roundTripTime.set((Integer)roundTripTime == 0 ? "-" : String.valueOf(roundTripTime) + " ms"));
        this.listener = new ClockWatcher.Listener(){

            public void onSecondTick() {
                P2pNetworkListItem.this.onLastActivityChanged(P2pNetworkListItem.this.statistic.getLastActivityTimestamp());
                P2pNetworkListItem.this.updatePeerType();
                P2pNetworkListItem.this.updateConnectionType();
            }

            public void onMinuteTick() {
            }
        };
        clockWatcher.addListener(this.listener);
        this.onLastActivityChanged(this.statistic.getLastActivityTimestamp());
        this.updatePeerType();
        this.updateConnectionType();
    }

    private void onLastActivityChanged(long timeStamp) {
        this.lastActivity.set((Object)DurationFormatUtils.formatDuration((long)Math.abs(System.currentTimeMillis() - timeStamp), (String)"mm:ss.SSS"));
    }

    public void cleanup() {
        this.sentBytesSubscription.unsubscribe();
        this.receivedBytesSubscription.unsubscribe();
        this.onionAddressSubscription.unsubscribe();
        this.roundTripTimeSubscription.unsubscribe();
        this.clockWatcher.removeListener(this.listener);
    }

    public void updateConnectionType() {
        this.connectionType.set((Object)(this.connection instanceof OutboundConnection ? Res.get((String)"settings.net.outbound") : Res.get((String)"settings.net.inbound")));
    }

    public void updatePeerType() {
        ConnectionState connectionState = this.connection.getConnectionState();
        if (connectionState.getPeerType() == PeerType.DIRECT_MSG_PEER) {
            this.peerType.set((Object)Res.get((String)"settings.net.directPeer"));
        } else {
            String peerOrSeed;
            String string = peerOrSeed = connectionState.isSeedNode() ? Res.get((String)"settings.net.seedNode") : Res.get((String)"settings.net.peer");
            if (connectionState.getPeerType() == PeerType.INITIAL_DATA_EXCHANGE) {
                this.peerType.set((Object)Res.get((String)"settings.net.initialDataExchange", (Object[])new Object[]{peerOrSeed}));
            } else {
                this.peerType.set((Object)peerOrSeed);
            }
        }
    }

    public String getCreationDate() {
        return DisplayUtils.formatDateTime(this.statistic.getCreationDate());
    }

    public String getOnionAddress() {
        return (String)this.onionAddress.get();
    }

    public StringProperty onionAddressProperty() {
        return this.onionAddress;
    }

    public String getConnectionType() {
        return (String)this.connectionType.get();
    }

    public StringProperty connectionTypeProperty() {
        return this.connectionType;
    }

    public String getPeerType() {
        return (String)this.peerType.get();
    }

    public StringProperty peerTypeProperty() {
        return this.peerType;
    }

    public String getLastActivity() {
        return (String)this.lastActivity.get();
    }

    public StringProperty lastActivityProperty() {
        return this.lastActivity;
    }

    public String getSentBytes() {
        return (String)this.sentBytes.get();
    }

    public StringProperty sentBytesProperty() {
        return this.sentBytes;
    }

    public String getReceivedBytes() {
        return (String)this.receivedBytes.get();
    }

    public StringProperty receivedBytesProperty() {
        return this.receivedBytes;
    }

    public String getRoundTripTime() {
        return (String)this.roundTripTime.get();
    }

    public StringProperty roundTripTimeProperty() {
        return this.roundTripTime;
    }
}

