/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.settings.network;

import com.google.inject.Inject;
import haveno.common.ClockWatcher;
import haveno.common.UserThread;
import haveno.core.api.XmrConnectionService;
import haveno.core.api.XmrLocalNode;
import haveno.core.filter.Filter;
import haveno.core.filter.FilterManager;
import haveno.core.locale.Res;
import haveno.core.trade.HavenoUtils;
import haveno.core.user.Preferences;
import haveno.core.util.FormattingUtils;
import haveno.core.util.validation.InputValidator;
import haveno.core.util.validation.RegexValidator;
import haveno.core.util.validation.RegexValidatorFactory;
import haveno.core.xmr.nodes.XmrNodes;
import haveno.core.xmr.setup.WalletsSetup;
import haveno.desktop.app.HavenoApp;
import haveno.desktop.common.view.ActivatableView;
import haveno.desktop.common.view.FxmlView;
import haveno.desktop.components.AutoTooltipButton;
import haveno.desktop.components.AutoTooltipLabel;
import haveno.desktop.components.InputTextField;
import haveno.desktop.components.TitledGroupBg;
import haveno.desktop.main.overlays.popups.Popup;
import haveno.desktop.main.overlays.windows.TorNetworkSettingsWindow;
import haveno.desktop.main.settings.network.MoneroNetworkListItem;
import haveno.desktop.main.settings.network.P2pNetworkListItem;
import haveno.desktop.util.GUIUtil;
import haveno.network.p2p.P2PService;
import haveno.network.p2p.network.Connection;
import haveno.network.p2p.network.Statistic;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.SortedList;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.GridPane;
import monero.common.MoneroRpcConnection;
import org.fxmisc.easybind.EasyBind;
import org.fxmisc.easybind.Subscription;

@FxmlView
public class NetworkSettingsView
extends ActivatableView<GridPane, Void> {
    @FXML
    TitledGroupBg p2pHeader;
    @FXML
    TitledGroupBg btcHeader;
    @FXML
    Label useTorForXmrLabel;
    @FXML
    Label xmrNodesLabel;
    @FXML
    Label moneroNodesLabel;
    @FXML
    Label localhostXmrNodeInfoLabel;
    @FXML
    InputTextField xmrNodesInputTextField;
    @FXML
    TextField onionAddress;
    @FXML
    TextField sentDataTextField;
    @FXML
    TextField receivedDataTextField;
    @FXML
    TextField chainHeightTextField;
    @FXML
    Label p2PPeersLabel;
    @FXML
    Label moneroConnectionsLabel;
    @FXML
    RadioButton useTorForXmrAfterSyncRadio;
    @FXML
    RadioButton useTorForXmrOffRadio;
    @FXML
    RadioButton useTorForXmrOnRadio;
    @FXML
    RadioButton useProvidedNodesRadio;
    @FXML
    RadioButton useCustomNodesRadio;
    @FXML
    RadioButton usePublicNodesRadio;
    @FXML
    TableView<P2pNetworkListItem> p2pPeersTableView;
    @FXML
    TableView<MoneroNetworkListItem> moneroConnectionsTableView;
    @FXML
    TableColumn<P2pNetworkListItem, String> onionAddressColumn;
    @FXML
    TableColumn<P2pNetworkListItem, String> connectionTypeColumn;
    @FXML
    TableColumn<P2pNetworkListItem, String> creationDateColumn;
    @FXML
    TableColumn<P2pNetworkListItem, String> roundTripTimeColumn;
    @FXML
    TableColumn<P2pNetworkListItem, String> sentBytesColumn;
    @FXML
    TableColumn<P2pNetworkListItem, String> receivedBytesColumn;
    @FXML
    TableColumn<P2pNetworkListItem, String> peerTypeColumn;
    @FXML
    TableColumn<MoneroNetworkListItem, String> moneroConnectionAddressColumn;
    @FXML
    TableColumn<MoneroNetworkListItem, String> moneroConnectionConnectedColumn;
    @FXML
    Label rescanOutputsLabel;
    @FXML
    AutoTooltipButton rescanOutputsButton;
    @FXML
    AutoTooltipButton openTorSettingsButton;
    private final Preferences preferences;
    private final XmrNodes xmrNodes;
    private final FilterManager filterManager;
    private final XmrLocalNode xmrLocalNode;
    private final TorNetworkSettingsWindow torNetworkSettingsWindow;
    private final ClockWatcher clockWatcher;
    private final WalletsSetup walletsSetup;
    private final P2PService p2PService;
    private final XmrConnectionService connectionService;
    private final ObservableList<P2pNetworkListItem> p2pNetworkListItems = FXCollections.observableArrayList();
    private final SortedList<P2pNetworkListItem> p2pSortedList = new SortedList(this.p2pNetworkListItems);
    private final ObservableList<MoneroNetworkListItem> moneroNetworkListItems = FXCollections.observableArrayList();
    private final SortedList<MoneroNetworkListItem> moneroSortedList = new SortedList(this.moneroNetworkListItems);
    private Subscription numP2PPeersSubscription;
    private Subscription moneroConnectionsSubscription;
    private Subscription moneroBlockHeightSubscription;
    private Subscription nodeAddressSubscription;
    private ChangeListener<Boolean> xmrNodesInputTextFieldFocusListener;
    private ToggleGroup useTorForXmrToggleGroup;
    private ToggleGroup moneroPeersToggleGroup;
    private Preferences.UseTorForXmr selectedUseTorForXmr;
    private XmrNodes.MoneroNodesOption selectedMoneroNodesOption;
    private ChangeListener<Toggle> useTorForXmrToggleGroupListener;
    private ChangeListener<Toggle> moneroPeersToggleGroupListener;
    private ChangeListener<Filter> filterPropertyListener;

    @Inject
    public NetworkSettingsView(WalletsSetup walletsSetup, P2PService p2PService, XmrConnectionService connectionService, Preferences preferences, XmrNodes xmrNodes, FilterManager filterManager, XmrLocalNode xmrLocalNode, TorNetworkSettingsWindow torNetworkSettingsWindow, ClockWatcher clockWatcher) {
        this.walletsSetup = walletsSetup;
        this.p2PService = p2PService;
        this.connectionService = connectionService;
        this.preferences = preferences;
        this.xmrNodes = xmrNodes;
        this.filterManager = filterManager;
        this.xmrLocalNode = xmrLocalNode;
        this.torNetworkSettingsWindow = torNetworkSettingsWindow;
        this.clockWatcher = clockWatcher;
    }

    @Override
    public void initialize() {
        GUIUtil.applyTableStyle(this.p2pPeersTableView);
        GUIUtil.applyTableStyle(this.moneroConnectionsTableView);
        this.onionAddress.getStyleClass().add((Object)"label-float");
        this.sentDataTextField.getStyleClass().add((Object)"label-float");
        this.receivedDataTextField.getStyleClass().add((Object)"label-float");
        this.chainHeightTextField.getStyleClass().add((Object)"label-float");
        this.btcHeader.setText(Res.get((String)"settings.net.xmrHeader"));
        this.p2pHeader.setText(Res.get((String)"settings.net.p2pHeader"));
        this.onionAddress.setPromptText(Res.get((String)"settings.net.onionAddressLabel"));
        this.xmrNodesLabel.setText(Res.get((String)"settings.net.xmrNodesLabel"));
        this.moneroConnectionsLabel.setText(Res.get((String)"settings.net.moneroPeersLabel"));
        this.useTorForXmrLabel.setText(Res.get((String)"settings.net.useTorForXmrJLabel"));
        this.useTorForXmrAfterSyncRadio.setText(Res.get((String)"settings.net.useTorForXmrAfterSyncRadio"));
        this.useTorForXmrOffRadio.setText(Res.get((String)"settings.net.useTorForXmrOffRadio"));
        this.useTorForXmrOnRadio.setText(Res.get((String)"settings.net.useTorForXmrOnRadio"));
        this.moneroNodesLabel.setText(Res.get((String)"settings.net.moneroNodesLabel"));
        this.moneroConnectionAddressColumn.setGraphic((Node)new AutoTooltipLabel(Res.get((String)"shared.address")));
        this.moneroConnectionConnectedColumn.setGraphic((Node)new AutoTooltipLabel(Res.get((String)"settings.net.connection")));
        this.localhostXmrNodeInfoLabel.setText(Res.get((String)"settings.net.localhostXmrNodeInfo"));
        this.useProvidedNodesRadio.setText(Res.get((String)"settings.net.useProvidedNodesRadio"));
        this.useCustomNodesRadio.setText(Res.get((String)"settings.net.useCustomNodesRadio"));
        this.usePublicNodesRadio.setText(Res.get((String)"settings.net.usePublicNodesRadio"));
        this.rescanOutputsLabel.setText(Res.get((String)"settings.net.rescanOutputsLabel"));
        this.rescanOutputsButton.updateText(Res.get((String)"settings.net.rescanOutputsButton"));
        this.p2PPeersLabel.setText(Res.get((String)"settings.net.p2PPeersLabel"));
        this.onionAddressColumn.setGraphic((Node)new AutoTooltipLabel(Res.get((String)"settings.net.onionAddressColumn")));
        this.creationDateColumn.setGraphic((Node)new AutoTooltipLabel(Res.get((String)"settings.net.creationDateColumn")));
        this.connectionTypeColumn.setGraphic((Node)new AutoTooltipLabel(Res.get((String)"settings.net.connectionTypeColumn")));
        this.sentDataTextField.setPromptText(Res.get((String)"settings.net.sentDataLabel"));
        this.receivedDataTextField.setPromptText(Res.get((String)"settings.net.receivedDataLabel"));
        this.chainHeightTextField.setPromptText(Res.get((String)"settings.net.chainHeightLabel"));
        this.roundTripTimeColumn.setGraphic((Node)new AutoTooltipLabel(Res.get((String)"settings.net.roundTripTimeColumn")));
        this.sentBytesColumn.setGraphic((Node)new AutoTooltipLabel(Res.get((String)"settings.net.sentBytesColumn")));
        this.receivedBytesColumn.setGraphic((Node)new AutoTooltipLabel(Res.get((String)"settings.net.receivedBytesColumn")));
        this.peerTypeColumn.setGraphic((Node)new AutoTooltipLabel(Res.get((String)"settings.net.peerTypeColumn")));
        this.openTorSettingsButton.updateText(Res.get((String)"settings.net.openTorSettingsButton"));
        this.rescanOutputsLabel.setVisible(false);
        this.rescanOutputsButton.setVisible(false);
        GridPane.setMargin((Node)this.moneroConnectionsLabel, (Insets)new Insets(4.0, 0.0, 0.0, 0.0));
        GridPane.setValignment((Node)this.moneroConnectionsLabel, (VPos)VPos.TOP);
        GridPane.setMargin((Node)this.p2PPeersLabel, (Insets)new Insets(4.0, 0.0, 0.0, 0.0));
        GridPane.setValignment((Node)this.p2PPeersLabel, (VPos)VPos.TOP);
        this.moneroConnectionAddressColumn.setSortType(TableColumn.SortType.ASCENDING);
        this.moneroConnectionConnectedColumn.setSortType(TableColumn.SortType.DESCENDING);
        this.moneroConnectionsTableView.setMinHeight(180.0);
        this.moneroConnectionsTableView.setPrefHeight(180.0);
        this.moneroConnectionsTableView.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        this.moneroConnectionsTableView.setPlaceholder((Node)new AutoTooltipLabel(Res.get((String)"table.placeholder.noData")));
        this.moneroConnectionsTableView.getSortOrder().add(this.moneroConnectionConnectedColumn);
        this.p2pPeersTableView.setMinHeight(180.0);
        this.p2pPeersTableView.setPrefHeight(180.0);
        this.p2pPeersTableView.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        this.p2pPeersTableView.setPlaceholder((Node)new AutoTooltipLabel(Res.get((String)"table.placeholder.noData")));
        this.p2pPeersTableView.getSortOrder().add(this.creationDateColumn);
        this.creationDateColumn.setSortType(TableColumn.SortType.ASCENDING);
        this.useTorForXmrToggleGroup = new ToggleGroup();
        this.useTorForXmrAfterSyncRadio.setToggleGroup(this.useTorForXmrToggleGroup);
        this.useTorForXmrOffRadio.setToggleGroup(this.useTorForXmrToggleGroup);
        this.useTorForXmrOnRadio.setToggleGroup(this.useTorForXmrToggleGroup);
        this.useTorForXmrAfterSyncRadio.setUserData((Object)Preferences.UseTorForXmr.AFTER_SYNC);
        this.useTorForXmrOffRadio.setUserData((Object)Preferences.UseTorForXmr.OFF);
        this.useTorForXmrOnRadio.setUserData((Object)Preferences.UseTorForXmr.ON);
        this.selectedUseTorForXmr = Preferences.UseTorForXmr.values()[this.preferences.getUseTorForXmrOrdinal()];
        this.selectUseTorForXmrToggle();
        this.onUseTorForXmrToggleSelected(false);
        this.useTorForXmrToggleGroupListener = (observable, oldValue, newValue) -> {
            if (newValue != null) {
                this.selectedUseTorForXmr = (Preferences.UseTorForXmr)newValue.getUserData();
                this.onUseTorForXmrToggleSelected(true);
            }
        };
        this.moneroPeersToggleGroup = new ToggleGroup();
        this.useProvidedNodesRadio.setToggleGroup(this.moneroPeersToggleGroup);
        this.useCustomNodesRadio.setToggleGroup(this.moneroPeersToggleGroup);
        this.usePublicNodesRadio.setToggleGroup(this.moneroPeersToggleGroup);
        this.useProvidedNodesRadio.setUserData((Object)XmrNodes.MoneroNodesOption.PROVIDED);
        this.useCustomNodesRadio.setUserData((Object)XmrNodes.MoneroNodesOption.CUSTOM);
        this.usePublicNodesRadio.setUserData((Object)XmrNodes.MoneroNodesOption.PUBLIC);
        this.selectedMoneroNodesOption = XmrNodes.MoneroNodesOption.values()[this.preferences.getMoneroNodesOptionOrdinal()];
        if (this.selectedMoneroNodesOption == XmrNodes.MoneroNodesOption.CUSTOM && (this.preferences.getMoneroNodes() == null || this.preferences.getMoneroNodes().isEmpty()) || this.selectedMoneroNodesOption == XmrNodes.MoneroNodesOption.PUBLIC && this.isPreventPublicXmrNetwork()) {
            this.selectedMoneroNodesOption = XmrNodes.MoneroNodesOption.PROVIDED;
            this.preferences.setMoneroNodesOptionOrdinal(this.selectedMoneroNodesOption.ordinal());
        }
        this.selectMoneroPeersToggle();
        this.onMoneroPeersToggleSelected(false);
        this.moneroPeersToggleGroupListener = (observable, oldValue, newValue) -> {
            if (newValue != null) {
                this.selectedMoneroNodesOption = (XmrNodes.MoneroNodesOption)newValue.getUserData();
                this.onMoneroPeersToggleSelected(true);
            }
        };
        this.xmrNodesInputTextField.setPromptText(Res.get((String)"settings.net.ips", (Object[])new Object[]{"" + HavenoUtils.getDefaultMoneroPort()}));
        RegexValidator regexValidator = RegexValidatorFactory.addressRegexValidator();
        this.xmrNodesInputTextField.setValidator((InputValidator)regexValidator);
        this.xmrNodesInputTextField.setErrorMessage(Res.get((String)"validation.invalidAddressList"));
        this.xmrNodesInputTextFieldFocusListener = (observable, oldValue, newValue) -> {
            if (oldValue.booleanValue() && !newValue.booleanValue() && !this.xmrNodesInputTextField.getText().equals(this.preferences.getMoneroNodes()) && this.xmrNodesInputTextField.validate()) {
                this.preferences.setMoneroNodes(this.xmrNodesInputTextField.getText());
                this.preferences.setMoneroNodesOptionOrdinal(this.selectedMoneroNodesOption.ordinal());
                this.showShutDownPopup();
            }
        };
        this.filterPropertyListener = (observable, oldValue, newValue) -> this.applyFilter();
        if (this.xmrNodes.getProvidedXmrNodes().isEmpty()) {
            this.useProvidedNodesRadio.setDisable(true);
        }
        this.usePublicNodesRadio.setDisable(this.isPublicNodesDisabled());
    }

    @Override
    public void activate() {
        this.useTorForXmrToggleGroup.selectedToggleProperty().addListener(this.useTorForXmrToggleGroupListener);
        this.moneroPeersToggleGroup.selectedToggleProperty().addListener(this.moneroPeersToggleGroupListener);
        if (this.filterManager.getFilter() != null) {
            this.applyFilter();
        }
        this.filterManager.filterProperty().addListener(this.filterPropertyListener);
        this.rescanOutputsButton.setOnAction(event -> GUIUtil.rescanOutputs(this.preferences));
        this.moneroConnectionsSubscription = EasyBind.subscribe((ObservableValue)this.connectionService.connectionsProperty(), connections -> this.updateMoneroConnectionsTable());
        this.moneroBlockHeightSubscription = EasyBind.subscribe((ObservableValue)this.connectionService.chainHeightProperty(), height -> this.updateMoneroConnectionsTable());
        this.nodeAddressSubscription = EasyBind.subscribe((ObservableValue)this.p2PService.getNetworkNode().nodeAddressProperty(), nodeAddress -> this.onionAddress.setText(nodeAddress == null ? Res.get((String)"settings.net.notKnownYet") : nodeAddress.getFullAddress()));
        this.numP2PPeersSubscription = EasyBind.subscribe((ObservableValue)this.p2PService.getNumConnectedPeers(), numPeers -> this.updateP2PTable());
        this.sentDataTextField.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> Res.get((String)"settings.net.sentData", (Object[])new Object[]{FormattingUtils.formatBytes((long)Statistic.totalSentBytesProperty().get()), Statistic.numTotalSentMessagesProperty().get(), Statistic.numTotalSentMessagesPerSecProperty().get()}), (Observable[])new Observable[]{Statistic.numTotalSentMessagesPerSecProperty()}));
        this.receivedDataTextField.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> Res.get((String)"settings.net.receivedData", (Object[])new Object[]{FormattingUtils.formatBytes((long)Statistic.totalReceivedBytesProperty().get()), Statistic.numTotalReceivedMessagesProperty().get(), Statistic.numTotalReceivedMessagesPerSecProperty().get()}), (Observable[])new Observable[]{Statistic.numTotalReceivedMessagesPerSecProperty()}));
        this.moneroSortedList.comparatorProperty().bind((ObservableValue)this.moneroConnectionsTableView.comparatorProperty());
        this.moneroConnectionsTableView.setItems(this.moneroSortedList);
        this.p2pSortedList.comparatorProperty().bind((ObservableValue)this.p2pPeersTableView.comparatorProperty());
        this.p2pPeersTableView.setItems(this.p2pSortedList);
        this.xmrNodesInputTextField.setText(this.preferences.getMoneroNodes());
        this.xmrNodesInputTextField.focusedProperty().addListener(this.xmrNodesInputTextFieldFocusListener);
        this.openTorSettingsButton.setOnAction(e -> this.torNetworkSettingsWindow.show());
    }

    @Override
    public void deactivate() {
        this.useTorForXmrToggleGroup.selectedToggleProperty().removeListener(this.useTorForXmrToggleGroupListener);
        this.moneroPeersToggleGroup.selectedToggleProperty().removeListener(this.moneroPeersToggleGroupListener);
        this.filterManager.filterProperty().removeListener(this.filterPropertyListener);
        if (this.nodeAddressSubscription != null) {
            this.nodeAddressSubscription.unsubscribe();
        }
        if (this.moneroConnectionsSubscription != null) {
            this.moneroConnectionsSubscription.unsubscribe();
        }
        if (this.moneroBlockHeightSubscription != null) {
            this.moneroBlockHeightSubscription.unsubscribe();
        }
        if (this.numP2PPeersSubscription != null) {
            this.numP2PPeersSubscription.unsubscribe();
        }
        this.sentDataTextField.textProperty().unbind();
        this.receivedDataTextField.textProperty().unbind();
        this.moneroSortedList.comparatorProperty().unbind();
        this.p2pSortedList.comparatorProperty().unbind();
        this.p2pPeersTableView.getItems().forEach(P2pNetworkListItem::cleanup);
        this.xmrNodesInputTextField.focusedProperty().removeListener(this.xmrNodesInputTextFieldFocusListener);
        this.openTorSettingsButton.setOnAction(null);
    }

    private boolean isPreventPublicXmrNetwork() {
        return this.filterManager.getFilter() != null && this.filterManager.getFilter().isPreventPublicXmrNetwork();
    }

    private void selectUseTorForXmrToggle() {
        switch (this.selectedUseTorForXmr) {
            case OFF: {
                this.useTorForXmrToggleGroup.selectToggle((Toggle)this.useTorForXmrOffRadio);
                break;
            }
            case ON: {
                this.useTorForXmrToggleGroup.selectToggle((Toggle)this.useTorForXmrOnRadio);
                break;
            }
            default: {
                this.useTorForXmrToggleGroup.selectToggle((Toggle)this.useTorForXmrAfterSyncRadio);
            }
        }
    }

    private void selectMoneroPeersToggle() {
        switch (this.selectedMoneroNodesOption) {
            case CUSTOM: {
                this.moneroPeersToggleGroup.selectToggle((Toggle)this.useCustomNodesRadio);
                break;
            }
            case PUBLIC: {
                this.moneroPeersToggleGroup.selectToggle((Toggle)this.usePublicNodesRadio);
                break;
            }
            default: {
                this.moneroPeersToggleGroup.selectToggle((Toggle)this.useProvidedNodesRadio);
            }
        }
    }

    private void showShutDownPopup() {
        ((Popup)((Popup)((Popup)new Popup().information(Res.get((String)"settings.net.needRestart"))).closeButtonText(Res.get((String)"shared.cancel"))).useShutDownButton()).show();
    }

    private void onUseTorForXmrToggleSelected(boolean calledFromUser) {
        Preferences.UseTorForXmr currentUseTorForXmr = Preferences.UseTorForXmr.values()[this.preferences.getUseTorForXmrOrdinal()];
        if (currentUseTorForXmr != this.selectedUseTorForXmr && calledFromUser) {
            ((Popup)((Popup)((Popup)((Popup)((Popup)new Popup().information(Res.get((String)"settings.net.needRestart"))).actionButtonText(Res.get((String)"shared.applyAndShutDown"))).onAction(() -> {
                this.preferences.setUseTorForXmrOrdinal(this.selectedUseTorForXmr.ordinal());
                UserThread.runAfter((Runnable)HavenoApp.getShutDownHandler(), (long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
            })).closeButtonText(Res.get((String)"shared.cancel"))).onClose(() -> {
                this.selectedUseTorForXmr = currentUseTorForXmr;
                this.selectUseTorForXmrToggle();
            })).show();
        }
    }

    private void onMoneroPeersToggleSelected(boolean calledFromUser) {
        this.usePublicNodesRadio.setDisable(this.isPublicNodesDisabled());
        XmrNodes.MoneroNodesOption currentMoneroNodesOption = XmrNodes.MoneroNodesOption.values()[this.preferences.getMoneroNodesOptionOrdinal()];
        switch (this.selectedMoneroNodesOption) {
            case CUSTOM: {
                this.xmrNodesInputTextField.setDisable(false);
                this.xmrNodesLabel.setDisable(false);
                if (this.xmrNodesInputTextField.getText().isEmpty() || !this.xmrNodesInputTextField.validate() || currentMoneroNodesOption == XmrNodes.MoneroNodesOption.CUSTOM) break;
                this.preferences.setMoneroNodesOptionOrdinal(this.selectedMoneroNodesOption.ordinal());
                if (!calledFromUser) break;
                if (this.isPreventPublicXmrNetwork()) {
                    ((Popup)((Popup)new Popup().warning(Res.get((String)"settings.net.warn.useCustomNodes.B2XWarning"))).onAction(() -> UserThread.runAfter(this::showShutDownPopup, (long)300L, (TimeUnit)TimeUnit.MILLISECONDS))).show();
                    break;
                }
                this.showShutDownPopup();
                break;
            }
            case PUBLIC: {
                this.xmrNodesInputTextField.setDisable(true);
                this.xmrNodesLabel.setDisable(true);
                if (currentMoneroNodesOption == XmrNodes.MoneroNodesOption.PUBLIC) break;
                this.preferences.setMoneroNodesOptionOrdinal(this.selectedMoneroNodesOption.ordinal());
                if (!calledFromUser) break;
                ((Popup)((Popup)((Popup)((Popup)((Popup)new Popup().warning(Res.get((String)"settings.net.warn.usePublicNodes"))).actionButtonText(Res.get((String)"settings.net.warn.usePublicNodes.useProvided"))).onAction(() -> UserThread.runAfter(() -> {
                    this.selectedMoneroNodesOption = XmrNodes.MoneroNodesOption.PROVIDED;
                    this.preferences.setMoneroNodesOptionOrdinal(this.selectedMoneroNodesOption.ordinal());
                    this.selectMoneroPeersToggle();
                    this.onMoneroPeersToggleSelected(false);
                }, (long)300L, (TimeUnit)TimeUnit.MILLISECONDS))).closeButtonText(Res.get((String)"settings.net.warn.usePublicNodes.usePublic"))).onClose(() -> UserThread.runAfter(this::showShutDownPopup, (long)300L, (TimeUnit)TimeUnit.MILLISECONDS))).show();
                break;
            }
            default: {
                this.xmrNodesInputTextField.setDisable(true);
                this.xmrNodesLabel.setDisable(true);
                if (currentMoneroNodesOption == XmrNodes.MoneroNodesOption.PROVIDED) break;
                this.preferences.setMoneroNodesOptionOrdinal(this.selectedMoneroNodesOption.ordinal());
                if (!calledFromUser) break;
                this.showShutDownPopup();
            }
        }
    }

    private void applyFilter() {
        boolean preventPublicXmrNetwork = this.isPreventPublicXmrNetwork();
        this.usePublicNodesRadio.setDisable(this.isPublicNodesDisabled());
        if (preventPublicXmrNetwork && this.selectedMoneroNodesOption == XmrNodes.MoneroNodesOption.PUBLIC) {
            this.selectedMoneroNodesOption = XmrNodes.MoneroNodesOption.PROVIDED;
            this.preferences.setMoneroNodesOptionOrdinal(this.selectedMoneroNodesOption.ordinal());
            this.selectMoneroPeersToggle();
            this.onMoneroPeersToggleSelected(false);
        }
    }

    private boolean isPublicNodesDisabled() {
        return this.xmrNodes.getPublicXmrNodes().isEmpty() || this.isPreventPublicXmrNetwork();
    }

    private void updateP2PTable() {
        UserThread.execute(() -> {
            if (this.connectionService.isShutDownStarted()) {
                return;
            }
            this.p2pPeersTableView.getItems().forEach(P2pNetworkListItem::cleanup);
            this.p2pNetworkListItems.clear();
            this.p2pNetworkListItems.setAll((Collection)this.p2PService.getNetworkNode().getAllConnections().stream().map(connection -> new P2pNetworkListItem((Connection)connection, this.clockWatcher)).collect(Collectors.toList()));
        });
    }

    private void updateMoneroConnectionsTable() {
        UserThread.execute(() -> {
            if (this.connectionService.isShutDownStarted()) {
                return;
            }
            this.moneroNetworkListItems.clear();
            this.moneroNetworkListItems.setAll((Collection)this.connectionService.getConnections().stream().map(connection -> new MoneroNetworkListItem((MoneroRpcConnection)connection, connection == this.connectionService.getConnection() && Boolean.TRUE.equals(this.connectionService.isConnected()))).collect(Collectors.toList()));
            this.updateChainHeightTextField(this.connectionService.chainHeightProperty().get());
        });
    }

    private void updateChainHeightTextField(Number chainHeight) {
        this.chainHeightTextField.textProperty().setValue(Res.get((String)"settings.net.chainHeight", (Object[])new Object[]{chainHeight}));
    }
}

