/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.settings.about;

import com.google.inject.Inject;
import haveno.common.app.Version;
import haveno.core.filter.FilterManager;
import haveno.core.locale.Res;
import haveno.desktop.common.view.ActivatableView;
import haveno.desktop.common.view.FxmlView;
import haveno.desktop.components.HyperlinkWithIcon;
import haveno.desktop.util.FormBuilder;
import javafx.geometry.HPos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.GridPane;

@FxmlView
public class AboutView
extends ActivatableView<GridPane, Void> {
    private final FilterManager filterManager;
    private int gridRow = 0;

    @Inject
    public AboutView(FilterManager filterManager) {
        this.filterManager = filterManager;
    }

    @Override
    public void initialize() {
        FormBuilder.addTitledGroupBg((GridPane)this.root, this.gridRow, 5, Res.get((String)"setting.about.aboutHaveno"));
        Label label = FormBuilder.addLabel((GridPane)this.root, this.gridRow, Res.get((String)"setting.about.about"), 40.0);
        label.setWrapText(true);
        GridPane.setColumnSpan((Node)label, (Integer)2);
        GridPane.setHalignment((Node)label, (HPos)HPos.LEFT);
        HyperlinkWithIcon hyperlinkWithIcon = FormBuilder.addHyperlinkWithIcon((GridPane)this.root, ++this.gridRow, Res.get((String)"setting.about.web"), "https://haveno.exchange");
        GridPane.setColumnSpan((Node)hyperlinkWithIcon, (Integer)2);
        hyperlinkWithIcon = FormBuilder.addHyperlinkWithIcon((GridPane)this.root, ++this.gridRow, Res.get((String)"setting.about.code"), "https://github.com/haveno-dex/haveno");
        GridPane.setColumnSpan((Node)hyperlinkWithIcon, (Integer)2);
        hyperlinkWithIcon = FormBuilder.addHyperlinkWithIcon((GridPane)this.root, ++this.gridRow, Res.get((String)"setting.about.agpl"), "https://github.com/haveno-dex/haveno/blob/master/LICENSE");
        GridPane.setColumnSpan((Node)hyperlinkWithIcon, (Integer)2);
        FormBuilder.addTitledGroupBg((GridPane)this.root, ++this.gridRow, 2, Res.get((String)"setting.about.support"), 40.0);
        label = FormBuilder.addLabel((GridPane)this.root, this.gridRow, Res.get((String)"setting.about.def"), 80.0);
        label.setWrapText(true);
        GridPane.setColumnSpan((Node)label, (Integer)2);
        GridPane.setHalignment((Node)label, (HPos)HPos.LEFT);
        hyperlinkWithIcon = FormBuilder.addHyperlinkWithIcon((GridPane)this.root, ++this.gridRow, Res.get((String)"setting.about.contribute"), "https://github.com/haveno-dex/haveno#support");
        GridPane.setColumnSpan((Node)hyperlinkWithIcon, (Integer)2);
        boolean isXmr = Res.getBaseCurrencyCode().equals("XMR");
        FormBuilder.addTitledGroupBg((GridPane)this.root, ++this.gridRow, isXmr ? 3 : 2, Res.get((String)"setting.about.providers"), 40.0);
        label = FormBuilder.addLabel((GridPane)this.root, this.gridRow, Res.get((String)(isXmr ? "setting.about.apisWithFee" : "setting.about.apis")), 80.0);
        label.setWrapText(true);
        GridPane.setHalignment((Node)label, (HPos)HPos.LEFT);
        FormBuilder.addCompactTopLabelTextField((GridPane)this.root, ++this.gridRow, Res.get((String)"setting.about.pricesProvided"), "Haveno's pricenode (https://price.haveno.network)");
        if (isXmr) {
            FormBuilder.addCompactTopLabelTextField((GridPane)this.root, ++this.gridRow, Res.get((String)"setting.about.feeEstimation.label"), "Monero node");
        }
        String minVersion = this.filterManager.getDisableTradeBelowVersion() == null ? Res.get((String)"shared.none") : this.filterManager.getDisableTradeBelowVersion();
        FormBuilder.addTitledGroupBg((GridPane)this.root, ++this.gridRow, 3, Res.get((String)"setting.about.versionDetails"), 40.0);
        FormBuilder.addCompactTopLabelTextField((GridPane)this.root, this.gridRow, Res.get((String)"setting.about.version"), "1.2.2", 80.0);
        FormBuilder.addCompactTopLabelTextField((GridPane)this.root, ++this.gridRow, Res.get((String)"filterWindow.disableTradeBelowVersion"), minVersion);
        FormBuilder.addCompactTopLabelTextField((GridPane)this.root, ++this.gridRow, Res.get((String)"setting.about.subsystems.label"), Res.get((String)"setting.about.subsystems.val", (Object[])new Object[]{"A", Version.getP2PMessageVersion(), 1, 3}));
        FormBuilder.addTitledGroupBg((GridPane)this.root, ++this.gridRow, 18, Res.get((String)"setting.about.shortcuts"), 40.0);
        FormBuilder.addCompactTopLabelTextField((GridPane)this.root, this.gridRow, Res.get((String)"setting.about.shortcuts.menuNav"), Res.get((String)"setting.about.shortcuts.menuNav.value"), 80.0);
        FormBuilder.addCompactTopLabelTextField((GridPane)this.root, ++this.gridRow, Res.get((String)"setting.about.shortcuts.close"), Res.get((String)"setting.about.shortcuts.close.value", (Object[])new Object[]{"q", "w"}));
        FormBuilder.addCompactTopLabelTextField((GridPane)this.root, ++this.gridRow, Res.get((String)"setting.about.shortcuts.closePopup"), Res.get((String)"setting.about.shortcuts.closePopup.value"));
        FormBuilder.addCompactTopLabelTextField((GridPane)this.root, ++this.gridRow, Res.get((String)"setting.about.shortcuts.chatSendMsg"), Res.get((String)"setting.about.shortcuts.chatSendMsg.value"));
        FormBuilder.addCompactTopLabelTextField((GridPane)this.root, ++this.gridRow, Res.get((String)"setting.about.shortcuts.openDispute"), Res.get((String)"setting.about.shortcuts.openDispute.value", (Object[])new Object[]{Res.get((String)"setting.about.shortcuts.ctrlOrAltOrCmd", (Object[])new Object[]{"o"})}));
        FormBuilder.addCompactTopLabelTextField((GridPane)this.root, ++this.gridRow, Res.get((String)"setting.about.shortcuts.walletDetails"), Res.get((String)"setting.about.shortcuts.ctrlOrAltOrCmd", (Object[])new Object[]{"j"}));
        FormBuilder.addCompactTopLabelTextField((GridPane)this.root, ++this.gridRow, Res.get((String)"setting.about.shortcuts.openEmergencyXmrWalletTool"), Res.get((String)"setting.about.shortcuts.ctrlOrAltOrCmd", (Object[])new Object[]{"e"}));
        FormBuilder.addCompactTopLabelTextField((GridPane)this.root, ++this.gridRow, Res.get((String)"setting.about.shortcuts.showTorLogs"), Res.get((String)"setting.about.shortcuts.ctrlOrAltOrCmd", (Object[])new Object[]{"t"}));
        FormBuilder.addCompactTopLabelTextField((GridPane)this.root, ++this.gridRow, Res.get((String)"setting.about.shortcuts.removeStuckTrade"), Res.get((String)"setting.about.shortcuts.removeStuckTrade.value", (Object[])new Object[]{Res.get((String)"setting.about.shortcuts.ctrlOrAltOrCmd", (Object[])new Object[]{"y"})}));
        FormBuilder.addCompactTopLabelTextField((GridPane)this.root, ++this.gridRow, Res.get((String)"setting.about.shortcuts.manualPayoutTxWindow"), Res.get((String)"setting.about.shortcuts.ctrlOrAltOrCmd", (Object[])new Object[]{"g"}));
        FormBuilder.addCompactTopLabelTextField((GridPane)this.root, ++this.gridRow, Res.get((String)"setting.about.shortcuts.registerArbitrator"), Res.get((String)"setting.about.shortcuts.registerArbitrator.value", (Object[])new Object[]{Res.get((String)"setting.about.shortcuts.ctrlOrAltOrCmd", (Object[])new Object[]{"n"})}));
        FormBuilder.addCompactTopLabelTextField((GridPane)this.root, ++this.gridRow, Res.get((String)"setting.about.shortcuts.registerMediator"), Res.get((String)"setting.about.shortcuts.registerMediator.value", (Object[])new Object[]{Res.get((String)"setting.about.shortcuts.ctrlOrAltOrCmd", (Object[])new Object[]{"d"})}));
        FormBuilder.addCompactTopLabelTextField((GridPane)this.root, ++this.gridRow, Res.get((String)"setting.about.shortcuts.openSignPaymentAccountsWindow"), Res.get((String)"setting.about.shortcuts.openSignPaymentAccountsWindow.value", (Object[])new Object[]{Res.get((String)"setting.about.shortcuts.ctrlOrAltOrCmd", (Object[])new Object[]{"s"})}));
        FormBuilder.addCompactTopLabelTextField((GridPane)this.root, ++this.gridRow, Res.get((String)"setting.about.shortcuts.sendAlertMsg"), Res.get((String)"setting.about.shortcuts.ctrlOrAltOrCmd", (Object[])new Object[]{"m"}));
        FormBuilder.addCompactTopLabelTextField((GridPane)this.root, ++this.gridRow, Res.get((String)"setting.about.shortcuts.sendFilter"), Res.get((String)"setting.about.shortcuts.ctrlOrAltOrCmd", (Object[])new Object[]{"f"}));
        FormBuilder.addCompactTopLabelTextField((GridPane)this.root, ++this.gridRow, Res.get((String)"setting.about.shortcuts.sendPrivateNotification"), Res.get((String)"setting.about.shortcuts.sendPrivateNotification.value", (Object[])new Object[]{Res.get((String)"setting.about.shortcuts.ctrlOrAltOrCmd", (Object[])new Object[]{"r"})}));
    }

    @Override
    public void activate() {
    }

    @Override
    public void deactivate() {
    }
}

