/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.settings;

import com.google.inject.Inject;
import haveno.core.locale.Res;
import haveno.core.user.Preferences;
import haveno.desktop.Navigation;
import haveno.desktop.common.view.ActivatableView;
import haveno.desktop.common.view.CachingViewLoader;
import haveno.desktop.common.view.FxmlView;
import haveno.desktop.common.view.View;
import haveno.desktop.common.view.ViewLoader;
import haveno.desktop.main.MainView;
import haveno.desktop.main.settings.about.AboutView;
import haveno.desktop.main.settings.network.NetworkSettingsView;
import haveno.desktop.main.settings.preferences.PreferencesView;
import javafx.beans.value.ChangeListener;
import javafx.fxml.FXML;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;

@FxmlView
public class SettingsView
extends ActivatableView<TabPane, Void> {
    @FXML
    Tab preferencesTab;
    @FXML
    Tab networkTab;
    @FXML
    Tab aboutTab;
    private final ViewLoader viewLoader;
    private final Navigation navigation;
    private Preferences preferences;
    private Navigation.Listener navigationListener;
    private ChangeListener<Tab> tabChangeListener;

    @Inject
    public SettingsView(CachingViewLoader viewLoader, Navigation navigation, Preferences preferences) {
        this.viewLoader = viewLoader;
        this.navigation = navigation;
        this.preferences = preferences;
    }

    @Override
    public void initialize() {
        this.preferencesTab.setText(Res.get((String)"settings.tab.preferences"));
        this.networkTab.setText(Res.get((String)"settings.tab.network"));
        this.aboutTab.setText(Res.get((String)"settings.tab.about"));
        this.navigationListener = (viewPath, data) -> {
            if (viewPath.size() == 3 && viewPath.indexOf(SettingsView.class) == 1) {
                this.loadView(viewPath.tip());
            }
        };
        this.tabChangeListener = (ov, oldValue, newValue) -> this.navigationToTabContent((Tab)newValue);
    }

    private void navigationToTabContent(Tab newValue) {
        if (newValue == this.preferencesTab) {
            this.navigation.navigateTo(MainView.class, SettingsView.class, PreferencesView.class);
        } else if (newValue == this.networkTab) {
            this.navigation.navigateTo(MainView.class, SettingsView.class, NetworkSettingsView.class);
        } else if (newValue == this.aboutTab) {
            this.navigation.navigateTo(MainView.class, SettingsView.class, AboutView.class);
        }
    }

    @Override
    protected void activate() {
        this.preferences.dontShowAgain("settingsNews", true);
        ((TabPane)this.root).getSelectionModel().selectedItemProperty().addListener(this.tabChangeListener);
        this.navigation.addListener(this.navigationListener);
        Tab selectedItem = (Tab)((TabPane)this.root).getSelectionModel().getSelectedItem();
        this.navigationToTabContent(selectedItem);
    }

    @Override
    protected void deactivate() {
        ((TabPane)this.root).getSelectionModel().selectedItemProperty().removeListener(this.tabChangeListener);
        this.navigation.removeListener(this.navigationListener);
    }

    private void loadView(Class<? extends View> viewClass) {
        Tab tab;
        View view = this.viewLoader.load(viewClass);
        if (view instanceof PreferencesView) {
            tab = this.preferencesTab;
        } else if (view instanceof NetworkSettingsView) {
            tab = this.networkTab;
        } else if (view instanceof AboutView) {
            tab = this.aboutTab;
        } else {
            throw new IllegalArgumentException("Navigation to " + String.valueOf(viewClass) + " is not supported");
        }
        if (tab.getContent() != null && tab.getContent() instanceof ScrollPane) {
            ((ScrollPane)tab.getContent()).setContent(view.getRoot());
        } else {
            tab.setContent(view.getRoot());
        }
        ((TabPane)this.root).getSelectionModel().select((Object)tab);
    }
}

