/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.presentation;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import haveno.core.user.Preferences;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;

@Singleton
public class SettingsPresentation {
    public static final String SETTINGS_NEWS = "settingsNews";
    private Preferences preferences;
    private final SimpleBooleanProperty showNotification = new SimpleBooleanProperty(false);

    @Inject
    public SettingsPresentation(Preferences preferences) {
        this.preferences = preferences;
        preferences.getDontShowAgainMapAsObservable().addListener(change -> {
            if (((String)change.getKey()).equals(SETTINGS_NEWS)) {
                this.showNotification.set(!change.wasAdded());
            }
        });
    }

    public BooleanProperty getShowSettingsUpdatesNotification() {
        return this.showNotification;
    }

    public void setup() {
        this.showNotification.set(this.preferences.showAgain(SETTINGS_NEWS));
    }
}

