/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.presentation;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import haveno.common.UserThread;
import haveno.core.locale.CurrencyUtil;
import haveno.core.locale.Res;
import haveno.core.locale.TradeCurrency;
import haveno.core.provider.price.MarketPrice;
import haveno.core.provider.price.PriceFeedService;
import haveno.core.user.Preferences;
import haveno.core.util.FormattingUtils;
import haveno.core.xmr.wallet.XmrWalletService;
import haveno.desktop.components.TxIdTextField;
import haveno.desktop.main.shared.PriceFeedComboBoxItem;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.fxmisc.easybind.EasyBind;
import org.fxmisc.easybind.Subscription;
import org.fxmisc.easybind.monadic.MonadicBinding;

@Singleton
public class MarketPricePresentation {
    private final Preferences preferences;
    private final PriceFeedService priceFeedService;
    private final ObservableList<PriceFeedComboBoxItem> priceFeedComboBoxItems = FXCollections.observableArrayList();
    private MonadicBinding<String> marketPriceBinding;
    private Subscription priceFeedAllLoadedSubscription;
    private final StringProperty marketPriceCurrencyCode = new SimpleStringProperty("");
    private final ObjectProperty<PriceFeedComboBoxItem> selectedPriceFeedComboBoxItemProperty = new SimpleObjectProperty();
    private final BooleanProperty isFiatCurrencyPriceFeedSelected = new SimpleBooleanProperty(true);
    private final BooleanProperty isCryptoCurrencyPriceFeedSelected = new SimpleBooleanProperty(false);
    private final BooleanProperty isExternallyProvidedPrice = new SimpleBooleanProperty(true);
    private final BooleanProperty isPriceAvailable = new SimpleBooleanProperty(false);
    private final IntegerProperty marketPriceUpdated = new SimpleIntegerProperty(0);
    private final StringProperty marketPrice = new SimpleStringProperty(Res.get((String)"shared.na"));

    @Inject
    public MarketPricePresentation(XmrWalletService xmrWalletService, PriceFeedService priceFeedService, Preferences preferences) {
        this.priceFeedService = priceFeedService;
        this.preferences = preferences;
        TxIdTextField.setPreferences(preferences);
        TxIdTextField.setXmrWalletService(xmrWalletService);
    }

    public void setup() {
        this.fillPriceFeedComboBoxItems();
        this.setupMarketPriceFeed();
    }

    public void setPriceFeedComboBoxItem(PriceFeedComboBoxItem item) {
        if (item != null) {
            Optional<PriceFeedComboBoxItem> itemOptional = this.findPriceFeedComboBoxItem((String)this.priceFeedService.currencyCodeProperty().get());
            if (itemOptional.isPresent()) {
                this.selectedPriceFeedComboBoxItemProperty.set((Object)itemOptional.get());
            } else {
                this.findPriceFeedComboBoxItem(this.preferences.getPreferredTradeCurrency().getCode()).ifPresent(arg_0 -> this.selectedPriceFeedComboBoxItemProperty.set(arg_0));
            }
            this.priceFeedService.setCurrencyCode(item.currencyCode);
        } else {
            this.findPriceFeedComboBoxItem(this.preferences.getPreferredTradeCurrency().getCode()).ifPresent(arg_0 -> this.selectedPriceFeedComboBoxItemProperty.set(arg_0));
        }
    }

    private void fillPriceFeedComboBoxItems() {
        List uniqueCurrencyCodeBases = this.preferences.getTradeCurrenciesAsObservable().stream().map(TradeCurrency::getCode).map(CurrencyUtil::getCurrencyCodeBase).distinct().collect(Collectors.toList());
        List currencyItems = uniqueCurrencyCodeBases.stream().map(currencyCodeBase -> new PriceFeedComboBoxItem((String)currencyCodeBase)).collect(Collectors.toList());
        this.priceFeedComboBoxItems.setAll(currencyItems);
    }

    private void setupMarketPriceFeed() {
        this.priceFeedService.startRequestingPrices(price -> this.marketPrice.set((Object)FormattingUtils.formatMarketPrice((double)price, (String)this.priceFeedService.getCurrencyCode())), (errorMessage, throwable) -> this.marketPrice.set((Object)Res.get((String)"shared.na")));
        this.marketPriceBinding = EasyBind.combine((ObservableValue)this.marketPriceCurrencyCode, (ObservableValue)this.marketPrice, (currencyCode, price) -> {
            MarketPrice currentPrice = this.priceFeedService.getMarketPrice(currencyCode);
            String currentPriceStr = currentPrice == null ? Res.get((String)"shared.na") : FormattingUtils.formatMarketPrice((double)currentPrice.getPrice(), (String)currencyCode);
            return CurrencyUtil.getCurrencyPair((String)currencyCode) + ": " + currentPriceStr;
        });
        this.marketPriceBinding.subscribe((observable, oldValue, newValue) -> UserThread.execute(() -> {
            if (newValue != null && !newValue.equals(oldValue)) {
                this.setMarketPriceInItems();
                String code = (String)this.priceFeedService.currencyCodeProperty().get();
                Optional<PriceFeedComboBoxItem> itemOptional = this.findPriceFeedComboBoxItem(code);
                if (itemOptional.isPresent()) {
                    itemOptional.get().setDisplayString((String)newValue);
                    this.selectedPriceFeedComboBoxItemProperty.set((Object)itemOptional.get());
                } else if (CurrencyUtil.isCryptoCurrency((String)code)) {
                    CurrencyUtil.getCryptoCurrency((String)code).ifPresent(cryptoCurrency -> {
                        this.preferences.addCryptoCurrency(cryptoCurrency);
                        this.fillPriceFeedComboBoxItems();
                    });
                } else {
                    CurrencyUtil.getTraditionalCurrency((String)code).ifPresent(traditionalCurrency -> {
                        this.preferences.addTraditionalCurrency(traditionalCurrency);
                        this.fillPriceFeedComboBoxItems();
                    });
                }
                if (this.selectedPriceFeedComboBoxItemProperty.get() != null) {
                    ((PriceFeedComboBoxItem)this.selectedPriceFeedComboBoxItemProperty.get()).setDisplayString((String)newValue);
                }
            }
        }));
        this.marketPriceCurrencyCode.bind((ObservableValue)this.priceFeedService.currencyCodeProperty());
        this.priceFeedAllLoadedSubscription = EasyBind.subscribe((ObservableValue)this.priceFeedService.updateCounterProperty(), updateCounter -> UserThread.execute(() -> this.setMarketPriceInItems()));
        this.preferences.getTradeCurrenciesAsObservable().addListener(c -> UserThread.runAfter(() -> {
            this.fillPriceFeedComboBoxItems();
            this.setMarketPriceInItems();
        }, (long)100L, (TimeUnit)TimeUnit.MILLISECONDS));
    }

    private Optional<PriceFeedComboBoxItem> findPriceFeedComboBoxItem(String currencyCode) {
        return this.priceFeedComboBoxItems.stream().filter(item -> CurrencyUtil.getCurrencyCodeBase((String)item.currencyCode).equals(CurrencyUtil.getCurrencyCodeBase((String)currencyCode))).findAny();
    }

    private void setMarketPriceInItems() {
        this.priceFeedComboBoxItems.forEach(item -> {
            String priceString;
            String currencyCode = item.currencyCode;
            MarketPrice marketPrice = this.priceFeedService.getMarketPrice(currencyCode);
            if (marketPrice != null && marketPrice.isPriceAvailable()) {
                priceString = FormattingUtils.formatMarketPrice((double)marketPrice.getPrice(), (String)currencyCode);
                item.setPriceAvailable(true);
                item.setExternallyProvidedPrice(marketPrice.isExternallyProvidedPrice());
            } else {
                priceString = Res.get((String)"shared.na");
                item.setPriceAvailable(false);
            }
            item.setDisplayString(CurrencyUtil.getCurrencyPair((String)currencyCode) + ": " + priceString);
            String code = item.currencyCode;
            if (this.selectedPriceFeedComboBoxItemProperty.get() != null && ((PriceFeedComboBoxItem)this.selectedPriceFeedComboBoxItemProperty.get()).currencyCode.equals(code)) {
                this.isFiatCurrencyPriceFeedSelected.set(CurrencyUtil.isTraditionalCurrency((String)code) && CurrencyUtil.getTraditionalCurrency((String)code).isPresent() && item.isPriceAvailable() && item.isExternallyProvidedPrice());
                this.isCryptoCurrencyPriceFeedSelected.set(CurrencyUtil.isCryptoCurrency((String)code) && CurrencyUtil.getCryptoCurrency((String)code).isPresent() && item.isPriceAvailable() && item.isExternallyProvidedPrice());
                this.isExternallyProvidedPrice.set(item.isExternallyProvidedPrice());
                this.isPriceAvailable.set(item.isPriceAvailable());
                this.marketPriceUpdated.set(this.marketPriceUpdated.get() + 1);
            }
        });
    }

    public ObjectProperty<PriceFeedComboBoxItem> getSelectedPriceFeedComboBoxItemProperty() {
        return this.selectedPriceFeedComboBoxItemProperty;
    }

    public BooleanProperty getIsFiatCurrencyPriceFeedSelected() {
        return this.isFiatCurrencyPriceFeedSelected;
    }

    public BooleanProperty getIsCryptoCurrencyPriceFeedSelected() {
        return this.isCryptoCurrencyPriceFeedSelected;
    }

    public BooleanProperty getIsExternallyProvidedPrice() {
        return this.isExternallyProvidedPrice;
    }

    public BooleanProperty getIsPriceAvailable() {
        return this.isPriceAvailable;
    }

    public IntegerProperty getMarketPriceUpdated() {
        return this.marketPriceUpdated;
    }

    public StringProperty getMarketPrice() {
        return this.marketPrice;
    }

    public StringProperty getMarketPrice(String currencyCode) {
        SimpleStringProperty marketPrice = new SimpleStringProperty(Res.get((String)"shared.na"));
        MarketPrice marketPriceValue = this.priceFeedService.getMarketPrice(currencyCode);
        if (marketPriceValue != null) {
            marketPrice.set(String.valueOf(marketPriceValue.getPrice()));
        }
        return marketPrice;
    }

    public ObservableList<PriceFeedComboBoxItem> getPriceFeedComboBoxItems() {
        return this.priceFeedComboBoxItems;
    }
}

