/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.presentation;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import haveno.common.app.DevEnv;
import haveno.core.locale.Res;
import haveno.core.user.DontShowAgainLookup;
import haveno.core.user.Preferences;
import haveno.desktop.main.overlays.popups.Popup;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;

@Singleton
public class AccountPresentation {
    public static final String ACCOUNT_NEWS = "accountNews";
    private Preferences preferences;
    private final SimpleBooleanProperty showNotification = new SimpleBooleanProperty(false);

    @Inject
    public AccountPresentation(Preferences preferences) {
        this.preferences = preferences;
        preferences.getDontShowAgainMapAsObservable().addListener(change -> {
            if (((String)change.getKey()).equals(ACCOUNT_NEWS)) {
                this.showNotification.set(!change.wasAdded());
            }
        });
    }

    public BooleanProperty getShowAccountUpdatesNotification() {
        return this.showNotification;
    }

    public void setup() {
        this.showNotification.set(this.preferences.showAgain(ACCOUNT_NEWS));
    }

    public void showOneTimeAccountSigningPopup(String key, String s) {
        this.showOneTimeAccountSigningPopup(key, s, null);
    }

    public void showOneTimeAccountSigningPopup(String key, String s, String optionalParam) {
        if (!DevEnv.isDevMode()) {
            DontShowAgainLookup.dontShowAgain((String)ACCOUNT_NEWS, (boolean)false);
            this.showNotification.set(true);
            DontShowAgainLookup.dontShowAgain((String)key, (boolean)true);
            String message = optionalParam != null ? Res.get((String)s, (Object[])new Object[]{optionalParam, Res.get((String)"popup.accountSigning.generalInformation")}) : Res.get((String)s, (Object[])new Object[]{Res.get((String)"popup.accountSigning.generalInformation")});
            ((Popup)new Popup().information(message)).show();
        }
    }
}

