/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.portfolio.pendingtrades.steps.seller;

import haveno.common.Timer;
import haveno.common.UserThread;
import haveno.common.app.DevEnv;
import haveno.common.util.Tuple2;
import haveno.common.util.Tuple4;
import haveno.core.locale.Res;
import haveno.core.monetary.Volume;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.PaymentAccountUtil;
import haveno.core.payment.payload.AmazonGiftCardAccountPayload;
import haveno.core.payment.payload.AssetAccountPayload;
import haveno.core.payment.payload.BankAccountPayload;
import haveno.core.payment.payload.CashDepositAccountPayload;
import haveno.core.payment.payload.F2FAccountPayload;
import haveno.core.payment.payload.HalCashAccountPayload;
import haveno.core.payment.payload.MoneyGramAccountPayload;
import haveno.core.payment.payload.PayByMailAccountPayload;
import haveno.core.payment.payload.PaymentAccountPayload;
import haveno.core.payment.payload.SepaAccountPayload;
import haveno.core.payment.payload.SepaInstantAccountPayload;
import haveno.core.payment.payload.USPostalMoneyOrderAccountPayload;
import haveno.core.payment.payload.WesternUnionAccountPayload;
import haveno.core.trade.Contract;
import haveno.core.trade.Trade;
import haveno.core.user.DontShowAgainLookup;
import haveno.core.user.User;
import haveno.core.util.VolumeUtil;
import haveno.desktop.components.BusyAnimation;
import haveno.desktop.components.InfoTextField;
import haveno.desktop.components.TextFieldWithCopyIcon;
import haveno.desktop.components.indicator.TxConfidenceIndicator;
import haveno.desktop.main.overlays.popups.Popup;
import haveno.desktop.main.portfolio.pendingtrades.PendingTradesDataModel;
import haveno.desktop.main.portfolio.pendingtrades.PendingTradesViewModel;
import haveno.desktop.main.portfolio.pendingtrades.steps.TradeStepView;
import haveno.desktop.util.FormBuilder;
import java.util.Optional;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javax.annotation.Nullable;
import org.fxmisc.easybind.EasyBind;
import org.fxmisc.easybind.Subscription;

public class SellerStep3View
extends TradeStepView {
    private Button confirmButton;
    private Label statusLabel;
    private BusyAnimation busyAnimation;
    private Subscription tradeStatePropertySubscription;
    private Timer timeoutTimer;
    @Nullable
    private InfoTextField assetTxProofResultField;
    @Nullable
    private TxConfidenceIndicator assetTxConfidenceIndicator;
    @Nullable
    private ChangeListener<Number> proofResultListener;

    public SellerStep3View(PendingTradesViewModel model) {
        super(model);
    }

    @Override
    public void activate() {
        super.activate();
        if (this.timeoutTimer != null) {
            this.timeoutTimer.stop();
        }
        this.tradeStatePropertySubscription = EasyBind.subscribe((ObservableValue)this.trade.stateProperty(), state -> {
            if (this.timeoutTimer != null) {
                this.timeoutTimer.stop();
            }
            if (this.trade.isPaymentSent() && !this.trade.isPaymentReceived()) {
                this.busyAnimation.stop();
                this.statusLabel.setText("");
                this.showPopup();
            } else if (this.trade.isPaymentReceived()) {
                if (this.trade.isCompleted()) {
                    if (!this.trade.isPayoutPublished()) {
                        this.log.warn("Payout is expected to be published for {} {} state {}", new Object[]{this.trade.getClass().getSimpleName(), this.trade.getId(), this.trade.getState()});
                    }
                    this.busyAnimation.stop();
                    this.statusLabel.setText("");
                } else {
                    switch (state) {
                        case SELLER_CONFIRMED_PAYMENT_RECEIPT: {
                            this.busyAnimation.play();
                            this.statusLabel.setText(Res.get((String)"shared.preparingConfirmation"));
                            break;
                        }
                        case SELLER_SENT_PAYMENT_RECEIVED_MSG: {
                            this.busyAnimation.play();
                            this.statusLabel.setText(Res.get((String)"shared.sendingConfirmation"));
                            this.timeoutTimer = UserThread.runAfter(() -> {
                                this.busyAnimation.stop();
                                this.statusLabel.setText(Res.get((String)"shared.sendingConfirmationAgain"));
                            }, (long)30L);
                            break;
                        }
                        case SELLER_STORED_IN_MAILBOX_PAYMENT_RECEIVED_MSG: {
                            this.busyAnimation.stop();
                            this.statusLabel.setText(Res.get((String)"shared.messageStoredInMailbox"));
                            break;
                        }
                        case SELLER_SAW_ARRIVED_PAYMENT_RECEIVED_MSG: 
                        case BUYER_RECEIVED_PAYMENT_RECEIVED_MSG: {
                            this.busyAnimation.stop();
                            this.statusLabel.setText(Res.get((String)"shared.messageArrived"));
                            break;
                        }
                        case SELLER_SEND_FAILED_PAYMENT_RECEIVED_MSG: {
                            this.busyAnimation.stop();
                            this.statusLabel.setText("");
                            break;
                        }
                        default: {
                            this.log.warn("Unexpected case: State={}, tradeId={} " + state.name(), (Object)this.trade.getId());
                            this.busyAnimation.stop();
                            this.statusLabel.setText(Res.get((String)"shared.sendingConfirmationAgain"));
                        }
                    }
                }
            }
            this.confirmButton.setDisable(!this.confirmPaymentReceivedPermitted());
        });
    }

    @Override
    public void deactivate() {
        super.deactivate();
        if (this.tradeStatePropertySubscription != null) {
            this.tradeStatePropertySubscription.unsubscribe();
            this.tradeStatePropertySubscription = null;
        }
        this.busyAnimation.stop();
        if (this.timeoutTimer != null) {
            this.timeoutTimer.stop();
        }
    }

    @Override
    protected void addContent() {
        ((ColumnConstraints)this.gridPane.getColumnConstraints().get(1)).setHgrow(Priority.ALWAYS);
        this.addTradeInfoBlock();
        FormBuilder.addTitledGroupBg(this.gridPane, ++this.gridRow, 3, Res.get((String)"portfolio.pending.step3_seller.confirmPaymentReceipt"), 30.0);
        TextFieldWithCopyIcon field = (TextFieldWithCopyIcon)((Object)FormBuilder.addTopLabelTextFieldWithCopyIcon((GridPane)this.gridPane, (int)this.gridRow, (String)Res.get((String)"portfolio.pending.step3_seller.amountToReceive"), (String)this.model.getFiatVolume(), (double)50.0).second);
        field.setCopyWithoutCurrencyPostFix(true);
        String myPaymentDetails = "";
        String peersPaymentDetails = "";
        String myTitle = "";
        String peersTitle = "";
        String currencyName = this.getCurrencyName(this.trade);
        Contract contract = this.trade.getContract();
        if (contract != null) {
            PaymentAccountPayload myPaymentAccountPayload = this.trade.getSeller().getPaymentAccountPayload();
            PaymentAccountPayload peersPaymentAccountPayload = this.trade.getBuyer().getPaymentAccountPayload();
            myPaymentDetails = PaymentAccountUtil.findPaymentAccount((PaymentAccountPayload)myPaymentAccountPayload, (User)this.model.getUser()).map(PaymentAccount::getAccountName).orElse("");
            if (myPaymentAccountPayload instanceof AssetAccountPayload) {
                myPaymentDetails = ((AssetAccountPayload)myPaymentAccountPayload).getAddress();
                peersPaymentDetails = peersPaymentAccountPayload != null ? ((AssetAccountPayload)peersPaymentAccountPayload).getAddress() : "NA";
                myTitle = Res.get((String)"portfolio.pending.step3_seller.yourAddress", (Object[])new Object[]{currencyName});
                peersTitle = Res.get((String)"portfolio.pending.step3_seller.buyersAddress", (Object[])new Object[]{currencyName});
            } else {
                if (myPaymentDetails.isEmpty()) {
                    myPaymentDetails = myPaymentAccountPayload != null ? myPaymentAccountPayload.getPaymentDetails() : "NA";
                }
                peersPaymentDetails = peersPaymentAccountPayload != null ? peersPaymentAccountPayload.getPaymentDetails() : "NA";
                myTitle = Res.get((String)"portfolio.pending.step3_seller.yourAccount");
                peersTitle = Res.get((String)"portfolio.pending.step3_seller.buyersAccount");
            }
        }
        if (this.isXmrTrade()) {
            this.assetTxProofResultField = new InfoTextField();
            Tuple2<Label, VBox> topLabelWithVBox = FormBuilder.getTopLabelWithVBox(Res.get((String)"portfolio.pending.step3_seller.autoConf.status.label"), (Node)this.assetTxProofResultField);
            VBox vBox = (VBox)topLabelWithVBox.second;
            this.assetTxConfidenceIndicator = new TxConfidenceIndicator();
            this.assetTxConfidenceIndicator.setId("xmr-confidence");
            this.assetTxConfidenceIndicator.setProgress(0.0);
            this.assetTxConfidenceIndicator.setTooltip(new Tooltip());
            this.assetTxProofResultField.setContentForInfoPopOver((Node)this.createPopoverLabel(Res.get((String)"setting.info.msg")));
            HBox.setMargin((Node)this.assetTxConfidenceIndicator, (Insets)new Insets(23.0, 0.0, 0.0, 0.0));
            HBox hBox = new HBox();
            HBox.setHgrow((Node)vBox, (Priority)Priority.ALWAYS);
            hBox.setSpacing(10.0);
            hBox.getChildren().addAll((Object[])new Node[]{vBox, this.assetTxConfidenceIndicator});
            GridPane.setRowIndex((Node)hBox, (Integer)this.gridRow);
            GridPane.setColumnIndex((Node)hBox, (Integer)1);
            GridPane.setMargin((Node)hBox, (Insets)new Insets(73.0, 0.0, 0.0, 0.0));
            this.gridPane.getChildren().add((Object)hBox);
        }
        TextFieldWithCopyIcon myPaymentDetailsTextField = (TextFieldWithCopyIcon)((Object)FormBuilder.addCompactTopLabelTextFieldWithCopyIcon((GridPane)this.gridPane, (int)(++this.gridRow), (int)0, (String)myTitle, (String)myPaymentDetails).second);
        myPaymentDetailsTextField.setMouseTransparent(false);
        myPaymentDetailsTextField.setTooltip(new Tooltip(myPaymentDetails));
        TextFieldWithCopyIcon peersPaymentDetailsTextField = (TextFieldWithCopyIcon)((Object)FormBuilder.addCompactTopLabelTextFieldWithCopyIcon((GridPane)this.gridPane, (int)this.gridRow, (int)1, (String)peersTitle, (String)peersPaymentDetails).second);
        peersPaymentDetailsTextField.setMouseTransparent(false);
        peersPaymentDetailsTextField.setTooltip(new Tooltip(peersPaymentDetails));
        String counterCurrencyTxId = this.trade.getCounterCurrencyTxId();
        String counterCurrencyExtraData = this.trade.getCounterCurrencyExtraData();
        if (counterCurrencyTxId != null && !counterCurrencyTxId.isEmpty() && counterCurrencyExtraData != null && !counterCurrencyExtraData.isEmpty()) {
            TextFieldWithCopyIcon txHashTextField = (TextFieldWithCopyIcon)((Object)FormBuilder.addCompactTopLabelTextFieldWithCopyIcon((GridPane)this.gridPane, (int)(++this.gridRow), (int)0, (String)Res.get((String)"portfolio.pending.step3_seller.xmrTxHash"), (String)counterCurrencyTxId).second);
            txHashTextField.setMouseTransparent(false);
            txHashTextField.setTooltip(new Tooltip(myPaymentDetails));
            TextFieldWithCopyIcon txKeyDetailsTextField = (TextFieldWithCopyIcon)((Object)FormBuilder.addCompactTopLabelTextFieldWithCopyIcon((GridPane)this.gridPane, (int)this.gridRow, (int)1, (String)Res.get((String)"portfolio.pending.step3_seller.xmrTxKey"), (String)counterCurrencyExtraData).second);
            txKeyDetailsTextField.setMouseTransparent(false);
            txKeyDetailsTextField.setTooltip(new Tooltip(peersPaymentDetails));
        }
        Tuple4<Button, BusyAnimation, Label, HBox> tuple = FormBuilder.addButtonBusyAnimationLabelAfterGroup(this.gridPane, ++this.gridRow, Res.get((String)"portfolio.pending.step3_seller.confirmReceipt"));
        HBox hBox = (HBox)tuple.fourth;
        GridPane.setColumnSpan((Node)((Node)tuple.fourth), (Integer)2);
        this.confirmButton = (Button)tuple.first;
        this.confirmButton.setDisable(!this.confirmPaymentReceivedPermitted());
        this.confirmButton.setOnAction(e -> this.onPaymentReceived());
        this.busyAnimation = (BusyAnimation)((Object)tuple.second);
        this.statusLabel = (Label)tuple.third;
    }

    private boolean confirmPaymentReceivedPermitted() {
        if (!this.trade.confirmPermitted()) {
            return false;
        }
        if (this.trade.getState() == Trade.State.SELLER_SEND_FAILED_PAYMENT_RECEIVED_MSG) {
            return true;
        }
        return this.trade.getState().ordinal() >= Trade.State.BUYER_SENT_PAYMENT_SENT_MSG.ordinal() && this.trade.getState().ordinal() < Trade.State.SELLER_CONFIRMED_PAYMENT_RECEIPT.ordinal();
    }

    @Override
    protected String getInfoText() {
        String currencyName = this.getCurrencyName(this.trade);
        if (this.model.isBlockChainMethod()) {
            return Res.get((String)"portfolio.pending.step3_seller.buyerStartedPayment", (Object[])new Object[]{Res.get((String)"portfolio.pending.step3_seller.buyerStartedPayment.crypto", (Object[])new Object[]{currencyName})});
        }
        return Res.get((String)"portfolio.pending.step3_seller.buyerStartedPayment", (Object[])new Object[]{Res.get((String)"portfolio.pending.step3_seller.buyerStartedPayment.traditional", (Object[])new Object[]{currencyName})});
    }

    @Override
    protected String getFirstHalfOverWarnText() {
        String substitute = this.model.isBlockChainMethod() ? Res.get((String)"portfolio.pending.step3_seller.warn.part1a", (Object[])new Object[]{this.getCurrencyName(this.trade)}) : Res.get((String)"portfolio.pending.step3_seller.warn.part1b");
        return Res.get((String)"portfolio.pending.step3_seller.warn.part2", (Object[])new Object[]{substitute});
    }

    @Override
    protected String getPeriodOverWarnText() {
        return Res.get((String)"portfolio.pending.step3_seller.openForDispute");
    }

    @Override
    protected void applyOnDisputeOpened() {
    }

    @Override
    protected void updateDisputeState(Trade.DisputeState disputeState) {
        super.updateDisputeState(disputeState);
        this.confirmButton.setDisable(!this.confirmPaymentReceivedPermitted());
    }

    private void onPaymentReceived() {
        if (((PendingTradesDataModel)this.model.dataModel).isReadyForTxBroadcast()) {
            String key = "confirmPaymentReceived";
            if (!DevEnv.isDevMode() && DontShowAgainLookup.showAgain((String)key)) {
                Optional<String> optionalHolderName;
                PaymentAccountPayload paymentAccountPayload = ((PendingTradesDataModel)this.model.dataModel).getSellersPaymentAccountPayload();
                Object message = Res.get((String)"portfolio.pending.step3_seller.onPaymentReceived.part1", (Object[])new Object[]{this.getCurrencyName(this.trade)});
                if (!(paymentAccountPayload instanceof AssetAccountPayload) && (optionalHolderName = this.getOptionalHolderName()).isPresent()) {
                    message = (String)message + Res.get((String)"portfolio.pending.step3_seller.onPaymentReceived.name", (Object[])new Object[]{optionalHolderName.get()});
                }
                message = (String)message + Res.get((String)"portfolio.pending.step3_seller.onPaymentReceived.note");
                if (((PendingTradesDataModel)this.model.dataModel).isSignWitnessTrade()) {
                    message = (String)message + Res.get((String)"portfolio.pending.step3_seller.onPaymentReceived.signer");
                }
                ((Popup)((Popup)((Popup)((Popup)((Popup)((Popup)new Popup().headLine(Res.get((String)"portfolio.pending.step3_seller.onPaymentReceived.confirm.headline"))).confirmation((String)message)).width(700.0)).actionButtonText(Res.get((String)"portfolio.pending.step3_seller.onPaymentReceived.confirm.yes"))).onAction(this::confirmPaymentReceived)).closeButtonText(Res.get((String)"shared.cancel"))).show();
            } else {
                this.confirmPaymentReceived();
            }
        }
    }

    private void showPopup() {
        PaymentAccountPayload paymentAccountPayload = ((PendingTradesDataModel)this.model.dataModel).getSellersPaymentAccountPayload();
        String key = "confirmPayment" + this.trade.getId();
        Object message = "";
        String tradeVolumeWithCode = VolumeUtil.formatVolumeWithCode((Volume)this.trade.getVolume());
        String currencyName = this.getCurrencyName(this.trade);
        String part1 = Res.get((String)"portfolio.pending.step3_seller.part", (Object[])new Object[]{currencyName});
        if (paymentAccountPayload instanceof AssetAccountPayload) {
            String address = ((AssetAccountPayload)paymentAccountPayload).getAddress();
            String explorerOrWalletString = this.isXmrTrade() ? Res.get((String)"portfolio.pending.step3_seller.crypto.wallet", (Object[])new Object[]{currencyName}) : Res.get((String)"portfolio.pending.step3_seller.crypto.explorer", (Object[])new Object[]{currencyName});
            message = Res.get((String)"portfolio.pending.step3_seller.crypto", (Object[])new Object[]{part1, explorerOrWalletString, address, tradeVolumeWithCode, currencyName});
        } else {
            if (paymentAccountPayload instanceof USPostalMoneyOrderAccountPayload) {
                message = Res.get((String)"portfolio.pending.step3_seller.postal", (Object[])new Object[]{part1, tradeVolumeWithCode});
            } else if (paymentAccountPayload instanceof PayByMailAccountPayload) {
                message = Res.get((String)"portfolio.pending.step3_seller.payByMail", (Object[])new Object[]{part1, tradeVolumeWithCode});
            } else if (!(paymentAccountPayload instanceof WesternUnionAccountPayload || paymentAccountPayload instanceof HalCashAccountPayload || paymentAccountPayload instanceof F2FAccountPayload || paymentAccountPayload instanceof AmazonGiftCardAccountPayload)) {
                message = Res.get((String)"portfolio.pending.step3_seller.bank", (Object[])new Object[]{currencyName, tradeVolumeWithCode});
            }
            String part = Res.get((String)"portfolio.pending.step3_seller.openDispute");
            if (paymentAccountPayload instanceof CashDepositAccountPayload) {
                message = (String)message + Res.get((String)"portfolio.pending.step3_seller.cash", (Object[])new Object[]{part});
            } else if (paymentAccountPayload instanceof WesternUnionAccountPayload) {
                message = (String)message + Res.get((String)"portfolio.pending.step3_seller.westernUnion");
            } else if (paymentAccountPayload instanceof MoneyGramAccountPayload) {
                message = (String)message + Res.get((String)"portfolio.pending.step3_seller.moneyGram");
            } else if (paymentAccountPayload instanceof HalCashAccountPayload) {
                message = (String)message + Res.get((String)"portfolio.pending.step3_seller.halCash");
            } else if (paymentAccountPayload instanceof F2FAccountPayload) {
                message = part1;
            } else if (paymentAccountPayload instanceof AmazonGiftCardAccountPayload) {
                message = Res.get((String)"portfolio.pending.step3_seller.amazonGiftCard");
            }
            Optional<String> optionalHolderName = this.getOptionalHolderName();
            if (optionalHolderName.isPresent()) {
                message = (String)message + Res.get((String)"portfolio.pending.step3_seller.bankCheck", (Object[])new Object[]{optionalHolderName.get(), part});
            }
            if (((PendingTradesDataModel)this.model.dataModel).isSignWitnessTrade()) {
                message = (String)message + "\n\n" + Res.get((String)"portfolio.pending.step3_seller.onPaymentReceived.signer");
            }
        }
        if (!DevEnv.isDevMode() && DontShowAgainLookup.showAgain((String)key)) {
            DontShowAgainLookup.dontShowAgain((String)key, (boolean)true);
            ((Popup)((Popup)new Popup().headLine(Res.get((String)"popup.attention.forTradeWithId", (Object[])new Object[]{this.trade.getShortId()}))).attention((String)message)).show();
        }
    }

    private void confirmPaymentReceived() {
        this.log.info("User pressed the [Confirm payment receipt] button for Trade {}", (Object)this.trade.getShortId());
        this.busyAnimation.play();
        this.statusLabel.setText(Res.get((String)"shared.preparingConfirmation"));
        this.confirmButton.setDisable(true);
        ((PendingTradesDataModel)this.model.dataModel).onPaymentReceived(() -> {}, errorMessage -> {
            this.busyAnimation.stop();
            ((Popup)new Popup().warning(Res.get((String)"popup.warning.sendMsgFailed") + "\n\n" + errorMessage)).show();
            this.confirmButton.setDisable(!this.confirmPaymentReceivedPermitted());
            UserThread.execute(() -> this.statusLabel.setText("Error confirming payment received."));
        });
    }

    private Optional<String> getOptionalHolderName() {
        Contract contract = this.trade.getContract();
        if (contract != null) {
            PaymentAccountPayload paymentAccountPayload = this.trade.getBuyer().getPaymentAccountPayload();
            if (paymentAccountPayload instanceof BankAccountPayload) {
                return Optional.of(((BankAccountPayload)paymentAccountPayload).getHolderName());
            }
            if (paymentAccountPayload instanceof SepaAccountPayload) {
                return Optional.of(((SepaAccountPayload)paymentAccountPayload).getHolderName());
            }
            if (paymentAccountPayload instanceof SepaInstantAccountPayload) {
                return Optional.of(((SepaInstantAccountPayload)paymentAccountPayload).getHolderName());
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    private Label createPopoverLabel(String text) {
        Label label = new Label(text);
        label.setPrefWidth(600.0);
        label.setWrapText(true);
        label.setPadding(new Insets(10.0));
        return label;
    }
}

