/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.portfolio.pendingtrades.steps.buyer;

import haveno.common.UserThread;
import haveno.common.app.DevEnv;
import haveno.core.locale.Res;
import haveno.core.user.DontShowAgainLookup;
import haveno.core.xmr.model.XmrAddressEntry;
import haveno.desktop.components.AutoTooltipButton;
import haveno.desktop.components.TitledGroupBg;
import haveno.desktop.main.MainView;
import haveno.desktop.main.overlays.notifications.Notification;
import haveno.desktop.main.overlays.popups.Popup;
import haveno.desktop.main.overlays.windows.TradeFeedbackWindow;
import haveno.desktop.main.portfolio.PortfolioView;
import haveno.desktop.main.portfolio.closedtrades.ClosedTradesView;
import haveno.desktop.main.portfolio.pendingtrades.PendingTradesDataModel;
import haveno.desktop.main.portfolio.pendingtrades.PendingTradesViewModel;
import haveno.desktop.main.portfolio.pendingtrades.steps.TradeStepView;
import haveno.desktop.util.FormBuilder;
import java.util.concurrent.TimeUnit;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;

public class BuyerStep4View
extends TradeStepView {
    private Button closeButton;

    public BuyerStep4View(PendingTradesViewModel model) {
        super(model);
    }

    @Override
    public void activate() {
        super.activate();
        this.hideTradeStepInfo();
    }

    @Override
    public void deactivate() {
        super.deactivate();
    }

    @Override
    protected void addContent() {
        ((ColumnConstraints)this.gridPane.getColumnConstraints().get(1)).setHgrow(Priority.SOMETIMES);
        TitledGroupBg completedTradeLabel = new TitledGroupBg();
        if (this.trade.getDisputeState().isMediated()) {
            completedTradeLabel.setText(Res.get((String)"portfolio.pending.step5_buyer.groupTitle.mediated"));
        } else if (this.trade.getDisputeState().isDisputed() && this.trade.getDisputeResult() != null) {
            completedTradeLabel.setText(Res.get((String)"portfolio.pending.step5_buyer.groupTitle.arbitrated"));
        } else {
            completedTradeLabel.setText(Res.get((String)"portfolio.pending.step5_buyer.groupTitle"));
        }
        HBox hBox2 = new HBox(1.0, new Node[]{completedTradeLabel});
        GridPane.setMargin((Node)hBox2, (Insets)new Insets(18.0, -10.0, -12.0, -10.0));
        this.gridPane.getChildren().add((Object)hBox2);
        GridPane.setRowSpan((Node)hBox2, (Integer)5);
        if (this.trade.isPaymentReceived()) {
            FormBuilder.addCompactTopLabelTextField(this.gridPane, this.gridRow, this.getXmrTradeAmountLabel(), this.model.getTradeVolume(), 40.0);
            FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, this.getTraditionalTradeAmountLabel(), this.model.getFiatVolume());
            FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"portfolio.pending.step5_buyer.refunded"), this.model.getSecurityDeposit());
            FormBuilder.addCompactTopLabelTextField(this.gridPane, ++this.gridRow, Res.get((String)"portfolio.pending.step5_buyer.tradeFee"), this.model.getTradeFee());
        }
        this.closeButton = new AutoTooltipButton(Res.get((String)"shared.close"));
        this.closeButton.setDefaultButton(true);
        this.closeButton.getStyleClass().add((Object)"action-button");
        GridPane.setRowIndex((Node)this.closeButton, (Integer)(++this.gridRow));
        GridPane.setMargin((Node)this.closeButton, (Insets)new Insets(40.0, 10.0, 0.0, 0.0));
        this.gridPane.getChildren().add((Object)this.closeButton);
        this.closeButton.setOnAction(e -> {
            this.handleTradeCompleted();
            ((PendingTradesDataModel)this.model.dataModel).tradeManager.onTradeCompleted(this.trade);
        });
        String key = "tradeCompleted" + this.trade.getId();
        if (!DevEnv.isDevMode() && DontShowAgainLookup.showAgain((String)key)) {
            DontShowAgainLookup.dontShowAgain((String)key, (boolean)true);
            ((Notification)((Notification)new Notification().headLine(Res.get((String)"notification.tradeCompleted.headline"))).notification(Res.get((String)"notification.tradeCompleted.msg"))).autoClose().show();
        }
    }

    private void handleTradeCompleted() {
        this.closeButton.setDisable(true);
        ((PendingTradesDataModel)this.model.dataModel).xmrWalletService.swapAddressEntryToAvailable(this.trade.getId(), XmrAddressEntry.Context.TRADE_PAYOUT);
        this.openTradeFeedbackWindow();
    }

    private void openTradeFeedbackWindow() {
        String key = "feedbackPopupAfterTrade";
        if (!DevEnv.isDevMode() && this.preferences.showAgain(key)) {
            UserThread.runAfter(() -> ((TradeFeedbackWindow)((TradeFeedbackWindow)new TradeFeedbackWindow().dontShowAgainId(key)).onAction(this::showNavigateToClosedTradesViewPopup)).show(), (long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
        } else {
            this.showNavigateToClosedTradesViewPopup();
        }
    }

    private void showNavigateToClosedTradesViewPopup() {
        if (!DevEnv.isDevMode()) {
            UserThread.runAfter(() -> ((Popup)((Popup)((Popup)((Popup)((Popup)new Popup().headLine(Res.get((String)"portfolio.pending.step5_buyer.tradeCompleted.headline"))).feedback(Res.get((String)"portfolio.pending.step5_buyer.tradeCompleted.msg"))).actionButtonTextWithGoTo("portfolio.tab.history")).onAction(() -> ((PendingTradesDataModel)this.model.dataModel).navigation.navigateTo(MainView.class, PortfolioView.class, ClosedTradesView.class))).dontShowAgainId("tradeCompleteWithdrawCompletedInfo")).show(), (long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
    }

    protected String getXmrTradeAmountLabel() {
        return Res.get((String)"portfolio.pending.step5_buyer.bought");
    }

    protected String getTraditionalTradeAmountLabel() {
        return Res.get((String)"portfolio.pending.step5_buyer.paid");
    }
}

