/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.portfolio.pendingtrades.steps.buyer;

import de.jensd.fx.fontawesome.AwesomeIcon;
import haveno.core.locale.Res;
import haveno.core.network.MessageState;
import haveno.desktop.components.TextFieldWithIcon;
import haveno.desktop.main.portfolio.pendingtrades.PendingTradesViewModel;
import haveno.desktop.main.portfolio.pendingtrades.steps.TradeStepView;
import haveno.desktop.util.FormBuilder;
import javafx.beans.value.ChangeListener;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.GridPane;

public class BuyerStep3View
extends TradeStepView {
    private final ChangeListener<MessageState> messageStateChangeListener = (observable, oldValue, newValue) -> this.updateMessageStateInfo();
    private TextFieldWithIcon textFieldWithIcon;

    public BuyerStep3View(PendingTradesViewModel model) {
        super(model);
    }

    @Override
    public void activate() {
        super.activate();
        this.model.getPaymentSentMessageStateProperty().addListener(this.messageStateChangeListener);
        this.updateMessageStateInfo();
    }

    @Override
    public void deactivate() {
        super.deactivate();
        this.model.getPaymentSentMessageStateProperty().removeListener(this.messageStateChangeListener);
    }

    @Override
    protected void addInfoBlock() {
        FormBuilder.addTitledGroupBg(this.gridPane, ++this.gridRow, 2, this.getInfoBlockTitle(), 40.0);
        this.infoLabel = FormBuilder.addMultilineLabel(this.gridPane, this.gridRow, "", 60.0);
        GridPane.setColumnSpan((Node)this.infoLabel, (Integer)2);
        this.textFieldWithIcon = (TextFieldWithIcon)((Object)FormBuilder.addTopLabelTextFieldWithIcon((GridPane)this.gridPane, (int)(++this.gridRow), (String)Res.get((String)"portfolio.pending.step3_buyer.wait.msgStateInfo.label"), (double)0.0).second);
    }

    @Override
    protected String getInfoBlockTitle() {
        return Res.get((String)"portfolio.pending.step3_buyer.wait.headline");
    }

    @Override
    protected String getInfoText() {
        return Res.get((String)"portfolio.pending.step3_buyer.wait.info", (Object[])new Object[]{this.getCurrencyCode(this.trade)});
    }

    private void updateMessageStateInfo() {
        MessageState messageState = (MessageState)this.model.getPaymentSentMessageStateProperty().get();
        this.textFieldWithIcon.setText(Res.get((String)("message.state." + messageState.name())));
        Label iconLabel = this.textFieldWithIcon.getIconLabel();
        switch (messageState) {
            case UNDEFINED: {
                this.textFieldWithIcon.setIcon(AwesomeIcon.QUESTION);
                iconLabel.getStyleClass().add((Object)"trade-msg-state-undefined");
                break;
            }
            case SENT: {
                this.textFieldWithIcon.setIcon(AwesomeIcon.ARROW_RIGHT);
                iconLabel.getStyleClass().add((Object)"trade-msg-state-sent");
                break;
            }
            case ARRIVED: {
                this.textFieldWithIcon.setIcon(AwesomeIcon.OK);
                iconLabel.getStyleClass().add((Object)"trade-msg-state-arrived");
                break;
            }
            case STORED_IN_MAILBOX: {
                this.textFieldWithIcon.setIcon(AwesomeIcon.ENVELOPE_ALT);
                iconLabel.getStyleClass().add((Object)"trade-msg-state-stored");
                break;
            }
            case ACKNOWLEDGED: {
                this.textFieldWithIcon.setIcon(AwesomeIcon.OK_SIGN);
                iconLabel.getStyleClass().add((Object)"trade-msg-state-stored");
                break;
            }
            case FAILED: 
            case NACKED: {
                this.textFieldWithIcon.setIcon(AwesomeIcon.EXCLAMATION_SIGN);
                iconLabel.getStyleClass().add((Object)"trade-msg-state-acknowledged");
            }
        }
    }

    @Override
    protected String getFirstHalfOverWarnText() {
        String substitute = this.model.isBlockChainMethod() ? Res.get((String)"portfolio.pending.step3_buyer.warn.part1a", (Object[])new Object[]{this.getCurrencyCode(this.trade)}) : Res.get((String)"portfolio.pending.step3_buyer.warn.part1b");
        return Res.get((String)"portfolio.pending.step3_buyer.warn.part2", (Object[])new Object[]{substitute});
    }

    @Override
    protected String getPeriodOverWarnText() {
        return Res.get((String)"portfolio.pending.step3_buyer.openForDispute");
    }

    @Override
    protected void applyOnDisputeOpened() {
    }
}

