/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.portfolio.pendingtrades.steps.buyer;

import com.google.common.base.Preconditions;
import haveno.common.Timer;
import haveno.common.UserThread;
import haveno.common.app.DevEnv;
import haveno.common.util.Tuple4;
import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.locale.Res;
import haveno.core.monetary.Volume;
import haveno.core.offer.Offer;
import haveno.core.payment.PaymentAccountUtil;
import haveno.core.payment.payload.AssetAccountPayload;
import haveno.core.payment.payload.CashDepositAccountPayload;
import haveno.core.payment.payload.F2FAccountPayload;
import haveno.core.payment.payload.FasterPaymentsAccountPayload;
import haveno.core.payment.payload.HalCashAccountPayload;
import haveno.core.payment.payload.MoneyGramAccountPayload;
import haveno.core.payment.payload.PayByMailAccountPayload;
import haveno.core.payment.payload.PaymentAccountPayload;
import haveno.core.payment.payload.SwiftAccountPayload;
import haveno.core.payment.payload.USPostalMoneyOrderAccountPayload;
import haveno.core.payment.payload.WesternUnionAccountPayload;
import haveno.core.trade.Trade;
import haveno.core.user.DontShowAgainLookup;
import haveno.core.util.VolumeUtil;
import haveno.desktop.components.BusyAnimation;
import haveno.desktop.components.TextFieldWithCopyIcon;
import haveno.desktop.components.TitledGroupBg;
import haveno.desktop.components.paymentmethods.AchTransferForm;
import haveno.desktop.components.paymentmethods.AdvancedCashForm;
import haveno.desktop.components.paymentmethods.AliPayForm;
import haveno.desktop.components.paymentmethods.AmazonGiftCardForm;
import haveno.desktop.components.paymentmethods.AssetsForm;
import haveno.desktop.components.paymentmethods.AustraliaPayidForm;
import haveno.desktop.components.paymentmethods.BizumForm;
import haveno.desktop.components.paymentmethods.CapitualForm;
import haveno.desktop.components.paymentmethods.CashAppForm;
import haveno.desktop.components.paymentmethods.CashAtAtmForm;
import haveno.desktop.components.paymentmethods.CashDepositForm;
import haveno.desktop.components.paymentmethods.CelPayForm;
import haveno.desktop.components.paymentmethods.ChaseQuickPayForm;
import haveno.desktop.components.paymentmethods.DomesticWireTransferForm;
import haveno.desktop.components.paymentmethods.F2FForm;
import haveno.desktop.components.paymentmethods.FasterPaymentsForm;
import haveno.desktop.components.paymentmethods.HalCashForm;
import haveno.desktop.components.paymentmethods.ImpsForm;
import haveno.desktop.components.paymentmethods.InteracETransferForm;
import haveno.desktop.components.paymentmethods.JapanBankTransferForm;
import haveno.desktop.components.paymentmethods.MoneseForm;
import haveno.desktop.components.paymentmethods.MoneyBeamForm;
import haveno.desktop.components.paymentmethods.MoneyGramForm;
import haveno.desktop.components.paymentmethods.NationalBankForm;
import haveno.desktop.components.paymentmethods.NeftForm;
import haveno.desktop.components.paymentmethods.NequiForm;
import haveno.desktop.components.paymentmethods.PaxumForm;
import haveno.desktop.components.paymentmethods.PayByMailForm;
import haveno.desktop.components.paymentmethods.PayPalForm;
import haveno.desktop.components.paymentmethods.PaysafeForm;
import haveno.desktop.components.paymentmethods.PayseraForm;
import haveno.desktop.components.paymentmethods.PaytmForm;
import haveno.desktop.components.paymentmethods.PerfectMoneyForm;
import haveno.desktop.components.paymentmethods.PixForm;
import haveno.desktop.components.paymentmethods.PopmoneyForm;
import haveno.desktop.components.paymentmethods.PromptPayForm;
import haveno.desktop.components.paymentmethods.RevolutForm;
import haveno.desktop.components.paymentmethods.RtgsForm;
import haveno.desktop.components.paymentmethods.SameBankForm;
import haveno.desktop.components.paymentmethods.SatispayForm;
import haveno.desktop.components.paymentmethods.SepaForm;
import haveno.desktop.components.paymentmethods.SepaInstantForm;
import haveno.desktop.components.paymentmethods.SpecificBankForm;
import haveno.desktop.components.paymentmethods.StrikeForm;
import haveno.desktop.components.paymentmethods.SwiftForm;
import haveno.desktop.components.paymentmethods.SwishForm;
import haveno.desktop.components.paymentmethods.TikkieForm;
import haveno.desktop.components.paymentmethods.TransferwiseForm;
import haveno.desktop.components.paymentmethods.TransferwiseUsdForm;
import haveno.desktop.components.paymentmethods.USPostalMoneyOrderForm;
import haveno.desktop.components.paymentmethods.UpholdForm;
import haveno.desktop.components.paymentmethods.UpiForm;
import haveno.desktop.components.paymentmethods.VenmoForm;
import haveno.desktop.components.paymentmethods.VerseForm;
import haveno.desktop.components.paymentmethods.WeChatPayForm;
import haveno.desktop.components.paymentmethods.WesternUnionForm;
import haveno.desktop.components.paymentmethods.ZelleForm;
import haveno.desktop.main.overlays.popups.Popup;
import haveno.desktop.main.portfolio.pendingtrades.PendingTradesDataModel;
import haveno.desktop.main.portfolio.pendingtrades.PendingTradesViewModel;
import haveno.desktop.main.portfolio.pendingtrades.steps.TradeStepView;
import haveno.desktop.util.FormBuilder;
import java.util.Set;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.text.Font;
import org.fxmisc.easybind.EasyBind;
import org.fxmisc.easybind.Subscription;

public class BuyerStep2View
extends TradeStepView {
    private Button confirmButton;
    private Label statusLabel;
    private BusyAnimation busyAnimation;
    private Subscription tradeStatePropertySubscription;
    private Timer timeoutTimer;
    private int paymentAccountGridRow = 0;
    private GridPane paymentAccountGridPane;
    private GridPane moreConfirmationsGridPane;

    public BuyerStep2View(PendingTradesViewModel model) {
        super(model);
    }

    @Override
    public void activate() {
        super.activate();
        if (this.timeoutTimer != null) {
            this.timeoutTimer.stop();
        }
        if (this.tradeStatePropertySubscription == null) {
            this.tradeStatePropertySubscription = EasyBind.subscribe((ObservableValue)this.trade.stateProperty(), state -> {
                if (this.timeoutTimer != null) {
                    this.timeoutTimer.stop();
                }
                if (this.trade.isDepositsUnlocked() && !this.trade.isPaymentSent()) {
                    this.busyAnimation.stop();
                    this.statusLabel.setText("");
                    this.showPopup();
                } else if (state.ordinal() <= Trade.State.SELLER_RECEIVED_PAYMENT_SENT_MSG.ordinal()) {
                    switch (state) {
                        case BUYER_CONFIRMED_PAYMENT_SENT: {
                            this.busyAnimation.play();
                            this.statusLabel.setText(Res.get((String)"shared.preparingConfirmation"));
                            break;
                        }
                        case BUYER_SENT_PAYMENT_SENT_MSG: {
                            this.busyAnimation.play();
                            this.statusLabel.setText(Res.get((String)"shared.sendingConfirmation"));
                            this.timeoutTimer = UserThread.runAfter(() -> {
                                this.busyAnimation.stop();
                                this.statusLabel.setText(Res.get((String)"shared.sendingConfirmationAgain"));
                            }, (long)30L);
                            break;
                        }
                        case BUYER_STORED_IN_MAILBOX_PAYMENT_SENT_MSG: {
                            this.busyAnimation.stop();
                            this.statusLabel.setText(Res.get((String)"shared.messageStoredInMailbox"));
                            break;
                        }
                        case BUYER_SAW_ARRIVED_PAYMENT_SENT_MSG: 
                        case SELLER_RECEIVED_PAYMENT_SENT_MSG: {
                            this.busyAnimation.stop();
                            this.statusLabel.setText(Res.get((String)"shared.messageArrived"));
                            break;
                        }
                        case BUYER_SEND_FAILED_PAYMENT_SENT_MSG: {
                            this.busyAnimation.stop();
                            this.statusLabel.setText("");
                            break;
                        }
                        default: {
                            this.log.warn("Unexpected case: State={}, tradeId={} ", (Object)state.name(), (Object)this.trade.getId());
                            this.busyAnimation.stop();
                            this.statusLabel.setText(Res.get((String)"shared.sendingConfirmationAgain"));
                        }
                    }
                }
            });
        }
    }

    @Override
    public void deactivate() {
        super.deactivate();
        this.busyAnimation.stop();
        if (this.timeoutTimer != null) {
            this.timeoutTimer.stop();
        }
        if (this.tradeStatePropertySubscription != null) {
            this.tradeStatePropertySubscription.unsubscribe();
            this.tradeStatePropertySubscription = null;
        }
    }

    @Override
    protected void onPendingTradesInitialized() {
        super.onPendingTradesInitialized();
    }

    @Override
    protected void addContent() {
        ((ColumnConstraints)this.gridPane.getColumnConstraints().get(1)).setHgrow(Priority.ALWAYS);
        this.addTradeInfoBlock();
        this.createPaymentDetailsGridPane();
        this.createRecommendationGridPane();
        EasyBind.subscribe((ObservableValue)this.trade.statePhaseProperty(), newValue -> {
            if (this.trade.isPaymentSent() || this.model.getShowPaymentDetailsEarly() || this.trade.isDepositsFinalized()) {
                this.attachPaymentDetailsGrid();
            } else {
                this.attachRecommendationGrid();
            }
        });
    }

    private void createPaymentDetailsGridPane() {
        PaymentAccountPayload paymentAccountPayload = ((PendingTradesDataModel)this.model.dataModel).getSellersPaymentAccountPayload();
        String paymentMethodId = paymentAccountPayload != null ? paymentAccountPayload.getPaymentMethodId() : "<pending>";
        this.paymentAccountGridPane = this.createGridPane();
        TitledGroupBg accountTitledGroupBg = FormBuilder.addTitledGroupBg(this.paymentAccountGridPane, this.paymentAccountGridRow, 4, Res.get((String)"portfolio.pending.step2_buyer.startPaymentUsing", (Object[])new Object[]{Res.get((String)paymentMethodId)}), 30.0);
        TextFieldWithCopyIcon field = (TextFieldWithCopyIcon)((Object)FormBuilder.addTopLabelTextFieldWithCopyIcon((GridPane)this.paymentAccountGridPane, (int)this.paymentAccountGridRow, (int)0, (String)Res.get((String)"portfolio.pending.step2_buyer.amountToTransfer"), (String)this.model.getFiatVolume(), (double)50.0).second);
        field.setCopyWithoutCurrencyPostFix(true);
        TextArea uiHack = new TextArea();
        uiHack.setMaxHeight(1.0);
        GridPane.setRowIndex((Node)uiHack, (Integer)1);
        GridPane.setMargin((Node)uiHack, (Insets)new Insets(0.0, 0.0, 0.0, 0.0));
        uiHack.setVisible(false);
        this.paymentAccountGridPane.getChildren().add((Object)uiHack);
        switch (paymentMethodId) {
            case "UPHOLD": {
                this.paymentAccountGridRow = UpholdForm.addFormForBuyer(this.paymentAccountGridPane, this.paymentAccountGridRow, paymentAccountPayload);
                break;
            }
            case "MONEY_BEAM": {
                this.paymentAccountGridRow = MoneyBeamForm.addFormForBuyer(this.paymentAccountGridPane, this.paymentAccountGridRow, paymentAccountPayload);
                break;
            }
            case "POPMONEY": {
                this.paymentAccountGridRow = PopmoneyForm.addFormForBuyer(this.paymentAccountGridPane, this.paymentAccountGridRow, paymentAccountPayload);
                break;
            }
            case "REVOLUT": {
                this.paymentAccountGridRow = RevolutForm.addFormForBuyer(this.paymentAccountGridPane, this.paymentAccountGridRow, paymentAccountPayload);
                break;
            }
            case "PERFECT_MONEY": {
                this.paymentAccountGridRow = PerfectMoneyForm.addFormForBuyer(this.paymentAccountGridPane, this.paymentAccountGridRow, paymentAccountPayload);
                break;
            }
            case "SEPA": {
                this.paymentAccountGridRow = SepaForm.addFormForBuyer(this.paymentAccountGridPane, this.paymentAccountGridRow, paymentAccountPayload);
                break;
            }
            case "SEPA_INSTANT": {
                this.paymentAccountGridRow = SepaInstantForm.addFormForBuyer(this.paymentAccountGridPane, this.paymentAccountGridRow, paymentAccountPayload);
                break;
            }
            case "FASTER_PAYMENTS": {
                this.paymentAccountGridRow = FasterPaymentsForm.addFormForBuyer(this.paymentAccountGridPane, this.paymentAccountGridRow, paymentAccountPayload);
                break;
            }
            case "NATIONAL_BANK": {
                this.paymentAccountGridRow = NationalBankForm.addFormForBuyer(this.paymentAccountGridPane, this.paymentAccountGridRow, paymentAccountPayload);
                break;
            }
            case "AUSTRALIA_PAYID": {
                this.paymentAccountGridRow = AustraliaPayidForm.addFormForBuyer(this.paymentAccountGridPane, this.paymentAccountGridRow, paymentAccountPayload);
                break;
            }
            case "SAME_BANK": {
                this.paymentAccountGridRow = SameBankForm.addFormForBuyer(this.paymentAccountGridPane, this.paymentAccountGridRow, paymentAccountPayload);
                break;
            }
            case "SPECIFIC_BANKS": {
                this.paymentAccountGridRow = SpecificBankForm.addFormForBuyer(this.paymentAccountGridPane, this.paymentAccountGridRow, paymentAccountPayload);
                break;
            }
            case "SWISH": {
                this.paymentAccountGridRow = SwishForm.addFormForBuyer(this.paymentAccountGridPane, this.paymentAccountGridRow, paymentAccountPayload);
                break;
            }
            case "ALI_PAY": {
                this.paymentAccountGridRow = AliPayForm.addFormForBuyer(this.paymentAccountGridPane, this.paymentAccountGridRow, paymentAccountPayload);
                break;
            }
            case "WECHAT_PAY": {
                this.paymentAccountGridRow = WeChatPayForm.addFormForBuyer(this.paymentAccountGridPane, this.paymentAccountGridRow, paymentAccountPayload);
                break;
            }
            case "ZELLE": {
                this.paymentAccountGridRow = ZelleForm.addFormForBuyer(this.paymentAccountGridPane, this.paymentAccountGridRow, paymentAccountPayload);
                break;
            }
            case "CHASE_QUICK_PAY": {
                this.paymentAccountGridRow = ChaseQuickPayForm.addFormForBuyer(this.paymentAccountGridPane, this.paymentAccountGridRow, paymentAccountPayload);
                break;
            }
            case "INTERAC_E_TRANSFER": {
                this.paymentAccountGridRow = InteracETransferForm.addFormForBuyer(this.paymentAccountGridPane, this.paymentAccountGridRow, paymentAccountPayload);
                break;
            }
            case "JAPAN_BANK": {
                this.paymentAccountGridRow = JapanBankTransferForm.addFormForBuyer(this.paymentAccountGridPane, this.paymentAccountGridRow, paymentAccountPayload);
                break;
            }
            case "US_POSTAL_MONEY_ORDER": {
                this.paymentAccountGridRow = USPostalMoneyOrderForm.addFormForBuyer(this.paymentAccountGridPane, this.paymentAccountGridRow, paymentAccountPayload);
                break;
            }
            case "CASH_DEPOSIT": {
                this.paymentAccountGridRow = CashDepositForm.addFormForBuyer(this.paymentAccountGridPane, this.paymentAccountGridRow, paymentAccountPayload);
                break;
            }
            case "PAY_BY_MAIL": {
                this.paymentAccountGridRow = PayByMailForm.addFormForBuyer(this.paymentAccountGridPane, this.paymentAccountGridRow, paymentAccountPayload);
                break;
            }
            case "CASH_AT_ATM": {
                this.paymentAccountGridRow = CashAtAtmForm.addFormForBuyer(this.paymentAccountGridPane, this.paymentAccountGridRow, paymentAccountPayload);
                break;
            }
            case "MONEY_GRAM": {
                this.paymentAccountGridRow = MoneyGramForm.addFormForBuyer(this.paymentAccountGridPane, this.paymentAccountGridRow, paymentAccountPayload);
                break;
            }
            case "WESTERN_UNION": {
                this.paymentAccountGridRow = WesternUnionForm.addFormForBuyer(this.paymentAccountGridPane, this.paymentAccountGridRow, paymentAccountPayload);
                break;
            }
            case "HAL_CASH": {
                this.paymentAccountGridRow = HalCashForm.addFormForBuyer(this.paymentAccountGridPane, this.paymentAccountGridRow, paymentAccountPayload);
                break;
            }
            case "F2F": {
                Preconditions.checkNotNull((Object)((PendingTradesDataModel)this.model.dataModel).getTrade(), (Object)"model.dataModel.getTrade() must not be null");
                Preconditions.checkNotNull((Object)((PendingTradesDataModel)this.model.dataModel).getTrade().getOffer(), (Object)"model.dataModel.getTrade().getOffer() must not be null");
                this.paymentAccountGridRow = F2FForm.addStep2Form(this.paymentAccountGridPane, this.paymentAccountGridRow, paymentAccountPayload, ((PendingTradesDataModel)this.model.dataModel).getTrade().getOffer(), 0.0, true);
                break;
            }
            case "BLOCK_CHAINS": 
            case "BLOCK_CHAINS_INSTANT": {
                String labelTitle = Res.get((String)"portfolio.pending.step2_buyer.sellersAddress", (Object[])new Object[]{this.getCurrencyName(this.trade)});
                this.paymentAccountGridRow = AssetsForm.addFormForBuyer(this.paymentAccountGridPane, this.paymentAccountGridRow, paymentAccountPayload, labelTitle);
                break;
            }
            case "PROMPT_PAY": {
                this.paymentAccountGridRow = PromptPayForm.addFormForBuyer(this.paymentAccountGridPane, this.paymentAccountGridRow, paymentAccountPayload);
                break;
            }
            case "ADVANCED_CASH": {
                this.paymentAccountGridRow = AdvancedCashForm.addFormForBuyer(this.paymentAccountGridPane, this.paymentAccountGridRow, paymentAccountPayload);
                break;
            }
            case "TRANSFERWISE": {
                this.paymentAccountGridRow = TransferwiseForm.addFormForBuyer(this.paymentAccountGridPane, this.paymentAccountGridRow, paymentAccountPayload);
                break;
            }
            case "TRANSFERWISE_USD": {
                this.paymentAccountGridRow = TransferwiseUsdForm.addFormForBuyer(this.paymentAccountGridPane, this.paymentAccountGridRow, paymentAccountPayload);
                break;
            }
            case "PAYSERA": {
                this.paymentAccountGridRow = PayseraForm.addFormForBuyer(this.paymentAccountGridPane, this.paymentAccountGridRow, paymentAccountPayload);
                break;
            }
            case "PAXUM": {
                this.paymentAccountGridRow = PaxumForm.addFormForBuyer(this.paymentAccountGridPane, this.paymentAccountGridRow, paymentAccountPayload);
                break;
            }
            case "NEFT": {
                this.paymentAccountGridRow = NeftForm.addFormForBuyer(this.paymentAccountGridPane, this.paymentAccountGridRow, paymentAccountPayload);
                break;
            }
            case "RTGS": {
                this.paymentAccountGridRow = RtgsForm.addFormForBuyer(this.paymentAccountGridPane, this.paymentAccountGridRow, paymentAccountPayload);
                break;
            }
            case "IMPS": {
                this.paymentAccountGridRow = ImpsForm.addFormForBuyer(this.paymentAccountGridPane, this.paymentAccountGridRow, paymentAccountPayload);
                break;
            }
            case "UPI": {
                this.paymentAccountGridRow = UpiForm.addFormForBuyer(this.paymentAccountGridPane, this.paymentAccountGridRow, paymentAccountPayload);
                break;
            }
            case "PAYTM": {
                this.paymentAccountGridRow = PaytmForm.addFormForBuyer(this.paymentAccountGridPane, this.paymentAccountGridRow, paymentAccountPayload);
                break;
            }
            case "NEQUI": {
                this.paymentAccountGridRow = NequiForm.addFormForBuyer(this.paymentAccountGridPane, this.paymentAccountGridRow, paymentAccountPayload);
                break;
            }
            case "BIZUM": {
                this.paymentAccountGridRow = BizumForm.addFormForBuyer(this.paymentAccountGridPane, this.paymentAccountGridRow, paymentAccountPayload);
                break;
            }
            case "PIX": {
                this.paymentAccountGridRow = PixForm.addFormForBuyer(this.paymentAccountGridPane, this.paymentAccountGridRow, paymentAccountPayload);
                break;
            }
            case "AMAZON_GIFT_CARD": {
                this.paymentAccountGridRow = AmazonGiftCardForm.addFormForBuyer(this.paymentAccountGridPane, this.paymentAccountGridRow, paymentAccountPayload);
                break;
            }
            case "CAPITUAL": {
                this.paymentAccountGridRow = CapitualForm.addFormForBuyer(this.paymentAccountGridPane, this.paymentAccountGridRow, paymentAccountPayload);
                break;
            }
            case "CELPAY": {
                this.paymentAccountGridRow = CelPayForm.addFormForBuyer(this.paymentAccountGridPane, this.paymentAccountGridRow, paymentAccountPayload);
                break;
            }
            case "MONESE": {
                this.paymentAccountGridRow = MoneseForm.addFormForBuyer(this.paymentAccountGridPane, this.paymentAccountGridRow, paymentAccountPayload);
                break;
            }
            case "SATISPAY": {
                this.paymentAccountGridRow = SatispayForm.addFormForBuyer(this.paymentAccountGridPane, this.paymentAccountGridRow, paymentAccountPayload);
                break;
            }
            case "TIKKIE": {
                this.paymentAccountGridRow = TikkieForm.addFormForBuyer(this.paymentAccountGridPane, this.paymentAccountGridRow, paymentAccountPayload);
                break;
            }
            case "VERSE": {
                this.paymentAccountGridRow = VerseForm.addFormForBuyer(this.paymentAccountGridPane, this.paymentAccountGridRow, paymentAccountPayload);
                break;
            }
            case "STRIKE": {
                this.paymentAccountGridRow = StrikeForm.addFormForBuyer(this.paymentAccountGridPane, this.paymentAccountGridRow, paymentAccountPayload);
                break;
            }
            case "SWIFT": {
                this.paymentAccountGridRow = SwiftForm.addFormForBuyer(this.paymentAccountGridPane, this.paymentAccountGridRow, paymentAccountPayload, this.trade);
                break;
            }
            case "ACH_TRANSFER": {
                this.paymentAccountGridRow = AchTransferForm.addFormForBuyer(this.paymentAccountGridPane, this.paymentAccountGridRow, paymentAccountPayload);
                break;
            }
            case "DOMESTIC_WIRE_TRANSFER": {
                this.paymentAccountGridRow = DomesticWireTransferForm.addFormForBuyer(this.paymentAccountGridPane, this.paymentAccountGridRow, paymentAccountPayload);
                break;
            }
            case "CASH_APP": {
                this.paymentAccountGridRow = CashAppForm.addFormForBuyer(this.paymentAccountGridPane, this.paymentAccountGridRow, paymentAccountPayload);
                break;
            }
            case "PAYPAL": {
                this.paymentAccountGridRow = PayPalForm.addFormForBuyer(this.paymentAccountGridPane, this.paymentAccountGridRow, paymentAccountPayload);
                break;
            }
            case "VENMO": {
                this.paymentAccountGridRow = VenmoForm.addFormForBuyer(this.paymentAccountGridPane, this.paymentAccountGridRow, paymentAccountPayload);
                break;
            }
            case "PAYSAFE": {
                this.paymentAccountGridRow = PaysafeForm.addFormForBuyer(this.paymentAccountGridPane, this.paymentAccountGridRow, paymentAccountPayload);
                break;
            }
            default: {
                this.log.error("Not supported PaymentMethod: " + paymentMethodId);
            }
        }
        Trade trade = this.model.getTrade();
        if (trade != null && this.model.getUser().getPaymentAccounts() != null) {
            Offer offer = trade.getOffer();
            ObservableList possiblePaymentAccounts = PaymentAccountUtil.getPossiblePaymentAccounts((Offer)offer, (Set)this.model.getUser().getPaymentAccounts(), (AccountAgeWitnessService)((PendingTradesDataModel)this.model.dataModel).getAccountAgeWitnessService());
            PaymentAccountPayload buyersPaymentAccountPayload = ((PendingTradesDataModel)this.model.dataModel).getBuyersPaymentAccountPayload();
            if (buyersPaymentAccountPayload != null && possiblePaymentAccounts.size() > 1) {
                String id = buyersPaymentAccountPayload.getId();
                possiblePaymentAccounts.stream().filter(paymentAccount -> paymentAccount.getId().equals(id)).findFirst().ifPresent(paymentAccount -> {
                    String accountName = paymentAccount.getAccountName();
                    FormBuilder.addCompactTopLabelTextFieldWithCopyIcon(this.paymentAccountGridPane, ++this.paymentAccountGridRow, 0, Res.get((String)"portfolio.pending.step2_buyer.buyerAccount"), accountName);
                });
            }
        }
        GridPane.setRowSpan((Node)accountTitledGroupBg, (Integer)(this.gridRow + this.paymentAccountGridRow - 1));
        Tuple4<Button, BusyAnimation, Label, HBox> tuple3 = FormBuilder.addButtonBusyAnimationLabel(this.paymentAccountGridPane, ++this.paymentAccountGridRow, 0, Res.get((String)"portfolio.pending.step2_buyer.paymentSent"), 10.0);
        HBox confirmButtonHBox = (HBox)tuple3.fourth;
        GridPane.setColumnSpan((Node)confirmButtonHBox, (Integer)2);
        this.confirmButton = (Button)tuple3.first;
        this.confirmButton.setDisable(!this.confirmPaymentSentPermitted());
        this.confirmButton.setOnAction(e -> this.onPaymentSent());
        this.busyAnimation = (BusyAnimation)((Object)tuple3.second);
        this.statusLabel = (Label)tuple3.third;
    }

    private void createRecommendationGridPane() {
        this.moreConfirmationsGridPane = new GridPane();
        this.moreConfirmationsGridPane.setStyle("-fx-background-color: -bs-content-background-gray;");
        this.moreConfirmationsGridPane.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        FormBuilder.addTitledGroupBg(this.moreConfirmationsGridPane, 0, 1, Res.get((String)"portfolio.pending.step1.waitForConf"), 30.0);
        Label label = new Label(Res.get((String)"portfolio.pending.step2_buyer.additionalConf", (Object[])new Object[]{30}));
        label.setFont(new Font(16.0));
        GridPane.setMargin((Node)label, (Insets)new Insets(20.0, 0.0, 0.0, 0.0));
        this.moreConfirmationsGridPane.add((Node)label, 0, 1, 2, 1);
        Button showPaymentDetailsButton = new Button("Show payment details early");
        showPaymentDetailsButton.getStyleClass().add((Object)"action-button");
        GridPane.setMargin((Node)showPaymentDetailsButton, (Insets)new Insets(20.0, 0.0, 0.0, 0.0));
        showPaymentDetailsButton.setOnAction(e -> {
            this.model.setShowPaymentDetailsEarly(true);
            this.gridPane.getChildren().remove((Object)this.moreConfirmationsGridPane);
            this.gridPane.getChildren().add((Object)this.paymentAccountGridPane);
            GridPane.setRowIndex((Node)this.paymentAccountGridPane, (Integer)(this.gridRow + 1));
            GridPane.setColumnSpan((Node)this.paymentAccountGridPane, (Integer)2);
        });
        this.moreConfirmationsGridPane.add((Node)showPaymentDetailsButton, 0, 2);
    }

    private GridPane createGridPane() {
        GridPane gridPane = new GridPane();
        gridPane.setHgap(5.0);
        gridPane.setVgap(5.0);
        ColumnConstraints columnConstraints1 = new ColumnConstraints();
        columnConstraints1.setHgrow(Priority.ALWAYS);
        ColumnConstraints columnConstraints2 = new ColumnConstraints();
        columnConstraints2.setHgrow(Priority.ALWAYS);
        gridPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{columnConstraints1, columnConstraints2});
        return gridPane;
    }

    private void attachRecommendationGrid() {
        if (this.gridPane.getChildren().contains((Object)this.moreConfirmationsGridPane)) {
            return;
        }
        if (this.gridPane.getChildren().contains((Object)this.paymentAccountGridPane)) {
            this.gridPane.getChildren().remove((Object)this.paymentAccountGridPane);
        }
        this.gridPane.getChildren().add((Object)this.moreConfirmationsGridPane);
        GridPane.setRowIndex((Node)this.moreConfirmationsGridPane, (Integer)(this.gridRow + 1));
        GridPane.setColumnSpan((Node)this.moreConfirmationsGridPane, (Integer)2);
    }

    private void attachPaymentDetailsGrid() {
        if (this.gridPane.getChildren().contains((Object)this.paymentAccountGridPane)) {
            return;
        }
        if (this.gridPane.getChildren().contains((Object)this.moreConfirmationsGridPane)) {
            this.gridPane.getChildren().remove((Object)this.moreConfirmationsGridPane);
        }
        this.gridPane.getChildren().add((Object)this.paymentAccountGridPane);
        GridPane.setRowIndex((Node)this.paymentAccountGridPane, (Integer)(this.gridRow + 1));
        GridPane.setColumnSpan((Node)this.paymentAccountGridPane, (Integer)2);
    }

    private boolean confirmPaymentSentPermitted() {
        if (!this.trade.confirmPermitted()) {
            return false;
        }
        if (this.trade.getState() == Trade.State.BUYER_SEND_FAILED_PAYMENT_SENT_MSG) {
            return true;
        }
        return this.trade.isDepositsUnlocked() && this.trade.getState().ordinal() < Trade.State.BUYER_CONFIRMED_PAYMENT_SENT.ordinal();
    }

    @Override
    protected String getFirstHalfOverWarnText() {
        return Res.get((String)"portfolio.pending.step2_buyer.warn", (Object[])new Object[]{this.getCurrencyCode(this.trade), this.model.getDateForOpenDispute()});
    }

    @Override
    protected String getPeriodOverWarnText() {
        return Res.get((String)"portfolio.pending.step2_buyer.openForDispute");
    }

    @Override
    protected void applyOnDisputeOpened() {
    }

    @Override
    protected void updateDisputeState(Trade.DisputeState disputeState) {
        super.updateDisputeState(disputeState);
        this.confirmButton.setDisable(!this.confirmPaymentSentPermitted());
    }

    private void onPaymentSent() {
        if (!((PendingTradesDataModel)this.model.dataModel).isBootstrappedOrShowPopup()) {
            return;
        }
        if (!((PendingTradesDataModel)this.model.dataModel).isReadyForTxBroadcast()) {
            return;
        }
        PaymentAccountPayload sellersPaymentAccountPayload = ((PendingTradesDataModel)this.model.dataModel).getSellersPaymentAccountPayload();
        Trade trade = (Trade)Preconditions.checkNotNull((Object)((PendingTradesDataModel)this.model.dataModel).getTrade(), (Object)"trade must not be null");
        if (sellersPaymentAccountPayload instanceof CashDepositAccountPayload) {
            String key = "confirmPaperReceiptSent";
            if (!DevEnv.isDevMode() && DontShowAgainLookup.showAgain((String)key)) {
                Popup popup = new Popup();
                ((Popup)((Popup)((Popup)((Popup)((Popup)((Popup)popup.headLine(Res.get((String)"portfolio.pending.step2_buyer.paperReceipt.headline"))).feedback(Res.get((String)"portfolio.pending.step2_buyer.paperReceipt.msg"))).onAction(this::showConfirmPaymentSentPopup)).closeButtonText(Res.get((String)"shared.no"))).onClose(popup::hide)).dontShowAgainId(key)).show();
            } else {
                this.showConfirmPaymentSentPopup();
            }
        } else if (sellersPaymentAccountPayload instanceof WesternUnionAccountPayload) {
            String key = "westernUnionMTCNSent";
            if (!DevEnv.isDevMode() && DontShowAgainLookup.showAgain((String)key)) {
                String email = ((WesternUnionAccountPayload)sellersPaymentAccountPayload).getEmail();
                Popup popup = new Popup();
                ((Popup)((Popup)((Popup)((Popup)((Popup)((Popup)((Popup)popup.headLine(Res.get((String)"portfolio.pending.step2_buyer.westernUnionMTCNInfo.headline"))).feedback(Res.get((String)"portfolio.pending.step2_buyer.westernUnionMTCNInfo.msg", (Object[])new Object[]{email}))).onAction(this::showConfirmPaymentSentPopup)).actionButtonText(Res.get((String)"shared.yes"))).closeButtonText(Res.get((String)"shared.no"))).onClose(popup::hide)).dontShowAgainId(key)).show();
            } else {
                this.showConfirmPaymentSentPopup();
            }
        } else if (sellersPaymentAccountPayload instanceof MoneyGramAccountPayload) {
            String key = "moneyGramMTCNSent";
            if (!DevEnv.isDevMode() && DontShowAgainLookup.showAgain((String)key)) {
                String email = ((MoneyGramAccountPayload)sellersPaymentAccountPayload).getEmail();
                Popup popup = new Popup();
                ((Popup)((Popup)((Popup)((Popup)((Popup)((Popup)((Popup)popup.headLine(Res.get((String)"portfolio.pending.step2_buyer.moneyGramMTCNInfo.headline"))).feedback(Res.get((String)"portfolio.pending.step2_buyer.moneyGramMTCNInfo.msg", (Object[])new Object[]{email}))).onAction(this::showConfirmPaymentSentPopup)).actionButtonText(Res.get((String)"shared.yes"))).closeButtonText(Res.get((String)"shared.no"))).onClose(popup::hide)).dontShowAgainId(key)).show();
            } else {
                this.showConfirmPaymentSentPopup();
            }
        } else if (sellersPaymentAccountPayload instanceof HalCashAccountPayload) {
            String key = "halCashCodeInfo";
            if (!DevEnv.isDevMode() && DontShowAgainLookup.showAgain((String)key)) {
                String mobileNr = ((HalCashAccountPayload)sellersPaymentAccountPayload).getMobileNr();
                Popup popup = new Popup();
                ((Popup)((Popup)((Popup)((Popup)((Popup)((Popup)((Popup)popup.headLine(Res.get((String)"portfolio.pending.step2_buyer.halCashInfo.headline"))).feedback(Res.get((String)"portfolio.pending.step2_buyer.halCashInfo.msg", (Object[])new Object[]{trade.getShortId(), mobileNr}))).onAction(this::showConfirmPaymentSentPopup)).actionButtonText(Res.get((String)"shared.yes"))).closeButtonText(Res.get((String)"shared.no"))).onClose(popup::hide)).dontShowAgainId(key)).show();
            } else {
                this.showConfirmPaymentSentPopup();
            }
        } else {
            this.showConfirmPaymentSentPopup();
        }
    }

    private void showConfirmPaymentSentPopup() {
        String key = "confirmPaymentSent";
        if (!DevEnv.isDevMode() && DontShowAgainLookup.showAgain((String)key)) {
            Popup popup = new Popup();
            ((Popup)((Popup)((Popup)((Popup)((Popup)((Popup)((Popup)((Popup)popup.headLine(Res.get((String)"portfolio.pending.step2_buyer.confirmStart.headline"))).confirmation(Res.get((String)"portfolio.pending.step2_buyer.confirmStart.msg", (Object[])new Object[]{this.getCurrencyName(this.trade)}))).width(700.0)).actionButtonText(Res.get((String)"portfolio.pending.step2_buyer.confirmStart.yes"))).onAction(this::confirmPaymentSent)).closeButtonText(Res.get((String)"shared.no"))).onClose(popup::hide)).dontShowAgainId(key)).show();
        } else {
            this.confirmPaymentSent();
        }
    }

    private void confirmPaymentSent() {
        this.busyAnimation.play();
        this.statusLabel.setText(Res.get((String)"shared.preparingConfirmation"));
        this.confirmButton.setDisable(true);
        ((PendingTradesDataModel)this.model.dataModel).onPaymentSent(() -> {}, errorMessage -> {
            this.busyAnimation.stop();
            ((Popup)new Popup().warning(Res.get((String)"popup.warning.sendMsgFailed") + "\n\n" + errorMessage)).show();
            this.confirmButton.setDisable(!this.confirmPaymentSentPermitted());
            UserThread.execute(() -> this.statusLabel.setText("Error confirming payment sent."));
        });
    }

    private void showPopup() {
        PaymentAccountPayload paymentAccountPayload = ((PendingTradesDataModel)this.model.dataModel).getSellersPaymentAccountPayload();
        if (paymentAccountPayload != null) {
            Object message = Res.get((String)"portfolio.pending.step2.confReached");
            String refTextWarn = Res.get((String)"portfolio.pending.step2_buyer.refTextWarn");
            String fees = Res.get((String)"portfolio.pending.step2_buyer.fees");
            String id = this.trade.getShortId();
            String amount = VolumeUtil.formatVolumeWithCode((Volume)this.trade.getVolume());
            if (paymentAccountPayload instanceof AssetAccountPayload) {
                message = (String)message + Res.get((String)"portfolio.pending.step2_buyer.crypto", (Object[])new Object[]{this.getCurrencyName(this.trade), amount});
            } else if (paymentAccountPayload instanceof CashDepositAccountPayload) {
                message = (String)message + Res.get((String)"portfolio.pending.step2_buyer.cash", (Object[])new Object[]{amount}) + refTextWarn + "\n\n" + fees + "\n\n" + Res.get((String)"portfolio.pending.step2_buyer.cash.extra");
            } else if (paymentAccountPayload instanceof WesternUnionAccountPayload) {
                email = ((WesternUnionAccountPayload)paymentAccountPayload).getEmail();
                String extra = Res.get((String)"portfolio.pending.step2_buyer.westernUnion.extra", (Object[])new Object[]{email});
                message = (String)message + Res.get((String)"portfolio.pending.step2_buyer.westernUnion", (Object[])new Object[]{amount}) + extra;
            } else if (paymentAccountPayload instanceof MoneyGramAccountPayload) {
                email = ((MoneyGramAccountPayload)paymentAccountPayload).getEmail();
                String extra = Res.get((String)"portfolio.pending.step2_buyer.moneyGram.extra", (Object[])new Object[]{email});
                message = (String)message + Res.get((String)"portfolio.pending.step2_buyer.moneyGram", (Object[])new Object[]{amount}) + extra;
            } else {
                message = paymentAccountPayload instanceof USPostalMoneyOrderAccountPayload ? (String)message + Res.get((String)"portfolio.pending.step2_buyer.postal", (Object[])new Object[]{amount}) + refTextWarn : (paymentAccountPayload instanceof F2FAccountPayload ? (String)message + Res.get((String)"portfolio.pending.step2_buyer.f2f", (Object[])new Object[]{amount}) : (paymentAccountPayload instanceof FasterPaymentsAccountPayload ? (String)message + Res.get((String)"portfolio.pending.step2_buyer.pay", (Object[])new Object[]{amount}) + Res.get((String)"portfolio.pending.step2_buyer.fasterPaymentsHolderNameInfo") + "\n\n" + refTextWarn + "\n\n" + fees : (paymentAccountPayload instanceof PayByMailAccountPayload || paymentAccountPayload instanceof HalCashAccountPayload ? (String)message + Res.get((String)"portfolio.pending.step2_buyer.pay", (Object[])new Object[]{amount}) : (paymentAccountPayload instanceof SwiftAccountPayload ? (String)message + Res.get((String)"portfolio.pending.step2_buyer.pay", (Object[])new Object[]{amount}) + refTextWarn + "\n\n" + Res.get((String)"portfolio.pending.step2_buyer.fees.swift") : (String)message + Res.get((String)"portfolio.pending.step2_buyer.pay", (Object[])new Object[]{amount}) + refTextWarn + "\n\n" + fees))));
            }
            String key = "startPayment" + this.trade.getId();
            if (!DevEnv.isDevMode() && DontShowAgainLookup.showAgain((String)key)) {
                DontShowAgainLookup.dontShowAgain((String)key, (boolean)true);
                ((Popup)((Popup)new Popup().headLine(Res.get((String)"popup.attention.forTradeWithId", (Object[])new Object[]{id}))).attention((String)message)).show();
            }
        }
    }
}

