/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.portfolio.pendingtrades.steps;

import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.materialdesignicons.MaterialDesignIcon;
import haveno.common.UserThread;
import haveno.desktop.main.portfolio.pendingtrades.steps.TradeStepView;
import haveno.desktop.util.FormBuilder;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.StackPane;
import javafx.scene.text.Text;
import org.jetbrains.annotations.NotNull;

public class TradeWizardItem
extends Label {
    private final String iconLabel;
    private final Class<? extends TradeStepView> viewClass;

    public Class<? extends TradeStepView> getViewClass() {
        return this.viewClass;
    }

    public TradeWizardItem(Class<? extends TradeStepView> viewClass, String title, String iconLabel) {
        this.viewClass = viewClass;
        this.iconLabel = iconLabel;
        this.setMouseTransparent(true);
        this.setText(title);
        this.setPrefWidth(360.0);
        this.setAlignment(Pos.CENTER_LEFT);
        this.setDisabled();
    }

    public void setDisabled() {
        this.setId("trade-wizard-item-background-disabled");
        UserThread.execute(() -> this.setGraphic((Node)this.getStackPane("trade-step-disabled-bg")));
    }

    public void setActive() {
        this.setId("trade-wizard-item-background-active");
        UserThread.execute(() -> this.setGraphic((Node)this.getStackPane("trade-step-active-bg")));
    }

    public void setCompleted() {
        this.setId("trade-wizard-item-background-active");
        Text icon = FormBuilder.getBigIcon((GlyphIcons)MaterialDesignIcon.CHECK_CIRCLE);
        icon.getStyleClass().add((Object)"trade-step-active-bg");
        UserThread.execute(() -> this.setGraphic((Node)icon));
    }

    @NotNull
    private StackPane getStackPane(String styleClass) {
        StackPane stackPane = new StackPane();
        Label label = new Label(this.iconLabel);
        label.getStyleClass().add((Object)"trade-step-label");
        Text icon = FormBuilder.getBigIcon((GlyphIcons)MaterialDesignIcon.CIRCLE);
        icon.getStyleClass().add((Object)styleClass);
        stackPane.getChildren().addAll((Object[])new Node[]{icon, label});
        return stackPane;
    }
}

