/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.portfolio.pendingtrades.steps;

import com.google.common.base.Preconditions;
import de.jensd.fx.fontawesome.AwesomeDude;
import de.jensd.fx.fontawesome.AwesomeIcon;
import haveno.common.ClockWatcher;
import haveno.common.UserThread;
import haveno.common.util.Tuple3;
import haveno.core.locale.CurrencyUtil;
import haveno.core.locale.Res;
import haveno.core.offer.Offer;
import haveno.core.support.dispute.Dispute;
import haveno.core.support.dispute.DisputeResult;
import haveno.core.support.dispute.mediation.MediationResultState;
import haveno.core.trade.ArbitratorTrade;
import haveno.core.trade.Contract;
import haveno.core.trade.HavenoUtils;
import haveno.core.trade.MakerTrade;
import haveno.core.trade.TakerTrade;
import haveno.core.trade.Trade;
import haveno.core.user.Preferences;
import haveno.desktop.components.InfoTextField;
import haveno.desktop.components.TitledGroupBg;
import haveno.desktop.components.TxIdTextField;
import haveno.desktop.components.paymentmethods.PaymentMethodForm;
import haveno.desktop.main.overlays.popups.Popup;
import haveno.desktop.main.portfolio.pendingtrades.PendingTradesDataModel;
import haveno.desktop.main.portfolio.pendingtrades.PendingTradesViewModel;
import haveno.desktop.main.portfolio.pendingtrades.TradeStepInfo;
import haveno.desktop.main.portfolio.pendingtrades.TradeSubView;
import haveno.desktop.util.FormBuilder;
import haveno.network.p2p.BootstrapListener;
import haveno.network.p2p.P2PServiceListener;
import java.math.BigInteger;
import java.util.Optional;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextField;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import org.fxmisc.easybind.EasyBind;
import org.fxmisc.easybind.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TradeStepView
extends AnchorPane {
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected final PendingTradesViewModel model;
    protected final Trade trade;
    protected final Preferences preferences;
    protected final GridPane gridPane;
    private Subscription tradePeriodStateSubscription;
    private Subscription tradeStateSubscription;
    private Subscription disputeStateSubscription;
    private Subscription mediationResultStateSubscription;
    protected int gridRow = 0;
    private TextField timeLeftTextField;
    private ProgressBar timeLeftProgressBar;
    private TxIdTextField selfTxIdTextField;
    private TxIdTextField peerTxIdTextField;
    private TradeStepInfo tradeStepInfo;
    private Subscription selfTxIdSubscription;
    private Subscription peerTxIdSubscription;
    private ClockWatcher.Listener clockListener;
    private final ChangeListener<String> errorMessageListener;
    protected Label infoLabel;
    private Popup acceptMediationResultPopup;
    private BootstrapListener bootstrapListener;
    private TradeSubView.ChatCallback chatCallback;
    private ChangeListener<Boolean> pendingTradesInitializedListener;

    protected TradeStepView(PendingTradesViewModel model) {
        this.model = model;
        this.preferences = ((PendingTradesDataModel)model.dataModel).preferences;
        this.trade = ((PendingTradesDataModel)model.dataModel).getTrade();
        Preconditions.checkNotNull((Object)this.trade, (Object)"Trade must not be null at TradeStepView");
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        scrollPane.setVbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        scrollPane.setFitToHeight(true);
        scrollPane.setFitToWidth(true);
        AnchorPane.setLeftAnchor((Node)scrollPane, (Double)10.0);
        AnchorPane.setRightAnchor((Node)scrollPane, (Double)10.0);
        AnchorPane.setTopAnchor((Node)scrollPane, (Double)10.0);
        AnchorPane.setBottomAnchor((Node)scrollPane, (Double)0.0);
        this.getChildren().add((Object)scrollPane);
        this.gridPane = new GridPane();
        this.gridPane.setHgap(5.0);
        this.gridPane.setVgap(5.0);
        this.gridPane.setPadding(new Insets(0.0, 0.0, 25.0, 0.0));
        ColumnConstraints columnConstraints1 = new ColumnConstraints();
        columnConstraints1.setHgrow(Priority.ALWAYS);
        ColumnConstraints columnConstraints2 = new ColumnConstraints();
        columnConstraints2.setHgrow(Priority.ALWAYS);
        this.gridPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{columnConstraints1, columnConstraints2});
        scrollPane.setContent((Node)this.gridPane);
        AnchorPane.setLeftAnchor((Node)this, (Double)0.0);
        AnchorPane.setRightAnchor((Node)this, (Double)0.0);
        AnchorPane.setTopAnchor((Node)this, (Double)-10.0);
        AnchorPane.setBottomAnchor((Node)this, (Double)0.0);
        this.addContent();
        this.errorMessageListener = (observable, oldValue, newValue) -> {
            if (newValue != null) {
                this.log.warn("Showing popup for trade error {} {}", new Object[]{this.trade.getClass().getSimpleName(), this.trade.getId(), new RuntimeException((String)newValue)});
                ((Popup)new Popup().error((String)newValue)).show();
            }
        };
        this.clockListener = new ClockWatcher.Listener(){

            public void onSecondTick() {
            }

            public void onMinuteTick() {
                TradeStepView.this.updateTimeLeft();
            }
        };
    }

    public void activate() {
        BooleanProperty initialized;
        if (this.selfTxIdTextField != null) {
            if (this.selfTxIdSubscription != null) {
                this.selfTxIdSubscription.unsubscribe();
            }
            this.selfTxIdSubscription = EasyBind.subscribe((ObservableValue)(((PendingTradesDataModel)this.model.dataModel).isMaker() ? ((PendingTradesDataModel)this.model.dataModel).makerTxId : ((PendingTradesDataModel)this.model.dataModel).takerTxId), id -> {
                if (!id.isEmpty()) {
                    this.selfTxIdTextField.setup((String)id, this.trade);
                } else {
                    this.selfTxIdTextField.cleanup();
                }
            });
        }
        if (this.peerTxIdTextField != null) {
            if (this.peerTxIdSubscription != null) {
                this.peerTxIdSubscription.unsubscribe();
            }
            this.peerTxIdSubscription = EasyBind.subscribe((ObservableValue)(((PendingTradesDataModel)this.model.dataModel).isMaker() ? ((PendingTradesDataModel)this.model.dataModel).takerTxId : ((PendingTradesDataModel)this.model.dataModel).makerTxId), id -> {
                if (!id.isEmpty()) {
                    this.peerTxIdTextField.setup((String)id, this.trade);
                } else {
                    this.peerTxIdTextField.cleanup();
                }
            });
        }
        this.trade.errorMessageProperty().addListener(this.errorMessageListener);
        this.tradeStepInfo.setOnAction((EventHandler<ActionEvent>)((EventHandler)e -> {
            if (!this.isArbitrationOpenedState() && (this.isTradePeriodOver() || this.trade.isDepositTxMissing())) {
                this.openSupportTicket();
            } else {
                this.openChat();
            }
        }));
        if (this.model.p2PService.isBootstrapped()) {
            this.registerSubscriptions();
        } else {
            this.bootstrapListener = new BootstrapListener(){

                public void onDataReceived() {
                    TradeStepView.this.registerSubscriptions();
                }
            };
            this.model.p2PService.addP2PServiceListener((P2PServiceListener)this.bootstrapListener);
        }
        this.tradePeriodStateSubscription = EasyBind.subscribe((ObservableValue)this.trade.tradePeriodStateProperty(), newValue -> {
            if (newValue != null) {
                UserThread.execute(() -> this.updateTradePeriodState((Trade.TradePeriodState)newValue));
            }
        });
        this.model.clockWatcher.addListener(this.clockListener);
        if (this.infoLabel != null) {
            this.infoLabel.setText(this.getInfoText());
        }
        if ((initialized = ((PendingTradesDataModel)this.model.dataModel).tradeManager.getTradesInitialized()).get()) {
            this.onPendingTradesInitialized();
        } else {
            this.pendingTradesInitializedListener = (observable, oldValue, newValue) -> {
                if (newValue.booleanValue()) {
                    this.onPendingTradesInitialized();
                    UserThread.execute(() -> initialized.removeListener(this.pendingTradesInitializedListener));
                }
            };
            initialized.addListener(this.pendingTradesInitializedListener);
        }
    }

    protected void onPendingTradesInitialized() {
    }

    private void registerSubscriptions() {
        this.disputeStateSubscription = EasyBind.subscribe((ObservableValue)this.trade.disputeStateProperty(), newValue -> {
            if (newValue != null) {
                this.updateDisputeState((Trade.DisputeState)newValue);
            }
        });
        this.mediationResultStateSubscription = EasyBind.subscribe((ObservableValue)this.trade.mediationResultStateProperty(), newValue -> {
            if (newValue != null) {
                this.updateMediationResultState(true);
            }
        });
        if (this.trade.wasWalletSyncedAndPolledProperty.get()) {
            this.addTradeStateSubscription();
        } else {
            this.trade.wasWalletSyncedAndPolledProperty.addListener((observable, oldValue, newValue) -> {
                if (newValue.booleanValue()) {
                    this.addTradeStateSubscription();
                }
            });
        }
        UserThread.execute(() -> this.model.p2PService.removeP2PServiceListener((P2PServiceListener)this.bootstrapListener));
    }

    private void addTradeStateSubscription() {
        this.tradeStateSubscription = EasyBind.subscribe((ObservableValue)this.trade.stateProperty(), newValue -> {
            if (newValue != null) {
                UserThread.execute(() -> this.updateTradeState((Trade.State)newValue));
            }
        });
    }

    private void openSupportTicket() {
        this.applyOnDisputeOpened();
        ((PendingTradesDataModel)this.model.dataModel).onOpenDispute();
    }

    private void openChat() {
        if (this.chatCallback != null) {
            this.chatCallback.onOpenChat(this.trade);
        }
    }

    public void deactivate() {
        if (this.selfTxIdSubscription != null) {
            this.selfTxIdSubscription.unsubscribe();
        }
        if (this.peerTxIdSubscription != null) {
            this.peerTxIdSubscription.unsubscribe();
        }
        if (this.selfTxIdTextField != null) {
            this.selfTxIdTextField.cleanup();
        }
        if (this.peerTxIdTextField != null) {
            this.peerTxIdTextField.cleanup();
        }
        if (this.errorMessageListener != null) {
            this.trade.errorMessageProperty().removeListener(this.errorMessageListener);
        }
        if (this.disputeStateSubscription != null) {
            this.disputeStateSubscription.unsubscribe();
        }
        if (this.mediationResultStateSubscription != null) {
            this.mediationResultStateSubscription.unsubscribe();
        }
        if (this.tradePeriodStateSubscription != null) {
            this.tradePeriodStateSubscription.unsubscribe();
        }
        if (this.tradeStateSubscription != null) {
            this.tradeStateSubscription.unsubscribe();
        }
        if (this.clockListener != null) {
            this.model.clockWatcher.removeListener(this.clockListener);
        }
        if (this.tradeStepInfo != null) {
            this.tradeStepInfo.setOnAction(null);
        }
        if (this.acceptMediationResultPopup != null) {
            this.acceptMediationResultPopup.hide();
            this.acceptMediationResultPopup = null;
        }
    }

    protected void addContent() {
        this.addTradeInfoBlock();
        this.addInfoBlock();
    }

    protected void addTradeInfoBlock() {
        boolean showPeerTxId;
        boolean showSelfTxId;
        TitledGroupBg tradeInfoTitledGroupBg = FormBuilder.addTitledGroupBg(this.gridPane, this.gridRow, 3, Res.get((String)"portfolio.pending.tradeInformation"));
        GridPane.setColumnSpan((Node)tradeInfoTitledGroupBg, (Integer)2);
        boolean bl = showSelfTxId = ((PendingTradesDataModel)this.model.dataModel).isMaker() || !this.trade.hasBuyerAsTakerWithoutDeposit();
        if (showSelfTxId) {
            String selfTxId;
            Tuple3<Label, TxIdTextField, VBox> labelSelfTxIdTextFieldVBoxTuple3 = FormBuilder.addTopLabelTxIdTextField(this.gridPane, this.gridRow, Res.get((String)"shared.yourDepositTransactionId"), 10.0);
            GridPane.setColumnSpan((Node)((Node)labelSelfTxIdTextFieldVBoxTuple3.third), (Integer)2);
            this.selfTxIdTextField = (TxIdTextField)((Object)labelSelfTxIdTextFieldVBoxTuple3.second);
            String string = selfTxId = ((PendingTradesDataModel)this.model.dataModel).isMaker() ? (String)((PendingTradesDataModel)this.model.dataModel).makerTxId.get() : (String)((PendingTradesDataModel)this.model.dataModel).takerTxId.get();
            if (!selfTxId.isEmpty()) {
                this.selfTxIdTextField.setup(selfTxId, this.trade);
            } else {
                this.selfTxIdTextField.cleanup();
            }
        }
        boolean bl2 = showPeerTxId = !((PendingTradesDataModel)this.model.dataModel).isMaker() || !this.trade.hasBuyerAsTakerWithoutDeposit();
        if (showPeerTxId) {
            String peerTxId;
            Tuple3<Label, TxIdTextField, VBox> labelPeerTxIdTextFieldVBoxTuple3 = FormBuilder.addTopLabelTxIdTextField(this.gridPane, showSelfTxId ? (this.gridRow = this.gridRow + 1) : this.gridRow, Res.get((String)"shared.peerDepositTransactionId"), showSelfTxId ? -20.0 : 10.0);
            GridPane.setColumnSpan((Node)((Node)labelPeerTxIdTextFieldVBoxTuple3.third), (Integer)2);
            this.peerTxIdTextField = (TxIdTextField)((Object)labelPeerTxIdTextFieldVBoxTuple3.second);
            String string = peerTxId = ((PendingTradesDataModel)this.model.dataModel).isMaker() ? (String)((PendingTradesDataModel)this.model.dataModel).takerTxId.get() : (String)((PendingTradesDataModel)this.model.dataModel).makerTxId.get();
            if (!peerTxId.isEmpty()) {
                this.peerTxIdTextField.setup(peerTxId, this.trade);
            } else {
                this.peerTxIdTextField.cleanup();
            }
        }
        if (((PendingTradesDataModel)this.model.dataModel).getTrade() != null) {
            Preconditions.checkNotNull((Object)((PendingTradesDataModel)this.model.dataModel).getTrade().getOffer(), (Object)"Offer must not be null in TradeStepView");
            InfoTextField infoTextField = PaymentMethodForm.addOpenTradeDuration(this.gridPane, ++this.gridRow, ((PendingTradesDataModel)this.model.dataModel).getTrade().getOffer());
            infoTextField.setContentForInfoPopOver((Node)this.createInfoPopover());
        }
        Tuple3<Label, TextField, VBox> labelTextFieldVBoxTuple3 = FormBuilder.addCompactTopLabelTextField(this.gridPane, this.gridRow, 1, Res.get((String)"portfolio.pending.remainingTime"), "");
        this.timeLeftTextField = (TextField)labelTextFieldVBoxTuple3.second;
        this.timeLeftTextField.setMinWidth(400.0);
        this.timeLeftProgressBar = new ProgressBar(0.0);
        this.timeLeftProgressBar.setOpacity(0.7);
        this.timeLeftProgressBar.setMinHeight(9.0);
        this.timeLeftProgressBar.setMaxHeight(9.0);
        this.timeLeftProgressBar.setMaxWidth(Double.MAX_VALUE);
        GridPane.setRowIndex((Node)this.timeLeftProgressBar, (Integer)(++this.gridRow));
        GridPane.setColumnSpan((Node)this.timeLeftProgressBar, (Integer)2);
        GridPane.setFillWidth((Node)this.timeLeftProgressBar, (Boolean)true);
        this.gridPane.getChildren().add((Object)this.timeLeftProgressBar);
        this.updateTimeLeft();
    }

    protected void addInfoBlock() {
        TitledGroupBg titledGroupBg = FormBuilder.addTitledGroupBg(this.gridPane, ++this.gridRow, 1, this.getInfoBlockTitle(), 30.0);
        titledGroupBg.getStyleClass().add((Object)"last");
        GridPane.setColumnSpan((Node)titledGroupBg, (Integer)2);
        this.infoLabel = FormBuilder.addMultilineLabel(this.gridPane, this.gridRow, "", 40.0);
        GridPane.setColumnSpan((Node)this.infoLabel, (Integer)2);
    }

    protected String getInfoText() {
        return "";
    }

    protected String getInfoBlockTitle() {
        return "";
    }

    private void updateTimeLeft() {
        if (!this.trade.isInitialized()) {
            return;
        }
        if (this.timeLeftTextField != null) {
            if (((PendingTradesDataModel)this.model.dataModel).getTrade() == null) {
                this.log.warn("deactivating TradeStepView because model's trade is null");
                Platform.runLater(() -> this.deactivate());
                return;
            }
            String remainingTime = this.model.getRemainingTradeDurationAsWords();
            this.timeLeftProgressBar.setProgress(this.model.getRemainingTradeDurationAsPercentage());
            if (!remainingTime.isEmpty()) {
                this.timeLeftTextField.setText(Res.get((String)"portfolio.pending.remainingTimeDetail", (Object[])new Object[]{remainingTime, this.model.getDateForOpenDispute()}));
                if (this.model.showWarning() || this.model.showDispute()) {
                    this.timeLeftTextField.getStyleClass().add((Object)"error-text");
                    this.timeLeftProgressBar.getStyleClass().add((Object)"error");
                }
            } else {
                this.timeLeftTextField.setText(Res.get((String)"portfolio.pending.tradeNotCompleted", (Object[])new Object[]{this.model.getDateForOpenDispute()}));
                this.timeLeftTextField.getStyleClass().add((Object)"error-text");
                this.timeLeftProgressBar.getStyleClass().add((Object)"error");
            }
        }
    }

    public void setTradeStepInfo(TradeStepInfo tradeStepInfo) {
        this.tradeStepInfo = tradeStepInfo;
        tradeStepInfo.setFirstHalfOverWarnTextSupplier(this::getFirstHalfOverWarnText);
        tradeStepInfo.setPeriodOverWarnTextSupplier(this::getPeriodOverWarnText);
        tradeStepInfo.setDepositTxMissingWarnTextSupplier(this::getDepositTxMissingWarnText);
    }

    protected void hideTradeStepInfo() {
        this.tradeStepInfo.setState(TradeStepInfo.State.TRADE_COMPLETED);
    }

    protected String getFirstHalfOverWarnText() {
        return "";
    }

    protected String getPeriodOverWarnText() {
        return "";
    }

    protected String getDepositTxMissingWarnText() {
        return Res.get((String)"portfolio.pending.support.depositTxMissing");
    }

    protected void applyOnDisputeOpened() {
    }

    protected void updateDisputeState(Trade.DisputeState disputeState) {
        switch (disputeState) {
            case NO_DISPUTE: {
                break;
            }
            case DISPUTE_PREPARING: 
            case DISPUTE_REQUESTED: 
            case DISPUTE_OPENED: {
                if (this.tradeStepInfo != null) {
                    this.tradeStepInfo.setFirstHalfOverWarnTextSupplier(this::getFirstHalfOverWarnText);
                }
                this.applyOnDisputeOpened();
                if (this.trade instanceof ArbitratorTrade) break;
                Optional ownDispute = ((PendingTradesDataModel)this.model.dataModel).arbitrationManager.findDispute(this.trade.getId());
                ownDispute.ifPresent(dispute -> {
                    if (this.tradeStepInfo != null) {
                        boolean isOpener = dispute.isDisputeOpenerIsBuyer() ? this.trade.isBuyer() : this.trade.isSeller();
                        this.tradeStepInfo.setState(isOpener ? TradeStepInfo.State.IN_ARBITRATION_SELF_REQUESTED : TradeStepInfo.State.IN_ARBITRATION_PEER_REQUESTED);
                    }
                });
                break;
            }
            case DISPUTE_CLOSED: {
                break;
            }
            case MEDIATION_REQUESTED: {
                if (this.tradeStepInfo != null) {
                    this.tradeStepInfo.setFirstHalfOverWarnTextSupplier(this::getFirstHalfOverWarnText);
                }
                this.applyOnDisputeOpened();
                Optional ownDispute = ((PendingTradesDataModel)this.model.dataModel).mediationManager.findDispute(this.trade.getId());
                ownDispute.ifPresent(dispute -> {
                    if (this.tradeStepInfo != null) {
                        this.tradeStepInfo.setState(TradeStepInfo.State.IN_MEDIATION_SELF_REQUESTED);
                    }
                });
                break;
            }
            case MEDIATION_STARTED_BY_PEER: {
                if (this.tradeStepInfo != null) {
                    this.tradeStepInfo.setFirstHalfOverWarnTextSupplier(this::getFirstHalfOverWarnText);
                }
                this.applyOnDisputeOpened();
                Optional ownDispute = ((PendingTradesDataModel)this.model.dataModel).mediationManager.findDispute(this.trade.getId());
                ownDispute.ifPresent(dispute -> {
                    if (this.tradeStepInfo != null) {
                        this.tradeStepInfo.setState(TradeStepInfo.State.IN_MEDIATION_PEER_REQUESTED);
                    }
                });
                break;
            }
            case MEDIATION_CLOSED: {
                if (this.tradeStepInfo != null) {
                    this.tradeStepInfo.setOnAction((EventHandler<ActionEvent>)((EventHandler)e -> this.updateMediationResultState(false)));
                }
                if (this.tradeStepInfo != null) {
                    this.tradeStepInfo.setState(TradeStepInfo.State.MEDIATION_RESULT);
                }
                this.updateMediationResultState(true);
                break;
            }
            case REFUND_REQUESTED: {
                throw new RuntimeException("Unhandled case: " + String.valueOf(Trade.DisputeState.REFUND_REQUESTED));
            }
            case REFUND_REQUEST_STARTED_BY_PEER: {
                throw new RuntimeException("Unhandled case: " + String.valueOf(Trade.DisputeState.REFUND_REQUEST_STARTED_BY_PEER));
            }
            case REFUND_REQUEST_CLOSED: {
                break;
            }
        }
    }

    private void updateMediationResultState(boolean blockOpeningOfResultAcceptedPopup) {
        if (this.isInMediation()) {
            if (this.isRefundRequestStartedByPeer()) {
                this.tradeStepInfo.setState(TradeStepInfo.State.IN_REFUND_REQUEST_PEER_REQUESTED);
            } else if (this.isRefundRequestSelfStarted()) {
                this.tradeStepInfo.setState(TradeStepInfo.State.IN_REFUND_REQUEST_SELF_REQUESTED);
            }
        } else if (this.isMediationClosedState()) {
            if (this.hasSelfAccepted()) {
                this.tradeStepInfo.setState(TradeStepInfo.State.MEDIATION_RESULT_SELF_ACCEPTED);
                if (!blockOpeningOfResultAcceptedPopup) {
                    this.openMediationResultPopup(Res.get((String)"portfolio.pending.mediationResult.popup.headline", (Object[])new Object[]{this.trade.getShortId()}));
                }
            } else if (this.peerAccepted()) {
                this.tradeStepInfo.setState(TradeStepInfo.State.MEDIATION_RESULT_PEER_ACCEPTED);
                if (this.acceptMediationResultPopup == null) {
                    this.openMediationResultPopup(Res.get((String)"portfolio.pending.mediationResult.popup.headline.peerAccepted", (Object[])new Object[]{this.trade.getShortId()}));
                }
            } else {
                this.tradeStepInfo.setState(TradeStepInfo.State.MEDIATION_RESULT);
                this.openMediationResultPopup(Res.get((String)"portfolio.pending.mediationResult.popup.headline", (Object[])new Object[]{this.trade.getShortId()}));
            }
        }
    }

    private boolean isInMediation() {
        return this.isRefundRequestStartedByPeer() || this.isRefundRequestSelfStarted();
    }

    private boolean isRefundRequestStartedByPeer() {
        return this.trade.getDisputeState() == Trade.DisputeState.REFUND_REQUEST_STARTED_BY_PEER;
    }

    private boolean isRefundRequestSelfStarted() {
        return this.trade.getDisputeState() == Trade.DisputeState.REFUND_REQUESTED;
    }

    private boolean isMediationClosedState() {
        return this.trade.getDisputeState() == Trade.DisputeState.MEDIATION_CLOSED;
    }

    private boolean isArbitrationOpenedState() {
        return this.trade.getDisputeState().isOpen();
    }

    private boolean isTradePeriodOver() {
        return Trade.TradePeriodState.TRADE_PERIOD_OVER == this.trade.tradePeriodStateProperty().get();
    }

    private boolean hasSelfAccepted() {
        return this.trade.getProcessModel().getMediatedPayoutTxSignature() != null;
    }

    private boolean peerAccepted() {
        return this.trade.getTradePeer().getMediatedPayoutTxSignature() != null;
    }

    private void openMediationResultPopup(String headLine) {
        if (this.acceptMediationResultPopup != null) {
            return;
        }
        Optional optionalDispute = ((PendingTradesDataModel)this.model.dataModel).mediationManager.findDispute(this.trade.getId());
        if (optionalDispute.isEmpty()) {
            return;
        }
        if (this.trade.getPayoutTxId() != null) {
            return;
        }
        if (this.trade instanceof MakerTrade && this.trade.getMakerDepositTx() == null) {
            this.log.error("trade.getMakerDepositTx() was null at openMediationResultPopup. We add the trade to failed trades. TradeId={}", (Object)this.trade.getId());
            ((PendingTradesDataModel)this.model.dataModel).onMoveInvalidTradeToFailedTrades(this.trade);
            ((Popup)new Popup().warning(Res.get((String)"portfolio.pending.mediationResult.error.depositTxNull"))).show();
            return;
        }
        if (this.trade instanceof TakerTrade && this.trade.getTakerDepositTx() == null && !this.trade.hasBuyerAsTakerWithoutDeposit()) {
            this.log.error("trade.getTakerDepositTx() was null at openMediationResultPopup. We add the trade to failed trades. TradeId={}", (Object)this.trade.getId());
            ((PendingTradesDataModel)this.model.dataModel).onMoveInvalidTradeToFailedTrades(this.trade);
            ((Popup)new Popup().warning(Res.get((String)"portfolio.pending.mediationResult.error.depositTxNull"))).show();
            return;
        }
        DisputeResult disputeResult = (DisputeResult)((Dispute)optionalDispute.get()).getDisputeResultProperty().get();
        Contract contract = (Contract)Preconditions.checkNotNull((Object)this.trade.getContract(), (Object)"contract must not be null");
        boolean isMyRoleBuyer = contract.isMyRoleBuyer(((PendingTradesDataModel)this.model.dataModel).getPubKeyRingProvider().get());
        String buyerPayoutAmount = HavenoUtils.formatXmr((BigInteger)disputeResult.getBuyerPayoutAmountBeforeCost(), (boolean)true);
        String sellerPayoutAmount = HavenoUtils.formatXmr((BigInteger)disputeResult.getSellerPayoutAmountBeforeCost(), (boolean)true);
        String myPayoutAmount = isMyRoleBuyer ? buyerPayoutAmount : sellerPayoutAmount;
        String peersPayoutAmount = isMyRoleBuyer ? sellerPayoutAmount : buyerPayoutAmount;
        String actionButtonText = this.hasSelfAccepted() ? Res.get((String)"portfolio.pending.mediationResult.popup.alreadyAccepted") : Res.get((String)"shared.accept");
        MediationResultState mediationResultState = ((Trade)Preconditions.checkNotNull((Object)this.trade)).getMediationResultState();
        if (mediationResultState == null) {
            return;
        }
        this.acceptMediationResultPopup = (Popup)((Popup)((Popup)((Popup)((Popup)((Popup)((Popup)((Popup)new Popup().width(900.0)).headLine(headLine)).instruction(switch (mediationResultState) {
            case MediationResultState.MEDIATION_RESULT_ACCEPTED, MediationResultState.SIG_MSG_SENT, MediationResultState.SIG_MSG_ARRIVED, MediationResultState.SIG_MSG_IN_MAILBOX, MediationResultState.SIG_MSG_SEND_FAILED -> Res.get((String)"portfolio.pending.mediationResult.popup.selfAccepted.lockTimeOver", (Object[])new Object[]{"N/A", -1});
            default -> Res.get((String)"portfolio.pending.mediationResult.popup.info", (Object[])new Object[]{myPayoutAmount, peersPayoutAmount, "N/A", -1});
        })).actionButtonText(actionButtonText)).onAction(() -> ((PendingTradesDataModel)this.model.dataModel).mediationManager.onAcceptMediationResult(this.trade, () -> {
            this.log.info("onAcceptMediationResult completed");
            this.acceptMediationResultPopup = null;
        }, errorMessage -> UserThread.execute(() -> {
            ((Popup)new Popup().error(errorMessage)).show();
            if (this.acceptMediationResultPopup != null) {
                this.acceptMediationResultPopup.hide();
                this.acceptMediationResultPopup = null;
            }
        })))).secondaryActionButtonText(Res.get((String)"portfolio.pending.mediationResult.popup.openArbitration"))).onSecondaryAction(() -> {
            ((PendingTradesDataModel)this.model.dataModel).mediationManager.rejectMediationResult(this.trade);
            ((PendingTradesDataModel)this.model.dataModel).onOpenDispute();
            this.acceptMediationResultPopup = null;
        })).onClose(() -> {
            this.acceptMediationResultPopup = null;
        });
        if (this.hasSelfAccepted()) {
            this.acceptMediationResultPopup.disableActionButton();
        }
        this.acceptMediationResultPopup.show();
    }

    protected String getCurrencyName(Trade trade) {
        return CurrencyUtil.getNameByCode((String)this.getCurrencyCode(trade));
    }

    protected String getCurrencyCode(Trade trade) {
        return ((Offer)Preconditions.checkNotNull((Object)trade.getOffer())).getCounterCurrencyCode();
    }

    protected boolean isXmrTrade() {
        return this.getCurrencyCode(this.trade).equals("XMR");
    }

    private void updateTradePeriodState(Trade.TradePeriodState tradePeriodState) {
        if (!this.trade.getDisputeState().isDisputed()) {
            switch (tradePeriodState) {
                case FIRST_HALF: {
                    if (this.tradeStepInfo.getState() == TradeStepInfo.State.WARN_PERIOD_OVER) {
                        this.tradeStepInfo.setState(TradeStepInfo.State.WARN_HALF_PERIOD);
                        break;
                    }
                    if (this.tradeStepInfo.getState() != TradeStepInfo.State.WARN_HALF_PERIOD) break;
                    this.tradeStepInfo.setState(TradeStepInfo.State.SHOW_GET_HELP_BUTTON);
                    this.tradeStepInfo.setFirstHalfOverWarnTextSupplier(this::getFirstHalfOverWarnText);
                    break;
                }
                case SECOND_HALF: {
                    if (!this.trade.isPaymentReceived()) {
                        if (this.tradeStepInfo == null) break;
                        this.tradeStepInfo.setFirstHalfOverWarnTextSupplier(this::getFirstHalfOverWarnText);
                        this.tradeStepInfo.setState(TradeStepInfo.State.WARN_HALF_PERIOD);
                        break;
                    }
                    this.tradeStepInfo.setState(TradeStepInfo.State.SHOW_GET_HELP_BUTTON);
                    break;
                }
                case TRADE_PERIOD_OVER: {
                    if (this.tradeStepInfo == null) break;
                    this.tradeStepInfo.setFirstHalfOverWarnTextSupplier(this::getPeriodOverWarnText);
                    this.tradeStepInfo.setState(TradeStepInfo.State.WARN_PERIOD_OVER);
                }
            }
        }
    }

    private void updateTradeState(Trade.State tradeState) {
        if (!this.trade.getDisputeState().isOpen() && this.trade.isDepositTxMissing()) {
            this.tradeStepInfo.setState(TradeStepInfo.State.DEPOSIT_MISSING);
        }
    }

    private GridPane createInfoPopover() {
        GridPane infoGridPane = new GridPane();
        int rowIndex = 0;
        infoGridPane.setHgap(5.0);
        infoGridPane.setVgap(10.0);
        infoGridPane.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        Label label = FormBuilder.addMultilineLabel(infoGridPane, rowIndex++, Res.get((String)"portfolio.pending.tradePeriodInfo"));
        label.setMaxWidth(450.0);
        HBox warningBox = new HBox();
        warningBox.setMinHeight(30.0);
        warningBox.setPadding(new Insets(5.0));
        warningBox.getStyleClass().add((Object)"warning-box");
        GridPane.setRowIndex((Node)warningBox, (Integer)rowIndex);
        GridPane.setColumnSpan((Node)warningBox, (Integer)2);
        Label warningIcon = new Label();
        AwesomeDude.setIcon((Label)warningIcon, (AwesomeIcon)AwesomeIcon.WARNING_SIGN);
        warningIcon.getStyleClass().add((Object)"warning");
        Label warning = new Label(Res.get((String)"portfolio.pending.tradePeriodWarning"));
        warning.setWrapText(true);
        warning.setMaxWidth(410.0);
        warningBox.getChildren().addAll((Object[])new Node[]{warningIcon, warning});
        infoGridPane.getChildren().add((Object)warningBox);
        return infoGridPane;
    }

    public void setChatCallback(TradeSubView.ChatCallback chatCallback) {
        this.chatCallback = chatCallback;
    }
}

