/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.portfolio.pendingtrades;

import haveno.core.locale.Res;
import haveno.core.trade.Trade;
import haveno.desktop.components.AutoTooltipButton;
import haveno.desktop.components.SimpleMarkdownLabel;
import haveno.desktop.components.TitledGroupBg;
import haveno.desktop.main.portfolio.pendingtrades.PendingTradesView;
import haveno.desktop.main.portfolio.pendingtrades.PendingTradesViewModel;
import haveno.desktop.main.portfolio.pendingtrades.TradeStepInfo;
import haveno.desktop.main.portfolio.pendingtrades.steps.TradeStepView;
import haveno.desktop.main.portfolio.pendingtrades.steps.TradeWizardItem;
import haveno.desktop.util.FormBuilder;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Separator;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import org.fxmisc.easybind.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TradeSubView
extends HBox {
    private static final Logger log = LoggerFactory.getLogger(TradeSubView.class);
    protected final PendingTradesViewModel model;
    protected VBox leftVBox;
    private AnchorPane contentPane;
    private TradeStepView tradeStepView;
    protected TradeStepInfo tradeStepInfo;
    private GridPane leftGridPane;
    private TitledGroupBg tradeProcessTitledGroupBg;
    private int leftGridPaneRowIndex = 0;
    Subscription viewStateSubscription;
    private PendingTradesView.ChatCallback chatCallback;

    public TradeSubView(PendingTradesViewModel model) {
        this.model = model;
        HBox.setHgrow((Node)this, (Priority)Priority.ALWAYS);
        this.setSpacing(20.0);
        this.buildViews();
    }

    protected void activate() {
    }

    protected void deactivate() {
        if (this.viewStateSubscription != null) {
            this.viewStateSubscription.unsubscribe();
        }
        if (this.tradeStepView != null) {
            this.tradeStepView.deactivate();
        }
        if (this.tradeStepInfo != null) {
            this.tradeStepInfo.removeItselfFrom(this.leftGridPane);
        }
    }

    private void buildViews() {
        this.addLeftBox();
        this.addContentPane();
        this.leftGridPane = new GridPane();
        this.leftGridPane.setPrefWidth(340.0);
        this.leftGridPane.setHgap(5.0);
        this.leftGridPane.setVgap(5.0);
        VBox.setMargin((Node)this.leftGridPane, (Insets)new Insets(0.0, 10.0, 10.0, 10.0));
        this.leftVBox.getChildren().add((Object)this.leftGridPane);
        this.leftGridPaneRowIndex = 0;
        this.tradeProcessTitledGroupBg = FormBuilder.addTitledGroupBg(this.leftGridPane, this.leftGridPaneRowIndex, 1, Res.get((String)"portfolio.pending.tradeProcess"));
        this.tradeProcessTitledGroupBg.getStyleClass().add((Object)"last");
        this.addWizards();
        TitledGroupBg titledGroupBg = FormBuilder.addTitledGroupBg(this.leftGridPane, ++this.leftGridPaneRowIndex, 1, "", 10.0);
        titledGroupBg.getStyleClass().add((Object)"last");
        SimpleMarkdownLabel label = FormBuilder.addSimpleMarkdownLabel(this.leftGridPane, ++this.leftGridPaneRowIndex);
        AutoTooltipButton button = (AutoTooltipButton)FormBuilder.addButtonAfterGroup(this.leftGridPane, ++this.leftGridPaneRowIndex, "");
        SimpleMarkdownLabel footerLabel = FormBuilder.addSimpleMarkdownLabel(this.leftGridPane, ++this.leftGridPaneRowIndex, Res.get((String)"portfolio.pending.stillNotResolved"), 10.0);
        footerLabel.getStyleClass().add((Object)"medium-text");
        this.tradeStepInfo = new TradeStepInfo(titledGroupBg, label, button, footerLabel);
    }

    void showItem(TradeWizardItem item) {
        item.setActive();
        this.createAndAddTradeStepView(item.getViewClass());
    }

    protected abstract void addWizards();

    protected void onViewStateChanged(PendingTradesViewModel.State viewState) {
        this.tradeStepInfo.setTrade(this.model.getTrade());
    }

    void addWizardsToGridPane(TradeWizardItem tradeWizardItem) {
        if (this.leftGridPaneRowIndex == 0) {
            GridPane.setMargin((Node)tradeWizardItem, (Insets)new Insets(43.0, 0.0, 0.0, 0.0));
        }
        GridPane.setRowIndex((Node)tradeWizardItem, (Integer)this.leftGridPaneRowIndex++);
        this.leftGridPane.getChildren().add((Object)tradeWizardItem);
        GridPane.setRowSpan((Node)this.tradeProcessTitledGroupBg, (Integer)this.leftGridPaneRowIndex);
        GridPane.setFillWidth((Node)tradeWizardItem, (Boolean)true);
    }

    void addLineSeparatorToGridPane() {
        Separator separator = new Separator(Orientation.VERTICAL);
        separator.setMinHeight(10.0);
        GridPane.setMargin((Node)separator, (Insets)new Insets(0.0, 0.0, 0.0, 13.0));
        GridPane.setHalignment((Node)separator, (HPos)HPos.LEFT);
        GridPane.setRowIndex((Node)separator, (Integer)this.leftGridPaneRowIndex++);
        this.leftGridPane.getChildren().add((Object)separator);
    }

    private void createAndAddTradeStepView(Class<? extends TradeStepView> viewClass) {
        if (this.tradeStepView != null) {
            this.tradeStepView.deactivate();
        }
        try {
            this.tradeStepView = viewClass.getDeclaredConstructor(PendingTradesViewModel.class).newInstance(this.model);
            this.contentPane.getChildren().setAll((Object[])new Node[]{this.tradeStepView});
            this.tradeStepView.setTradeStepInfo(this.tradeStepInfo);
            ChatCallback chatCallback = trade -> {
                if (this.chatCallback != null) {
                    this.chatCallback.onOpenChat(trade);
                }
            };
            this.tradeStepView.setChatCallback(chatCallback);
            this.tradeStepView.activate();
        }
        catch (Exception e) {
            log.error("Creating viewClass {} caused an error {}\n", new Object[]{viewClass, e.getMessage(), e});
        }
    }

    private void addLeftBox() {
        this.leftVBox = new VBox();
        this.leftVBox.setSpacing(5.0);
        this.leftVBox.setMinWidth(290.0);
        this.getChildren().add((Object)this.leftVBox);
    }

    private void addContentPane() {
        this.contentPane = new AnchorPane();
        HBox.setHgrow((Node)this.contentPane, (Priority)Priority.SOMETIMES);
        this.getChildren().add((Object)this.contentPane);
    }

    public void setChatCallback(PendingTradesView.ChatCallback chatCallback) {
        this.chatCallback = chatCallback;
    }

    public static interface ChatCallback {
        public void onOpenChat(Trade var1);
    }
}

