/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.portfolio.pendingtrades;

import haveno.core.locale.Res;
import haveno.core.trade.Trade;
import haveno.desktop.components.AutoTooltipButton;
import haveno.desktop.components.SimpleMarkdownLabel;
import haveno.desktop.components.TitledGroupBg;
import java.util.function.Supplier;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.layout.GridPane;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TradeStepInfo {
    private static final Logger log = LoggerFactory.getLogger(TradeStepInfo.class);
    private final TitledGroupBg titledGroupBg;
    private final SimpleMarkdownLabel label;
    private final SimpleMarkdownLabel footerLabel;
    private final AutoTooltipButton button;
    @Nullable
    private Trade trade;
    private State state = State.UNDEFINED;
    private Supplier<String> firstHalfOverWarnTextSupplier = () -> "";
    private Supplier<String> periodOverWarnTextSupplier = () -> "";
    private Supplier<String> depositTxMissingWarnTextSupplier = () -> "";

    TradeStepInfo(TitledGroupBg titledGroupBg, SimpleMarkdownLabel label, AutoTooltipButton button, SimpleMarkdownLabel footerLabel) {
        this.titledGroupBg = titledGroupBg;
        this.label = label;
        this.button = button;
        this.footerLabel = footerLabel;
        GridPane.setColumnIndex((Node)button, (Integer)0);
        this.setState(State.SHOW_GET_HELP_BUTTON);
    }

    void removeItselfFrom(GridPane leftGridPane) {
        leftGridPane.getChildren().remove((Object)this.titledGroupBg);
        leftGridPane.getChildren().remove((Object)this.label);
        leftGridPane.getChildren().remove((Object)this.button);
    }

    public void setOnAction(EventHandler<ActionEvent> e) {
        this.button.setOnAction(e);
    }

    public void setFirstHalfOverWarnTextSupplier(Supplier<String> firstHalfOverWarnTextSupplier) {
        this.firstHalfOverWarnTextSupplier = firstHalfOverWarnTextSupplier;
    }

    public void setPeriodOverWarnTextSupplier(Supplier<String> periodOverWarnTextSupplier) {
        this.periodOverWarnTextSupplier = periodOverWarnTextSupplier;
    }

    public void setDepositTxMissingWarnTextSupplier(Supplier<String> depositTxMissingWarnTextSupplier) {
        this.depositTxMissingWarnTextSupplier = depositTxMissingWarnTextSupplier;
    }

    public void setState(State state) {
        this.state = state;
        switch (state.ordinal()) {
            case 0: {
                break;
            }
            case 1: {
                this.titledGroupBg.setText(Res.get((String)"portfolio.pending.support.headline.getHelp"));
                this.label.updateContent("");
                this.button.setText(Res.get((String)"portfolio.pending.support.button.getHelp").toUpperCase());
                this.button.setId(null);
                this.button.getStyleClass().remove((Object)"action-button");
                this.button.setDisable(false);
                break;
            }
            case 7: {
                String text = this.trade.getDisputeState().isOpen() ? Res.get((String)"portfolio.pending.supportTicketOpened") : Res.get((String)"portfolio.pending.arbitrationRequested");
                this.titledGroupBg.setText(text);
                this.label.updateContent(Res.get((String)"portfolio.pending.disputeOpenedByUser", (Object[])new Object[]{Res.get((String)"portfolio.pending.communicateWithArbitrator")}));
                this.button.setText(text.toUpperCase());
                this.button.setId("open-dispute-button");
                this.button.getStyleClass().remove((Object)"action-button");
                this.button.setDisable(true);
                break;
            }
            case 8: {
                String text = this.trade.getDisputeState().isOpen() ? Res.get((String)"portfolio.pending.supportTicketOpened") : Res.get((String)"portfolio.pending.arbitrationRequested");
                this.titledGroupBg.setText(text);
                this.label.updateContent(Res.get((String)"portfolio.pending.disputeOpenedByPeer", (Object[])new Object[]{Res.get((String)"portfolio.pending.communicateWithArbitrator")}));
                this.button.setText(text.toUpperCase());
                this.button.setId("open-dispute-button");
                this.button.getStyleClass().remove((Object)"action-button");
                this.button.setDisable(true);
                break;
            }
            case 4: {
                this.titledGroupBg.setText(Res.get((String)"portfolio.pending.mediationResult.headline"));
                this.label.updateContent(Res.get((String)"portfolio.pending.mediationResult.info.noneAccepted"));
                this.button.setText(Res.get((String)"portfolio.pending.mediationResult.button").toUpperCase());
                this.button.setId(null);
                this.button.getStyleClass().add((Object)"action-button");
                this.button.setDisable(false);
                break;
            }
            case 5: {
                this.titledGroupBg.setText(Res.get((String)"portfolio.pending.mediationResult.headline"));
                this.label.updateContent(Res.get((String)"portfolio.pending.mediationResult.info.selfAccepted"));
                this.button.setText(Res.get((String)"portfolio.pending.mediationResult.button").toUpperCase());
                this.button.setId(null);
                this.button.getStyleClass().add((Object)"action-button");
                this.button.setDisable(false);
                break;
            }
            case 6: {
                this.titledGroupBg.setText(Res.get((String)"portfolio.pending.mediationResult.headline"));
                this.label.updateContent(Res.get((String)"portfolio.pending.mediationResult.info.peerAccepted"));
                this.button.setText(Res.get((String)"portfolio.pending.mediationResult.button").toUpperCase());
                this.button.setId(null);
                this.button.getStyleClass().add((Object)"action-button");
                this.button.setDisable(false);
                break;
            }
            case 9: {
                this.titledGroupBg.setText(Res.get((String)"portfolio.pending.refundRequested"));
                this.label.updateContent(Res.get((String)"portfolio.pending.disputeOpenedByUser", (Object[])new Object[]{Res.get((String)"portfolio.pending.communicateWithArbitrator")}));
                this.button.setText(Res.get((String)"portfolio.pending.refundRequested").toUpperCase());
                this.button.setId("open-dispute-button");
                this.button.getStyleClass().remove((Object)"action-button");
                this.button.setDisable(true);
                break;
            }
            case 10: {
                this.titledGroupBg.setText(Res.get((String)"portfolio.pending.refundRequested"));
                this.label.updateContent(Res.get((String)"portfolio.pending.disputeOpenedByPeer", (Object[])new Object[]{Res.get((String)"portfolio.pending.communicateWithArbitrator")}));
                this.button.setText(Res.get((String)"portfolio.pending.refundRequested").toUpperCase());
                this.button.setId("open-dispute-button");
                this.button.getStyleClass().remove((Object)"action-button");
                this.button.setDisable(true);
                break;
            }
            case 11: {
                this.titledGroupBg.setText(Res.get((String)"portfolio.pending.support.headline.halfPeriodOver"));
                this.label.updateContent(this.firstHalfOverWarnTextSupplier.get());
                this.button.setText(Res.get((String)"portfolio.pending.support.button.getHelp").toUpperCase());
                this.button.setId(null);
                this.button.getStyleClass().remove((Object)"action-button");
                this.button.setDisable(false);
                break;
            }
            case 12: {
                this.titledGroupBg.setText(Res.get((String)"portfolio.pending.support.headline.periodOver"));
                this.label.updateContent(this.periodOverWarnTextSupplier.get());
                this.button.setText(Res.get((String)"portfolio.pending.openSupport").toUpperCase());
                this.button.setId("open-dispute-button");
                this.button.getStyleClass().remove((Object)"action-button");
                this.button.setDisable(false);
                break;
            }
            case 13: {
                this.titledGroupBg.setText(Res.get((String)"portfolio.pending.support.headline.depositTxMissing"));
                this.label.updateContent(this.depositTxMissingWarnTextSupplier.get());
                this.button.setText(Res.get((String)"portfolio.pending.openSupport").toUpperCase());
                this.button.setId("open-dispute-button");
                this.button.getStyleClass().remove((Object)"action-button");
                this.button.setDisable(false);
                break;
            }
            case 14: {
                this.titledGroupBg.setVisible(false);
                this.label.setVisible(false);
                this.button.setVisible(false);
                this.footerLabel.setVisible(false);
            }
        }
        if (this.trade != null && this.trade.getPayoutTxId() != null) {
            this.button.setDisable(true);
        }
    }

    public void setTrade(@Nullable Trade trade) {
        this.trade = trade;
    }

    public State getState() {
        return this.state;
    }

    public static enum State {
        UNDEFINED,
        SHOW_GET_HELP_BUTTON,
        IN_MEDIATION_SELF_REQUESTED,
        IN_MEDIATION_PEER_REQUESTED,
        MEDIATION_RESULT,
        MEDIATION_RESULT_SELF_ACCEPTED,
        MEDIATION_RESULT_PEER_ACCEPTED,
        IN_ARBITRATION_SELF_REQUESTED,
        IN_ARBITRATION_PEER_REQUESTED,
        IN_REFUND_REQUEST_SELF_REQUESTED,
        IN_REFUND_REQUEST_PEER_REQUESTED,
        WARN_HALF_PERIOD,
        WARN_PERIOD_OVER,
        DEPOSIT_MISSING,
        TRADE_COMPLETED;

    }
}

