/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.portfolio.pendingtrades;

import haveno.core.locale.Res;
import haveno.desktop.main.portfolio.pendingtrades.PendingTradesViewModel;
import haveno.desktop.main.portfolio.pendingtrades.TradeSubView;
import haveno.desktop.main.portfolio.pendingtrades.steps.TradeWizardItem;
import haveno.desktop.main.portfolio.pendingtrades.steps.seller.SellerStep1View;
import haveno.desktop.main.portfolio.pendingtrades.steps.seller.SellerStep2View;
import haveno.desktop.main.portfolio.pendingtrades.steps.seller.SellerStep3View;
import haveno.desktop.main.portfolio.pendingtrades.steps.seller.SellerStep4View;
import org.fxmisc.easybind.EasyBind;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SellerSubView
extends TradeSubView {
    private static final Logger log = LoggerFactory.getLogger(SellerSubView.class);
    private TradeWizardItem step1;
    private TradeWizardItem step2;
    private TradeWizardItem step3;
    private TradeWizardItem step4;

    SellerSubView(PendingTradesViewModel model) {
        super(model);
    }

    @Override
    protected void activate() {
        this.viewStateSubscription = EasyBind.subscribe(this.model.getSellerState(), this::onViewStateChanged);
        super.activate();
    }

    @Override
    protected void addWizards() {
        this.step1 = new TradeWizardItem(SellerStep1View.class, Res.get((String)"portfolio.pending.step1.waitForConf"), "1");
        this.step2 = new TradeWizardItem(SellerStep2View.class, Res.get((String)"portfolio.pending.step2_seller.waitPaymentSent"), "2");
        this.step3 = new TradeWizardItem(SellerStep3View.class, Res.get((String)"portfolio.pending.step3_seller.confirmPaymentReceived"), "3");
        this.step4 = new TradeWizardItem(SellerStep4View.class, Res.get((String)"portfolio.pending.step5.completed"), "4");
        this.addWizardsToGridPane(this.step1);
        this.addLineSeparatorToGridPane();
        this.addWizardsToGridPane(this.step2);
        this.addLineSeparatorToGridPane();
        this.addWizardsToGridPane(this.step3);
        this.addLineSeparatorToGridPane();
        this.addWizardsToGridPane(this.step4);
    }

    @Override
    protected void onViewStateChanged(PendingTradesViewModel.State viewState) {
        super.onViewStateChanged(viewState);
        if (viewState != null) {
            PendingTradesViewModel.SellerState sellerState = (PendingTradesViewModel.SellerState)viewState;
            this.step1.setDisabled();
            this.step2.setDisabled();
            this.step3.setDisabled();
            this.step4.setDisabled();
            switch (sellerState) {
                case UNDEFINED: {
                    break;
                }
                case STEP1: {
                    this.showItem(this.step1);
                    break;
                }
                case STEP2: {
                    this.step1.setCompleted();
                    this.showItem(this.step2);
                    break;
                }
                case STEP3: {
                    this.step1.setCompleted();
                    this.step2.setCompleted();
                    this.showItem(this.step3);
                    break;
                }
                case STEP4: {
                    this.step1.setCompleted();
                    this.step2.setCompleted();
                    this.step3.setCompleted();
                    this.showItem(this.step4);
                    break;
                }
                default: {
                    log.warn("unhandled viewState " + String.valueOf(sellerState));
                }
            }
        }
    }
}

