/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.portfolio.pendingtrades;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import haveno.common.ClockWatcher;
import haveno.common.UserThread;
import haveno.common.app.DevEnv;
import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.monetary.Volume;
import haveno.core.network.MessageState;
import haveno.core.offer.Offer;
import haveno.core.offer.OfferUtil;
import haveno.core.trade.ClosedTradableManager;
import haveno.core.trade.HavenoUtils;
import haveno.core.trade.Trade;
import haveno.core.trade.TradeUtil;
import haveno.core.user.User;
import haveno.core.util.VolumeUtil;
import haveno.core.util.coin.CoinFormatter;
import haveno.core.util.validation.BtcAddressValidator;
import haveno.desktop.Navigation;
import haveno.desktop.common.model.ActivatableWithDataModel;
import haveno.desktop.common.model.ViewModel;
import haveno.desktop.main.portfolio.pendingtrades.PendingTradesDataModel;
import haveno.desktop.main.portfolio.pendingtrades.PendingTradesListItem;
import haveno.desktop.util.DisplayUtils;
import haveno.desktop.util.GUIUtil;
import haveno.network.p2p.P2PService;
import java.math.BigInteger;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javax.annotation.Nullable;
import org.fxmisc.easybind.EasyBind;
import org.fxmisc.easybind.Subscription;

public class PendingTradesViewModel
extends ActivatableWithDataModel<PendingTradesDataModel>
implements ViewModel {
    @Nullable
    private Trade trade;
    public final CoinFormatter btcFormatter;
    public final BtcAddressValidator btcAddressValidator;
    final AccountAgeWitnessService accountAgeWitnessService;
    public final P2PService p2PService;
    private final ClosedTradableManager closedTradableManager;
    private final OfferUtil offerUtil;
    private final TradeUtil tradeUtil;
    public final ClockWatcher clockWatcher;
    private final Navigation navigation;
    private final User user;
    private final ObjectProperty<BuyerState> buyerState = new SimpleObjectProperty();
    private final ObjectProperty<SellerState> sellerState = new SimpleObjectProperty();
    private final ObjectProperty<MessageState> paymentSentMessageStateProperty = new SimpleObjectProperty((Object)MessageState.UNDEFINED);
    private Subscription tradeStateSubscription;
    private Subscription paymentAccountDecryptedSubscription;
    private Subscription payoutStateSubscription;
    private Subscription messageStateSubscription;
    protected final IntegerProperty mempoolStatus = new SimpleIntegerProperty();
    private transient Map<String, Boolean> showPaymentDetailsEarly = new HashMap<String, Boolean>();

    @Inject
    public PendingTradesViewModel(PendingTradesDataModel dataModel, @Named(value="BTC") CoinFormatter btcFormatter, BtcAddressValidator btcAddressValidator, P2PService p2PService, ClosedTradableManager closedTradableManager, OfferUtil offerUtil, TradeUtil tradeUtil, AccountAgeWitnessService accountAgeWitnessService, ClockWatcher clockWatcher, Navigation navigation, User user) {
        super(dataModel);
        this.btcFormatter = btcFormatter;
        this.btcAddressValidator = btcAddressValidator;
        this.p2PService = p2PService;
        this.closedTradableManager = closedTradableManager;
        this.offerUtil = offerUtil;
        this.tradeUtil = tradeUtil;
        this.accountAgeWitnessService = accountAgeWitnessService;
        this.clockWatcher = clockWatcher;
        this.navigation = navigation;
        this.user = user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void deactivate() {
        PendingTradesViewModel pendingTradesViewModel = this;
        synchronized (pendingTradesViewModel) {
            if (this.tradeStateSubscription != null) {
                this.tradeStateSubscription.unsubscribe();
                this.tradeStateSubscription = null;
            }
            if (this.paymentAccountDecryptedSubscription != null) {
                this.paymentAccountDecryptedSubscription.unsubscribe();
                this.paymentAccountDecryptedSubscription = null;
            }
            if (this.payoutStateSubscription != null) {
                this.payoutStateSubscription.unsubscribe();
                this.payoutStateSubscription = null;
            }
            if (this.messageStateSubscription != null) {
                this.messageStateSubscription.unsubscribe();
                this.messageStateSubscription = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSelectedItemChanged(PendingTradesListItem selectedItem) {
        PendingTradesViewModel pendingTradesViewModel = this;
        synchronized (pendingTradesViewModel) {
            if (this.tradeStateSubscription != null) {
                this.tradeStateSubscription.unsubscribe();
                this.sellerState.set((Object)SellerState.UNDEFINED);
                this.buyerState.set((Object)BuyerState.UNDEFINED);
            }
            if (this.paymentAccountDecryptedSubscription != null) {
                this.paymentAccountDecryptedSubscription.unsubscribe();
            }
            if (this.payoutStateSubscription != null) {
                this.payoutStateSubscription.unsubscribe();
                this.sellerState.set((Object)SellerState.UNDEFINED);
                this.buyerState.set((Object)BuyerState.UNDEFINED);
            }
            if (this.messageStateSubscription != null) {
                this.messageStateSubscription.unsubscribe();
                this.paymentSentMessageStateProperty.set((Object)MessageState.UNDEFINED);
            }
            if (selectedItem != null) {
                this.trade = selectedItem.getTrade();
                this.tradeStateSubscription = EasyBind.subscribe((ObservableValue)this.trade.stateProperty(), state -> this.onTradeStateChanged((Trade.State)state));
                this.paymentAccountDecryptedSubscription = EasyBind.subscribe((ObservableValue)this.trade.getProcessModel().getPaymentAccountDecryptedProperty(), decrypted -> this.refresh());
                this.payoutStateSubscription = EasyBind.subscribe((ObservableValue)this.trade.payoutStateProperty(), state -> this.onPayoutStateChanged((Trade.PayoutState)state));
                this.messageStateSubscription = EasyBind.subscribe((ObservableValue)this.trade.getSeller().getPaymentSentMessageStateProperty(), this::onPaymentSentMessageStateChanged);
            }
        }
    }

    private void refresh() {
        UserThread.execute(() -> {
            this.sellerState.set((Object)SellerState.UNDEFINED);
            this.buyerState.set((Object)BuyerState.UNDEFINED);
            this.onTradeStateChanged(this.trade.getState());
            if (this.trade.isPayoutPublished()) {
                this.onPayoutStateChanged(this.trade.getPayoutState());
            } else {
                this.onTradeStateChanged(this.trade.getState());
            }
        });
    }

    private void onPaymentSentMessageStateChanged(MessageState messageState) {
        this.paymentSentMessageStateProperty.set((Object)messageState);
    }

    ReadOnlyObjectProperty<BuyerState> getBuyerState() {
        return this.buyerState;
    }

    ReadOnlyObjectProperty<SellerState> getSellerState() {
        return this.sellerState;
    }

    public String getPayoutAmountBeforeCost() {
        return ((PendingTradesDataModel)this.dataModel).getTrade() != null ? HavenoUtils.formatXmr((BigInteger)((PendingTradesDataModel)this.dataModel).getTrade().getPayoutAmountBeforeCost(), (boolean)true) : "";
    }

    String getMarketLabel(PendingTradesListItem item) {
        return item == null ? "" : this.tradeUtil.getMarketDescription(item.getTrade());
    }

    public String getRemainingTradeDurationAsWords() {
        Preconditions.checkNotNull((Object)((PendingTradesDataModel)this.dataModel).getTrade(), (Object)"model's trade must not be null");
        return this.tradeUtil.getRemainingTradeDurationAsWords(((PendingTradesDataModel)this.dataModel).getTrade());
    }

    public double getRemainingTradeDurationAsPercentage() {
        Preconditions.checkNotNull((Object)((PendingTradesDataModel)this.dataModel).getTrade(), (Object)"model's trade must not be null");
        return this.tradeUtil.getRemainingTradeDurationAsPercentage(((PendingTradesDataModel)this.dataModel).getTrade());
    }

    public String getDateForOpenDispute() {
        Preconditions.checkNotNull((Object)((PendingTradesDataModel)this.dataModel).getTrade(), (Object)"model's trade must not be null");
        return DisplayUtils.formatDateTime(this.tradeUtil.getDateForOpenDispute(((PendingTradesDataModel)this.dataModel).getTrade()));
    }

    public boolean showWarning() {
        Preconditions.checkNotNull((Object)((PendingTradesDataModel)this.dataModel).getTrade(), (Object)"model's trade must not be null");
        Date halfTradePeriodDate = this.tradeUtil.getHalfTradePeriodDate(((PendingTradesDataModel)this.dataModel).getTrade());
        return halfTradePeriodDate != null && new Date().after(halfTradePeriodDate);
    }

    public boolean showDispute() {
        return this.getMaxTradePeriodDate() != null && new Date().after(this.getMaxTradePeriodDate());
    }

    public boolean getShowPaymentDetailsEarly() {
        return this.showPaymentDetailsEarly.getOrDefault(((PendingTradesDataModel)this.dataModel).getTrade().getId(), false);
    }

    public void setShowPaymentDetailsEarly(boolean show) {
        this.showPaymentDetailsEarly.put(((PendingTradesDataModel)this.dataModel).getTrade().getId(), show);
    }

    String getMyRole(PendingTradesListItem item) {
        return TradeUtil.getRole((Trade)item.getTrade());
    }

    String getPaymentMethod(PendingTradesListItem item) {
        return item == null ? "" : this.tradeUtil.getPaymentMethodNameWithCountryCode(item.getTrade());
    }

    public String getTradeVolume() {
        return ((PendingTradesDataModel)this.dataModel).getTrade() != null ? HavenoUtils.formatXmr((BigInteger)((PendingTradesDataModel)this.dataModel).getTrade().getAmount(), (boolean)true) : "";
    }

    public String getFiatVolume() {
        return ((PendingTradesDataModel)this.dataModel).getTrade() != null ? VolumeUtil.formatVolumeWithCode((Volume)((PendingTradesDataModel)this.dataModel).getTrade().getVolume()) : "";
    }

    public String getTradeFee() {
        if (this.trade != null && ((PendingTradesDataModel)this.dataModel).getOffer() != null && this.trade.getAmount() != null) {
            Preconditions.checkNotNull((Object)((PendingTradesDataModel)this.dataModel).getTrade());
            BigInteger tradeFeeInXmr = ((PendingTradesDataModel)this.dataModel).getTradeFee();
            String percentage = GUIUtil.getPercentageOfTradeAmount(tradeFeeInXmr, this.trade.getAmount());
            return HavenoUtils.formatXmr((BigInteger)tradeFeeInXmr, (boolean)true) + percentage;
        }
        return "";
    }

    public String getSecurityDeposit() {
        Offer offer = ((PendingTradesDataModel)this.dataModel).getOffer();
        Trade trade = ((PendingTradesDataModel)this.dataModel).getTrade();
        if (offer != null && trade != null && trade.getAmount() != null) {
            BigInteger securityDeposit = ((PendingTradesDataModel)this.dataModel).isBuyer() ? offer.getMaxBuyerSecurityDeposit() : offer.getMaxSellerSecurityDeposit();
            String percentage = GUIUtil.getPercentageOfTradeAmount(securityDeposit, trade.getAmount());
            return HavenoUtils.formatXmr((BigInteger)securityDeposit, (boolean)true) + percentage;
        }
        return "";
    }

    public boolean isBlockChainMethod() {
        return this.offerUtil.isBlockChainPaymentMethod(((PendingTradesDataModel)this.dataModel).getOffer());
    }

    public int getNumPastTrades(Trade trade) {
        return this.closedTradableManager.getObservableList().stream().filter(e -> {
            if (e instanceof Trade) {
                Trade t = (Trade)e;
                return t.getTradePeerNodeAddress() != null && trade.getTradePeerNodeAddress() != null && t.getTradePeerNodeAddress().getFullAddress().equals(trade.getTradePeerNodeAddress().getFullAddress());
            }
            return false;
        }).collect(Collectors.toSet()).size();
    }

    @Nullable
    private Date getMaxTradePeriodDate() {
        return ((PendingTradesDataModel)this.dataModel).getTrade() != null ? ((PendingTradesDataModel)this.dataModel).getTrade().getMaxTradePeriodDate() : null;
    }

    private void onTradeStateChanged(Trade.State tradeState) {
        this.log.debug("UI tradeState={}, id={}", (Object)tradeState, (Object)(this.trade != null ? this.trade.getShortId() : "trade is null"));
        if (this.trade.isArbitrator()) {
            this.buyerState.set((Object)BuyerState.STEP1);
            this.sellerState.set((Object)SellerState.STEP1);
            return;
        }
        if (this.trade.isCompleted()) {
            this.sellerState.set((Object)SellerState.UNDEFINED);
            this.buyerState.set((Object)BuyerState.UNDEFINED);
            return;
        }
        switch (tradeState) {
            case PREPARATION: 
            case MULTISIG_PREPARED: 
            case MULTISIG_MADE: 
            case MULTISIG_EXCHANGED: 
            case MULTISIG_COMPLETED: 
            case CONTRACT_SIGNATURE_REQUESTED: 
            case CONTRACT_SIGNED: 
            case SENT_PUBLISH_DEPOSIT_TX_REQUEST: 
            case SEND_FAILED_PUBLISH_DEPOSIT_TX_REQUEST: 
            case SAW_ARRIVED_PUBLISH_DEPOSIT_TX_REQUEST: {
                this.buyerState.set((Object)BuyerState.UNDEFINED);
                this.sellerState.set((Object)SellerState.UNDEFINED);
                break;
            }
            case ARBITRATOR_PUBLISHED_DEPOSIT_TXS: 
            case DEPOSIT_TXS_SEEN_IN_NETWORK: 
            case DEPOSIT_TXS_CONFIRMED_IN_BLOCKCHAIN: {
                this.buyerState.set((Object)BuyerState.STEP1);
                this.sellerState.set((Object)SellerState.STEP1);
                break;
            }
            case DEPOSIT_TXS_UNLOCKED_IN_BLOCKCHAIN: 
            case DEPOSIT_TXS_FINALIZED_IN_BLOCKCHAIN: {
                this.buyerState.set((Object)BuyerState.STEP2);
                this.sellerState.set((Object)SellerState.STEP2);
                break;
            }
            case BUYER_CONFIRMED_PAYMENT_SENT: 
            case BUYER_SENT_PAYMENT_SENT_MSG: 
            case BUYER_SAW_ARRIVED_PAYMENT_SENT_MSG: {
                this.buyerState.set((Object)BuyerState.STEP2);
                this.sellerState.set((Object)(this.trade.isPayoutPublished() ? SellerState.STEP4 : SellerState.STEP3));
                break;
            }
            case BUYER_STORED_IN_MAILBOX_PAYMENT_SENT_MSG: 
            case SELLER_RECEIVED_PAYMENT_SENT_MSG: {
                this.buyerState.set((Object)BuyerState.STEP3);
                break;
            }
            case BUYER_SEND_FAILED_PAYMENT_SENT_MSG: {
                this.buyerState.set((Object)BuyerState.STEP2);
                break;
            }
            case SELLER_CONFIRMED_PAYMENT_RECEIPT: {
                if (this.trade.isBuyer()) {
                    this.buyerState.set((Object)BuyerState.STEP3);
                    break;
                }
                if (!this.trade.isSeller()) break;
                this.sellerState.set((Object)(this.trade.isPayoutPublished() ? SellerState.STEP4 : SellerState.STEP3));
                break;
            }
            case SELLER_SENT_PAYMENT_RECEIVED_MSG: {
                if (this.trade.isBuyer()) {
                    this.buyerState.set((Object)BuyerState.UNDEFINED);
                    this.buyerState.set((Object)BuyerState.STEP4);
                    break;
                }
                if (!this.trade.isSeller()) break;
                this.sellerState.set((Object)(this.trade.isPayoutPublished() ? SellerState.STEP4 : SellerState.STEP3));
                break;
            }
            case SELLER_SEND_FAILED_PAYMENT_RECEIVED_MSG: 
            case SELLER_STORED_IN_MAILBOX_PAYMENT_RECEIVED_MSG: 
            case SELLER_SAW_ARRIVED_PAYMENT_RECEIVED_MSG: 
            case BUYER_RECEIVED_PAYMENT_RECEIVED_MSG: {
                this.sellerState.set((Object)(this.trade.isPayoutPublished() ? SellerState.STEP4 : SellerState.STEP3));
                break;
            }
            default: {
                this.sellerState.set((Object)SellerState.UNDEFINED);
                this.buyerState.set((Object)BuyerState.UNDEFINED);
                this.log.warn("unhandled processState " + String.valueOf(tradeState));
                DevEnv.logErrorAndThrowIfDevMode((String)("unhandled processState " + String.valueOf(tradeState)));
            }
        }
    }

    private void onPayoutStateChanged(Trade.PayoutState payoutState) {
        this.log.debug("UI payoutState={}, id={}", (Object)payoutState, (Object)(this.trade != null ? this.trade.getShortId() : "trade is null"));
        if (this.trade.isArbitrator()) {
            return;
        }
        switch (payoutState) {
            case PAYOUT_PUBLISHED: 
            case PAYOUT_CONFIRMED: 
            case PAYOUT_UNLOCKED: 
            case PAYOUT_FINALIZED: {
                this.sellerState.set((Object)SellerState.STEP4);
                this.buyerState.set((Object)BuyerState.STEP4);
                break;
            }
        }
    }

    @Nullable
    public Trade getTrade() {
        return this.trade;
    }

    public Navigation getNavigation() {
        return this.navigation;
    }

    public User getUser() {
        return this.user;
    }

    public ObjectProperty<MessageState> getPaymentSentMessageStateProperty() {
        return this.paymentSentMessageStateProperty;
    }

    public IntegerProperty getMempoolStatus() {
        return this.mempoolStatus;
    }

    static enum SellerState implements State
    {
        UNDEFINED,
        STEP1,
        STEP2,
        STEP3,
        STEP4;

    }

    static enum BuyerState implements State
    {
        UNDEFINED,
        STEP1,
        STEP2,
        STEP3,
        STEP4;

    }

    static interface State {
    }
}

