/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.portfolio.pendingtrades;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.jfoenix.controls.JFXBadge;
import com.jfoenix.controls.JFXButton;
import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.materialdesignicons.MaterialDesignIcon;
import haveno.common.UserThread;
import haveno.common.crypto.KeyRing;
import haveno.common.util.Utilities;
import haveno.core.alert.PrivateNotificationManager;
import haveno.core.locale.Res;
import haveno.core.monetary.Price;
import haveno.core.monetary.Volume;
import haveno.core.offer.OfferPayload;
import haveno.core.support.SupportManager;
import haveno.core.support.SupportSession;
import haveno.core.support.dispute.mediation.MediationResultState;
import haveno.core.support.messages.ChatMessage;
import haveno.core.support.traderchat.TradeChatSession;
import haveno.core.support.traderchat.TraderChatManager;
import haveno.core.trade.Contract;
import haveno.core.trade.HavenoUtils;
import haveno.core.trade.Trade;
import haveno.core.user.Preferences;
import haveno.core.util.FormattingUtils;
import haveno.core.util.VolumeUtil;
import haveno.core.util.coin.CoinFormatter;
import haveno.desktop.Navigation;
import haveno.desktop.common.view.ActivatableViewAndModel;
import haveno.desktop.common.view.FxmlView;
import haveno.desktop.components.AutoTooltipLabel;
import haveno.desktop.components.HyperlinkWithIcon;
import haveno.desktop.components.PeerInfoIconTrading;
import haveno.desktop.components.list.FilterBox;
import haveno.desktop.main.MainView;
import haveno.desktop.main.overlays.popups.Popup;
import haveno.desktop.main.overlays.windows.TradeDetailsWindow;
import haveno.desktop.main.portfolio.pendingtrades.BuyerSubView;
import haveno.desktop.main.portfolio.pendingtrades.PendingTradesDataModel;
import haveno.desktop.main.portfolio.pendingtrades.PendingTradesListItem;
import haveno.desktop.main.portfolio.pendingtrades.PendingTradesViewModel;
import haveno.desktop.main.portfolio.pendingtrades.SellerSubView;
import haveno.desktop.main.portfolio.pendingtrades.TradeSubView;
import haveno.desktop.main.portfolio.presentation.PortfolioUtil;
import haveno.desktop.main.shared.ChatView;
import haveno.desktop.util.CssTheme;
import haveno.desktop.util.DisplayUtils;
import haveno.desktop.util.FormBuilder;
import haveno.desktop.util.GUIUtil;
import haveno.network.p2p.NodeAddress;
import java.math.BigInteger;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableObjectValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.util.Callback;
import org.fxmisc.easybind.EasyBind;
import org.fxmisc.easybind.Subscription;

@FxmlView
public class PendingTradesView
extends ActivatableViewAndModel<VBox, PendingTradesViewModel> {
    private final TradeDetailsWindow tradeDetailsWindow;
    private final Navigation navigation;
    private final KeyRing keyRing;
    private final CoinFormatter formatter;
    private final PrivateNotificationManager privateNotificationManager;
    private final boolean useDevPrivilegeKeys;
    private final boolean useDevModeHeader;
    private final Preferences preferences;
    @FXML
    FilterBox filterBox;
    @FXML
    TableView<PendingTradesListItem> tableView;
    @FXML
    TableColumn<PendingTradesListItem, PendingTradesListItem> priceColumn;
    @FXML
    TableColumn<PendingTradesListItem, PendingTradesListItem> volumeColumn;
    @FXML
    TableColumn<PendingTradesListItem, PendingTradesListItem> amountColumn;
    @FXML
    TableColumn<PendingTradesListItem, PendingTradesListItem> avatarColumn;
    @FXML
    TableColumn<PendingTradesListItem, PendingTradesListItem> marketColumn;
    @FXML
    TableColumn<PendingTradesListItem, PendingTradesListItem> roleColumn;
    @FXML
    TableColumn<PendingTradesListItem, PendingTradesListItem> paymentMethodColumn;
    @FXML
    TableColumn<PendingTradesListItem, PendingTradesListItem> tradeIdColumn;
    @FXML
    TableColumn<PendingTradesListItem, PendingTradesListItem> dateColumn;
    @FXML
    TableColumn<PendingTradesListItem, PendingTradesListItem> chatColumn;
    @FXML
    TableColumn<PendingTradesListItem, PendingTradesListItem> moveTradeToFailedColumn;
    @FXML
    ScrollPane scrollView;
    private FilteredList<PendingTradesListItem> filteredList;
    private SortedList<PendingTradesListItem> sortedList;
    private TradeSubView selectedSubView;
    private EventHandler<KeyEvent> keyEventEventHandler;
    private Scene scene;
    private Subscription selectedTableItemSubscription;
    private Subscription selectedItemSubscription;
    private Stage chatPopupStage;
    private ListChangeListener<PendingTradesListItem> tradesListChangeListener;
    private final Map<String, Long> newChatMessagesByTradeMap = new HashMap<String, Long>();
    private String tradeIdOfOpenChat;
    private double chatPopupStageXPosition = -1.0;
    private double chatPopupStageYPosition = -1.0;
    private ChangeListener<Number> xPositionListener;
    private ChangeListener<Number> yPositionListener;
    private final Map<String, Button> buttonByTrade = new HashMap<String, Button>();
    private final Map<String, JFXBadge> badgeByTrade = new HashMap<String, JFXBadge>();
    private final Map<String, ListChangeListener<ChatMessage>> listenerByTrade = new HashMap<String, ListChangeListener<ChatMessage>>();
    private ChangeListener<Trade.State> tradeStateListener;
    private ChangeListener<Trade.DisputeState> disputeStateListener;
    private ChangeListener<MediationResultState> mediationResultStateListener;
    private ChangeListener<Number> getMempoolStatusListener;

    @Inject
    public PendingTradesView(PendingTradesViewModel model, TradeDetailsWindow tradeDetailsWindow, Navigation navigation, KeyRing keyRing, @Named(value="BTC") CoinFormatter formatter, PrivateNotificationManager privateNotificationManager, Preferences preferences, @Named(value="useDevPrivilegeKeys") boolean useDevPrivilegeKeys, @Named(value="useDevModeHeader") boolean useDevModeHeader) {
        super(model);
        this.tradeDetailsWindow = tradeDetailsWindow;
        this.navigation = navigation;
        this.keyRing = keyRing;
        this.formatter = formatter;
        this.privateNotificationManager = privateNotificationManager;
        this.preferences = preferences;
        this.useDevPrivilegeKeys = useDevPrivilegeKeys;
        this.useDevModeHeader = useDevModeHeader;
    }

    @Override
    public void initialize() {
        GUIUtil.applyTableStyle(this.tableView);
        this.priceColumn.setGraphic((Node)new AutoTooltipLabel(Res.get((String)"shared.price")));
        this.amountColumn.setGraphic((Node)new AutoTooltipLabel(Res.get((String)"shared.amountWithCur", (Object[])new Object[]{Res.getBaseCurrencyCode()})));
        this.volumeColumn.setGraphic((Node)new AutoTooltipLabel(Res.get((String)"shared.amount")));
        this.marketColumn.setGraphic((Node)new AutoTooltipLabel(Res.get((String)"shared.market")));
        this.roleColumn.setGraphic((Node)new AutoTooltipLabel(Res.get((String)"portfolio.pending.role")));
        this.dateColumn.setGraphic((Node)new AutoTooltipLabel(Res.get((String)"shared.dateTime")));
        this.tradeIdColumn.setGraphic((Node)new AutoTooltipLabel(Res.get((String)"shared.tradeId")));
        this.paymentMethodColumn.setGraphic((Node)new AutoTooltipLabel(Res.get((String)"shared.paymentMethod")));
        this.avatarColumn.setText("");
        this.chatColumn.setText("");
        this.moveTradeToFailedColumn.setText("");
        this.setTradeIdColumnCellFactory();
        this.setDateColumnCellFactory();
        this.setAmountColumnCellFactory();
        this.setPriceColumnCellFactory();
        this.setVolumeColumnCellFactory();
        this.setPaymentMethodColumnCellFactory();
        this.setMarketColumnCellFactory();
        this.setRoleColumnCellFactory();
        this.setAvatarColumnCellFactory();
        this.setChatColumnCellFactory();
        this.setRemoveTradeColumnCellFactory();
        this.tableView.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        this.tableView.setPlaceholder((Node)new AutoTooltipLabel(Res.get((String)"table.placeholder.noItems", (Object[])new Object[]{Res.get((String)"shared.openTrades")})));
        this.tableView.setMinHeight(100.0);
        this.tradeIdColumn.setComparator(Comparator.comparing(o -> o.getTrade().getId()));
        this.dateColumn.setComparator(Comparator.comparing(o -> o.getTrade().getDate()));
        this.volumeColumn.setComparator(Comparator.comparing(o -> o.getTrade().getVolume(), Comparator.nullsFirst(Comparator.naturalOrder())));
        this.amountColumn.setComparator(Comparator.comparing(o -> o.getTrade().getAmount(), Comparator.nullsFirst(Comparator.naturalOrder())));
        this.priceColumn.setComparator(Comparator.comparing(PendingTradesListItem::getPrice));
        this.paymentMethodColumn.setComparator(Comparator.comparing(item -> item.getTrade().getOffer() != null ? Res.get((String)item.getTrade().getOffer().getPaymentMethod().getId()) : null, Comparator.nullsFirst(Comparator.naturalOrder())));
        this.marketColumn.setComparator(Comparator.comparing(PendingTradesListItem::getMarketDescription));
        this.roleColumn.setComparator(Comparator.comparing(((PendingTradesViewModel)this.model)::getMyRole));
        this.avatarColumn.setComparator(Comparator.comparing(o -> ((PendingTradesViewModel)this.model).getNumPastTrades(o.getTrade()), Comparator.nullsFirst(Comparator.naturalOrder())));
        this.dateColumn.setSortType(TableColumn.SortType.DESCENDING);
        this.tableView.getSortOrder().add(this.dateColumn);
        this.tableView.setRowFactory(tableView -> {
            TableRow row = new TableRow();
            ContextMenu rowMenu = new ContextMenu();
            MenuItem duplicateItem = new MenuItem(Res.get((String)"portfolio.context.offerLikeThis"));
            duplicateItem.setOnAction(event -> {
                try {
                    OfferPayload offerPayload = ((PendingTradesListItem)row.getItem()).getTrade().getOffer().getOfferPayload();
                    if (offerPayload.getPubKeyRing().equals((Object)this.keyRing.getPubKeyRing())) {
                        PortfolioUtil.duplicateOffer(this.navigation, offerPayload);
                    } else {
                        ((Popup)new Popup().warning(Res.get((String)"portfolio.context.notYourOffer"))).show();
                    }
                }
                catch (NullPointerException e) {
                    this.log.warn("Unable to get offerPayload - {}", (Object)e.toString());
                }
            });
            MenuItem moveToFailedItem = new MenuItem(Res.get((String)"portfolio.pending.failedTrade.moveTradeToFailedIcon.tooltip"));
            moveToFailedItem.setOnAction(event -> {
                if (this.isMaybeInvalidTrade(((PendingTradesListItem)row.getItem()).getTrade())) {
                    this.onMoveInvalidTradeToFailedTrades(((PendingTradesListItem)row.getItem()).getTrade());
                } else {
                    ((PendingTradesDataModel)((PendingTradesViewModel)this.model).dataModel).tradeManager.onMoveInvalidTradeToFailedTrades(((PendingTradesListItem)row.getItem()).getTrade());
                }
            });
            rowMenu.getItems().addAll((Object[])new MenuItem[]{duplicateItem, moveToFailedItem});
            row.contextMenuProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)Bindings.isNotNull((ObservableObjectValue)row.itemProperty())).then((Object)rowMenu).otherwise((Object)null));
            return row;
        });
        this.keyEventEventHandler = keyEvent -> {
            if (Utilities.isAltOrCtrlPressed((KeyCode)KeyCode.O, (KeyEvent)keyEvent)) {
                Popup popup = new Popup();
                ((Popup)((Popup)((Popup)((Popup)((Popup)((Popup)popup.headLine(Res.get((String)"portfolio.pending.openSupportTicket.headline"))).message(Res.get((String)"portfolio.pending.openSupportTicket.msg"))).actionButtonText(Res.get((String)"portfolio.pending.openSupportTicket.headline"))).onAction(((PendingTradesDataModel)((PendingTradesViewModel)this.model).dataModel)::onOpenSupportTicket)).closeButtonText(Res.get((String)"shared.cancel"))).onClose(popup::hide)).show();
            }
        };
        this.tradesListChangeListener = c -> this.onListChanged();
        this.getMempoolStatusListener = (observable, oldValue, newValue) -> {
            if (newValue.longValue() >= 0L) {
                this.log.info("Taker fee validation returned {}", (Object)newValue.longValue());
            }
        };
    }

    @Override
    protected void activate() {
        ObservableList<PendingTradesListItem> list = ((PendingTradesDataModel)((PendingTradesViewModel)this.model).dataModel).list;
        this.filteredList = new FilteredList(list);
        this.sortedList = new SortedList(this.filteredList);
        this.sortedList.comparatorProperty().bind((ObservableValue)this.tableView.comparatorProperty());
        this.tableView.setItems(this.sortedList);
        this.tableView.setPrefHeight(100.0);
        this.tableView.setMinHeight((double)this.getMinTableViewHeight());
        this.tableView.setMaxHeight(200.0);
        this.filterBox.initialize(this.filteredList, this.tableView);
        this.filterBox.setPromptText(Res.get((String)"shared.filter"));
        this.filterBox.activate();
        this.updateMoveTradeToFailedColumnState();
        this.scene = ((VBox)this.root).getScene();
        if (this.scene != null) {
            this.scene.addEventHandler(KeyEvent.KEY_RELEASED, this.keyEventEventHandler);
        }
        this.sortedList.addListener(change -> this.tableView.setMinHeight((double)this.getMinTableViewHeight()));
        this.selectedItemSubscription = EasyBind.subscribe(((PendingTradesDataModel)((PendingTradesViewModel)this.model).dataModel).selectedItemProperty, selectedItem -> {
            if (selectedItem != null) {
                if (this.selectedSubView != null) {
                    this.selectedSubView.deactivate();
                }
                if (selectedItem.getTrade() != null) {
                    TradeSubView tradeSubView = this.selectedSubView = ((PendingTradesDataModel)((PendingTradesViewModel)this.model).dataModel).tradeManager.isBuyer(((PendingTradesDataModel)((PendingTradesViewModel)this.model).dataModel).getOffer()) ? new BuyerSubView((PendingTradesViewModel)this.model) : new SellerSubView((PendingTradesViewModel)this.model);
                    if (((VBox)this.root).getChildren().size() == 2) {
                        ((VBox)this.root).getChildren().add((Object)this.scrollView);
                    } else if (((VBox)this.root).getChildren().size() == 3) {
                        ((VBox)this.root).getChildren().set(2, (Object)this.scrollView);
                    }
                    this.scrollView.setContent((Node)this.selectedSubView);
                    ChatCallback chatCallback = this::openChat;
                    this.selectedSubView.setChatCallback(chatCallback);
                }
                this.updateTableSelection();
            } else {
                this.removeSelectedSubView();
            }
            ((PendingTradesViewModel)this.model).onSelectedItemChanged((PendingTradesListItem)selectedItem);
            if (this.selectedSubView != null && selectedItem != null) {
                this.selectedSubView.activate();
            }
        });
        this.selectedTableItemSubscription = EasyBind.subscribe((ObservableValue)this.tableView.getSelectionModel().selectedItemProperty(), selectedItem -> {
            if (selectedItem != null && !selectedItem.equals(((PendingTradesDataModel)((PendingTradesViewModel)this.model).dataModel).selectedItemProperty.get())) {
                if (this.selectedSubView != null) {
                    this.selectedSubView.deactivate();
                }
                ((PendingTradesDataModel)((PendingTradesViewModel)this.model).dataModel).onSelectItem((PendingTradesListItem)selectedItem);
            }
        });
        this.updateTableSelection();
        list.addListener(this.tradesListChangeListener);
        this.updateNewChatMessagesByTradeMap();
        ((PendingTradesViewModel)this.model).getMempoolStatus().addListener(this.getMempoolStatusListener);
    }

    private int getMinTableViewHeight() {
        return this.sortedList.size() <= 1 ? 100 : 130;
    }

    @Override
    protected void deactivate() {
        this.filterBox.deactivate();
        this.sortedList.comparatorProperty().unbind();
        this.selectedItemSubscription.unsubscribe();
        this.selectedTableItemSubscription.unsubscribe();
        this.removeSelectedSubView();
        ((PendingTradesDataModel)((PendingTradesViewModel)this.model).dataModel).list.removeListener(this.tradesListChangeListener);
        ((PendingTradesViewModel)this.model).getMempoolStatus().removeListener(this.getMempoolStatusListener);
        if (this.scene != null) {
            this.scene.removeEventHandler(KeyEvent.KEY_RELEASED, this.keyEventEventHandler);
        }
    }

    private void removeSelectedSubView() {
        if (this.selectedSubView != null) {
            this.selectedSubView.deactivate();
            ((VBox)this.root).getChildren().remove((Object)this.selectedSubView);
            this.selectedSubView = null;
        }
    }

    private void updateMoveTradeToFailedColumnState() {
        UserThread.execute(() -> {
            ObservableList<PendingTradesListItem> observableList = ((PendingTradesDataModel)((PendingTradesViewModel)this.model).dataModel).list;
            synchronized (observableList) {
                this.moveTradeToFailedColumn.setVisible(((PendingTradesDataModel)((PendingTradesViewModel)this.model).dataModel).list.stream().anyMatch(item -> this.isMaybeInvalidTrade(item.getTrade())));
            }
        });
    }

    private boolean isMaybeInvalidTrade(Trade trade) {
        return trade.hasErrorMessage() || Trade.Phase.DEPOSITS_PUBLISHED.ordinal() <= trade.getPhase().ordinal() && trade.isTxChainInvalid();
    }

    private void onMoveInvalidTradeToFailedTrades(Trade trade) {
        String msg = trade.isTxChainInvalid() ? Res.get((String)"portfolio.pending.failedTrade.txChainInvalid.moveToFailed", (Object[])new Object[]{this.getInvalidTradeDetails(trade)}) : Res.get((String)"portfolio.pending.failedTrade.txChainValid.moveToFailed", (Object[])new Object[]{this.getInvalidTradeDetails(trade)});
        ((Popup)((Popup)((Popup)((Popup)((Popup)new Popup().width(900.0)).attention(msg)).onAction(() -> {
            ((PendingTradesDataModel)((PendingTradesViewModel)this.model).dataModel).onMoveInvalidTradeToFailedTrades(trade);
            this.updateMoveTradeToFailedColumnState();
        })).actionButtonText(Res.get((String)"shared.yes"))).closeButtonText(Res.get((String)"shared.no"))).show();
    }

    private void onShowInfoForInvalidTrade(Trade trade) {
        ((Popup)((Popup)new Popup().width(900.0)).attention(Res.get((String)"portfolio.pending.failedTrade.info.popup", (Object[])new Object[]{this.getInvalidTradeDetails(trade)}))).show();
    }

    private String getInvalidTradeDetails(Trade trade) {
        Contract contract = trade.getContract();
        if (contract == null) {
            return Res.get((String)"portfolio.pending.failedTrade.missingContract");
        }
        if (trade.getMakerDepositTx() == null) {
            return Res.get((String)"portfolio.pending.failedTrade.missingDepositTx");
        }
        if (trade.getTakerDepositTx() == null && !trade.hasBuyerAsTakerWithoutDeposit()) {
            return Res.get((String)"portfolio.pending.failedTrade.missingDepositTx");
        }
        if (trade.hasErrorMessage()) {
            return Res.get((String)"portfolio.pending.failedTrade.errorMsgSet", (Object[])new Object[]{trade.getErrorMessage()});
        }
        return Res.get((String)"shared.na");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNewChatMessagesByTradeMap() {
        ObservableList<PendingTradesListItem> observableList = ((PendingTradesDataModel)((PendingTradesViewModel)this.model).dataModel).list;
        synchronized (observableList) {
            ((PendingTradesDataModel)((PendingTradesViewModel)this.model).dataModel).list.forEach(t -> {
                Trade trade = t.getTrade();
                ObservableList observableList = trade.getChatMessages();
                synchronized (observableList) {
                    this.newChatMessagesByTradeMap.put(trade.getId(), trade.getChatMessages().stream().filter(m -> !m.isWasDisplayed()).filter(m -> !m.isSystemMessage()).count());
                }
            });
        }
    }

    private void openChat(Trade trade) {
        if (this.chatPopupStage != null) {
            this.chatPopupStage.close();
        }
        TraderChatManager traderChatManager = ((PendingTradesDataModel)((PendingTradesViewModel)this.model).dataModel).getTraderChatManager();
        if (trade.getChatMessages().isEmpty()) {
            traderChatManager.addSystemMsg(trade);
        }
        trade.getChatMessages().forEach(m -> m.setWasDisplayed(true));
        ((PendingTradesDataModel)((PendingTradesViewModel)this.model).dataModel).getTradeManager().requestPersistence();
        this.tradeIdOfOpenChat = trade.getId();
        ChatView chatView = new ChatView((SupportManager)traderChatManager, Res.get((String)"offerbook.trader"));
        chatView.setAllowAttachments(false);
        chatView.setDisplayHeader(false);
        chatView.initialize();
        AnchorPane pane = new AnchorPane(new Node[]{chatView});
        pane.setPrefSize(760.0, 500.0);
        AnchorPane.setLeftAnchor((Node)chatView, (Double)10.0);
        AnchorPane.setRightAnchor((Node)chatView, (Double)10.0);
        AnchorPane.setTopAnchor((Node)chatView, (Double)-20.0);
        AnchorPane.setBottomAnchor((Node)chatView, (Double)10.0);
        boolean isTaker = !((PendingTradesDataModel)((PendingTradesViewModel)this.model).dataModel).isMaker(trade.getOffer());
        TradeChatSession tradeChatSession = new TradeChatSession(trade, isTaker);
        this.tradeStateListener = (observable, oldValue, newValue) -> UserThread.execute(() -> {
            if (trade.isPayoutPublished() && this.chatPopupStage.isShowing()) {
                this.chatPopupStage.hide();
            }
        });
        trade.stateProperty().addListener(this.tradeStateListener);
        this.disputeStateListener = (observable, oldValue, newValue) -> UserThread.execute(() -> {
            if (newValue == Trade.DisputeState.DISPUTE_CLOSED || newValue == Trade.DisputeState.REFUND_REQUEST_CLOSED) {
                this.chatPopupStage.hide();
            }
        });
        trade.disputeStateProperty().addListener(this.disputeStateListener);
        this.mediationResultStateListener = (observable, oldValue, newValue) -> UserThread.execute(() -> {
            if (newValue == MediationResultState.PAYOUT_TX_PUBLISHED || newValue == MediationResultState.RECEIVED_PAYOUT_TX_PUBLISHED_MSG || newValue == MediationResultState.PAYOUT_TX_SEEN_IN_NETWORK) {
                this.chatPopupStage.hide();
            }
        });
        trade.mediationResultStateProperty().addListener(this.mediationResultStateListener);
        chatView.display((SupportSession)tradeChatSession, pane.widthProperty());
        chatView.activate();
        chatView.scrollToBottom();
        this.chatPopupStage = new Stage();
        this.chatPopupStage.setTitle(Res.get((String)"tradeChat.chatWindowTitle", (Object[])new Object[]{trade.getShortId()}));
        StackPane owner = MainView.getRootContainer();
        Scene rootScene = owner.getScene();
        this.chatPopupStage.initOwner(rootScene.getWindow());
        this.chatPopupStage.initModality(Modality.NONE);
        this.chatPopupStage.initStyle(StageStyle.DECORATED);
        this.chatPopupStage.setOnHiding(event -> {
            chatView.deactivate();
            trade.getChatMessages().forEach(m -> m.setWasDisplayed(true));
            ((PendingTradesDataModel)((PendingTradesViewModel)this.model).dataModel).getTradeManager().requestPersistence();
            this.tradeIdOfOpenChat = null;
            if (this.xPositionListener != null) {
                this.chatPopupStage.xProperty().removeListener(this.xPositionListener);
            }
            if (this.yPositionListener != null) {
                this.chatPopupStage.xProperty().removeListener(this.yPositionListener);
            }
            trade.stateProperty().removeListener(this.tradeStateListener);
            trade.disputeStateProperty().addListener(this.disputeStateListener);
            trade.mediationResultStateProperty().addListener(this.mediationResultStateListener);
            traderChatManager.requestPersistence();
        });
        Scene scene = new Scene((Parent)pane);
        CssTheme.loadSceneStyles(scene, this.preferences.getCssTheme(), this.useDevModeHeader);
        scene.addEventHandler(KeyEvent.KEY_RELEASED, ev -> {
            if (ev.getCode() == KeyCode.ESCAPE) {
                ev.consume();
                this.chatPopupStage.hide();
            }
        });
        this.chatPopupStage.setScene(scene);
        this.chatPopupStage.setOpacity(0.0);
        this.chatPopupStage.show();
        this.xPositionListener = (observable, oldValue, newValue) -> {
            this.chatPopupStageXPosition = (Double)newValue;
        };
        this.chatPopupStage.xProperty().addListener(this.xPositionListener);
        this.yPositionListener = (observable, oldValue, newValue) -> {
            this.chatPopupStageYPosition = (Double)newValue;
        };
        this.chatPopupStage.yProperty().addListener(this.yPositionListener);
        if (this.chatPopupStageXPosition == -1.0) {
            Window rootSceneWindow = rootScene.getWindow();
            double titleBarHeight = rootSceneWindow.getHeight() - rootScene.getHeight();
            this.chatPopupStage.setX((double)Math.round(rootSceneWindow.getX() + (owner.getWidth() - this.chatPopupStage.getWidth() / 4.0 * 3.0)));
            this.chatPopupStage.setY((double)Math.round(rootSceneWindow.getY() + titleBarHeight + (owner.getHeight() - this.chatPopupStage.getHeight() / 4.0 * 3.0)));
        } else {
            this.chatPopupStage.setX(this.chatPopupStageXPosition);
            this.chatPopupStage.setY(this.chatPopupStageYPosition);
        }
        UserThread.execute(() -> this.chatPopupStage.setOpacity(1.0));
        this.updateChatMessageCount(trade, this.badgeByTrade.get(trade.getId()));
    }

    private void updateChatMessageCount(Trade trade, JFXBadge badge) {
        UserThread.execute(() -> {
            if (!trade.getId().equals(this.tradeIdOfOpenChat)) {
                this.updateNewChatMessagesByTradeMap();
                long num = this.newChatMessagesByTradeMap.get(trade.getId());
                if (num > 0L) {
                    badge.setText(String.valueOf(num));
                    badge.setEnabled(true);
                } else {
                    badge.setText("");
                    badge.setEnabled(false);
                }
            } else {
                badge.setText("");
                badge.setEnabled(false);
            }
            badge.refreshBadge();
        });
    }

    private void updateTableSelection() {
        PendingTradesListItem selectedItemFromModel = (PendingTradesListItem)((PendingTradesDataModel)((PendingTradesViewModel)this.model).dataModel).selectedItemProperty.get();
        if (selectedItemFromModel != null) {
            int index = this.tableView.getItems().indexOf((Object)selectedItemFromModel);
            UserThread.execute(() -> this.tableView.getSelectionModel().select(index));
        }
    }

    private void onListChanged() {
        this.updateNewChatMessagesByTradeMap();
        this.updateMoveTradeToFailedColumnState();
    }

    private void setTradeIdColumnCellFactory() {
        this.tradeIdColumn.setCellValueFactory(pendingTradesListItem -> new ReadOnlyObjectWrapper((Object)((PendingTradesListItem)pendingTradesListItem.getValue())));
        this.tradeIdColumn.setCellFactory((Callback)new Callback<TableColumn<PendingTradesListItem, PendingTradesListItem>, TableCell<PendingTradesListItem, PendingTradesListItem>>(){

            public TableCell<PendingTradesListItem, PendingTradesListItem> call(TableColumn<PendingTradesListItem, PendingTradesListItem> column) {
                return new TableCell<PendingTradesListItem, PendingTradesListItem>(){
                    private Trade trade;
                    private ChangeListener<Trade.State> listener;

                    public void updateItem(PendingTradesListItem item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null && !empty) {
                            this.trade = item.getTrade();
                            this.listener = (observable, oldValue, newValue) -> UserThread.execute(() -> this.update());
                            this.trade.stateProperty().addListener(this.listener);
                            this.update();
                        } else {
                            this.setGraphic(null);
                            if (this.trade != null && this.listener != null) {
                                this.trade.stateProperty().removeListener(this.listener);
                                this.trade = null;
                                this.listener = null;
                            }
                        }
                    }

                    private void update() {
                        HyperlinkWithIcon field;
                        if (this.trade == null) {
                            return;
                        }
                        if (PendingTradesView.this.isMaybeInvalidTrade(this.trade)) {
                            field = new HyperlinkWithIcon(this.trade.getShortId());
                            field.setIcon((Node)FormBuilder.getMediumSizeIcon((GlyphIcons)MaterialDesignIcon.ALERT_CIRCLE_OUTLINE));
                            field.setOnAction(event -> PendingTradesView.this.tradeDetailsWindow.show(this.trade));
                            field.setTooltip(new Tooltip(Res.get((String)"tooltip.invalidTradeState.warning")));
                            if (this.trade.isTxChainInvalid()) {
                                field.getIcon().getStyleClass().addAll((Object[])new String[]{"icon", "error-icon"});
                            } else {
                                field.getIcon().getStyleClass().addAll((Object[])new String[]{"icon", "warn-icon"});
                            }
                        } else {
                            field = new HyperlinkWithIcon(this.trade.getShortId());
                            field.setOnAction(event -> PendingTradesView.this.tradeDetailsWindow.show(this.trade));
                            field.setTooltip(new Tooltip(Res.get((String)"tooltip.openPopupForDetails")));
                        }
                        this.setGraphic((Node)field);
                    }
                };
            }
        });
    }

    private void setDateColumnCellFactory() {
        this.dateColumn.setCellValueFactory(trade -> new ReadOnlyObjectWrapper((Object)((PendingTradesListItem)trade.getValue())));
        this.dateColumn.setCellFactory((Callback)new Callback<TableColumn<PendingTradesListItem, PendingTradesListItem>, TableCell<PendingTradesListItem, PendingTradesListItem>>(this){

            public TableCell<PendingTradesListItem, PendingTradesListItem> call(TableColumn<PendingTradesListItem, PendingTradesListItem> column) {
                return new TableCell<PendingTradesListItem, PendingTradesListItem>(this){

                    public void updateItem(PendingTradesListItem item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null && !empty) {
                            this.setGraphic((Node)new AutoTooltipLabel(DisplayUtils.formatDateTime(item.getTrade().getDate())));
                        } else {
                            this.setGraphic(null);
                        }
                    }
                };
            }
        });
    }

    private void setAmountColumnCellFactory() {
        this.amountColumn.setCellValueFactory(trade -> new ReadOnlyObjectWrapper((Object)((PendingTradesListItem)trade.getValue())));
        this.amountColumn.setCellFactory((Callback)new Callback<TableColumn<PendingTradesListItem, PendingTradesListItem>, TableCell<PendingTradesListItem, PendingTradesListItem>>(this){

            public TableCell<PendingTradesListItem, PendingTradesListItem> call(TableColumn<PendingTradesListItem, PendingTradesListItem> column) {
                return new TableCell<PendingTradesListItem, PendingTradesListItem>(this){

                    public void updateItem(PendingTradesListItem item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null && !empty) {
                            this.setGraphic((Node)new AutoTooltipLabel(HavenoUtils.formatXmr((BigInteger)item.getTrade().getAmount())));
                        } else {
                            this.setGraphic(null);
                        }
                    }
                };
            }
        });
    }

    private void setPriceColumnCellFactory() {
        this.priceColumn.setCellValueFactory(trade -> new ReadOnlyObjectWrapper((Object)((PendingTradesListItem)trade.getValue())));
        this.priceColumn.setCellFactory((Callback)new Callback<TableColumn<PendingTradesListItem, PendingTradesListItem>, TableCell<PendingTradesListItem, PendingTradesListItem>>(this){

            public TableCell<PendingTradesListItem, PendingTradesListItem> call(TableColumn<PendingTradesListItem, PendingTradesListItem> column) {
                return new TableCell<PendingTradesListItem, PendingTradesListItem>(this){

                    public void updateItem(PendingTradesListItem item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null && !empty) {
                            this.setGraphic((Node)new AutoTooltipLabel(FormattingUtils.formatPrice((Price)item.getPrice())));
                        } else {
                            this.setGraphic(null);
                        }
                    }
                };
            }
        });
    }

    private void setVolumeColumnCellFactory() {
        this.volumeColumn.setCellValueFactory(trade -> new ReadOnlyObjectWrapper((Object)((PendingTradesListItem)trade.getValue())));
        this.volumeColumn.setCellFactory((Callback)new Callback<TableColumn<PendingTradesListItem, PendingTradesListItem>, TableCell<PendingTradesListItem, PendingTradesListItem>>(){

            public TableCell<PendingTradesListItem, PendingTradesListItem> call(TableColumn<PendingTradesListItem, PendingTradesListItem> column) {
                return new TableCell<PendingTradesListItem, PendingTradesListItem>(){

                    public void updateItem(PendingTradesListItem item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null && !empty) {
                            try {
                                String volume = VolumeUtil.formatVolumeWithCode((Volume)item.getTrade().getVolume());
                                this.setGraphic((Node)new AutoTooltipLabel(volume));
                            }
                            catch (Throwable ignore) {
                                PendingTradesView.this.log.debug(ignore.toString());
                            }
                        } else {
                            this.setGraphic(null);
                        }
                    }
                };
            }
        });
    }

    private void setPaymentMethodColumnCellFactory() {
        this.paymentMethodColumn.setCellValueFactory(trade -> new ReadOnlyObjectWrapper((Object)((PendingTradesListItem)trade.getValue())));
        this.paymentMethodColumn.setCellFactory((Callback)new Callback<TableColumn<PendingTradesListItem, PendingTradesListItem>, TableCell<PendingTradesListItem, PendingTradesListItem>>(this){

            public TableCell<PendingTradesListItem, PendingTradesListItem> call(TableColumn<PendingTradesListItem, PendingTradesListItem> column) {
                return new TableCell<PendingTradesListItem, PendingTradesListItem>(this){

                    public void updateItem(PendingTradesListItem item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null && !empty) {
                            this.setGraphic((Node)new AutoTooltipLabel(item.getPaymentMethod()));
                        } else {
                            this.setGraphic(null);
                        }
                    }
                };
            }
        });
    }

    private void setMarketColumnCellFactory() {
        this.marketColumn.setCellValueFactory(trade -> new ReadOnlyObjectWrapper((Object)((PendingTradesListItem)trade.getValue())));
        this.marketColumn.setCellFactory((Callback)new Callback<TableColumn<PendingTradesListItem, PendingTradesListItem>, TableCell<PendingTradesListItem, PendingTradesListItem>>(this){

            public TableCell<PendingTradesListItem, PendingTradesListItem> call(TableColumn<PendingTradesListItem, PendingTradesListItem> column) {
                return new TableCell<PendingTradesListItem, PendingTradesListItem>(this){

                    public void updateItem(PendingTradesListItem item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null && !empty) {
                            this.setGraphic((Node)new AutoTooltipLabel(item.getMarketDescription()));
                        } else {
                            this.setGraphic(null);
                        }
                    }
                };
            }
        });
    }

    private void setRoleColumnCellFactory() {
        this.roleColumn.setCellValueFactory(trade -> new ReadOnlyObjectWrapper((Object)((PendingTradesListItem)trade.getValue())));
        this.roleColumn.setCellFactory((Callback)new Callback<TableColumn<PendingTradesListItem, PendingTradesListItem>, TableCell<PendingTradesListItem, PendingTradesListItem>>(){

            public TableCell<PendingTradesListItem, PendingTradesListItem> call(TableColumn<PendingTradesListItem, PendingTradesListItem> column) {
                return new TableCell<PendingTradesListItem, PendingTradesListItem>(){

                    public void updateItem(PendingTradesListItem item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null && !empty) {
                            this.setGraphic((Node)new AutoTooltipLabel(((PendingTradesViewModel)PendingTradesView.this.model).getMyRole(item)));
                        } else {
                            this.setGraphic(null);
                        }
                    }
                };
            }
        });
    }

    private TableColumn<PendingTradesListItem, PendingTradesListItem> setAvatarColumnCellFactory() {
        this.avatarColumn.setCellValueFactory(trade -> new ReadOnlyObjectWrapper((Object)((PendingTradesListItem)trade.getValue())));
        this.avatarColumn.getStyleClass().add((Object)"avatar-column");
        this.avatarColumn.setCellFactory((Callback)new Callback<TableColumn<PendingTradesListItem, PendingTradesListItem>, TableCell<PendingTradesListItem, PendingTradesListItem>>(){

            public TableCell<PendingTradesListItem, PendingTradesListItem> call(TableColumn<PendingTradesListItem, PendingTradesListItem> column) {
                return new TableCell<PendingTradesListItem, PendingTradesListItem>(){

                    public void updateItem(PendingTradesListItem newItem, boolean empty) {
                        super.updateItem((Object)newItem, empty);
                        if (!empty && newItem != null) {
                            Trade trade = newItem.getTrade();
                            NodeAddress tradePeerNodeAddress = trade.getTradePeerNodeAddress();
                            int numPastTrades = ((PendingTradesViewModel)PendingTradesView.this.model).getNumPastTrades(trade);
                            String role = Res.get((String)"peerInfoIcon.tooltip.tradePeer");
                            PeerInfoIconTrading peerInfoIcon = new PeerInfoIconTrading(tradePeerNodeAddress, role, numPastTrades, PendingTradesView.this.privateNotificationManager, trade, PendingTradesView.this.preferences, ((PendingTradesViewModel)((PendingTradesView)PendingTradesView.this).model).accountAgeWitnessService, PendingTradesView.this.useDevPrivilegeKeys);
                            this.setPadding(new Insets(1.0, 0.0, 0.0, 0.0));
                            this.setGraphic((Node)peerInfoIcon);
                        } else {
                            this.setGraphic(null);
                        }
                    }
                };
            }
        });
        return this.avatarColumn;
    }

    private TableColumn<PendingTradesListItem, PendingTradesListItem> setChatColumnCellFactory() {
        this.chatColumn.setCellValueFactory(trade -> new ReadOnlyObjectWrapper((Object)((PendingTradesListItem)trade.getValue())));
        this.chatColumn.getStyleClass().addAll((Object[])new String[]{"avatar-column"});
        this.chatColumn.setSortable(false);
        this.chatColumn.setCellFactory((Callback)new Callback<TableColumn<PendingTradesListItem, PendingTradesListItem>, TableCell<PendingTradesListItem, PendingTradesListItem>>(){

            public TableCell<PendingTradesListItem, PendingTradesListItem> call(TableColumn<PendingTradesListItem, PendingTradesListItem> column) {
                return new TableCell<PendingTradesListItem, PendingTradesListItem>(){

                    public void updateItem(PendingTradesListItem newItem, boolean empty) {
                        super.updateItem((Object)newItem, empty);
                        if (!empty && newItem != null) {
                            JFXBadge badge;
                            Button button;
                            Trade trade = newItem.getTrade();
                            String id = trade.getId();
                            if (!PendingTradesView.this.buttonByTrade.containsKey(id)) {
                                button = FormBuilder.getIconButton((GlyphIcons)MaterialDesignIcon.COMMENT_MULTIPLE_OUTLINE);
                                PendingTradesView.this.buttonByTrade.put(id, button);
                                button.setTooltip(new Tooltip(Res.get((String)"tradeChat.openChat")));
                            } else {
                                button = PendingTradesView.this.buttonByTrade.get(id);
                            }
                            if (!PendingTradesView.this.badgeByTrade.containsKey(id)) {
                                badge = new JFXBadge((Node)button);
                                PendingTradesView.this.badgeByTrade.put(id, badge);
                                badge.setPosition(Pos.TOP_RIGHT);
                            } else {
                                badge = PendingTradesView.this.badgeByTrade.get(id);
                            }
                            button.setOnAction(e -> {
                                PendingTradesView.this.tableView.getSelectionModel().select(this.getIndex());
                                PendingTradesView.this.openChat(trade);
                            });
                            if (!PendingTradesView.this.listenerByTrade.containsKey(id)) {
                                ListChangeListener listener = c -> PendingTradesView.this.updateChatMessageCount(trade, badge);
                                PendingTradesView.this.listenerByTrade.put(id, (ListChangeListener<ChatMessage>)listener);
                                trade.getChatMessages().addListener(listener);
                            }
                            PendingTradesView.this.updateChatMessageCount(trade, badge);
                            this.setGraphic((Node)badge);
                        } else {
                            this.setGraphic(null);
                        }
                    }
                };
            }
        });
        return this.chatColumn;
    }

    private void setRemoveTradeColumnCellFactory() {
        this.moveTradeToFailedColumn.setCellValueFactory(trade -> new ReadOnlyObjectWrapper((Object)((PendingTradesListItem)trade.getValue())));
        this.moveTradeToFailedColumn.setCellFactory((Callback)new Callback<TableColumn<PendingTradesListItem, PendingTradesListItem>, TableCell<PendingTradesListItem, PendingTradesListItem>>(){

            public TableCell<PendingTradesListItem, PendingTradesListItem> call(TableColumn<PendingTradesListItem, PendingTradesListItem> column) {
                return new TableCell<PendingTradesListItem, PendingTradesListItem>(){
                    private Trade trade;
                    private JFXButton warnIconButton;
                    private JFXButton trashIconButton;
                    private ChangeListener<Trade.State> listener;

                    public void updateItem(PendingTradesListItem newItem, boolean empty) {
                        super.updateItem((Object)newItem, empty);
                        if (!empty && newItem != null) {
                            this.trade = newItem.getTrade();
                            this.listener = (observable, oldValue, newValue) -> UserThread.execute(() -> this.update());
                            this.trade.stateProperty().addListener(this.listener);
                            this.update();
                        } else {
                            this.cleanup();
                        }
                    }

                    private void update() {
                        if (PendingTradesView.this.isMaybeInvalidTrade(this.trade)) {
                            Text warnIcon = FormBuilder.getMediumSizeIcon((GlyphIcons)MaterialDesignIcon.ALERT_CIRCLE_OUTLINE);
                            Text trashIcon = FormBuilder.getMediumSizeIcon((GlyphIcons)MaterialDesignIcon.ARROW_RIGHT_BOLD_BOX_OUTLINE);
                            if (this.trade.isTxChainInvalid()) {
                                trashIcon.getStyleClass().addAll((Object[])new String[]{"icon", "error-icon"});
                                warnIcon.getStyleClass().addAll((Object[])new String[]{"icon", "error-icon"});
                            } else {
                                trashIcon.getStyleClass().addAll((Object[])new String[]{"icon", "warn-icon"});
                                warnIcon.getStyleClass().addAll((Object[])new String[]{"icon", "warn-icon"});
                            }
                            this.warnIconButton = new JFXButton("", (Node)warnIcon);
                            this.warnIconButton.getStyleClass().add((Object)"hidden-icon-button");
                            this.warnIconButton.setTooltip(new Tooltip(Res.get((String)"portfolio.pending.failedTrade.warningIcon.tooltip")));
                            this.warnIconButton.setOnAction(e -> PendingTradesView.this.onShowInfoForInvalidTrade(this.trade));
                            this.trashIconButton = new JFXButton("", (Node)trashIcon);
                            this.trashIconButton.getStyleClass().add((Object)"hidden-icon-button");
                            this.trashIconButton.setTooltip(new Tooltip(Res.get((String)"portfolio.pending.failedTrade.moveTradeToFailedIcon.tooltip")));
                            this.trashIconButton.setOnAction(e -> PendingTradesView.this.onMoveInvalidTradeToFailedTrades(this.trade));
                            HBox hBox = new HBox();
                            hBox.setSpacing(0.0);
                            hBox.getChildren().addAll((Object[])new Node[]{this.warnIconButton, this.trashIconButton});
                            this.setGraphic((Node)hBox);
                        } else {
                            this.cleanup();
                        }
                        PendingTradesView.this.updateMoveTradeToFailedColumnState();
                    }

                    private void cleanup() {
                        if (this.warnIconButton != null) {
                            this.warnIconButton.setOnAction(null);
                        }
                        if (this.trashIconButton != null) {
                            this.trashIconButton.setOnAction(null);
                        }
                        if (this.listener != null && this.trade != null) {
                            this.trade.stateProperty().removeListener(this.listener);
                        }
                        this.setGraphic(null);
                    }
                };
            }
        });
    }

    public static interface ChatCallback {
        public void onOpenChat(Trade var1);
    }
}

