/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.portfolio.pendingtrades;

import haveno.core.locale.CurrencyUtil;
import haveno.core.monetary.Price;
import haveno.core.trade.HavenoUtils;
import haveno.core.trade.Trade;
import haveno.core.util.FormattingUtils;
import haveno.core.util.coin.CoinFormatter;
import haveno.desktop.util.filtering.FilterableListItem;
import java.math.BigInteger;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PendingTradesListItem
implements FilterableListItem {
    public static final Logger log = LoggerFactory.getLogger(PendingTradesListItem.class);
    private final CoinFormatter btcFormatter;
    private final Trade trade;

    public PendingTradesListItem(Trade trade, CoinFormatter btcFormatter) {
        this.trade = trade;
        this.btcFormatter = btcFormatter;
    }

    public Trade getTrade() {
        return this.trade;
    }

    public Price getPrice() {
        return this.trade.getPrice();
    }

    public String getPriceAsString() {
        return FormattingUtils.formatPrice((Price)this.trade.getPrice());
    }

    public String getAmountAsString() {
        return HavenoUtils.formatXmr((BigInteger)this.trade.getAmount());
    }

    public String getPaymentMethod() {
        return this.trade.getOffer().getPaymentMethodNameWithCountryCode();
    }

    public String getMarketDescription() {
        return CurrencyUtil.getCurrencyPair((String)this.trade.getOffer().getCounterCurrencyCode());
    }

    @Override
    public boolean match(String filterString) {
        if (filterString.isEmpty()) {
            return true;
        }
        if (StringUtils.containsIgnoreCase((CharSequence)this.getTrade().getId(), (CharSequence)filterString)) {
            return true;
        }
        if (StringUtils.containsIgnoreCase((CharSequence)this.getAmountAsString(), (CharSequence)filterString)) {
            return true;
        }
        if (StringUtils.containsIgnoreCase((CharSequence)this.getPaymentMethod(), (CharSequence)filterString)) {
            return true;
        }
        if (StringUtils.containsIgnoreCase((CharSequence)this.getMarketDescription(), (CharSequence)filterString)) {
            return true;
        }
        if (StringUtils.containsIgnoreCase((CharSequence)this.getTrade().getOffer().getCombinedExtraInfo(), (CharSequence)filterString)) {
            return true;
        }
        if (this.getTrade().getBuyer().getPaymentAccountPayload() != null && StringUtils.containsIgnoreCase((CharSequence)this.getTrade().getBuyer().getPaymentAccountPayload().getPaymentDetails(), (CharSequence)filterString)) {
            return true;
        }
        if (this.getTrade().getSeller().getPaymentAccountPayload() != null && StringUtils.containsIgnoreCase((CharSequence)this.getTrade().getSeller().getPaymentAccountPayload().getPaymentDetails(), (CharSequence)filterString)) {
            return true;
        }
        return StringUtils.containsIgnoreCase((CharSequence)this.getPriceAsString(), (CharSequence)filterString);
    }
}

