/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.portfolio.pendingtrades;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import haveno.common.UserThread;
import haveno.common.crypto.PubKeyRing;
import haveno.common.crypto.PubKeyRingProvider;
import haveno.common.handlers.ErrorMessageHandler;
import haveno.common.handlers.FaultHandler;
import haveno.common.handlers.ResultHandler;
import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.api.CoreDisputesService;
import haveno.core.api.XmrConnectionService;
import haveno.core.locale.Res;
import haveno.core.offer.Offer;
import haveno.core.offer.OfferDirection;
import haveno.core.offer.OfferUtil;
import haveno.core.payment.payload.PaymentAccountPayload;
import haveno.core.support.SupportType;
import haveno.core.support.dispute.Dispute;
import haveno.core.support.dispute.DisputeList;
import haveno.core.support.dispute.DisputeManager;
import haveno.core.support.dispute.arbitration.ArbitrationManager;
import haveno.core.support.dispute.mediation.MediationManager;
import haveno.core.support.traderchat.TraderChatManager;
import haveno.core.trade.BuyerTrade;
import haveno.core.trade.SellerTrade;
import haveno.core.trade.Trade;
import haveno.core.trade.TradeManager;
import haveno.core.trade.protocol.BuyerProtocol;
import haveno.core.trade.protocol.SellerProtocol;
import haveno.core.user.Preferences;
import haveno.core.util.coin.CoinFormatter;
import haveno.core.xmr.wallet.XmrWalletService;
import haveno.desktop.Navigation;
import haveno.desktop.common.model.ActivatableDataModel;
import haveno.desktop.main.MainView;
import haveno.desktop.main.overlays.notifications.NotificationCenter;
import haveno.desktop.main.overlays.popups.Popup;
import haveno.desktop.main.overlays.windows.WalletPasswordWindow;
import haveno.desktop.main.portfolio.pendingtrades.PendingTradesListItem;
import haveno.desktop.main.support.SupportView;
import haveno.desktop.main.support.dispute.client.arbitration.ArbitrationClientView;
import haveno.desktop.main.support.dispute.client.mediation.MediationClientView;
import haveno.desktop.util.GUIUtil;
import haveno.network.p2p.P2PService;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javax.annotation.Nullable;
import org.bitcoinj.core.Coin;
import org.bouncycastle.crypto.params.KeyParameter;

public class PendingTradesDataModel
extends ActivatableDataModel {
    public final TradeManager tradeManager;
    public final XmrWalletService xmrWalletService;
    public final ArbitrationManager arbitrationManager;
    public final MediationManager mediationManager;
    private final P2PService p2PService;
    private final XmrConnectionService xmrConnectionService;
    private final AccountAgeWitnessService accountAgeWitnessService;
    public final Navigation navigation;
    public final WalletPasswordWindow walletPasswordWindow;
    private final NotificationCenter notificationCenter;
    private final OfferUtil offerUtil;
    private final CoinFormatter btcFormatter;
    final ObservableList<PendingTradesListItem> list = FXCollections.observableArrayList();
    private final ListChangeListener<Trade> tradesListChangeListener;
    private boolean isMaker;
    final ObjectProperty<PendingTradesListItem> selectedItemProperty = new SimpleObjectProperty();
    public final StringProperty makerTxId = new SimpleStringProperty();
    public final StringProperty takerTxId = new SimpleStringProperty();
    private final TraderChatManager traderChatManager;
    public final Preferences preferences;
    private boolean activated;
    private ChangeListener<Trade.State> tradeStateChangeListener;
    private Trade selectedTrade;
    private final PubKeyRingProvider pubKeyRingProvider;
    private final CoreDisputesService disputesService;
    private final Set<Trade> hiddenTrades = new HashSet<Trade>();
    private final ChangeListener<Trade.State> hiddenStateChangeListener = (observable, oldValue, newValue) -> this.onListChanged();

    @Inject
    public PendingTradesDataModel(TradeManager tradeManager, XmrWalletService xmrWalletService, PubKeyRingProvider pubKeyRingProvider, ArbitrationManager arbitrationManager, MediationManager mediationManager, TraderChatManager traderChatManager, Preferences preferences, P2PService p2PService, XmrConnectionService xmrConnectionService, AccountAgeWitnessService accountAgeWitnessService, Navigation navigation, WalletPasswordWindow walletPasswordWindow, NotificationCenter notificationCenter, OfferUtil offerUtil, CoreDisputesService disputesService, @Named(value="BTC") CoinFormatter formatter) {
        this.tradeManager = tradeManager;
        this.xmrWalletService = xmrWalletService;
        this.pubKeyRingProvider = pubKeyRingProvider;
        this.arbitrationManager = arbitrationManager;
        this.mediationManager = mediationManager;
        this.traderChatManager = traderChatManager;
        this.preferences = preferences;
        this.p2PService = p2PService;
        this.xmrConnectionService = xmrConnectionService;
        this.accountAgeWitnessService = accountAgeWitnessService;
        this.navigation = navigation;
        this.walletPasswordWindow = walletPasswordWindow;
        this.notificationCenter = notificationCenter;
        this.offerUtil = offerUtil;
        this.disputesService = disputesService;
        this.btcFormatter = formatter;
        this.tradesListChangeListener = change -> this.onListChanged();
        notificationCenter.setSelectItemByTradeIdConsumer(this::selectItemByTradeId);
    }

    @Override
    protected void activate() {
        this.tradeManager.getObservableList().addListener(this.tradesListChangeListener);
        this.onListChanged();
        if (this.selectedItemProperty.get() != null) {
            this.notificationCenter.setSelectedTradeId(((PendingTradesListItem)this.selectedItemProperty.get()).getTrade().getId());
        }
        this.activated = true;
    }

    @Override
    protected void deactivate() {
        for (Trade trade : this.hiddenTrades) {
            trade.stateProperty().removeListener(this.hiddenStateChangeListener);
        }
        this.tradeManager.getObservableList().removeListener(this.tradesListChangeListener);
        this.notificationCenter.setSelectedTradeId(null);
        this.activated = false;
    }

    void onSelectItem(PendingTradesListItem item) {
        this.doSelectItem(item);
    }

    public void onPaymentSent(ResultHandler resultHandler, ErrorMessageHandler errorMessageHandler) {
        Trade trade = this.getTrade();
        Preconditions.checkNotNull((Object)trade, (Object)"trade must not be null");
        Preconditions.checkArgument((boolean)(trade instanceof BuyerTrade), (Object)("Check failed: trade instanceof BuyerTrade. Was: " + trade.getClass().getSimpleName()));
        ((BuyerProtocol)this.tradeManager.getTradeProtocol(trade)).onPaymentSent(resultHandler, errorMessageHandler);
    }

    public void onPaymentReceived(ResultHandler resultHandler, ErrorMessageHandler errorMessageHandler) {
        Trade trade = this.getTrade();
        Preconditions.checkNotNull((Object)trade, (Object)"trade must not be null");
        Preconditions.checkArgument((boolean)(trade instanceof SellerTrade), (Object)"Trade must be instance of SellerTrade");
        ((SellerProtocol)this.tradeManager.getTradeProtocol(trade)).onPaymentReceived(resultHandler, errorMessageHandler);
    }

    public void onWithdrawRequest(String toAddress, Coin amount, Coin fee, KeyParameter aesKey, @Nullable String memo, ResultHandler resultHandler, FaultHandler faultHandler) {
        Preconditions.checkNotNull((Object)this.getTrade(), (Object)"trade must not be null");
        if (toAddress != null && toAddress.length() > 0) {
            this.tradeManager.onWithdrawRequest(toAddress, amount, fee, aesKey, this.getTrade(), memo, () -> {
                resultHandler.handleResult();
                this.selectBestItem();
            }, (errorMessage, throwable) -> {
                this.log.error(errorMessage);
                faultHandler.handleFault(errorMessage, throwable);
            });
        } else {
            faultHandler.handleFault(Res.get((String)"portfolio.pending.noReceiverAddressDefined"), null);
        }
    }

    public void onOpenDispute() {
        this.tryOpenDispute(false);
    }

    public void onOpenSupportTicket() {
        this.tryOpenDispute(true);
    }

    @Nullable
    public Trade getTrade() {
        return this.selectedItemProperty.get() != null ? ((PendingTradesListItem)this.selectedItemProperty.get()).getTrade() : null;
    }

    @Nullable
    Offer getOffer() {
        return this.getTrade() != null ? this.getTrade().getOffer() : null;
    }

    private boolean isBuyOffer() {
        return this.getOffer() != null && this.offerUtil.isBuyOffer(this.getOffer().getDirection());
    }

    boolean isBuyer() {
        return this.isMaker(this.getOffer()) && this.isBuyOffer() || !this.isMaker(this.getOffer()) && !this.isBuyOffer();
    }

    boolean isMaker(Offer offer) {
        return this.tradeManager.isMyOffer(offer);
    }

    public boolean isMaker() {
        return this.isMaker;
    }

    BigInteger getTradeFee() {
        Trade trade = this.getTrade();
        if (trade != null) {
            Offer offer = trade.getOffer();
            if (this.isMaker()) {
                if (offer != null) {
                    return trade.getMakerFee();
                }
                this.log.error("offer is null");
                return BigInteger.ZERO;
            }
            return trade.getTakerFee();
        }
        this.log.error("Trade is null at getTotalFees");
        return BigInteger.ZERO;
    }

    @Nullable
    public PaymentAccountPayload getSellersPaymentAccountPayload() {
        if (this.getTrade() == null) {
            return null;
        }
        return this.getTrade().getSeller().getPaymentAccountPayload();
    }

    @Nullable
    public PaymentAccountPayload getBuyersPaymentAccountPayload() {
        if (this.getTrade() == null) {
            return null;
        }
        return this.getTrade().getBuyer().getPaymentAccountPayload();
    }

    public String getReference() {
        return this.getOffer() != null ? this.getOffer().getShortId() : "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onListChanged() {
        ObservableList observableList = this.tradeManager.getObservableList();
        synchronized (observableList) {
            for (Trade trade2 : this.tradeManager.getObservableList()) {
                if (this.isTradeShown(trade2)) {
                    if (!this.hiddenTrades.contains(trade2)) continue;
                    trade2.stateProperty().removeListener(this.hiddenStateChangeListener);
                    this.hiddenTrades.remove(trade2);
                    continue;
                }
                if (this.hiddenTrades.contains(trade2)) continue;
                trade2.stateProperty().addListener(this.hiddenStateChangeListener);
                this.hiddenTrades.add(trade2);
            }
            ObservableList<PendingTradesListItem> observableList2 = this.list;
            synchronized (observableList2) {
                this.list.clear();
                this.list.addAll((Collection)this.tradeManager.getObservableList().stream().filter(trade -> this.isTradeShown((Trade)trade)).map(trade -> new PendingTradesListItem((Trade)trade, this.btcFormatter)).collect(Collectors.toList()));
                this.list.sort((o1, o2) -> o2.getTrade().getDate().compareTo(o1.getTrade().getDate()));
            }
        }
        this.selectBestItem();
    }

    private boolean isTradeShown(Trade trade) {
        return trade.isDepositsPublished();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectBestItem() {
        ObservableList<PendingTradesListItem> observableList = this.list;
        synchronized (observableList) {
            if (this.list.size() == 1) {
                this.doSelectItem((PendingTradesListItem)this.list.get(0));
            } else if (!(this.list.size() <= 1 || this.selectedItemProperty.get() != null && this.list.contains(this.selectedItemProperty.get()))) {
                this.doSelectItem((PendingTradesListItem)this.list.get(0));
            } else if (this.list.size() == 0) {
                this.doSelectItem(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectItemByTradeId(String tradeId) {
        if (this.activated) {
            ObservableList<PendingTradesListItem> observableList = this.list;
            synchronized (observableList) {
                this.list.stream().filter(e -> e.getTrade().getId().equals(tradeId)).findAny().ifPresent(this::doSelectItem);
            }
        }
    }

    private void doSelectItem(@Nullable PendingTradesListItem item) {
        UserThread.execute(() -> {
            if (this.selectedTrade != null) {
                this.selectedTrade.stateProperty().removeListener(this.tradeStateChangeListener);
            }
            if (item != null) {
                this.selectedTrade = item.getTrade();
                if (this.selectedTrade == null) {
                    this.log.error("selectedTrade is null");
                    return;
                }
                String tradeId = this.selectedTrade.getId();
                this.tradeStateChangeListener = (observable, oldValue, newValue) -> {
                    String makerDepositTxHash = this.selectedTrade.getMaker().getDepositTxHash();
                    String takerDepositTxHash = this.selectedTrade.getTaker().getDepositTxHash();
                    this.makerTxId.set((Object)this.nullToEmptyString(makerDepositTxHash));
                    this.takerTxId.set((Object)this.nullToEmptyString(takerDepositTxHash));
                    if (makerDepositTxHash != null || takerDepositTxHash != null) {
                        this.notificationCenter.setSelectedTradeId(tradeId);
                        this.selectedTrade.stateProperty().removeListener(this.tradeStateChangeListener);
                    }
                };
                this.selectedTrade.stateProperty().addListener(this.tradeStateChangeListener);
                Offer offer = this.selectedTrade.getOffer();
                if (offer == null) {
                    this.log.error("offer is null");
                    return;
                }
                this.isMaker = this.tradeManager.isMyOffer(offer);
                String makerDepositTxHash = this.selectedTrade.getMaker().getDepositTxHash();
                String takerDepositTxHash = this.selectedTrade.getTaker().getDepositTxHash();
                this.makerTxId.set((Object)this.nullToEmptyString(makerDepositTxHash));
                this.takerTxId.set((Object)this.nullToEmptyString(takerDepositTxHash));
                this.notificationCenter.setSelectedTradeId(tradeId);
            } else {
                this.selectedTrade = null;
                this.makerTxId.set((Object)"");
                this.takerTxId.set((Object)"");
                this.notificationCenter.setSelectedTradeId(null);
            }
            this.selectedItemProperty.set((Object)item);
        });
    }

    private String nullToEmptyString(String str) {
        return str == null ? "" : str;
    }

    private void tryOpenDispute(boolean isSupportTicket) {
        Trade trade = this.getTrade();
        if (trade == null) {
            this.log.error("Trade is null");
            return;
        }
        this.doOpenDispute(isSupportTicket, trade);
    }

    private void doOpenDispute(boolean isSupportTicket, Trade trade) {
        if (trade == null) {
            this.log.warn("trade is null at doOpenDispute");
            return;
        }
        Offer offer = trade.getOffer();
        if (offer == null) {
            this.log.warn("offer is null at doOpenDispute");
            return;
        }
        if (!GUIUtil.isBootstrappedOrShowPopup(this.p2PService)) {
            return;
        }
        byte[] payoutTxSerialized = null;
        String payoutTxHashAsString = null;
        if (trade.getPayoutTxId() != null) {
            // empty if block
        }
        Trade.DisputeState disputeState = trade.getDisputeState();
        boolean useMediation = false;
        boolean useArbitration = true;
        if (useMediation) {
            ResultHandler resultHandler = () -> this.navigation.navigateTo(MainView.class, SupportView.class, MediationClientView.class);
            MediationManager disputeManager = this.mediationManager;
            PubKeyRing arbitratorPubKeyRing = trade.getArbitrator().getPubKeyRing();
            Preconditions.checkNotNull((Object)arbitratorPubKeyRing, (Object)"arbitratorPubKeyRing must not be null");
            Object depositTxSerialized = null;
            Dispute dispute = new Dispute(new Date().getTime(), trade.getId(), this.pubKeyRingProvider.get().hashCode(), true, offer.getDirection() == OfferDirection.BUY == this.isMaker, this.isMaker, this.pubKeyRingProvider.get(), trade.getDate().getTime(), trade.getMaxTradePeriodDate().getTime(), trade.getContract(), trade.getContractHash(), payoutTxSerialized, payoutTxHashAsString, trade.getContractAsJson(), trade.getMaker().getContractSignature(), trade.getTaker().getContractSignature(), trade.getMaker().getPaymentAccountPayload(), trade.getTaker().getPaymentAccountPayload(), arbitratorPubKeyRing, isSupportTicket, SupportType.MEDIATION);
            dispute.setExtraData("counterCurrencyTxId", trade.getCounterCurrencyTxId());
            dispute.setExtraData("counterCurrencyExtraData", trade.getCounterCurrencyExtraData());
            trade.setDisputeState(Trade.DisputeState.MEDIATION_REQUESTED);
            this.sendDisputeOpenedMessage(dispute, (DisputeManager<? extends DisputeList<Dispute>>)disputeManager);
            this.tradeManager.requestPersistence();
        } else if (useArbitration) {
            ArbitrationManager disputeManager = this.arbitrationManager;
            Dispute dispute = this.disputesService.createDisputeForTrade(trade, offer, this.pubKeyRingProvider.get(), this.isMaker, isSupportTicket);
            this.sendDisputeOpenedMessage(dispute, (DisputeManager<? extends DisputeList<Dispute>>)disputeManager);
            this.tradeManager.requestPersistence();
        } else {
            this.log.warn("Invalid dispute state {}", (Object)disputeState.name());
        }
    }

    private void sendDisputeOpenedMessage(Dispute dispute, DisputeManager<? extends DisputeList<Dispute>> disputeManager) {
        boolean disputeClosed;
        Optional optionalDispute = disputeManager.findDispute(dispute);
        boolean bl = disputeClosed = optionalDispute.isPresent() && ((Dispute)optionalDispute.get()).isClosed();
        if (disputeClosed) {
            String msg = "We got a dispute already open for that trade and trading peer.\nTradeId = " + dispute.getTradeId();
            ((Popup)((Popup)((Popup)((Popup)new Popup().warning(msg + "\n\n" + Res.get((String)"portfolio.pending.openAgainDispute.msg"))).actionButtonText(Res.get((String)"portfolio.pending.openAgainDispute.button"))).onAction(() -> this.doSendDisputeOpenedMessage(dispute, disputeManager))).closeButtonText(Res.get((String)"shared.cancel"))).show();
        } else {
            this.doSendDisputeOpenedMessage(dispute, disputeManager);
        }
    }

    private void doSendDisputeOpenedMessage(Dispute dispute, DisputeManager<? extends DisputeList<Dispute>> disputeManager) {
        this.navigation.navigateTo(MainView.class, SupportView.class, ArbitrationClientView.class);
        disputeManager.sendDisputeOpenedMessage(dispute, null, (errorMessage, throwable) -> ((Popup)new Popup().warning(errorMessage)).show());
    }

    public boolean isReadyForTxBroadcast() {
        return GUIUtil.isBootstrappedOrShowPopup(this.p2PService) && GUIUtil.isReadyForTxBroadcastOrShowPopup(this.xmrWalletService);
    }

    public boolean isBootstrappedOrShowPopup() {
        return GUIUtil.isBootstrappedOrShowPopup(this.p2PService);
    }

    public void onMoveInvalidTradeToFailedTrades(Trade trade) {
        this.tradeManager.onMoveInvalidTradeToFailedTrades(trade);
    }

    public boolean isSignWitnessTrade() {
        return this.accountAgeWitnessService.isSignWitnessTrade(this.selectedTrade);
    }

    public TradeManager getTradeManager() {
        return this.tradeManager;
    }

    public AccountAgeWitnessService getAccountAgeWitnessService() {
        return this.accountAgeWitnessService;
    }

    public TraderChatManager getTraderChatManager() {
        return this.traderChatManager;
    }

    public PubKeyRingProvider getPubKeyRingProvider() {
        return this.pubKeyRingProvider;
    }
}

