/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.portfolio.openoffer;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import haveno.common.handlers.ErrorMessageHandler;
import haveno.common.handlers.ResultHandler;
import haveno.core.locale.CurrencyUtil;
import haveno.core.locale.Res;
import haveno.core.monetary.Price;
import haveno.core.offer.Offer;
import haveno.core.offer.OpenOffer;
import haveno.core.util.FormattingUtils;
import haveno.core.util.PriceUtil;
import haveno.core.util.VolumeUtil;
import haveno.core.util.coin.CoinFormatter;
import haveno.desktop.common.model.ActivatableWithDataModel;
import haveno.desktop.common.model.ViewModel;
import haveno.desktop.main.portfolio.openoffer.OpenOfferListItem;
import haveno.desktop.main.portfolio.openoffer.OpenOffersDataModel;
import haveno.desktop.util.DisplayUtils;
import haveno.desktop.util.GUIUtil;
import haveno.network.p2p.P2PService;
import javafx.collections.ObservableList;

class OpenOffersViewModel
extends ActivatableWithDataModel<OpenOffersDataModel>
implements ViewModel {
    private final P2PService p2PService;
    private final PriceUtil priceUtil;
    private final CoinFormatter btcFormatter;

    @Inject
    public OpenOffersViewModel(OpenOffersDataModel dataModel, P2PService p2PService, PriceUtil priceUtil, @Named(value="BTC") CoinFormatter btcFormatter) {
        super(dataModel);
        this.p2PService = p2PService;
        this.priceUtil = priceUtil;
        this.btcFormatter = btcFormatter;
    }

    @Override
    protected void activate() {
    }

    void onActivateOpenOffer(OpenOffer openOffer, ResultHandler resultHandler, ErrorMessageHandler errorMessageHandler) {
        ((OpenOffersDataModel)this.dataModel).onActivateOpenOffer(openOffer, resultHandler, errorMessageHandler);
    }

    void onDeactivateOpenOffer(OpenOffer openOffer, ResultHandler resultHandler, ErrorMessageHandler errorMessageHandler) {
        ((OpenOffersDataModel)this.dataModel).onDeactivateOpenOffer(openOffer, resultHandler, errorMessageHandler);
    }

    void onRemoveOpenOffer(OpenOffer openOffer, ResultHandler resultHandler, ErrorMessageHandler errorMessageHandler) {
        ((OpenOffersDataModel)this.dataModel).onRemoveOpenOffer(openOffer, resultHandler, errorMessageHandler);
    }

    public ObservableList<OpenOfferListItem> getList() {
        return ((OpenOffersDataModel)this.dataModel).getList();
    }

    String getOfferId(OpenOfferListItem item) {
        return item.getOffer().getShortId();
    }

    String getGroupId(OpenOfferListItem item) {
        return item.getGroupId();
    }

    String getAmount(OpenOfferListItem item) {
        return item != null ? DisplayUtils.formatAmount(item.getOffer(), this.btcFormatter) : "";
    }

    String getPrice(OpenOfferListItem item) {
        if (item == null) {
            return "";
        }
        Offer offer = item.getOffer();
        Price price = offer.getPrice();
        if (price != null) {
            return FormattingUtils.formatPrice((Price)price);
        }
        return Res.get((String)"shared.na");
    }

    String getPriceDeviation(OpenOfferListItem item) {
        Offer offer = item.getOffer();
        return this.priceUtil.getMarketBasedPrice(offer, offer.getMirroredDirection()).map(FormattingUtils::formatPercentagePrice).orElse("");
    }

    Double getPriceDeviationAsDouble(OpenOfferListItem item) {
        Offer offer = item.getOffer();
        return this.priceUtil.getMarketBasedPrice(offer, offer.getMirroredDirection()).orElse(0.0);
    }

    String getVolume(OpenOfferListItem item) {
        return item != null ? VolumeUtil.formatVolume((Offer)item.getOffer(), (Boolean)false, (int)0) + " " + item.getOffer().getCounterCurrencyCode() : "";
    }

    String getDirectionLabel(OpenOfferListItem item) {
        if (item == null) {
            return "";
        }
        return DisplayUtils.getDirectionWithCode(((OpenOffersDataModel)this.dataModel).getDirection(item.getOffer()), item.getOffer().getCounterCurrencyCode(), item.getOffer().isPrivateOffer());
    }

    String getMarketLabel(OpenOfferListItem item) {
        if (item == null) {
            return "";
        }
        return CurrencyUtil.getCurrencyPair((String)item.getOffer().getCounterCurrencyCode());
    }

    String getPaymentMethod(OpenOfferListItem item) {
        String result = "";
        if (item != null) {
            Offer offer = item.getOffer();
            Preconditions.checkNotNull((Object)offer);
            Preconditions.checkNotNull((Object)offer.getPaymentMethod());
            result = offer.getPaymentMethodNameWithCountryCode();
        }
        return result;
    }

    String getDate(OpenOfferListItem item) {
        return DisplayUtils.formatDateTime(item.getOffer().getDate());
    }

    boolean isDeactivated(OpenOfferListItem item) {
        return item != null && item.getOpenOffer() != null && item.getOpenOffer().isDeactivated();
    }

    boolean isBootstrappedOrShowPopup() {
        return GUIUtil.isBootstrappedOrShowPopup(this.p2PService);
    }

    String getTriggerPrice(OpenOfferListItem item) {
        if (item == null) {
            return "";
        }
        Offer offer = item.getOffer();
        long triggerPrice = item.getOpenOffer().getTriggerPrice();
        if (!offer.isUseMarketBasedPrice() || triggerPrice <= 0L) {
            return Res.get((String)"shared.na");
        }
        return PriceUtil.formatMarketPrice((long)triggerPrice, (String)offer.getCounterCurrencyCode());
    }
}

