/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.portfolio.openoffer;

import com.google.inject.Inject;
import com.googlecode.jcsv.writer.CSVEntryConverter;
import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.materialdesignicons.MaterialDesignIcon;
import haveno.core.locale.Res;
import haveno.core.offer.Offer;
import haveno.core.offer.OpenOffer;
import haveno.core.offer.OpenOfferManager;
import haveno.core.user.DontShowAgainLookup;
import haveno.desktop.Navigation;
import haveno.desktop.common.view.ActivatableViewAndModel;
import haveno.desktop.common.view.FxmlView;
import haveno.desktop.components.AutoTooltipButton;
import haveno.desktop.components.AutoTooltipLabel;
import haveno.desktop.components.AutoTooltipSlideToggleButton;
import haveno.desktop.components.AutoTooltipTableColumn;
import haveno.desktop.components.HyperlinkWithIcon;
import haveno.desktop.components.InputTextField;
import haveno.desktop.main.MainView;
import haveno.desktop.main.funds.FundsView;
import haveno.desktop.main.funds.withdrawal.WithdrawalView;
import haveno.desktop.main.overlays.popups.Popup;
import haveno.desktop.main.overlays.windows.OfferDetailsWindow;
import haveno.desktop.main.portfolio.PortfolioView;
import haveno.desktop.main.portfolio.openoffer.OpenOfferListItem;
import haveno.desktop.main.portfolio.openoffer.OpenOffersDataModel;
import haveno.desktop.main.portfolio.openoffer.OpenOffersViewModel;
import haveno.desktop.main.portfolio.presentation.PortfolioUtil;
import haveno.desktop.util.FormBuilder;
import haveno.desktop.util.GUIUtil;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableObjectValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.jetbrains.annotations.NotNull;

@FxmlView
public class OpenOffersView
extends ActivatableViewAndModel<VBox, OpenOffersViewModel> {
    @FXML
    TableView<OpenOfferListItem> tableView;
    @FXML
    TableColumn<OpenOfferListItem, OpenOfferListItem> priceColumn;
    @FXML
    TableColumn<OpenOfferListItem, OpenOfferListItem> deviationColumn;
    @FXML
    TableColumn<OpenOfferListItem, OpenOfferListItem> amountColumn;
    @FXML
    TableColumn<OpenOfferListItem, OpenOfferListItem> volumeColumn;
    @FXML
    TableColumn<OpenOfferListItem, OpenOfferListItem> marketColumn;
    @FXML
    TableColumn<OpenOfferListItem, OpenOfferListItem> directionColumn;
    @FXML
    TableColumn<OpenOfferListItem, OpenOfferListItem> dateColumn;
    @FXML
    TableColumn<OpenOfferListItem, OpenOfferListItem> offerIdColumn;
    @FXML
    TableColumn<OpenOfferListItem, OpenOfferListItem> deactivateItemColumn;
    @FXML
    TableColumn<OpenOfferListItem, OpenOfferListItem> groupIdColumn;
    @FXML
    TableColumn<OpenOfferListItem, OpenOfferListItem> removeItemColumn;
    @FXML
    TableColumn<OpenOfferListItem, OpenOfferListItem> editItemColumn;
    @FXML
    TableColumn<OpenOfferListItem, OpenOfferListItem> triggerPriceColumn;
    @FXML
    TableColumn<OpenOfferListItem, OpenOfferListItem> triggerIconColumn;
    @FXML
    TableColumn<OpenOfferListItem, OpenOfferListItem> paymentMethodColumn;
    @FXML
    TableColumn<OpenOfferListItem, OpenOfferListItem> duplicateItemColumn;
    @FXML
    TableColumn<OpenOfferListItem, OpenOfferListItem> cloneItemColumn;
    @FXML
    HBox searchBox;
    @FXML
    InputTextField filterTextField;
    @FXML
    Pane searchBoxSpacer;
    @FXML
    Label numItems;
    @FXML
    Region footerSpacer;
    @FXML
    AutoTooltipButton exportButton;
    @FXML
    AutoTooltipSlideToggleButton selectToggleButton;
    private final Navigation navigation;
    private final OfferDetailsWindow offerDetailsWindow;
    private SortedList<OpenOfferListItem> sortedList;
    private FilteredList<OpenOfferListItem> filteredList;
    private ChangeListener<String> filterTextFieldListener;
    private final OpenOfferManager openOfferManager;
    private PortfolioView.EditOpenOfferHandler editOpenOfferHandler;
    private PortfolioView.CloneOpenOfferHandler cloneOpenOfferHandler;
    private ChangeListener<Number> widthListener;
    private ListChangeListener<OpenOfferListItem> sortedListChangedListener;
    private Map<String, ChangeListener<OpenOffer.State>> offerStateChangeListeners = new HashMap<String, ChangeListener<OpenOffer.State>>();

    @Inject
    public OpenOffersView(OpenOffersViewModel model, OpenOfferManager openOfferManager, Navigation navigation, OfferDetailsWindow offerDetailsWindow) {
        super(model);
        this.navigation = navigation;
        this.offerDetailsWindow = offerDetailsWindow;
        this.openOfferManager = openOfferManager;
    }

    @Override
    public void initialize() {
        GUIUtil.applyTableStyle(this.tableView);
        this.widthListener = (observable, oldValue, newValue) -> this.onWidthChange((Double)newValue);
        this.groupIdColumn.setGraphic((Node)new AutoTooltipLabel(ColumnNames.GROUP_ID.toString()));
        this.paymentMethodColumn.setGraphic((Node)new AutoTooltipLabel(ColumnNames.PAYMENT_METHOD.toString()));
        this.priceColumn.setGraphic((Node)new AutoTooltipLabel(ColumnNames.PRICE.toString()));
        this.deviationColumn.setGraphic(new AutoTooltipTableColumn(ColumnNames.DEVIATION.toString(), Res.get((String)"portfolio.closedTrades.deviation.help")).getGraphic());
        this.triggerPriceColumn.setGraphic((Node)new AutoTooltipLabel(ColumnNames.TRIGGER_PRICE.toString()));
        this.amountColumn.setGraphic((Node)new AutoTooltipLabel(ColumnNames.AMOUNT.toString()));
        this.volumeColumn.setGraphic((Node)new AutoTooltipLabel(ColumnNames.VOLUME.toString()));
        this.marketColumn.setGraphic((Node)new AutoTooltipLabel(ColumnNames.MARKET.toString()));
        this.directionColumn.setGraphic((Node)new AutoTooltipLabel(ColumnNames.DIRECTION.toString()));
        this.dateColumn.setGraphic((Node)new AutoTooltipLabel(ColumnNames.DATE.toString()));
        this.offerIdColumn.setGraphic((Node)new AutoTooltipLabel(ColumnNames.OFFER_ID.toString()));
        this.deactivateItemColumn.setGraphic((Node)new AutoTooltipLabel(ColumnNames.STATUS.toString()));
        this.editItemColumn.setGraphic((Node)new AutoTooltipLabel(""));
        this.duplicateItemColumn.setText("");
        this.cloneItemColumn.setText("");
        this.removeItemColumn.setGraphic((Node)new AutoTooltipLabel(""));
        this.setOfferIdColumnCellFactory();
        this.setGroupIdCellFactory();
        this.setDirectionColumnCellFactory();
        this.setMarketColumnCellFactory();
        this.setPriceColumnCellFactory();
        this.setDeviationColumnCellFactory();
        this.setAmountColumnCellFactory();
        this.setVolumeColumnCellFactory();
        this.setPaymentMethodColumnCellFactory();
        this.setDateColumnCellFactory();
        this.setDeactivateColumnCellFactory();
        this.setEditColumnCellFactory();
        this.setTriggerIconColumnCellFactory();
        this.setTriggerPriceColumnCellFactory();
        this.setDuplicateColumnCellFactory();
        this.setCloneColumnCellFactory();
        this.setRemoveColumnCellFactory();
        this.tableView.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        this.tableView.setPlaceholder((Node)new AutoTooltipLabel(Res.get((String)"table.placeholder.noItems", (Object[])new Object[]{Res.get((String)"shared.openOffers")})));
        this.offerIdColumn.setComparator(Comparator.comparing(o -> o.getOffer().getId()));
        this.groupIdColumn.setComparator(Comparator.comparing(o -> o.getOpenOffer().getReserveTxHash() == null ? "" : o.getOpenOffer().getReserveTxHash()));
        this.directionColumn.setComparator(Comparator.comparing(o -> o.getOffer().getDirection()));
        this.marketColumn.setComparator(Comparator.comparing(((OpenOffersViewModel)this.model)::getMarketLabel));
        this.amountColumn.setComparator(Comparator.comparing(o -> o.getOffer().getAmount()));
        this.priceColumn.setComparator(Comparator.comparing(o -> o.getOffer().getPrice(), Comparator.nullsFirst(Comparator.naturalOrder())));
        this.deviationColumn.setComparator(Comparator.comparing(((OpenOffersViewModel)this.model)::getPriceDeviationAsDouble, Comparator.nullsFirst(Comparator.naturalOrder())));
        this.triggerPriceColumn.setComparator(Comparator.comparing(o -> o.getOpenOffer().getTriggerPrice(), Comparator.nullsFirst(Comparator.naturalOrder())));
        this.volumeColumn.setComparator(Comparator.comparing(o -> o.getOffer().getVolume(), Comparator.nullsFirst(Comparator.naturalOrder())));
        this.dateColumn.setComparator(Comparator.comparing(o -> o.getOffer().getDate()));
        this.paymentMethodColumn.setComparator(Comparator.comparing(o -> Res.get((String)o.getOffer().getPaymentMethod().getId())));
        this.dateColumn.setSortType(TableColumn.SortType.ASCENDING);
        this.tableView.getSortOrder().add(this.dateColumn);
        this.tableView.setRowFactory(tableView -> {
            TableRow row = new TableRow();
            ContextMenu rowMenu = new ContextMenu();
            MenuItem duplicateOfferMenuItem = new MenuItem(Res.get((String)"portfolio.context.offerLikeThis"));
            duplicateOfferMenuItem.setOnAction(event -> this.onDuplicateOffer((OpenOfferListItem)row.getItem()));
            rowMenu.getItems().add((Object)duplicateOfferMenuItem);
            MenuItem cloneOfferMenuItem = new MenuItem(Res.get((String)"offerbook.cloneOffer"));
            cloneOfferMenuItem.setOnAction(event -> this.onCloneOffer((OpenOfferListItem)row.getItem()));
            rowMenu.getItems().add((Object)cloneOfferMenuItem);
            row.contextMenuProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)Bindings.isNotNull((ObservableObjectValue)row.itemProperty())).then((Object)rowMenu).otherwise((Object)null));
            return row;
        });
        this.filterTextField.setPromptText(Res.get((String)"shared.filter"));
        this.filterTextFieldListener = (observable, oldValue, newValue) -> this.applyFilteredListPredicate(this.filterTextField.getText());
        this.searchBox.setSpacing(5.0);
        HBox.setHgrow((Node)this.searchBoxSpacer, (Priority)Priority.ALWAYS);
        this.selectToggleButton.setPadding(new Insets(0.0, 60.0, -20.0, 0.0));
        this.selectToggleButton.setText(Res.get((String)"shared.enabled"));
        this.selectToggleButton.setDisable(true);
        this.numItems.setId("num-offers");
        this.numItems.setPadding(new Insets(-5.0, 0.0, 0.0, 10.0));
        HBox.setHgrow((Node)this.footerSpacer, (Priority)Priority.ALWAYS);
        HBox.setMargin((Node)this.exportButton, (Insets)new Insets(0.0, 10.0, 0.0, 0.0));
        this.exportButton.updateText(Res.get((String)"shared.exportCSV"));
        this.sortedListChangedListener = c -> {
            c.next();
            if (c.wasAdded() || c.wasRemoved()) {
                this.updateNumberOfOffers();
                this.updateGroupIdColumnVisibility();
                this.updateTriggerColumnVisibility();
            }
        };
    }

    @Override
    protected void activate() {
        this.filteredList = new FilteredList(((OpenOffersViewModel)this.model).getList());
        this.sortedList = new SortedList(this.filteredList);
        this.sortedList.comparatorProperty().bind((ObservableValue)this.tableView.comparatorProperty());
        this.sortedList.addListener(this.sortedListChangedListener);
        this.tableView.setItems(this.sortedList);
        this.updateGroupIdColumnVisibility();
        this.updateTriggerColumnVisibility();
        this.updateSelectToggleButtonState();
        this.selectToggleButton.setOnAction(event -> {
            if (((OpenOffersViewModel)this.model).isBootstrappedOrShowPopup()) {
                if (this.selectToggleButton.isSelected()) {
                    this.sortedList.forEach(openOfferListItem -> this.onActivateOpenOffer(openOfferListItem.getOpenOffer()));
                } else {
                    this.sortedList.forEach(openOfferListItem -> this.onDeactivateOpenOffer(openOfferListItem.getOpenOffer()));
                }
            }
            this.tableView.refresh();
        });
        this.numItems.setText(Res.get((String)"shared.numItemsLabel", (Object[])new Object[]{this.sortedList.size()}));
        this.exportButton.setOnAction(event -> {
            CSVEntryConverter headerConverter = item -> {
                String[] columns = new String[ColumnNames.values().length];
                for (ColumnNames m : ColumnNames.values()) {
                    columns[m.ordinal()] = m.toString();
                }
                return columns;
            };
            CSVEntryConverter contentConverter = item -> {
                String[] columns = new String[ColumnNames.values().length];
                columns[ColumnNames.OFFER_ID.ordinal()] = ((OpenOffersViewModel)this.model).getOfferId((OpenOfferListItem)item);
                columns[ColumnNames.GROUP_ID.ordinal()] = this.openOfferManager.hasClonedOffer(item.getOffer().getId()) ? this.getShortenedGroupId(item.getGroupId()) : "";
                columns[ColumnNames.DATE.ordinal()] = ((OpenOffersViewModel)this.model).getDate((OpenOfferListItem)item);
                columns[ColumnNames.MARKET.ordinal()] = ((OpenOffersViewModel)this.model).getMarketLabel((OpenOfferListItem)item);
                columns[ColumnNames.PRICE.ordinal()] = ((OpenOffersViewModel)this.model).getPrice((OpenOfferListItem)item);
                columns[ColumnNames.DEVIATION.ordinal()] = ((OpenOffersViewModel)this.model).getPriceDeviation((OpenOfferListItem)item);
                columns[ColumnNames.TRIGGER_PRICE.ordinal()] = ((OpenOffersViewModel)this.model).getTriggerPrice((OpenOfferListItem)item);
                columns[ColumnNames.AMOUNT.ordinal()] = ((OpenOffersViewModel)this.model).getAmount((OpenOfferListItem)item);
                columns[ColumnNames.VOLUME.ordinal()] = ((OpenOffersViewModel)this.model).getVolume((OpenOfferListItem)item);
                columns[ColumnNames.PAYMENT_METHOD.ordinal()] = ((OpenOffersViewModel)this.model).getPaymentMethod((OpenOfferListItem)item);
                columns[ColumnNames.DIRECTION.ordinal()] = ((OpenOffersViewModel)this.model).getDirectionLabel((OpenOfferListItem)item);
                columns[ColumnNames.STATUS.ordinal()] = String.valueOf(!item.getOpenOffer().isDeactivated());
                return columns;
            };
            GUIUtil.exportCSV("openOffers.csv", headerConverter, contentConverter, new OpenOfferListItem(), this.sortedList, (Stage)((VBox)this.root).getScene().getWindow());
        });
        this.filterTextField.textProperty().addListener(this.filterTextFieldListener);
        this.applyFilteredListPredicate(this.filterTextField.getText());
        ((VBox)this.root).widthProperty().addListener(this.widthListener);
        this.onWidthChange(((VBox)this.root).getWidth());
    }

    private void updateNumberOfOffers() {
        this.numItems.setText(Res.get((String)"shared.numItemsLabel", (Object[])new Object[]{this.sortedList.size()}));
    }

    private void updateGroupIdColumnVisibility() {
        this.groupIdColumn.setVisible(this.openOfferManager.hasClonedOffers());
    }

    private void updateTriggerColumnVisibility() {
        this.triggerIconColumn.setVisible(((OpenOffersDataModel)((OpenOffersViewModel)this.model).dataModel).getList().stream().mapToLong(item -> item.getOpenOffer().getTriggerPrice()).sum() > 0L);
    }

    @Override
    protected void deactivate() {
        this.sortedList.comparatorProperty().unbind();
        this.sortedList.removeListener(this.sortedListChangedListener);
        this.exportButton.setOnAction(null);
        this.filterTextField.textProperty().removeListener(this.filterTextFieldListener);
        ((VBox)this.root).widthProperty().removeListener(this.widthListener);
    }

    private void refresh() {
        this.tableView.refresh();
        this.updateSelectToggleButtonState();
    }

    private void updateSelectToggleButtonState() {
        List availableItems = this.sortedList.stream().filter(openOfferListItem -> !openOfferListItem.getOpenOffer().isPending()).collect(Collectors.toList());
        if (availableItems.size() == 0) {
            this.selectToggleButton.setDisable(true);
            this.selectToggleButton.setSelected(false);
        } else {
            this.selectToggleButton.setDisable(false);
            long numDeactivated = availableItems.stream().filter(openOfferListItem -> openOfferListItem.getOpenOffer().isDeactivated()).count();
            if (numDeactivated == (long)availableItems.size()) {
                this.selectToggleButton.setSelected(false);
            } else if (numDeactivated == 0L) {
                this.selectToggleButton.setSelected(true);
            }
        }
    }

    private void applyFilteredListPredicate(String filterString) {
        this.filteredList.setPredicate(item -> {
            if (filterString.isEmpty()) {
                return true;
            }
            Offer offer = item.getOpenOffer().getOffer();
            if (offer.getId().toLowerCase().contains(filterString.toLowerCase())) {
                return true;
            }
            if (((OpenOffersViewModel)this.model).getDate((OpenOfferListItem)item).toLowerCase().contains(filterString.toLowerCase())) {
                return true;
            }
            if (((OpenOffersViewModel)this.model).getMarketLabel((OpenOfferListItem)item).toLowerCase().contains(filterString.toLowerCase())) {
                return true;
            }
            if (((OpenOffersViewModel)this.model).getPrice((OpenOfferListItem)item).toLowerCase().contains(filterString.toLowerCase())) {
                return true;
            }
            if (((OpenOffersViewModel)this.model).getPriceDeviation((OpenOfferListItem)item).toLowerCase().contains(filterString.toLowerCase())) {
                return true;
            }
            if (((OpenOffersViewModel)this.model).getPaymentMethod((OpenOfferListItem)item).toLowerCase().contains(filterString.toLowerCase())) {
                return true;
            }
            if (((OpenOffersViewModel)this.model).getVolume((OpenOfferListItem)item).toLowerCase().contains(filterString.toLowerCase())) {
                return true;
            }
            if (((OpenOffersViewModel)this.model).getAmount((OpenOfferListItem)item).toLowerCase().contains(filterString.toLowerCase())) {
                return true;
            }
            if (((OpenOffersViewModel)this.model).getDirectionLabel((OpenOfferListItem)item).toLowerCase().contains(filterString.toLowerCase())) {
                return true;
            }
            return item.getOffer().getCombinedExtraInfo() != null && item.getOffer().getCombinedExtraInfo().toLowerCase().contains(filterString.toLowerCase());
        });
    }

    private void onWidthChange(double width) {
        this.triggerPriceColumn.setVisible(width > 1300.0);
    }

    private void onDeactivateOpenOffer(OpenOffer openOffer) {
        if (((OpenOffersViewModel)this.model).isBootstrappedOrShowPopup()) {
            ((OpenOffersViewModel)this.model).onDeactivateOpenOffer(openOffer, () -> this.log.debug("Deactivate offer was successful"), message -> {
                this.log.error(message);
                ((Popup)new Popup().warning(message)).show();
            });
            this.updateSelectToggleButtonState();
        }
    }

    private void onActivateOpenOffer(OpenOffer openOffer) {
        if (((OpenOffersViewModel)this.model).isBootstrappedOrShowPopup() && !((OpenOffersDataModel)((OpenOffersViewModel)this.model).dataModel).isTriggered(openOffer)) {
            ((OpenOffersViewModel)this.model).onActivateOpenOffer(openOffer, () -> this.log.debug("Activate offer was successful"), message -> {
                this.log.error(message);
                ((Popup)new Popup().warning(Res.get((String)"offerbook.activateOffer.failed", (Object[])new Object[]{message}))).show();
            });
            this.updateSelectToggleButtonState();
        }
    }

    private void onRemoveOpenOffer(OpenOffer openOffer) {
        if (((OpenOffersViewModel)this.model).isBootstrappedOrShowPopup()) {
            String key = "RemoveOfferWarning";
            if (DontShowAgainLookup.showAgain((String)key)) {
                ((Popup)((Popup)((Popup)((Popup)((Popup)new Popup().warning(Res.get((String)"popup.warning.removeOffer"))).actionButtonText(Res.get((String)"shared.removeOffer"))).onAction(() -> this.doRemoveOpenOffer(openOffer))).closeButtonText(Res.get((String)"shared.dontRemoveOffer"))).dontShowAgainId(key)).show();
            } else {
                this.doRemoveOpenOffer(openOffer);
            }
            this.updateSelectToggleButtonState();
        }
    }

    private void doRemoveOpenOffer(OpenOffer openOffer) {
        boolean hasClonedOffer = this.openOfferManager.hasClonedOffer(openOffer.getId());
        ((OpenOffersViewModel)this.model).onRemoveOpenOffer(openOffer, () -> {
            this.log.debug("Remove offer was successful");
            this.tableView.refresh();
            if (hasClonedOffer) {
                return;
            }
            String key = "WithdrawFundsAfterRemoveOfferInfo";
            if (DontShowAgainLookup.showAgain((String)key)) {
                ((Popup)((Popup)((Popup)((Popup)new Popup().instruction(Res.get((String)"offerbook.withdrawFundsHint", (Object[])new Object[]{Res.get((String)"funds.tab.withdrawal")}))).actionButtonTextWithGoTo("funds.tab.withdrawal")).onAction(() -> this.navigation.navigateTo(MainView.class, FundsView.class, WithdrawalView.class))).dontShowAgainId(key)).show();
            }
        }, message -> {
            this.log.error(message);
            ((Popup)new Popup().warning(Res.get((String)"offerbook.removeOffer.failed", (Object[])new Object[]{message}))).show();
        });
    }

    private void onEditOpenOffer(OpenOffer openOffer) {
        if (((OpenOffersViewModel)this.model).isBootstrappedOrShowPopup()) {
            this.editOpenOfferHandler.onEditOpenOffer(openOffer);
        }
    }

    private void onDuplicateOffer(OpenOfferListItem item) {
        if (item == null || item.getOffer().getOfferPayload() == null) {
            return;
        }
        if (((OpenOffersViewModel)this.model).isBootstrappedOrShowPopup()) {
            PortfolioUtil.duplicateOffer(this.navigation, item.getOffer().getOfferPayload());
        }
    }

    private void onCloneOffer(OpenOfferListItem item) {
        if (item == null) {
            return;
        }
        if (((OpenOffersViewModel)this.model).isBootstrappedOrShowPopup()) {
            String key = "clonedOfferInfo";
            if (DontShowAgainLookup.showAgain((String)key)) {
                ((Popup)((Popup)((Popup)((Popup)((Popup)new Popup().headLine(Res.get((String)"offerbook.clonedOffer.headline"))).instruction(Res.get((String)"offerbook.clonedOffer.info"))).useIUnderstandButton()).dontShowAgainId(key)).onClose(() -> this.doCloneOffer(item))).show();
            } else {
                this.doCloneOffer(item);
            }
        }
    }

    private void doCloneOffer(OpenOfferListItem item) {
        OpenOffer openOffer = item.getOpenOffer();
        if (openOffer == null || openOffer.getOffer() == null || openOffer.getOffer().getOfferPayload() == null) {
            return;
        }
        this.cloneOpenOfferHandler.onCloneOpenOffer(openOffer);
    }

    private void setOfferIdColumnCellFactory() {
        this.offerIdColumn.setCellValueFactory(openOfferListItem -> new ReadOnlyObjectWrapper((Object)((OpenOfferListItem)openOfferListItem.getValue())));
        this.offerIdColumn.getStyleClass().addAll((Object[])new String[]{"number-column"});
        this.offerIdColumn.setCellFactory((Callback)new Callback<TableColumn<OpenOfferListItem, OpenOfferListItem>, TableCell<OpenOfferListItem, OpenOfferListItem>>(){

            public TableCell<OpenOfferListItem, OpenOfferListItem> call(TableColumn<OpenOfferListItem, OpenOfferListItem> column) {
                return new TableCell<OpenOfferListItem, OpenOfferListItem>(){
                    private HyperlinkWithIcon hyperlinkWithIcon;

                    public void updateItem(OpenOfferListItem item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null && !empty) {
                            this.hyperlinkWithIcon = new HyperlinkWithIcon(item.getOffer().getShortId());
                            if (((OpenOffersViewModel)OpenOffersView.this.model).isDeactivated(item)) {
                                this.hyperlinkWithIcon.setStyle("-fx-text-fill: -bs-color-gray-3;");
                                this.hyperlinkWithIcon.getIcon().setOpacity(0.2);
                            }
                            this.hyperlinkWithIcon.setOnAction(event -> OpenOffersView.this.offerDetailsWindow.show(item.getOffer()));
                            this.hyperlinkWithIcon.setTooltip(new Tooltip(Res.get((String)"tooltip.openPopupForDetails")));
                            this.setGraphic((Node)this.hyperlinkWithIcon);
                        } else {
                            this.setGraphic(null);
                            if (this.hyperlinkWithIcon != null) {
                                this.hyperlinkWithIcon.setOnAction(null);
                            }
                        }
                    }
                };
            }
        });
    }

    private void setGroupIdCellFactory() {
        this.groupIdColumn.setCellValueFactory(offerListItem -> new ReadOnlyObjectWrapper((Object)((OpenOfferListItem)offerListItem.getValue())));
        this.groupIdColumn.setCellFactory((Callback)new Callback<TableColumn<OpenOfferListItem, OpenOfferListItem>, TableCell<OpenOfferListItem, OpenOfferListItem>>(){

            public TableCell<OpenOfferListItem, OpenOfferListItem> call(TableColumn<OpenOfferListItem, OpenOfferListItem> column) {
                return new TableCell<OpenOfferListItem, OpenOfferListItem>(){

                    public void updateItem(OpenOfferListItem item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        this.getStyleClass().removeAll((Object[])new String[]{"offer-disabled"});
                        if (item != null) {
                            Text icon;
                            Label label;
                            if (OpenOffersView.this.openOfferManager.hasClonedOffer(item.getOpenOffer().getId())) {
                                label = new Label(OpenOffersView.this.getShortenedGroupId(item.getOpenOffer().getGroupId()));
                                icon = FormBuilder.getRegularIconForLabel((GlyphIcons)MaterialDesignIcon.LINK, label, "icon");
                                icon.setVisible(true);
                                this.setTooltip(new Tooltip(Res.get((String)"offerbook.clonedOffer.tooltip", (Object[])new Object[]{item.getOpenOffer().getReserveTxHash()})));
                            } else {
                                label = new Label("");
                                icon = FormBuilder.getRegularIconForLabel((GlyphIcons)MaterialDesignIcon.LINK_OFF, label, "icon");
                                icon.setVisible(false);
                                this.setTooltip(new Tooltip(Res.get((String)"offerbook.nonClonedOffer.tooltip", (Object[])new Object[]{item.getOpenOffer().getReserveTxHash()})));
                            }
                            if (((OpenOffersViewModel)OpenOffersView.this.model).isDeactivated(item)) {
                                this.getStyleClass().add((Object)"offer-disabled");
                                icon.setOpacity(0.2);
                            }
                            this.setGraphic((Node)label);
                        } else {
                            this.setGraphic(null);
                        }
                    }
                };
            }
        });
    }

    private String getShortenedGroupId(String groupId) {
        if (groupId.length() > 5) {
            return groupId.substring(0, 5);
        }
        return groupId;
    }

    private void setDateColumnCellFactory() {
        this.dateColumn.setCellValueFactory(openOfferListItem -> new ReadOnlyObjectWrapper((Object)((OpenOfferListItem)openOfferListItem.getValue())));
        this.dateColumn.setCellFactory((Callback)new Callback<TableColumn<OpenOfferListItem, OpenOfferListItem>, TableCell<OpenOfferListItem, OpenOfferListItem>>(){

            public TableCell<OpenOfferListItem, OpenOfferListItem> call(TableColumn<OpenOfferListItem, OpenOfferListItem> column) {
                return new TableCell<OpenOfferListItem, OpenOfferListItem>(){

                    public void updateItem(OpenOfferListItem item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        this.getStyleClass().removeAll((Object[])new String[]{"offer-disabled"});
                        if (item != null) {
                            if (((OpenOffersViewModel)OpenOffersView.this.model).isDeactivated(item)) {
                                this.getStyleClass().add((Object)"offer-disabled");
                            }
                            this.setGraphic((Node)new AutoTooltipLabel(((OpenOffersViewModel)OpenOffersView.this.model).getDate(item)));
                        } else {
                            this.setGraphic(null);
                        }
                    }
                };
            }
        });
    }

    private void setAmountColumnCellFactory() {
        this.amountColumn.setCellValueFactory(offer -> new ReadOnlyObjectWrapper((Object)((OpenOfferListItem)offer.getValue())));
        this.amountColumn.setCellFactory((Callback)new Callback<TableColumn<OpenOfferListItem, OpenOfferListItem>, TableCell<OpenOfferListItem, OpenOfferListItem>>(){

            public TableCell<OpenOfferListItem, OpenOfferListItem> call(TableColumn<OpenOfferListItem, OpenOfferListItem> column) {
                return new TableCell<OpenOfferListItem, OpenOfferListItem>(){

                    public void updateItem(OpenOfferListItem item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        this.getStyleClass().removeAll((Object[])new String[]{"offer-disabled"});
                        if (item != null) {
                            if (((OpenOffersViewModel)OpenOffersView.this.model).isDeactivated(item)) {
                                this.getStyleClass().add((Object)"offer-disabled");
                            }
                            this.setGraphic((Node)new AutoTooltipLabel(((OpenOffersViewModel)OpenOffersView.this.model).getAmount(item)));
                        } else {
                            this.setGraphic(null);
                        }
                    }
                };
            }
        });
    }

    private void setPriceColumnCellFactory() {
        this.priceColumn.setCellValueFactory(offer -> new ReadOnlyObjectWrapper((Object)((OpenOfferListItem)offer.getValue())));
        this.priceColumn.setCellFactory((Callback)new Callback<TableColumn<OpenOfferListItem, OpenOfferListItem>, TableCell<OpenOfferListItem, OpenOfferListItem>>(){

            public TableCell<OpenOfferListItem, OpenOfferListItem> call(TableColumn<OpenOfferListItem, OpenOfferListItem> column) {
                return new TableCell<OpenOfferListItem, OpenOfferListItem>(){

                    public void updateItem(OpenOfferListItem item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        this.getStyleClass().removeAll((Object[])new String[]{"offer-disabled"});
                        if (item != null) {
                            if (((OpenOffersViewModel)OpenOffersView.this.model).isDeactivated(item)) {
                                this.getStyleClass().add((Object)"offer-disabled");
                            }
                            this.setGraphic((Node)new AutoTooltipLabel(((OpenOffersViewModel)OpenOffersView.this.model).getPrice(item)));
                        } else {
                            this.setGraphic(null);
                        }
                    }
                };
            }
        });
    }

    private void setDeviationColumnCellFactory() {
        this.deviationColumn.setCellValueFactory(offer -> new ReadOnlyObjectWrapper((Object)((OpenOfferListItem)offer.getValue())));
        this.deviationColumn.setCellFactory((Callback)new Callback<TableColumn<OpenOfferListItem, OpenOfferListItem>, TableCell<OpenOfferListItem, OpenOfferListItem>>(){

            public TableCell<OpenOfferListItem, OpenOfferListItem> call(TableColumn<OpenOfferListItem, OpenOfferListItem> column) {
                return new TableCell<OpenOfferListItem, OpenOfferListItem>(){

                    public void updateItem(OpenOfferListItem item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        this.getStyleClass().removeAll((Object[])new String[]{"offer-disabled"});
                        if (item != null) {
                            if (((OpenOffersViewModel)OpenOffersView.this.model).isDeactivated(item)) {
                                this.getStyleClass().add((Object)"offer-disabled");
                            }
                            AutoTooltipLabel autoTooltipLabel = new AutoTooltipLabel(((OpenOffersViewModel)OpenOffersView.this.model).getPriceDeviation(item));
                            autoTooltipLabel.setOpacity(item.getOffer().isUseMarketBasedPrice() ? 1.0 : 0.4);
                            this.setGraphic((Node)autoTooltipLabel);
                        } else {
                            this.setGraphic(null);
                        }
                    }
                };
            }
        });
    }

    private void setTriggerPriceColumnCellFactory() {
        this.triggerPriceColumn.setCellValueFactory(offerListItem -> new ReadOnlyObjectWrapper((Object)((OpenOfferListItem)offerListItem.getValue())));
        this.triggerPriceColumn.setCellFactory((Callback)new Callback<TableColumn<OpenOfferListItem, OpenOfferListItem>, TableCell<OpenOfferListItem, OpenOfferListItem>>(){

            public TableCell<OpenOfferListItem, OpenOfferListItem> call(TableColumn<OpenOfferListItem, OpenOfferListItem> column) {
                return new TableCell<OpenOfferListItem, OpenOfferListItem>(){

                    public void updateItem(OpenOfferListItem item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        this.getStyleClass().removeAll((Object[])new String[]{"offer-disabled"});
                        if (item != null) {
                            if (((OpenOffersViewModel)OpenOffersView.this.model).isDeactivated(item)) {
                                this.getStyleClass().add((Object)"offer-disabled");
                            }
                            this.setGraphic((Node)new AutoTooltipLabel(((OpenOffersViewModel)OpenOffersView.this.model).getTriggerPrice(item)));
                        } else {
                            this.setGraphic(null);
                        }
                    }
                };
            }
        });
    }

    private void setVolumeColumnCellFactory() {
        this.volumeColumn.setCellValueFactory(offer -> new ReadOnlyObjectWrapper((Object)((OpenOfferListItem)offer.getValue())));
        this.volumeColumn.setCellFactory((Callback)new Callback<TableColumn<OpenOfferListItem, OpenOfferListItem>, TableCell<OpenOfferListItem, OpenOfferListItem>>(){

            public TableCell<OpenOfferListItem, OpenOfferListItem> call(TableColumn<OpenOfferListItem, OpenOfferListItem> column) {
                return new TableCell<OpenOfferListItem, OpenOfferListItem>(){

                    public void updateItem(OpenOfferListItem item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        this.getStyleClass().removeAll((Object[])new String[]{"offer-disabled"});
                        if (item != null) {
                            if (((OpenOffersViewModel)OpenOffersView.this.model).isDeactivated(item)) {
                                this.getStyleClass().add((Object)"offer-disabled");
                            }
                            this.setGraphic((Node)new AutoTooltipLabel(((OpenOffersViewModel)OpenOffersView.this.model).getVolume(item)));
                        } else {
                            this.setGraphic(null);
                        }
                    }
                };
            }
        });
    }

    private void setPaymentMethodColumnCellFactory() {
        this.paymentMethodColumn.setCellValueFactory(offer -> new ReadOnlyObjectWrapper((Object)((OpenOfferListItem)offer.getValue())));
        this.paymentMethodColumn.setCellFactory((Callback)new Callback<TableColumn<OpenOfferListItem, OpenOfferListItem>, TableCell<OpenOfferListItem, OpenOfferListItem>>(){

            public TableCell<OpenOfferListItem, OpenOfferListItem> call(TableColumn<OpenOfferListItem, OpenOfferListItem> column) {
                return new TableCell<OpenOfferListItem, OpenOfferListItem>(){

                    public void updateItem(OpenOfferListItem item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        this.getStyleClass().removeAll((Object[])new String[]{"offer-disabled"});
                        if (item != null) {
                            if (((OpenOffersViewModel)OpenOffersView.this.model).isDeactivated(item)) {
                                this.getStyleClass().add((Object)"offer-disabled");
                            }
                            this.setGraphic((Node)new AutoTooltipLabel(((OpenOffersViewModel)OpenOffersView.this.model).getPaymentMethod(item)));
                        } else {
                            this.setGraphic(null);
                        }
                    }
                };
            }
        });
    }

    private void setDirectionColumnCellFactory() {
        this.directionColumn.setCellValueFactory(offer -> new ReadOnlyObjectWrapper((Object)((OpenOfferListItem)offer.getValue())));
        this.directionColumn.setCellFactory((Callback)new Callback<TableColumn<OpenOfferListItem, OpenOfferListItem>, TableCell<OpenOfferListItem, OpenOfferListItem>>(){

            public TableCell<OpenOfferListItem, OpenOfferListItem> call(TableColumn<OpenOfferListItem, OpenOfferListItem> column) {
                return new TableCell<OpenOfferListItem, OpenOfferListItem>(){

                    public void updateItem(OpenOfferListItem item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        this.getStyleClass().removeAll((Object[])new String[]{"offer-disabled"});
                        if (item != null) {
                            if (((OpenOffersViewModel)OpenOffersView.this.model).isDeactivated(item)) {
                                this.getStyleClass().add((Object)"offer-disabled");
                            }
                            this.setGraphic((Node)new AutoTooltipLabel(((OpenOffersViewModel)OpenOffersView.this.model).getDirectionLabel(item)));
                        } else {
                            this.setGraphic(null);
                        }
                    }
                };
            }
        });
    }

    private void setMarketColumnCellFactory() {
        this.marketColumn.setCellValueFactory(offer -> new ReadOnlyObjectWrapper((Object)((OpenOfferListItem)offer.getValue())));
        this.marketColumn.setCellFactory((Callback)new Callback<TableColumn<OpenOfferListItem, OpenOfferListItem>, TableCell<OpenOfferListItem, OpenOfferListItem>>(){

            public TableCell<OpenOfferListItem, OpenOfferListItem> call(TableColumn<OpenOfferListItem, OpenOfferListItem> column) {
                return new TableCell<OpenOfferListItem, OpenOfferListItem>(){

                    public void updateItem(OpenOfferListItem item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        this.getStyleClass().removeAll((Object[])new String[]{"offer-disabled"});
                        if (item != null) {
                            if (((OpenOffersViewModel)OpenOffersView.this.model).isDeactivated(item)) {
                                this.getStyleClass().add((Object)"offer-disabled");
                            }
                            this.setGraphic((Node)new AutoTooltipLabel(((OpenOffersViewModel)OpenOffersView.this.model).getMarketLabel(item)));
                        } else {
                            this.setGraphic(null);
                        }
                    }
                };
            }
        });
    }

    private void setDeactivateColumnCellFactory() {
        this.deactivateItemColumn.setCellValueFactory(offerListItem -> new ReadOnlyObjectWrapper((Object)((OpenOfferListItem)offerListItem.getValue())));
        this.deactivateItemColumn.setCellFactory((Callback)new Callback<TableColumn<OpenOfferListItem, OpenOfferListItem>, TableCell<OpenOfferListItem, OpenOfferListItem>>(){

            public TableCell<OpenOfferListItem, OpenOfferListItem> call(TableColumn<OpenOfferListItem, OpenOfferListItem> column) {
                return new TableCell<OpenOfferListItem, OpenOfferListItem>(){
                    final ImageView iconView = new ImageView();
                    AutoTooltipSlideToggleButton checkBox;

                    private void updateState(@NotNull OpenOffer openOffer) {
                        if (this.checkBox != null) {
                            this.checkBox.setSelected(openOffer.getState() == OpenOffer.State.AVAILABLE);
                        }
                    }

                    public void updateItem(OpenOfferListItem item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null && !empty) {
                            OpenOffer openOffer = item.getOpenOffer();
                            if (OpenOffersView.this.offerStateChangeListeners.containsKey(openOffer.getId())) {
                                openOffer.stateProperty().removeListener(OpenOffersView.this.offerStateChangeListeners.get(openOffer.getId()));
                                OpenOffersView.this.offerStateChangeListeners.remove(openOffer.getId());
                            }
                            ChangeListener listener = (observable, oldValue, newValue) -> {
                                if (oldValue != newValue) {
                                    OpenOffersView.this.refresh();
                                }
                            };
                            OpenOffersView.this.offerStateChangeListeners.put(openOffer.getId(), (ChangeListener<OpenOffer.State>)listener);
                            openOffer.stateProperty().addListener(listener);
                            if (openOffer.getState() == OpenOffer.State.PENDING) {
                                this.setGraphic((Node)new AutoTooltipLabel(Res.get((String)"shared.pending")));
                                return;
                            }
                            if (this.checkBox == null) {
                                this.checkBox = new AutoTooltipSlideToggleButton();
                                this.checkBox.setPadding(new Insets(-7.0, 0.0, -7.0, 0.0));
                                this.checkBox.setGraphic((Node)this.iconView);
                            }
                            this.checkBox.setDisable(((OpenOffersDataModel)((OpenOffersViewModel)((OpenOffersView)OpenOffersView.this).model).dataModel).isTriggered(openOffer));
                            this.checkBox.setOnAction(event -> {
                                if (openOffer.isDeactivated()) {
                                    OpenOffersView.this.onActivateOpenOffer(openOffer);
                                } else {
                                    OpenOffersView.this.onDeactivateOpenOffer(openOffer);
                                }
                                this.updateState(openOffer);
                                OpenOffersView.this.tableView.refresh();
                            });
                            this.updateState(openOffer);
                            this.setGraphic((Node)this.checkBox);
                        } else {
                            this.setGraphic(null);
                            if (this.checkBox != null) {
                                this.checkBox.setOnAction(null);
                                this.checkBox = null;
                            }
                        }
                    }
                };
            }
        });
    }

    private void setRemoveColumnCellFactory() {
        this.removeItemColumn.getStyleClass().addAll((Object[])new String[]{"avatar-column"});
        this.removeItemColumn.setCellValueFactory(offerListItem -> new ReadOnlyObjectWrapper((Object)((OpenOfferListItem)offerListItem.getValue())));
        this.removeItemColumn.setCellFactory((Callback)new Callback<TableColumn<OpenOfferListItem, OpenOfferListItem>, TableCell<OpenOfferListItem, OpenOfferListItem>>(){

            public TableCell<OpenOfferListItem, OpenOfferListItem> call(TableColumn<OpenOfferListItem, OpenOfferListItem> column) {
                return new TableCell<OpenOfferListItem, OpenOfferListItem>(){
                    Button button;

                    public void updateItem(OpenOfferListItem item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null && !empty) {
                            if (this.button == null) {
                                this.button = FormBuilder.getRegularIconButton((GlyphIcons)MaterialDesignIcon.DELETE_FOREVER, "delete");
                                this.button.setTooltip(new Tooltip(Res.get((String)"shared.removeOffer")));
                                this.setGraphic((Node)this.button);
                            }
                            this.button.setOnAction(event -> OpenOffersView.this.onRemoveOpenOffer(item.getOpenOffer()));
                        } else {
                            this.setGraphic(null);
                            if (this.button != null) {
                                this.button.setOnAction(null);
                                this.button = null;
                            }
                        }
                    }
                };
            }
        });
    }

    private void setDuplicateColumnCellFactory() {
        this.duplicateItemColumn.getStyleClass().add((Object)"avatar-column");
        this.duplicateItemColumn.setCellValueFactory(offerListItem -> new ReadOnlyObjectWrapper((Object)((OpenOfferListItem)offerListItem.getValue())));
        this.duplicateItemColumn.setCellFactory((Callback)new Callback<TableColumn<OpenOfferListItem, OpenOfferListItem>, TableCell<OpenOfferListItem, OpenOfferListItem>>(){

            public TableCell<OpenOfferListItem, OpenOfferListItem> call(TableColumn<OpenOfferListItem, OpenOfferListItem> column) {
                return new TableCell<OpenOfferListItem, OpenOfferListItem>(){
                    Button button;

                    public void updateItem(OpenOfferListItem item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null && !empty) {
                            if (this.button == null) {
                                this.button = FormBuilder.getRegularIconButton((GlyphIcons)MaterialDesignIcon.CONTENT_COPY);
                                this.button.setTooltip(new Tooltip(Res.get((String)"portfolio.context.offerLikeThis")));
                                this.setGraphic((Node)this.button);
                            }
                            this.button.setOnAction(event -> OpenOffersView.this.onDuplicateOffer(item));
                        } else {
                            this.setGraphic(null);
                            if (this.button != null) {
                                this.button.setOnAction(null);
                                this.button = null;
                            }
                        }
                    }
                };
            }
        });
    }

    private void setCloneColumnCellFactory() {
        this.cloneItemColumn.getStyleClass().add((Object)"avatar-column");
        this.cloneItemColumn.setCellValueFactory(offerListItem -> new ReadOnlyObjectWrapper((Object)((OpenOfferListItem)offerListItem.getValue())));
        this.cloneItemColumn.setCellFactory((Callback)new Callback<TableColumn<OpenOfferListItem, OpenOfferListItem>, TableCell<OpenOfferListItem, OpenOfferListItem>>(){

            public TableCell<OpenOfferListItem, OpenOfferListItem> call(TableColumn<OpenOfferListItem, OpenOfferListItem> column) {
                return new TableCell<OpenOfferListItem, OpenOfferListItem>(){
                    Button button;

                    public void updateItem(OpenOfferListItem item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null && !empty) {
                            if (this.button == null) {
                                this.button = FormBuilder.getRegularIconButton((GlyphIcons)MaterialDesignIcon.BOX_SHADOW);
                                this.button.setTooltip(new Tooltip(Res.get((String)"offerbook.cloneOffer")));
                                this.setGraphic((Node)this.button);
                            }
                            this.button.setOnAction(event -> OpenOffersView.this.onCloneOffer(item));
                        } else {
                            this.setGraphic(null);
                            if (this.button != null) {
                                this.button.setOnAction(null);
                                this.button = null;
                            }
                        }
                    }
                };
            }
        });
    }

    private void setTriggerIconColumnCellFactory() {
        this.triggerIconColumn.setCellValueFactory(offerListItem -> new ReadOnlyObjectWrapper((Object)((OpenOfferListItem)offerListItem.getValue())));
        this.triggerIconColumn.setCellFactory((Callback)new Callback<TableColumn<OpenOfferListItem, OpenOfferListItem>, TableCell<OpenOfferListItem, OpenOfferListItem>>(){

            public TableCell<OpenOfferListItem, OpenOfferListItem> call(TableColumn<OpenOfferListItem, OpenOfferListItem> column) {
                return new TableCell<OpenOfferListItem, OpenOfferListItem>(){
                    private final Button button = FormBuilder.getRegularIconButton((GlyphIcons)MaterialDesignIcon.SHIELD_HALF_FULL);

                    protected void updateItem(OpenOfferListItem item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item == null || empty) {
                            this.setGraphic(null);
                            this.button.setOnAction(null);
                            return;
                        }
                        boolean triggerPriceSet = item.getOpenOffer().getTriggerPrice() > 0L;
                        this.button.setVisible(triggerPriceSet);
                        if (((OpenOffersDataModel)((OpenOffersViewModel)((OpenOffersView)OpenOffersView.this).model).dataModel).isTriggered(item.getOpenOffer())) {
                            this.button.getGraphic().getStyleClass().add((Object)"warning");
                            this.button.setTooltip(new Tooltip(Res.get((String)"openOffer.triggered")));
                        } else {
                            this.button.getGraphic().getStyleClass().remove((Object)"warning");
                            this.button.setTooltip(new Tooltip(Res.get((String)"openOffer.triggerPrice", (Object[])new Object[]{((OpenOffersViewModel)OpenOffersView.this.model).getTriggerPrice(item)})));
                        }
                        this.button.setOnAction(e -> OpenOffersView.this.onEditOpenOffer(item.getOpenOffer()));
                        this.setGraphic((Node)this.button);
                    }
                };
            }
        });
    }

    private void setEditColumnCellFactory() {
        this.editItemColumn.setCellValueFactory(offerListItem -> new ReadOnlyObjectWrapper((Object)((OpenOfferListItem)offerListItem.getValue())));
        this.editItemColumn.setCellFactory((Callback)new Callback<TableColumn<OpenOfferListItem, OpenOfferListItem>, TableCell<OpenOfferListItem, OpenOfferListItem>>(){

            public TableCell<OpenOfferListItem, OpenOfferListItem> call(TableColumn<OpenOfferListItem, OpenOfferListItem> column) {
                return new TableCell<OpenOfferListItem, OpenOfferListItem>(){
                    Button button;

                    public void updateItem(OpenOfferListItem item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null && !empty) {
                            if (this.button == null) {
                                this.button = FormBuilder.getRegularIconButton((GlyphIcons)MaterialDesignIcon.PENCIL);
                                this.button.setTooltip(new Tooltip(Res.get((String)"shared.editOffer")));
                                this.setGraphic((Node)this.button);
                            }
                            this.button.setOnAction(event -> OpenOffersView.this.onEditOpenOffer(item.getOpenOffer()));
                        } else {
                            this.setGraphic(null);
                            if (this.button != null) {
                                this.button.setOnAction(null);
                                this.button = null;
                            }
                        }
                    }
                };
            }
        });
    }

    public void setEditOpenOfferHandler(PortfolioView.EditOpenOfferHandler editOpenOfferHandler) {
        this.editOpenOfferHandler = editOpenOfferHandler;
    }

    public void setCloneOpenOfferHandler(PortfolioView.CloneOpenOfferHandler cloneOpenOfferHandler) {
        this.cloneOpenOfferHandler = cloneOpenOfferHandler;
    }

    private static enum ColumnNames {
        OFFER_ID(Res.get((String)"shared.offerId")),
        GROUP_ID(Res.get((String)"openOffer.header.groupId")),
        DATE(Res.get((String)"shared.dateTime")),
        MARKET(Res.get((String)"shared.market")),
        PRICE(Res.get((String)"shared.price")),
        DEVIATION(Res.get((String)"shared.deviation")),
        TRIGGER_PRICE(Res.get((String)"openOffer.header.triggerPrice")),
        AMOUNT(Res.get((String)"shared.XMRMinMax")),
        VOLUME(Res.get((String)"shared.amountMinMax")),
        PAYMENT_METHOD(Res.get((String)"shared.paymentMethod")),
        DIRECTION(Res.get((String)"shared.offerType")),
        STATUS(Res.get((String)"shared.state"));

        private final String text;

        private ColumnNames(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }
    }
}

