/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.portfolio.openoffer;

import com.google.inject.Inject;
import haveno.common.UserThread;
import haveno.common.handlers.ErrorMessageHandler;
import haveno.common.handlers.ResultHandler;
import haveno.core.offer.Offer;
import haveno.core.offer.OfferDirection;
import haveno.core.offer.OpenOffer;
import haveno.core.offer.OpenOfferManager;
import haveno.core.offer.TriggerPriceService;
import haveno.core.provider.price.MarketPrice;
import haveno.core.provider.price.PriceFeedService;
import haveno.desktop.common.model.ActivatableDataModel;
import haveno.desktop.main.portfolio.openoffer.OpenOfferListItem;
import java.util.Collection;
import java.util.stream.Collectors;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;

class OpenOffersDataModel
extends ActivatableDataModel {
    private final OpenOfferManager openOfferManager;
    private final PriceFeedService priceFeedService;
    private final ObservableList<OpenOfferListItem> list = FXCollections.observableArrayList();
    private final ListChangeListener<OpenOffer> tradesListChangeListener;
    private final ChangeListener<Number> currenciesUpdateFlagPropertyListener;

    @Inject
    public OpenOffersDataModel(OpenOfferManager openOfferManager, PriceFeedService priceFeedService) {
        this.openOfferManager = openOfferManager;
        this.priceFeedService = priceFeedService;
        this.tradesListChangeListener = change -> UserThread.execute(() -> this.applyList());
        this.currenciesUpdateFlagPropertyListener = (observable, oldValue, newValue) -> UserThread.execute(() -> this.applyList());
    }

    @Override
    protected void activate() {
        this.openOfferManager.getObservableList().addListener(this.tradesListChangeListener);
        this.priceFeedService.updateCounterProperty().addListener(this.currenciesUpdateFlagPropertyListener);
        this.applyList();
    }

    @Override
    protected void deactivate() {
        this.openOfferManager.getObservableList().removeListener(this.tradesListChangeListener);
        this.priceFeedService.updateCounterProperty().removeListener(this.currenciesUpdateFlagPropertyListener);
    }

    void onActivateOpenOffer(OpenOffer openOffer, ResultHandler resultHandler, ErrorMessageHandler errorMessageHandler) {
        this.openOfferManager.activateOpenOffer(openOffer, resultHandler, errorMessageHandler);
    }

    void onDeactivateOpenOffer(OpenOffer openOffer, ResultHandler resultHandler, ErrorMessageHandler errorMessageHandler) {
        this.openOfferManager.deactivateOpenOffer(openOffer, false, resultHandler, errorMessageHandler);
    }

    void onRemoveOpenOffer(OpenOffer openOffer, ResultHandler resultHandler, ErrorMessageHandler errorMessageHandler) {
        this.openOfferManager.cancelOpenOffer(openOffer, resultHandler, errorMessageHandler);
    }

    public ObservableList<OpenOfferListItem> getList() {
        return this.list;
    }

    public OfferDirection getDirection(Offer offer) {
        return this.openOfferManager.isMyOffer(offer) ? offer.getDirection() : offer.getMirroredDirection();
    }

    private synchronized void applyList() {
        this.list.clear();
        this.list.addAll((Collection)this.openOfferManager.getOpenOffers().stream().map(OpenOfferListItem::new).collect(Collectors.toList()));
        this.list.sort((o1, o2) -> o2.getOffer().getDate().compareTo(o1.getOffer().getDate()));
    }

    boolean isTriggered(OpenOffer openOffer) {
        return TriggerPriceService.isTriggered((MarketPrice)this.priceFeedService.getMarketPrice(openOffer.getOffer().getCounterCurrencyCode()), (OpenOffer)openOffer);
    }
}

