/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.portfolio.failedtrades;

import haveno.core.locale.CurrencyUtil;
import haveno.core.locale.Res;
import haveno.core.monetary.Price;
import haveno.core.monetary.Volume;
import haveno.core.offer.Offer;
import haveno.core.offer.OfferDirection;
import haveno.core.trade.ArbitratorTrade;
import haveno.core.trade.HavenoUtils;
import haveno.core.trade.Trade;
import haveno.core.trade.failed.FailedTradesManager;
import haveno.core.util.FormattingUtils;
import haveno.core.util.VolumeUtil;
import haveno.desktop.util.DisplayUtils;
import haveno.desktop.util.filtering.FilterableListItem;
import haveno.desktop.util.filtering.FilteringUtils;
import java.math.BigInteger;
import org.apache.commons.lang3.StringUtils;

class FailedTradesListItem
implements FilterableListItem {
    private final Trade trade;
    private final FailedTradesManager failedTradesManager;

    FailedTradesListItem(Trade trade, FailedTradesManager failedTradesManager) {
        this.trade = trade;
        this.failedTradesManager = failedTradesManager;
    }

    FailedTradesListItem() {
        this.trade = null;
        this.failedTradesManager = null;
    }

    public String getDateAsString() {
        return DisplayUtils.formatDateTime(this.trade.getDate());
    }

    public String getPriceAsString() {
        return FormattingUtils.formatPrice((Price)this.trade.getPrice());
    }

    public String getAmountAsString() {
        return HavenoUtils.formatXmr((BigInteger)this.trade.getAmount());
    }

    public String getPaymentMethod() {
        return this.trade.getOffer().getPaymentMethodNameWithCountryCode();
    }

    public String getMarketDescription() {
        return CurrencyUtil.getCurrencyPair((String)this.trade.getOffer().getCounterCurrencyCode());
    }

    public String getDirectionLabel() {
        Offer offer = this.trade.getOffer();
        OfferDirection direction = this.failedTradesManager.wasMyOffer(offer) || this.trade instanceof ArbitratorTrade ? offer.getDirection() : offer.getMirroredDirection();
        String currencyCode = this.trade.getOffer().getCounterCurrencyCode();
        return DisplayUtils.getDirectionWithCode(direction, currencyCode, offer.isPrivateOffer());
    }

    public String getVolumeAsString() {
        return VolumeUtil.formatVolumeWithCode((Volume)this.trade.getVolume());
    }

    public String getState() {
        return Res.get((String)"portfolio.failed.Failed");
    }

    @Override
    public boolean match(String filterString) {
        if (filterString.isEmpty()) {
            return true;
        }
        if (StringUtils.containsIgnoreCase((CharSequence)this.getDateAsString(), (CharSequence)filterString)) {
            return true;
        }
        if (StringUtils.containsIgnoreCase((CharSequence)this.getMarketDescription(), (CharSequence)filterString)) {
            return true;
        }
        if (StringUtils.containsIgnoreCase((CharSequence)this.getPriceAsString(), (CharSequence)filterString)) {
            return true;
        }
        if (StringUtils.containsIgnoreCase((CharSequence)this.getPaymentMethod(), (CharSequence)filterString)) {
            return true;
        }
        if (StringUtils.containsIgnoreCase((CharSequence)this.getAmountAsString(), (CharSequence)filterString)) {
            return true;
        }
        if (StringUtils.containsIgnoreCase((CharSequence)this.getDirectionLabel(), (CharSequence)filterString)) {
            return true;
        }
        if (StringUtils.containsIgnoreCase((CharSequence)this.getVolumeAsString(), (CharSequence)filterString)) {
            return true;
        }
        if (StringUtils.containsIgnoreCase((CharSequence)this.getState(), (CharSequence)filterString)) {
            return true;
        }
        if (StringUtils.containsIgnoreCase((CharSequence)this.getTrade().getOffer().getCombinedExtraInfo(), (CharSequence)filterString)) {
            return true;
        }
        if (this.trade.getBuyer().getPaymentAccountPayload() != null && StringUtils.containsIgnoreCase((CharSequence)this.getTrade().getBuyer().getPaymentAccountPayload().getPaymentDetails(), (CharSequence)filterString)) {
            return true;
        }
        if (this.trade.getSeller().getPaymentAccountPayload() != null && StringUtils.containsIgnoreCase((CharSequence)this.getTrade().getSeller().getPaymentAccountPayload().getPaymentDetails(), (CharSequence)filterString)) {
            return true;
        }
        if (FilteringUtils.match(this.trade.getOffer(), filterString)) {
            return true;
        }
        return FilteringUtils.match(this.trade, filterString);
    }

    public Trade getTrade() {
        return this.trade;
    }
}

