/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.portfolio.failedtrades;

import com.google.inject.Inject;
import haveno.core.offer.Offer;
import haveno.core.offer.OfferDirection;
import haveno.core.trade.Trade;
import haveno.core.trade.TradeManager;
import haveno.core.trade.failed.FailedTradesManager;
import haveno.desktop.common.model.ActivatableDataModel;
import haveno.desktop.main.portfolio.failedtrades.FailedTradesListItem;
import java.util.Collection;
import java.util.stream.Collectors;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;

class FailedTradesDataModel
extends ActivatableDataModel {
    private final FailedTradesManager failedTradesManager;
    private final TradeManager tradeManager;
    private final ObservableList<FailedTradesListItem> list = FXCollections.observableArrayList();
    private final ListChangeListener<Trade> tradesListChangeListener;

    @Inject
    public FailedTradesDataModel(FailedTradesManager failedTradesManager, TradeManager tradeManager) {
        this.failedTradesManager = failedTradesManager;
        this.tradeManager = tradeManager;
        this.tradesListChangeListener = change -> this.applyList();
    }

    @Override
    protected void activate() {
        this.applyList();
        this.failedTradesManager.getObservableList().addListener(this.tradesListChangeListener);
    }

    @Override
    protected void deactivate() {
        this.failedTradesManager.getObservableList().removeListener(this.tradesListChangeListener);
    }

    public ObservableList<FailedTradesListItem> getList() {
        return this.list;
    }

    public OfferDirection getDirection(Offer offer) {
        return this.failedTradesManager.wasMyOffer(offer) ? offer.getDirection() : offer.getMirroredDirection();
    }

    private void applyList() {
        this.list.clear();
        this.list.addAll((Collection)this.failedTradesManager.getObservableList().stream().map(trade -> new FailedTradesListItem((Trade)trade, this.failedTradesManager)).collect(Collectors.toList()));
        this.list.sort((o1, o2) -> o2.getTrade().getDate().compareTo(o1.getTrade().getDate()));
    }

    public void onMoveTradeToPendingTrades(Trade trade) {
        this.tradeManager.onMoveFailedTradeToPendingTrades(trade);
    }

    public void unfailTrade(Trade trade) {
        this.failedTradesManager.unFailTrade(trade);
    }

    public String checkUnfail(Trade trade) {
        return this.failedTradesManager.checkUnFail(trade);
    }
}

