/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.portfolio.editoffer;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import haveno.common.handlers.ErrorMessageHandler;
import haveno.common.handlers.ResultHandler;
import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.monetary.Price;
import haveno.core.offer.OfferUtil;
import haveno.core.offer.OpenOffer;
import haveno.core.payment.validation.FiatVolumeValidator;
import haveno.core.payment.validation.SecurityDepositValidator;
import haveno.core.payment.validation.XmrValidator;
import haveno.core.provider.price.PriceFeedService;
import haveno.core.user.Preferences;
import haveno.core.util.FormattingUtils;
import haveno.core.util.PriceUtil;
import haveno.core.util.coin.CoinFormatter;
import haveno.core.util.validation.AmountValidator4Decimals;
import haveno.core.util.validation.AmountValidator8Decimals;
import haveno.desktop.Navigation;
import haveno.desktop.main.offer.MutableOfferViewModel;
import haveno.desktop.main.portfolio.editoffer.EditOfferDataModel;

class EditOfferViewModel
extends MutableOfferViewModel<EditOfferDataModel> {
    @Inject
    public EditOfferViewModel(EditOfferDataModel dataModel, FiatVolumeValidator fiatVolumeValidator, AmountValidator4Decimals priceValidator4Decimals, AmountValidator8Decimals priceValidator8Decimals, XmrValidator xmrValidator, SecurityDepositValidator securityDepositValidator, PriceFeedService priceFeedService, AccountAgeWitnessService accountAgeWitnessService, Navigation navigation, Preferences preferences, @Named(value="BTC") CoinFormatter btcFormatter, OfferUtil offerUtil) {
        super(dataModel, fiatVolumeValidator, priceValidator4Decimals, priceValidator8Decimals, xmrValidator, securityDepositValidator, priceFeedService, accountAgeWitnessService, navigation, preferences, btcFormatter, offerUtil);
        this.syncMinAmountWithAmount = false;
    }

    @Override
    public void activate() {
        super.activate();
        ((EditOfferDataModel)this.dataModel).populateData();
        long triggerPriceAsLong = ((EditOfferDataModel)this.dataModel).getTriggerPrice();
        ((EditOfferDataModel)this.dataModel).setTriggerPrice(triggerPriceAsLong);
        if (triggerPriceAsLong > 0L) {
            this.triggerPrice.set((Object)PriceUtil.formatMarketPrice((long)triggerPriceAsLong, (String)((EditOfferDataModel)this.dataModel).getCurrencyCode()));
        } else {
            this.triggerPrice.set((Object)"");
        }
        this.onTriggerPriceTextFieldChanged();
        this.onReserveExactAmountCheckboxChanged();
    }

    public void applyOpenOffer(OpenOffer openOffer) {
        ((EditOfferDataModel)this.dataModel).reset();
        ((EditOfferDataModel)this.dataModel).applyOpenOffer(openOffer);
    }

    public void onStartEditOffer(ErrorMessageHandler errorMessageHandler) {
        ((EditOfferDataModel)this.dataModel).onStartEditOffer(errorMessageHandler);
    }

    public void onPublishOffer(ResultHandler resultHandler, ErrorMessageHandler errorMessageHandler) {
        ((EditOfferDataModel)this.dataModel).onPublishOffer(resultHandler, errorMessageHandler);
    }

    public void onCancelEditOffer(ErrorMessageHandler errorMessageHandler) {
        ((EditOfferDataModel)this.dataModel).onCancelEditOffer(errorMessageHandler);
    }

    public void onInvalidateMarketPriceMarginPct() {
        this.marketPriceMargin.set((Object)FormattingUtils.formatToPercent((double)((EditOfferDataModel)this.dataModel).getMarketPriceMarginPct()));
    }

    public void onInvalidatePrice() {
        this.price.set((Object)FormattingUtils.formatPrice(null));
        this.price.set((Object)FormattingUtils.formatPrice((Price)((Price)((EditOfferDataModel)this.dataModel).getPrice().get())));
    }

    public boolean isSecurityDepositValid() {
        return this.securityDepositValidator.validate((String)((String)this.securityDeposit.get())).isValid;
    }

    @Override
    public void triggerFocusOutOnAmountFields() {
    }
}

