/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.portfolio.editoffer;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import haveno.common.UserThread;
import haveno.common.util.Tuple4;
import haveno.core.locale.CurrencyUtil;
import haveno.core.locale.Res;
import haveno.core.locale.TradeCurrency;
import haveno.core.offer.OpenOffer;
import haveno.core.payment.PaymentAccount;
import haveno.core.user.DontShowAgainLookup;
import haveno.core.user.Preferences;
import haveno.core.util.coin.CoinFormatter;
import haveno.desktop.Navigation;
import haveno.desktop.common.view.FxmlView;
import haveno.desktop.components.AutoTooltipButton;
import haveno.desktop.components.BusyAnimation;
import haveno.desktop.main.offer.MutableOfferView;
import haveno.desktop.main.overlays.popups.Popup;
import haveno.desktop.main.overlays.windows.OfferDetailsWindow;
import haveno.desktop.main.portfolio.editoffer.EditOfferDataModel;
import haveno.desktop.main.portfolio.editoffer.EditOfferViewModel;
import haveno.desktop.util.FormBuilder;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;

@FxmlView
public class EditOfferView
extends MutableOfferView<EditOfferViewModel> {
    private BusyAnimation busyAnimation;
    private Button confirmButton;
    private Button cancelButton;

    @Inject
    private EditOfferView(EditOfferViewModel model, Navigation navigation, Preferences preferences, OfferDetailsWindow offerDetailsWindow, @Named(value="BTC") CoinFormatter btcFormatter) {
        super(model, navigation, preferences, offerDetailsWindow, btcFormatter);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.addConfirmEditGroup();
        this.renameAmountGroup();
    }

    private void renameAmountGroup() {
        this.amountTitledGroupBg.setText(Res.get((String)"editOffer.setPrice"));
    }

    @Override
    protected void doSetFocus() {
    }

    @Override
    protected void doActivate() {
        super.doActivate();
        this.addBindings();
        this.hideOptionsGroup();
        this.hideNextButtons();
        this.amountTextField.setDisable(true);
        this.amountBtcLabel.setDisable(true);
        this.minAmountTextField.setDisable(true);
        this.minAmountBtcLabel.setDisable(true);
        this.volumeTextField.setDisable(true);
        this.volumeCurrencyLabel.setDisable(true);
        this.gridPane.setPadding(new Insets(-20.0, 25.0, 25.0, 25.0));
        this.updatePriceToggle();
        this.updateElementsWithDirection();
        ((EditOfferViewModel)this.model).isNextButtonDisabled.setValue(Boolean.valueOf(false));
        this.cancelButton.setDisable(false);
        ((EditOfferViewModel)this.model).onInvalidateMarketPriceMarginPct();
        ((EditOfferViewModel)this.model).onInvalidatePrice();
        this.onPaymentAccountsComboBoxSelected();
    }

    @Override
    public void onClose() {
        ((EditOfferViewModel)this.model).onCancelEditOffer(errorMessage -> {
            this.log.error(errorMessage);
            ((Popup)new Popup().warning(Res.get((String)"editOffer.failed", (Object[])new Object[]{errorMessage}))).show();
        });
    }

    @Override
    protected void deactivate() {
        super.deactivate();
        this.removeBindings();
    }

    public void applyOpenOffer(OpenOffer openOffer) {
        ((EditOfferViewModel)this.model).applyOpenOffer(openOffer);
        this.initWithData(openOffer.getOffer().getDirection(), (TradeCurrency)CurrencyUtil.getTradeCurrency((String)openOffer.getOffer().getCounterCurrencyCode()).get(), false, null);
        ((EditOfferViewModel)this.model).onStartEditOffer(errorMessage -> {
            this.log.error(errorMessage);
            ((Popup)((Popup)new Popup().warning(Res.get((String)"editOffer.failed", (Object[])new Object[]{errorMessage}))).onClose(() -> this.close())).show();
        });
        if (!((EditOfferViewModel)this.model).isSecurityDepositValid()) {
            ((Popup)((Popup)new Popup().warning(Res.get((String)"editOffer.invalidDeposit"))).onClose(() -> this.close())).show();
        }
    }

    private void addBindings() {
        this.confirmButton.disableProperty().bind((ObservableValue)((EditOfferViewModel)this.model).isNextButtonDisabled);
    }

    private void removeBindings() {
        this.confirmButton.disableProperty().unbind();
    }

    @Override
    protected ObservableList<PaymentAccount> filterPaymentAccounts(ObservableList<PaymentAccount> paymentAccounts) {
        return paymentAccounts;
    }

    private void addConfirmEditGroup() {
        int tmpGridRow = 6;
        Tuple4<Button, BusyAnimation, Label, HBox> editOfferTuple = FormBuilder.addButtonBusyAnimationLabelAfterGroup(this.gridPane, tmpGridRow++, Res.get((String)"editOffer.confirmEdit"));
        HBox editOfferConfirmationBox = (HBox)editOfferTuple.fourth;
        editOfferConfirmationBox.setAlignment(Pos.CENTER_LEFT);
        GridPane.setHalignment((Node)editOfferConfirmationBox, (HPos)HPos.LEFT);
        this.confirmButton = (Button)editOfferTuple.first;
        this.confirmButton.setMinHeight(40.0);
        this.confirmButton.setPadding(new Insets(0.0, 20.0, 0.0, 20.0));
        this.confirmButton.setGraphicTextGap(10.0);
        this.busyAnimation = (BusyAnimation)((Object)editOfferTuple.second);
        Label spinnerInfoLabel = (Label)editOfferTuple.third;
        this.cancelButton = new AutoTooltipButton(Res.get((String)"shared.cancel"));
        this.cancelButton.setDefaultButton(false);
        this.cancelButton.setOnAction(event -> this.close());
        editOfferConfirmationBox.getChildren().add((Object)this.cancelButton);
        this.confirmButton.setOnAction(e -> {
            if (((EditOfferViewModel)this.model).isPriceInRange()) {
                ((EditOfferViewModel)this.model).isNextButtonDisabled.setValue(Boolean.valueOf(true));
                this.cancelButton.setDisable(true);
                this.busyAnimation.play();
                spinnerInfoLabel.setText(Res.get((String)"editOffer.publishOffer"));
                ((EditOfferViewModel)this.model).onPublishOffer(() -> {
                    if (((EditOfferDataModel)((EditOfferViewModel)this.model).dataModel).hasConflictingClone()) {
                        ((Popup)new Popup().warning(Res.get((String)"editOffer.hasConflictingClone"))).show();
                    } else {
                        String key = "editOfferSuccess";
                        if (DontShowAgainLookup.showAgain((String)key)) {
                            ((Popup)((Popup)new Popup().feedback(Res.get((String)"editOffer.success"))).dontShowAgainId(key)).show();
                        }
                    }
                    UserThread.execute(() -> {
                        spinnerInfoLabel.setText("");
                        this.busyAnimation.stop();
                        this.close();
                    });
                }, message -> UserThread.execute(() -> {
                    this.log.error(message);
                    spinnerInfoLabel.setText("");
                    this.busyAnimation.stop();
                    ((EditOfferViewModel)this.model).isNextButtonDisabled.setValue(Boolean.valueOf(false));
                    this.cancelButton.setDisable(false);
                    ((Popup)new Popup().warning(Res.get((String)"editOffer.failed", (Object[])new Object[]{message}))).show();
                }));
            }
        });
    }

    private void updateElementsWithDirection() {
        ImageView iconView = new ImageView();
        iconView.setId(((EditOfferViewModel)this.model).isSellOffer() ? "image-sell-white" : "image-buy-white");
        this.confirmButton.setGraphic((Node)iconView);
        this.confirmButton.setId(((EditOfferViewModel)this.model).isSellOffer() ? "sell-button-big" : "buy-button-big");
    }
}

