/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.portfolio.editoffer;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import haveno.common.handlers.ErrorMessageHandler;
import haveno.common.handlers.ResultHandler;
import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.locale.CurrencyUtil;
import haveno.core.locale.TradeCurrency;
import haveno.core.offer.CreateOfferService;
import haveno.core.offer.Offer;
import haveno.core.offer.OfferDirection;
import haveno.core.offer.OfferPayload;
import haveno.core.offer.OfferUtil;
import haveno.core.offer.OpenOffer;
import haveno.core.offer.OpenOfferManager;
import haveno.core.payment.PaymentAccount;
import haveno.core.proto.CoreProtoResolver;
import haveno.core.proto.persistable.CorePersistenceProtoResolver;
import haveno.core.provider.price.PriceFeedService;
import haveno.core.trade.statistics.TradeStatisticsManager;
import haveno.core.user.Preferences;
import haveno.core.user.User;
import haveno.core.util.coin.CoinFormatter;
import haveno.core.util.coin.CoinUtil;
import haveno.core.xmr.wallet.Restrictions;
import haveno.core.xmr.wallet.XmrWalletService;
import haveno.desktop.Navigation;
import haveno.desktop.main.offer.MutableOfferDataModel;
import haveno.network.p2p.P2PService;
import java.math.BigInteger;
import java.util.Optional;
import java.util.Set;

class EditOfferDataModel
extends MutableOfferDataModel {
    private final CorePersistenceProtoResolver corePersistenceProtoResolver;
    private OpenOffer openOffer;
    private OpenOffer.State initialState;
    private Offer editedOffer;

    @Inject
    EditOfferDataModel(CreateOfferService createOfferService, OpenOfferManager openOfferManager, OfferUtil offerUtil, XmrWalletService xmrWalletService, Preferences preferences, User user, P2PService p2PService, PriceFeedService priceFeedService, AccountAgeWitnessService accountAgeWitnessService, @Named(value="BTC") CoinFormatter btcFormatter, CorePersistenceProtoResolver corePersistenceProtoResolver, TradeStatisticsManager tradeStatisticsManager, Navigation navigation) {
        super(createOfferService, openOfferManager, offerUtil, xmrWalletService, preferences, user, p2PService, priceFeedService, accountAgeWitnessService, btcFormatter, tradeStatisticsManager, navigation);
        this.corePersistenceProtoResolver = corePersistenceProtoResolver;
    }

    public void reset() {
        this.direction = null;
        this.tradeCurrency = null;
        this.tradeCurrencyCode.set(null);
        this.useMarketBasedPrice.set(false);
        this.amount.set(null);
        this.minAmount.set(null);
        this.price.set(null);
        this.volume.set(null);
        this.minVolume.set(null);
        this.securityDepositPct.set(0.0);
        this.paymentAccounts.clear();
        this.paymentAccount = null;
        this.marketPriceMarginPct = 0.0;
    }

    public void applyOpenOffer(OpenOffer openOffer) {
        double securityDepositPercent;
        this.openOffer = openOffer;
        Offer offer = openOffer.getOffer();
        this.direction = offer.getDirection();
        CurrencyUtil.getTradeCurrency((String)offer.getCounterCurrencyCode()).ifPresent(c -> {
            this.tradeCurrency = c;
        });
        this.tradeCurrencyCode.set((Object)offer.getCounterCurrencyCode());
        this.initialState = openOffer.getState();
        PaymentAccount tmpPaymentAccount = this.user.getPaymentAccount(openOffer.getOffer().getMakerPaymentAccountId());
        Optional optionalTradeCurrency = CurrencyUtil.getTradeCurrency((String)openOffer.getOffer().getCounterCurrencyCode());
        if (optionalTradeCurrency.isPresent() && tmpPaymentAccount != null) {
            TradeCurrency selectedTradeCurrency = (TradeCurrency)optionalTradeCurrency.get();
            this.paymentAccount = PaymentAccount.fromProto((protobuf.PaymentAccount)tmpPaymentAccount.toProtoMessage(), (CoreProtoResolver)this.corePersistenceProtoResolver);
            if (this.paymentAccount.getSingleTradeCurrency() != null) {
                this.paymentAccount.setSingleTradeCurrency(selectedTradeCurrency);
            } else {
                this.paymentAccount.setSelectedTradeCurrency(selectedTradeCurrency);
            }
        }
        if ((securityDepositPercent = CoinUtil.getAsPercentPerXmr((BigInteger)offer.getMaxSellerSecurityDeposit(), (BigInteger)offer.getAmount())) > Restrictions.getMaxSecurityDepositPct() && offer.getMaxSellerSecurityDeposit().equals(Restrictions.getMinSecurityDeposit())) {
            this.securityDepositPct.set(Restrictions.getDefaultSecurityDepositPct());
        } else {
            this.securityDepositPct.set(securityDepositPercent);
        }
        this.allowAmountUpdate = false;
        this.triggerPrice = openOffer.getTriggerPrice();
        this.extraInfo.set((Object)offer.getOfferExtraInfo());
    }

    public boolean initWithData(OfferDirection direction, TradeCurrency tradeCurrency) {
        try {
            return super.initWithData(direction, tradeCurrency, false);
        }
        catch (NullPointerException e) {
            if (e.getMessage().contains("tradeCurrency")) {
                throw new IllegalArgumentException("Offers of removed assets cannot be edited. You can only cancel it.", e);
            }
            return false;
        }
    }

    @Override
    protected PaymentAccount getPreselectedPaymentAccount() {
        return this.paymentAccount;
    }

    public void populateData() {
        Offer offer = this.openOffer.getOffer();
        this.setMinAmount(offer.getMinAmount());
        this.setAmount(offer.getAmount());
        this.setPrice(offer.getPrice());
        this.setVolume(offer.getVolume());
        this.setUseMarketBasedPrice(offer.isUseMarketBasedPrice());
        if (offer.isUseMarketBasedPrice()) {
            this.setMarketPriceMarginPct(offer.getMarketPriceMarginPct());
        }
        this.setTriggerPrice(this.openOffer.getTriggerPrice());
        this.setExtraInfo(offer.getOfferExtraInfo());
    }

    public void onStartEditOffer(ErrorMessageHandler errorMessageHandler) {
        this.openOfferManager.editOpenOfferStart(this.openOffer, () -> {}, errorMessageHandler);
    }

    public void onPublishOffer(ResultHandler resultHandler, ErrorMessageHandler errorMessageHandler) {
        OfferPayload offerPayload = this.openOffer.getOffer().getOfferPayload();
        OfferPayload newOfferPayload = this.createAndGetOffer().getOfferPayload();
        OfferPayload editedPayload = new OfferPayload(offerPayload.getId(), offerPayload.getDate(), offerPayload.getOwnerNodeAddress(), offerPayload.getPubKeyRing(), offerPayload.getDirection(), newOfferPayload.getPrice(), newOfferPayload.getMarketPriceMarginPct(), newOfferPayload.isUseMarketBasedPrice(), offerPayload.getAmount(), offerPayload.getMinAmount(), offerPayload.getMakerFeePct(), offerPayload.getTakerFeePct(), offerPayload.getPenaltyFeePct(), offerPayload.getBuyerSecurityDepositPct(), offerPayload.getSellerSecurityDepositPct(), newOfferPayload.getBaseCurrencyCode(), newOfferPayload.getCounterCurrencyCode(), newOfferPayload.getPaymentMethodId(), newOfferPayload.getMakerPaymentAccountId(), newOfferPayload.getCountryCode(), newOfferPayload.getAcceptedCountryCodes(), newOfferPayload.getBankId(), newOfferPayload.getAcceptedBankIds(), offerPayload.getVersionNr(), offerPayload.getBlockHeightAtOfferCreation(), offerPayload.getMaxTradeLimit(), offerPayload.getMaxTradePeriod(), offerPayload.isUseAutoClose(), offerPayload.isUseReOpenAfterAutoClose(), offerPayload.getLowerClosePrice(), offerPayload.getUpperClosePrice(), offerPayload.isPrivateOffer(), offerPayload.getChallengeHash(), offerPayload.getExtraDataMap(), offerPayload.getProtocolVersion(), offerPayload.getArbitratorSigner(), offerPayload.getArbitratorSignature(), offerPayload.getReserveTxKeyImages(), newOfferPayload.getExtraInfo());
        this.editedOffer = new Offer(editedPayload);
        this.editedOffer.setPriceFeedService(this.priceFeedService);
        this.editedOffer.setState(Offer.State.AVAILABLE);
        this.openOfferManager.editOpenOfferPublish(this.editedOffer, this.triggerPrice, this.initialState, () -> {
            resultHandler.handleResult();
            this.openOffer = null;
            this.editedOffer = null;
        }, errorMsg -> errorMessageHandler.handleErrorMessage(errorMsg));
    }

    public void onCancelEditOffer(ErrorMessageHandler errorMessageHandler) {
        if (this.openOffer != null) {
            this.openOfferManager.editOpenOfferCancel(this.openOffer, this.initialState, () -> {}, errorMessageHandler);
        }
    }

    public boolean hasConflictingClone() {
        Optional editedOpenOffer = this.openOfferManager.getOpenOffer(this.openOffer.getId());
        if (!editedOpenOffer.isPresent()) {
            this.log.warn("Edited open offer is no longer present");
            return false;
        }
        return this.openOfferManager.hasConflictingClone((OpenOffer)editedOpenOffer.get());
    }

    @Override
    protected Set<PaymentAccount> getUserPaymentAccounts() {
        throw new RuntimeException("Edit offer not supported with XMR");
    }
}

