/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.portfolio.duplicateoffer;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.offer.Offer;
import haveno.core.offer.OfferPayload;
import haveno.core.offer.OfferUtil;
import haveno.core.payment.validation.FiatVolumeValidator;
import haveno.core.payment.validation.SecurityDepositValidator;
import haveno.core.payment.validation.XmrValidator;
import haveno.core.provider.price.PriceFeedService;
import haveno.core.user.Preferences;
import haveno.core.util.PriceUtil;
import haveno.core.util.coin.CoinFormatter;
import haveno.core.util.validation.AmountValidator4Decimals;
import haveno.core.util.validation.AmountValidator8Decimals;
import haveno.desktop.Navigation;
import haveno.desktop.main.offer.MutableOfferViewModel;
import haveno.desktop.main.portfolio.duplicateoffer.DuplicateOfferDataModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DuplicateOfferViewModel
extends MutableOfferViewModel<DuplicateOfferDataModel> {
    private static final Logger log = LoggerFactory.getLogger(DuplicateOfferViewModel.class);

    @Inject
    public DuplicateOfferViewModel(DuplicateOfferDataModel dataModel, FiatVolumeValidator fiatVolumeValidator, AmountValidator4Decimals priceValidator4Decimals, AmountValidator8Decimals priceValidator8Decimals, XmrValidator btcValidator, SecurityDepositValidator securityDepositValidator, PriceFeedService priceFeedService, AccountAgeWitnessService accountAgeWitnessService, Navigation navigation, Preferences preferences, @Named(value="BTC") CoinFormatter btcFormatter, OfferUtil offerUtil) {
        super(dataModel, fiatVolumeValidator, priceValidator4Decimals, priceValidator8Decimals, btcValidator, securityDepositValidator, priceFeedService, accountAgeWitnessService, navigation, preferences, btcFormatter, offerUtil);
        this.syncMinAmountWithAmount = false;
    }

    public void initWithData(OfferPayload offerPayload) {
        this.offer = new Offer(offerPayload);
        this.offer.setPriceFeedService(this.priceFeedService);
    }

    @Override
    public void activate() {
        super.activate();
        ((DuplicateOfferDataModel)this.dataModel).populateData(this.offer);
        long triggerPriceAsLong = ((DuplicateOfferDataModel)this.dataModel).getTriggerPrice();
        ((DuplicateOfferDataModel)this.dataModel).setTriggerPrice(triggerPriceAsLong);
        if (triggerPriceAsLong > 0L) {
            this.triggerPrice.set((Object)PriceUtil.formatMarketPrice((long)triggerPriceAsLong, (String)((DuplicateOfferDataModel)this.dataModel).getCurrencyCode()));
        } else {
            this.triggerPrice.set((Object)"");
        }
        this.onTriggerPriceTextFieldChanged();
        this.triggerFocusOutOnAmountFields();
        this.onFocusOutPriceAsPercentageTextField(true, false);
    }
}

