/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.portfolio.duplicateoffer;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.locale.CurrencyUtil;
import haveno.core.locale.TradeCurrency;
import haveno.core.offer.CreateOfferService;
import haveno.core.offer.Offer;
import haveno.core.offer.OfferUtil;
import haveno.core.offer.OpenOffer;
import haveno.core.offer.OpenOfferManager;
import haveno.core.payment.PaymentAccount;
import haveno.core.provider.price.PriceFeedService;
import haveno.core.trade.statistics.TradeStatisticsManager;
import haveno.core.user.Preferences;
import haveno.core.user.User;
import haveno.core.util.coin.CoinFormatter;
import haveno.core.xmr.wallet.XmrWalletService;
import haveno.desktop.Navigation;
import haveno.desktop.main.offer.MutableOfferDataModel;
import haveno.network.p2p.P2PService;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

class DuplicateOfferDataModel
extends MutableOfferDataModel {
    @Inject
    DuplicateOfferDataModel(CreateOfferService createOfferService, OpenOfferManager openOfferManager, OfferUtil offerUtil, XmrWalletService xmrWalletService, Preferences preferences, User user, P2PService p2PService, PriceFeedService priceFeedService, AccountAgeWitnessService accountAgeWitnessService, @Named(value="BTC") CoinFormatter btcFormatter, TradeStatisticsManager tradeStatisticsManager, Navigation navigation) {
        super(createOfferService, openOfferManager, offerUtil, xmrWalletService, preferences, user, p2PService, priceFeedService, accountAgeWitnessService, btcFormatter, tradeStatisticsManager, navigation);
    }

    public void populateData(Offer offer) {
        if (offer == null) {
            return;
        }
        PaymentAccount account = this.user.getPaymentAccount(offer.getMakerPaymentAccountId());
        if (account != null) {
            this.paymentAccount = account;
        }
        this.setMinAmount(offer.getMinAmount());
        this.setAmount(offer.getAmount());
        this.setPrice(offer.getPrice());
        this.setVolume(offer.getVolume());
        this.setUseMarketBasedPrice(offer.isUseMarketBasedPrice());
        if (offer.isUseMarketBasedPrice()) {
            this.setMarketPriceMarginPct(offer.getMarketPriceMarginPct());
        }
        this.setBuyerAsTakerWithoutDeposit(offer.hasBuyerAsTakerWithoutDeposit());
        this.setSecurityDepositPct(this.getSecurityAsPercent(offer));
        this.setExtraInfo(offer.getOfferExtraInfo());
        OpenOffer openOffer = this.openOfferManager.getOpenOffer(offer.getId()).orElse(null);
        if (openOffer != null) {
            this.setTriggerPrice(openOffer.getTriggerPrice());
        }
    }

    @Override
    protected Set<PaymentAccount> getUserPaymentAccounts() {
        return Objects.requireNonNull(this.user.getPaymentAccounts()).stream().filter(account -> !account.getPaymentMethod().isBsqSwap()).collect(Collectors.toSet());
    }

    @Override
    protected PaymentAccount getPreselectedPaymentAccount() {
        Optional<PaymentAccount> firstBsqPaymentAccount;
        Optional bsqOptional = CurrencyUtil.getTradeCurrency((String)"BSQ");
        if (bsqOptional.isPresent() && this.tradeCurrency.equals(bsqOptional.get()) && this.user.getPaymentAccounts() != null && (firstBsqPaymentAccount = this.user.getPaymentAccounts().stream().filter(paymentAccount1 -> {
            Optional tradeCurrency = paymentAccount1.getTradeCurrency();
            return tradeCurrency.isPresent() && ((TradeCurrency)tradeCurrency.get()).equals(bsqOptional.get());
        }).findFirst()).isPresent()) {
            return firstBsqPaymentAccount.get();
        }
        return super.getPreselectedPaymentAccount();
    }
}

