/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.portfolio.closedtrades;

import com.google.inject.Inject;
import haveno.core.trade.ClosedTradableFormatter;
import haveno.desktop.common.model.ActivatableWithDataModel;
import haveno.desktop.common.model.ViewModel;
import haveno.desktop.main.portfolio.closedtrades.ClosedTradesDataModel;
import java.math.BigInteger;
import java.util.Map;

public class ClosedTradesViewModel
extends ActivatableWithDataModel<ClosedTradesDataModel>
implements ViewModel {
    private final ClosedTradableFormatter closedTradableFormatter;

    @Inject
    public ClosedTradesViewModel(ClosedTradesDataModel dataModel, ClosedTradableFormatter closedTradableFormatter) {
        super(dataModel);
        this.closedTradableFormatter = closedTradableFormatter;
    }

    public BigInteger getTotalTradeAmount() {
        return ((ClosedTradesDataModel)this.dataModel).getTotalAmount();
    }

    public String getTotalAmountWithVolume(BigInteger totalTradeAmount) {
        return ((ClosedTradesDataModel)this.dataModel).getVolumeInUserFiatCurrency(totalTradeAmount).map(volume -> this.closedTradableFormatter.getTotalAmountWithVolumeAsString(totalTradeAmount, volume)).orElse("");
    }

    public Map<String, String> getTotalVolumeByCurrency() {
        return this.closedTradableFormatter.getTotalVolumeByCurrencyAsString(((ClosedTradesDataModel)this.dataModel).getListAsTradables());
    }

    public String getTotalTxFee(BigInteger totalTradeAmount) {
        BigInteger totalTxFee = ((ClosedTradesDataModel)this.dataModel).getTotalTxFee();
        return this.closedTradableFormatter.getTotalTxFeeAsString(totalTradeAmount, totalTxFee);
    }

    public String getTotalTradeFee(BigInteger totalTradeAmount) {
        BigInteger totalTradeFee = ((ClosedTradesDataModel)this.dataModel).getTotalTradeFee();
        return this.closedTradableFormatter.getTotalTradeFeeAsString(totalTradeAmount, totalTradeFee);
    }
}

