/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.portfolio.closedtrades;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.googlecode.jcsv.writer.CSVEntryConverter;
import com.jfoenix.controls.JFXButton;
import de.jensd.fx.fontawesome.AwesomeIcon;
import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.materialdesignicons.MaterialDesignIcon;
import haveno.common.crypto.KeyRing;
import haveno.core.alert.PrivateNotificationManager;
import haveno.core.locale.Res;
import haveno.core.offer.Offer;
import haveno.core.offer.OfferPayload;
import haveno.core.offer.OpenOffer;
import haveno.core.trade.Tradable;
import haveno.core.trade.Trade;
import haveno.core.user.Preferences;
import haveno.desktop.Navigation;
import haveno.desktop.common.view.ActivatableViewAndModel;
import haveno.desktop.common.view.FxmlView;
import haveno.desktop.components.AutoTooltipButton;
import haveno.desktop.components.AutoTooltipLabel;
import haveno.desktop.components.AutoTooltipTableColumn;
import haveno.desktop.components.HyperlinkWithIcon;
import haveno.desktop.components.PeerInfoIconTrading;
import haveno.desktop.components.list.FilterBox;
import haveno.desktop.main.overlays.popups.Popup;
import haveno.desktop.main.overlays.windows.ClosedTradesSummaryWindow;
import haveno.desktop.main.overlays.windows.OfferDetailsWindow;
import haveno.desktop.main.overlays.windows.TradeDetailsWindow;
import haveno.desktop.main.portfolio.closedtrades.ClosedTradesDataModel;
import haveno.desktop.main.portfolio.closedtrades.ClosedTradesListItem;
import haveno.desktop.main.portfolio.closedtrades.ClosedTradesViewModel;
import haveno.desktop.main.portfolio.presentation.PortfolioUtil;
import haveno.desktop.util.FormBuilder;
import haveno.desktop.util.GUIUtil;
import haveno.network.p2p.NodeAddress;
import java.util.Comparator;
import java.util.function.Function;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableObjectValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.util.Callback;

@FxmlView
public class ClosedTradesView
extends ActivatableViewAndModel<VBox, ClosedTradesViewModel> {
    private final boolean useDevPrivilegeKeys;
    @FXML
    TableView<ClosedTradesListItem> tableView;
    @FXML
    TableColumn<ClosedTradesListItem, ClosedTradesListItem> priceColumn;
    @FXML
    TableColumn<ClosedTradesListItem, ClosedTradesListItem> deviationColumn;
    @FXML
    TableColumn<ClosedTradesListItem, ClosedTradesListItem> amountColumn;
    @FXML
    TableColumn<ClosedTradesListItem, ClosedTradesListItem> volumeColumn;
    @FXML
    TableColumn<ClosedTradesListItem, ClosedTradesListItem> tradeFeeColumn;
    @FXML
    TableColumn<ClosedTradesListItem, ClosedTradesListItem> buyerSecurityDepositColumn;
    @FXML
    TableColumn<ClosedTradesListItem, ClosedTradesListItem> sellerSecurityDepositColumn;
    @FXML
    TableColumn<ClosedTradesListItem, ClosedTradesListItem> marketColumn;
    @FXML
    TableColumn<ClosedTradesListItem, ClosedTradesListItem> directionColumn;
    @FXML
    TableColumn<ClosedTradesListItem, ClosedTradesListItem> dateColumn;
    @FXML
    TableColumn<ClosedTradesListItem, ClosedTradesListItem> tradeIdColumn;
    @FXML
    TableColumn<ClosedTradesListItem, ClosedTradesListItem> stateColumn;
    @FXML
    TableColumn<ClosedTradesListItem, ClosedTradesListItem> removeTradeColumn;
    @FXML
    TableColumn<ClosedTradesListItem, ClosedTradesListItem> duplicateColumn;
    @FXML
    TableColumn<ClosedTradesListItem, ClosedTradesListItem> avatarColumn;
    @FXML
    FilterBox filterBox;
    @FXML
    AutoTooltipButton exportButton;
    @FXML
    AutoTooltipButton summaryButton;
    @FXML
    Label numItems;
    @FXML
    Region footerSpacer;
    private final OfferDetailsWindow offerDetailsWindow;
    private final Navigation navigation;
    private final KeyRing keyRing;
    private final Preferences preferences;
    private final TradeDetailsWindow tradeDetailsWindow;
    private final PrivateNotificationManager privateNotificationManager;
    private SortedList<ClosedTradesListItem> sortedList;
    private FilteredList<ClosedTradesListItem> filteredList;
    private ChangeListener<Number> widthListener;

    @Inject
    public ClosedTradesView(ClosedTradesViewModel model, OfferDetailsWindow offerDetailsWindow, Navigation navigation, KeyRing keyRing, Preferences preferences, TradeDetailsWindow tradeDetailsWindow, PrivateNotificationManager privateNotificationManager, @Named(value="useDevPrivilegeKeys") boolean useDevPrivilegeKeys) {
        super(model);
        this.offerDetailsWindow = offerDetailsWindow;
        this.navigation = navigation;
        this.keyRing = keyRing;
        this.preferences = preferences;
        this.tradeDetailsWindow = tradeDetailsWindow;
        this.privateNotificationManager = privateNotificationManager;
        this.useDevPrivilegeKeys = useDevPrivilegeKeys;
    }

    @Override
    public void initialize() {
        GUIUtil.applyTableStyle(this.tableView);
        this.widthListener = (observable, oldValue, newValue) -> this.onWidthChange((Double)newValue);
        this.tradeFeeColumn.setGraphic((Node)new AutoTooltipLabel(ColumnNames.TRADE_FEE.toString().replace(" BTC", "")));
        this.buyerSecurityDepositColumn.setGraphic((Node)new AutoTooltipLabel(ColumnNames.BUYER_SEC.toString()));
        this.sellerSecurityDepositColumn.setGraphic((Node)new AutoTooltipLabel(ColumnNames.SELLER_SEC.toString()));
        this.priceColumn.setGraphic((Node)new AutoTooltipLabel(ColumnNames.PRICE.toString()));
        this.deviationColumn.setGraphic(new AutoTooltipTableColumn(ColumnNames.DEVIATION.toString(), Res.get((String)"portfolio.closedTrades.deviation.help")).getGraphic());
        this.amountColumn.setGraphic((Node)new AutoTooltipLabel(ColumnNames.AMOUNT.toString()));
        this.volumeColumn.setGraphic((Node)new AutoTooltipLabel(ColumnNames.VOLUME.toString()));
        this.marketColumn.setGraphic((Node)new AutoTooltipLabel(ColumnNames.MARKET.toString()));
        this.directionColumn.setGraphic((Node)new AutoTooltipLabel(ColumnNames.OFFER_TYPE.toString()));
        this.dateColumn.setGraphic((Node)new AutoTooltipLabel(ColumnNames.DATE.toString()));
        this.tradeIdColumn.setGraphic((Node)new AutoTooltipLabel(ColumnNames.TRADE_ID.toString()));
        this.stateColumn.setGraphic((Node)new AutoTooltipLabel(ColumnNames.STATUS.toString()));
        this.duplicateColumn.setGraphic((Node)new AutoTooltipLabel(""));
        this.avatarColumn.setText("");
        this.tableView.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        this.tableView.setPlaceholder((Node)new AutoTooltipLabel(Res.get((String)"table.placeholder.noItems", (Object[])new Object[]{Res.get((String)"shared.trades")})));
        this.setTradeIdColumnCellFactory();
        this.setDirectionColumnCellFactory();
        this.setAmountColumnCellFactory();
        this.setTradeFeeColumnCellFactory();
        this.setBuyerSecurityDepositColumnCellFactory();
        this.setSellerSecurityDepositColumnCellFactory();
        this.setPriceColumnCellFactory();
        this.setDeviationColumnCellFactory();
        this.setVolumeColumnCellFactory();
        this.setDateColumnCellFactory();
        this.setMarketColumnCellFactory();
        this.setStateColumnCellFactory();
        this.setRemoveTradeColumnCellFactory();
        this.setDuplicateColumnCellFactory();
        this.setAvatarColumnCellFactory();
        this.tradeIdColumn.setComparator(Comparator.comparing(ClosedTradesListItem::getTradeId));
        this.dateColumn.setComparator(Comparator.comparing(ClosedTradesListItem::getDate));
        this.directionColumn.setComparator(Comparator.comparing(o -> o.getTradable().getOffer().getDirection()));
        this.marketColumn.setComparator(Comparator.comparing(ClosedTradesListItem::getMarketLabel));
        this.priceColumn.setComparator(Comparator.comparing(ClosedTradesListItem::getPrice, Comparator.nullsFirst(Comparator.naturalOrder())));
        this.deviationColumn.setComparator(Comparator.comparing(o -> o.getTradable().getOffer().isUseMarketBasedPrice() ? o.getTradable().getOffer().getMarketPriceMarginPct() : 1.0, Comparator.nullsFirst(Comparator.naturalOrder())));
        this.volumeColumn.setComparator(ClosedTradesView.nullsFirstComparingAsTrade(Trade::getVolume));
        this.amountColumn.setComparator(Comparator.comparing(ClosedTradesListItem::getAmount, Comparator.nullsFirst(Comparator.naturalOrder())));
        this.avatarColumn.setComparator(Comparator.comparing(ClosedTradesListItem::getNumPastTrades, Comparator.nullsFirst(Comparator.naturalOrder())));
        this.tradeFeeColumn.setComparator(Comparator.comparing(item -> {
            String tradeFee = item.getTradeFeeAsString(true);
            return "BTC" + tradeFee;
        }, Comparator.nullsFirst(Comparator.naturalOrder())));
        this.buyerSecurityDepositColumn.setComparator(ClosedTradesView.nullsFirstComparing(o -> o.getTradable().getOffer() != null ? o.getTradable().getOffer().getMaxBuyerSecurityDeposit() : null));
        this.sellerSecurityDepositColumn.setComparator(ClosedTradesView.nullsFirstComparing(o -> o.getTradable().getOffer() != null ? o.getTradable().getOffer().getMaxSellerSecurityDeposit() : null));
        this.stateColumn.setComparator(Comparator.comparing(ClosedTradesListItem::getState));
        this.dateColumn.setSortType(TableColumn.SortType.DESCENDING);
        this.tableView.getSortOrder().add(this.dateColumn);
        this.tableView.setRowFactory(tableView -> {
            TableRow row = new TableRow();
            ContextMenu rowMenu = new ContextMenu();
            MenuItem duplicateItem = new MenuItem(Res.get((String)"portfolio.context.offerLikeThis"));
            duplicateItem.setOnAction(event -> this.onDuplicateOffer(((ClosedTradesListItem)row.getItem()).getTradable().getOffer()));
            rowMenu.getItems().add((Object)duplicateItem);
            row.contextMenuProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)Bindings.isNotNull((ObservableObjectValue)row.itemProperty())).then((Object)rowMenu).otherwise((Object)null));
            return row;
        });
        this.numItems.setId("num-offers");
        this.numItems.setPadding(new Insets(-5.0, 0.0, 0.0, 10.0));
        HBox.setHgrow((Node)this.footerSpacer, (Priority)Priority.ALWAYS);
        HBox.setMargin((Node)this.exportButton, (Insets)new Insets(0.0, 10.0, 0.0, 0.0));
        this.exportButton.updateText(Res.get((String)"shared.exportCSV"));
        this.summaryButton.updateText(Res.get((String)"shared.summary"));
    }

    @Override
    protected void activate() {
        this.filteredList = new FilteredList(((ClosedTradesDataModel)((ClosedTradesViewModel)this.model).dataModel).getList());
        this.sortedList = new SortedList(this.filteredList);
        this.sortedList.comparatorProperty().bind((ObservableValue)this.tableView.comparatorProperty());
        this.tableView.setItems(this.sortedList);
        this.filterBox.initialize(this.filteredList, this.tableView);
        this.filterBox.setPromptText(Res.get((String)"shared.filter"));
        this.filterBox.activate();
        this.numItems.setText(Res.get((String)"shared.numItemsLabel", (Object[])new Object[]{this.sortedList.size()}));
        this.exportButton.setOnAction(event -> {
            CSVEntryConverter headerConverter = item -> {
                String[] columns = new String[ColumnNames.values().length];
                for (ColumnNames m : ColumnNames.values()) {
                    columns[m.ordinal()] = m.toString();
                }
                return columns;
            };
            CSVEntryConverter contentConverter = item -> {
                String[] columns = new String[ColumnNames.values().length];
                columns[ColumnNames.TRADE_ID.ordinal()] = item.getTradeId();
                columns[ColumnNames.DATE.ordinal()] = item.getDateAsString();
                columns[ColumnNames.MARKET.ordinal()] = item.getMarketLabel();
                columns[ColumnNames.PRICE.ordinal()] = item.getPriceAsString();
                columns[ColumnNames.DEVIATION.ordinal()] = item.getPriceDeviationAsString();
                columns[ColumnNames.AMOUNT.ordinal()] = item.getAmountAsString();
                columns[ColumnNames.VOLUME.ordinal()] = item.getVolumeAsString(false);
                columns[ColumnNames.VOLUME_CURRENCY.ordinal()] = item.getVolumeCurrencyAsString();
                columns[ColumnNames.TX_FEE.ordinal()] = item.getTxFeeAsString();
                columns[ColumnNames.TRADE_FEE.ordinal()] = ((ClosedTradesDataModel)((ClosedTradesViewModel)this.model).dataModel).isCurrencyForTradeFeeBtc(item.getTradable()) ? item.getTradeFeeAsString(false) : "";
                columns[ColumnNames.BUYER_SEC.ordinal()] = item.getBuyerSecurityDepositAsString();
                columns[ColumnNames.SELLER_SEC.ordinal()] = item.getSellerSecurityDepositAsString();
                columns[ColumnNames.OFFER_TYPE.ordinal()] = item.getDirectionLabel();
                columns[ColumnNames.STATUS.ordinal()] = item.getState();
                return columns;
            };
            GUIUtil.exportCSV("tradeHistory.csv", headerConverter, contentConverter, null, this.sortedList, (Stage)((VBox)this.root).getScene().getWindow());
        });
        this.summaryButton.setOnAction(event -> new ClosedTradesSummaryWindow((ClosedTradesViewModel)this.model).show());
        ((VBox)this.root).widthProperty().addListener(this.widthListener);
        this.onWidthChange(((VBox)this.root).getWidth());
    }

    @Override
    protected void deactivate() {
        this.sortedList.comparatorProperty().unbind();
        this.exportButton.setOnAction(null);
        this.summaryButton.setOnAction(null);
        this.filterBox.deactivate();
        ((VBox)this.root).widthProperty().removeListener(this.widthListener);
    }

    private static <T extends Comparable<T>> Comparator<ClosedTradesListItem> nullsFirstComparing(Function<ClosedTradesListItem, T> keyExtractor) {
        return Comparator.comparing(o -> o != null ? (Comparable)keyExtractor.apply((ClosedTradesListItem)o) : null, Comparator.nullsFirst(Comparator.naturalOrder()));
    }

    private static <T extends Comparable<T>> Comparator<ClosedTradesListItem> nullsFirstComparingAsTrade(Function<Trade, T> keyExtractor) {
        return Comparator.comparing(o -> o.getTradable() instanceof Trade ? (Comparable)keyExtractor.apply((Trade)o.getTradable()) : null, Comparator.nullsFirst(Comparator.naturalOrder()));
    }

    private void onWidthChange(double width) {
        this.buyerSecurityDepositColumn.setVisible(width > 1400.0);
        this.sellerSecurityDepositColumn.setVisible(width > 1500.0);
    }

    private void setTradeIdColumnCellFactory() {
        this.tradeIdColumn.setCellValueFactory(offerListItem -> new ReadOnlyObjectWrapper((Object)((ClosedTradesListItem)offerListItem.getValue())));
        this.tradeIdColumn.setCellFactory((Callback)new Callback<TableColumn<ClosedTradesListItem, ClosedTradesListItem>, TableCell<ClosedTradesListItem, ClosedTradesListItem>>(){

            public TableCell<ClosedTradesListItem, ClosedTradesListItem> call(TableColumn<ClosedTradesListItem, ClosedTradesListItem> column) {
                return new TableCell<ClosedTradesListItem, ClosedTradesListItem>(){
                    private HyperlinkWithIcon field;

                    public void updateItem(ClosedTradesListItem item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null && !empty) {
                            this.field = new HyperlinkWithIcon(item.getTradeId());
                            this.field.setOnAction(event -> {
                                Tradable tradable = item.getTradable();
                                if (tradable instanceof Trade) {
                                    ClosedTradesView.this.tradeDetailsWindow.show((Trade)tradable);
                                } else if (tradable instanceof OpenOffer) {
                                    ClosedTradesView.this.offerDetailsWindow.show(tradable.getOffer());
                                }
                            });
                            this.field.setTooltip(new Tooltip(Res.get((String)"tooltip.openPopupForDetails")));
                            this.setGraphic((Node)this.field);
                        } else {
                            this.setGraphic(null);
                            if (this.field != null) {
                                this.field.setOnAction(null);
                            }
                        }
                    }
                };
            }
        });
    }

    private void setDateColumnCellFactory() {
        this.dateColumn.setCellValueFactory(item -> new ReadOnlyObjectWrapper((Object)((ClosedTradesListItem)item.getValue())));
        this.dateColumn.setCellFactory((Callback)new Callback<TableColumn<ClosedTradesListItem, ClosedTradesListItem>, TableCell<ClosedTradesListItem, ClosedTradesListItem>>(this){

            public TableCell<ClosedTradesListItem, ClosedTradesListItem> call(TableColumn<ClosedTradesListItem, ClosedTradesListItem> column) {
                return new TableCell<ClosedTradesListItem, ClosedTradesListItem>(this){

                    public void updateItem(ClosedTradesListItem item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null) {
                            this.setGraphic((Node)new AutoTooltipLabel(item.getDateAsString()));
                        } else {
                            this.setGraphic(null);
                        }
                    }
                };
            }
        });
    }

    private void setMarketColumnCellFactory() {
        this.marketColumn.setCellValueFactory(item -> new ReadOnlyObjectWrapper((Object)((ClosedTradesListItem)item.getValue())));
        this.marketColumn.setCellFactory((Callback)new Callback<TableColumn<ClosedTradesListItem, ClosedTradesListItem>, TableCell<ClosedTradesListItem, ClosedTradesListItem>>(this){

            public TableCell<ClosedTradesListItem, ClosedTradesListItem> call(TableColumn<ClosedTradesListItem, ClosedTradesListItem> column) {
                return new TableCell<ClosedTradesListItem, ClosedTradesListItem>(this){

                    public void updateItem(ClosedTradesListItem item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null && !empty) {
                            this.setGraphic((Node)new AutoTooltipLabel(item.getMarketLabel()));
                        } else {
                            this.setGraphic(null);
                        }
                    }
                };
            }
        });
    }

    private void setStateColumnCellFactory() {
        this.stateColumn.setCellValueFactory(item -> new ReadOnlyObjectWrapper((Object)((ClosedTradesListItem)item.getValue())));
        this.stateColumn.setCellFactory((Callback)new Callback<TableColumn<ClosedTradesListItem, ClosedTradesListItem>, TableCell<ClosedTradesListItem, ClosedTradesListItem>>(this){

            public TableCell<ClosedTradesListItem, ClosedTradesListItem> call(TableColumn<ClosedTradesListItem, ClosedTradesListItem> column) {
                return new TableCell<ClosedTradesListItem, ClosedTradesListItem>(this){

                    public void updateItem(ClosedTradesListItem item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null) {
                            this.setGraphic((Node)new AutoTooltipLabel(item.getState()));
                        } else {
                            this.setGraphic(null);
                        }
                    }
                };
            }
        });
    }

    private void setDuplicateColumnCellFactory() {
        this.duplicateColumn.getStyleClass().add((Object)"avatar-column");
        this.duplicateColumn.setCellValueFactory(offerListItem -> new ReadOnlyObjectWrapper((Object)((ClosedTradesListItem)offerListItem.getValue())));
        this.duplicateColumn.setCellFactory((Callback)new Callback<TableColumn<ClosedTradesListItem, ClosedTradesListItem>, TableCell<ClosedTradesListItem, ClosedTradesListItem>>(){

            public TableCell<ClosedTradesListItem, ClosedTradesListItem> call(TableColumn<ClosedTradesListItem, ClosedTradesListItem> column) {
                return new TableCell<ClosedTradesListItem, ClosedTradesListItem>(){
                    Button button;

                    public void updateItem(ClosedTradesListItem item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null && !empty && ClosedTradesView.this.isMyOfferAsMaker(item.getTradable().getOffer().getOfferPayload())) {
                            if (this.button == null) {
                                this.button = FormBuilder.getRegularIconButton((GlyphIcons)MaterialDesignIcon.CONTENT_COPY);
                                this.button.setTooltip(new Tooltip(Res.get((String)"portfolio.context.offerLikeThis")));
                                this.setGraphic((Node)this.button);
                            }
                            this.button.setOnAction(event -> ClosedTradesView.this.onDuplicateOffer(item.getTradable().getOffer()));
                        } else {
                            this.setGraphic(null);
                            if (this.button != null) {
                                this.button.setOnAction(null);
                                this.button = null;
                            }
                        }
                    }
                };
            }
        });
    }

    private TableColumn<ClosedTradesListItem, ClosedTradesListItem> setAvatarColumnCellFactory() {
        this.avatarColumn.getStyleClass().add((Object)"avatar-column");
        this.avatarColumn.setCellValueFactory(item -> new ReadOnlyObjectWrapper((Object)((ClosedTradesListItem)item.getValue())));
        this.avatarColumn.setCellFactory((Callback)new Callback<TableColumn<ClosedTradesListItem, ClosedTradesListItem>, TableCell<ClosedTradesListItem, ClosedTradesListItem>>(){

            public TableCell<ClosedTradesListItem, ClosedTradesListItem> call(TableColumn<ClosedTradesListItem, ClosedTradesListItem> column) {
                return new TableCell<ClosedTradesListItem, ClosedTradesListItem>(){

                    public void updateItem(ClosedTradesListItem item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (!empty && item != null && item.getTradable() instanceof Trade) {
                            Trade tradeModel = (Trade)item.getTradable();
                            int numPastTrades = item.getNumPastTrades();
                            NodeAddress tradePeerNodeAddress = tradeModel.getTradePeerNodeAddress();
                            String role = Res.get((String)"peerInfoIcon.tooltip.tradePeer");
                            PeerInfoIconTrading peerInfoIcon = new PeerInfoIconTrading(tradePeerNodeAddress, role, numPastTrades, ClosedTradesView.this.privateNotificationManager, tradeModel, ClosedTradesView.this.preferences, ((ClosedTradesDataModel)((ClosedTradesViewModel)((ClosedTradesView)ClosedTradesView.this).model).dataModel).accountAgeWitnessService, ClosedTradesView.this.useDevPrivilegeKeys);
                            this.setPadding(new Insets(1.0, 15.0, 0.0, 0.0));
                            this.setGraphic((Node)peerInfoIcon);
                        } else {
                            this.setGraphic(null);
                        }
                    }
                };
            }
        });
        return this.avatarColumn;
    }

    private void setAmountColumnCellFactory() {
        this.amountColumn.setCellValueFactory(item -> new ReadOnlyObjectWrapper((Object)((ClosedTradesListItem)item.getValue())));
        this.amountColumn.setCellFactory((Callback)new Callback<TableColumn<ClosedTradesListItem, ClosedTradesListItem>, TableCell<ClosedTradesListItem, ClosedTradesListItem>>(this){

            public TableCell<ClosedTradesListItem, ClosedTradesListItem> call(TableColumn<ClosedTradesListItem, ClosedTradesListItem> column) {
                return new TableCell<ClosedTradesListItem, ClosedTradesListItem>(this){

                    public void updateItem(ClosedTradesListItem item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null && !empty) {
                            this.setGraphic((Node)new AutoTooltipLabel(item.getAmountAsString()));
                        } else {
                            this.setGraphic(null);
                        }
                    }
                };
            }
        });
    }

    private void setPriceColumnCellFactory() {
        this.priceColumn.setCellValueFactory(item -> new ReadOnlyObjectWrapper((Object)((ClosedTradesListItem)item.getValue())));
        this.priceColumn.setCellFactory((Callback)new Callback<TableColumn<ClosedTradesListItem, ClosedTradesListItem>, TableCell<ClosedTradesListItem, ClosedTradesListItem>>(this){

            public TableCell<ClosedTradesListItem, ClosedTradesListItem> call(TableColumn<ClosedTradesListItem, ClosedTradesListItem> column) {
                return new TableCell<ClosedTradesListItem, ClosedTradesListItem>(this){

                    public void updateItem(ClosedTradesListItem item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null && !empty) {
                            this.setGraphic((Node)new AutoTooltipLabel(item.getPriceAsString()));
                        } else {
                            this.setGraphic(null);
                        }
                    }
                };
            }
        });
    }

    private void setDeviationColumnCellFactory() {
        this.deviationColumn.setCellValueFactory(item -> new ReadOnlyObjectWrapper((Object)((ClosedTradesListItem)item.getValue())));
        this.deviationColumn.setCellFactory((Callback)new Callback<TableColumn<ClosedTradesListItem, ClosedTradesListItem>, TableCell<ClosedTradesListItem, ClosedTradesListItem>>(this){

            public TableCell<ClosedTradesListItem, ClosedTradesListItem> call(TableColumn<ClosedTradesListItem, ClosedTradesListItem> column) {
                return new TableCell<ClosedTradesListItem, ClosedTradesListItem>(this){

                    public void updateItem(ClosedTradesListItem item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null && !empty) {
                            this.setGraphic((Node)new AutoTooltipLabel(item.getPriceDeviationAsString()));
                        } else {
                            this.setGraphic(null);
                        }
                    }
                };
            }
        });
    }

    private void setVolumeColumnCellFactory() {
        this.volumeColumn.setCellValueFactory(item -> new ReadOnlyObjectWrapper((Object)((ClosedTradesListItem)item.getValue())));
        this.volumeColumn.setCellFactory((Callback)new Callback<TableColumn<ClosedTradesListItem, ClosedTradesListItem>, TableCell<ClosedTradesListItem, ClosedTradesListItem>>(this){

            public TableCell<ClosedTradesListItem, ClosedTradesListItem> call(TableColumn<ClosedTradesListItem, ClosedTradesListItem> column) {
                return new TableCell<ClosedTradesListItem, ClosedTradesListItem>(this){

                    public void updateItem(ClosedTradesListItem item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null) {
                            this.setGraphic((Node)new AutoTooltipLabel(item.getVolumeAsString(true)));
                        } else {
                            this.setGraphic(null);
                        }
                    }
                };
            }
        });
    }

    private void setDirectionColumnCellFactory() {
        this.directionColumn.setCellValueFactory(item -> new ReadOnlyObjectWrapper((Object)((ClosedTradesListItem)item.getValue())));
        this.directionColumn.setCellFactory((Callback)new Callback<TableColumn<ClosedTradesListItem, ClosedTradesListItem>, TableCell<ClosedTradesListItem, ClosedTradesListItem>>(this){

            public TableCell<ClosedTradesListItem, ClosedTradesListItem> call(TableColumn<ClosedTradesListItem, ClosedTradesListItem> column) {
                return new TableCell<ClosedTradesListItem, ClosedTradesListItem>(this){

                    public void updateItem(ClosedTradesListItem item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null && !empty) {
                            this.setGraphic((Node)new AutoTooltipLabel(item.getDirectionLabel()));
                        } else {
                            this.setGraphic(null);
                        }
                    }
                };
            }
        });
    }

    private void setTradeFeeColumnCellFactory() {
        this.tradeFeeColumn.setCellValueFactory(item -> new ReadOnlyObjectWrapper((Object)((ClosedTradesListItem)item.getValue())));
        this.tradeFeeColumn.setCellFactory((Callback)new Callback<TableColumn<ClosedTradesListItem, ClosedTradesListItem>, TableCell<ClosedTradesListItem, ClosedTradesListItem>>(this){

            public TableCell<ClosedTradesListItem, ClosedTradesListItem> call(TableColumn<ClosedTradesListItem, ClosedTradesListItem> column) {
                return new TableCell<ClosedTradesListItem, ClosedTradesListItem>(this){

                    public void updateItem(ClosedTradesListItem item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null && !empty) {
                            this.setGraphic((Node)new AutoTooltipLabel(item.getTradeFeeAsString(true)));
                        } else {
                            this.setGraphic(null);
                        }
                    }
                };
            }
        });
    }

    private void setBuyerSecurityDepositColumnCellFactory() {
        this.buyerSecurityDepositColumn.setCellValueFactory(item -> new ReadOnlyObjectWrapper((Object)((ClosedTradesListItem)item.getValue())));
        this.buyerSecurityDepositColumn.setCellFactory((Callback)new Callback<TableColumn<ClosedTradesListItem, ClosedTradesListItem>, TableCell<ClosedTradesListItem, ClosedTradesListItem>>(this){

            public TableCell<ClosedTradesListItem, ClosedTradesListItem> call(TableColumn<ClosedTradesListItem, ClosedTradesListItem> column) {
                return new TableCell<ClosedTradesListItem, ClosedTradesListItem>(this){

                    public void updateItem(ClosedTradesListItem item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null && !empty) {
                            this.setGraphic((Node)new AutoTooltipLabel(item.getBuyerSecurityDepositAsString()));
                        } else {
                            this.setGraphic(null);
                        }
                    }
                };
            }
        });
    }

    private void setSellerSecurityDepositColumnCellFactory() {
        this.sellerSecurityDepositColumn.setCellValueFactory(item -> new ReadOnlyObjectWrapper((Object)((ClosedTradesListItem)item.getValue())));
        this.sellerSecurityDepositColumn.setCellFactory((Callback)new Callback<TableColumn<ClosedTradesListItem, ClosedTradesListItem>, TableCell<ClosedTradesListItem, ClosedTradesListItem>>(this){

            public TableCell<ClosedTradesListItem, ClosedTradesListItem> call(TableColumn<ClosedTradesListItem, ClosedTradesListItem> column) {
                return new TableCell<ClosedTradesListItem, ClosedTradesListItem>(this){

                    public void updateItem(ClosedTradesListItem item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null && !empty) {
                            this.setGraphic((Node)new AutoTooltipLabel(item.getSellerSecurityDepositAsString()));
                        } else {
                            this.setGraphic(null);
                        }
                    }
                };
            }
        });
    }

    private TableColumn<ClosedTradesListItem, ClosedTradesListItem> setRemoveTradeColumnCellFactory() {
        this.removeTradeColumn.setCellValueFactory(trade -> new ReadOnlyObjectWrapper((Object)((ClosedTradesListItem)trade.getValue())));
        this.removeTradeColumn.setCellFactory((Callback)new Callback<TableColumn<ClosedTradesListItem, ClosedTradesListItem>, TableCell<ClosedTradesListItem, ClosedTradesListItem>>(){

            public TableCell<ClosedTradesListItem, ClosedTradesListItem> call(TableColumn<ClosedTradesListItem, ClosedTradesListItem> column) {
                return new TableCell<ClosedTradesListItem, ClosedTradesListItem>(){

                    public void updateItem(ClosedTradesListItem newItem, boolean empty) {
                        if (newItem == null || !(newItem.getTradable() instanceof Trade)) {
                            this.setGraphic(null);
                            return;
                        }
                        Trade trade = (Trade)newItem.getTradable();
                        super.updateItem((Object)newItem, empty);
                        if (!empty && newItem != null && !trade.isPayoutConfirmed()) {
                            Label icon = FormBuilder.getIcon(AwesomeIcon.UNDO);
                            JFXButton iconButton = new JFXButton("", (Node)icon);
                            iconButton.setStyle("-fx-cursor: hand; -fx-padding: 0 10 0 10;");
                            iconButton.getStyleClass().add((Object)"hidden-icon-button");
                            iconButton.setTooltip(new Tooltip(Res.get((String)"portfolio.failed.revertToPending")));
                            iconButton.setOnAction(e -> ClosedTradesView.this.onRevertTrade(trade));
                            this.setGraphic((Node)iconButton);
                        } else {
                            this.setGraphic(null);
                        }
                    }
                };
            }
        });
        return this.removeTradeColumn;
    }

    private void onRevertTrade(Trade trade) {
        ((Popup)((Popup)((Popup)((Popup)new Popup().attention(Res.get((String)"portfolio.failed.revertToPending.popup"))).onAction(() -> this.onMoveTradeToPendingTrades(trade))).actionButtonText(Res.get((String)"shared.yes"))).closeButtonText(Res.get((String)"shared.no"))).show();
    }

    private void onMoveTradeToPendingTrades(Trade trade) {
        ((ClosedTradesDataModel)((ClosedTradesViewModel)this.model).dataModel).onMoveTradeToPendingTrades(trade);
    }

    private void onDuplicateOffer(Offer offer) {
        try {
            OfferPayload offerPayload = offer.getOfferPayload();
            if (this.isMyOfferAsMaker(offerPayload)) {
                PortfolioUtil.duplicateOffer(this.navigation, offerPayload);
            } else {
                ((Popup)new Popup().warning(Res.get((String)"portfolio.context.notYourOffer"))).show();
            }
        }
        catch (NullPointerException e) {
            this.log.warn("Unable to get offerPayload - {}", (Object)e.toString());
        }
    }

    private boolean isMyOfferAsMaker(OfferPayload offerPayload) {
        return offerPayload.getPubKeyRing().equals((Object)this.keyRing.getPubKeyRing());
    }

    private static enum ColumnNames {
        TRADE_ID(Res.get((String)"shared.tradeId")),
        DATE(Res.get((String)"shared.dateTime")),
        MARKET(Res.get((String)"shared.market")),
        PRICE(Res.get((String)"shared.price")),
        DEVIATION(Res.get((String)"shared.deviation")),
        AMOUNT(Res.get((String)"shared.amountWithCur", (Object[])new Object[]{Res.getBaseCurrencyCode()})),
        VOLUME(Res.get((String)"shared.amount")),
        VOLUME_CURRENCY(Res.get((String)"shared.currency")),
        TX_FEE(Res.get((String)"shared.txFee")),
        TRADE_FEE(Res.get((String)"shared.tradeFee")),
        BUYER_SEC(Res.get((String)"shared.buyerSecurityDeposit")),
        SELLER_SEC(Res.get((String)"shared.sellerSecurityDeposit")),
        OFFER_TYPE(Res.get((String)"shared.offerType")),
        STATUS(Res.get((String)"shared.state"));

        private final String text;

        private ColumnNames(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }
    }
}

