/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.portfolio.closedtrades;

import haveno.core.locale.CurrencyUtil;
import haveno.core.monetary.Price;
import haveno.core.offer.Offer;
import haveno.core.offer.OfferDirection;
import haveno.core.trade.ArbitratorTrade;
import haveno.core.trade.ClosedTradableFormatter;
import haveno.core.trade.ClosedTradableManager;
import haveno.core.trade.Tradable;
import haveno.core.trade.Trade;
import haveno.desktop.util.DisplayUtils;
import haveno.desktop.util.filtering.FilterableListItem;
import haveno.desktop.util.filtering.FilteringUtils;
import java.math.BigInteger;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class ClosedTradesListItem
implements FilterableListItem {
    private final Tradable tradable;
    private final ClosedTradableFormatter closedTradableFormatter;
    private final ClosedTradableManager closedTradableManager;

    public ClosedTradesListItem(Tradable tradable, ClosedTradableFormatter closedTradableFormatter, ClosedTradableManager closedTradableManager) {
        this.tradable = tradable;
        this.closedTradableFormatter = closedTradableFormatter;
        this.closedTradableManager = closedTradableManager;
    }

    public String getTradeId() {
        return this.tradable.getShortId();
    }

    public BigInteger getAmount() {
        return this.tradable.getOptionalAmount().orElse(null);
    }

    public String getAmountAsString() {
        return this.closedTradableFormatter.getAmountAsString(this.tradable);
    }

    public Price getPrice() {
        return this.tradable.getOptionalPrice().orElse(null);
    }

    public String getPriceAsString() {
        return this.closedTradableFormatter.getPriceAsString(this.tradable);
    }

    public String getPriceDeviationAsString() {
        return this.closedTradableFormatter.getPriceDeviationAsString(this.tradable);
    }

    public String getVolumeAsString(boolean appendCode) {
        return this.closedTradableFormatter.getVolumeAsString(this.tradable, appendCode);
    }

    public String getVolumeCurrencyAsString() {
        return this.closedTradableFormatter.getVolumeCurrencyAsString(this.tradable);
    }

    public String getTxFeeAsString() {
        return this.closedTradableFormatter.getTotalTxFeeAsString(this.tradable);
    }

    public String getTradeFeeAsString(boolean appendCode) {
        return this.closedTradableFormatter.getTradeFeeAsString(this.tradable, appendCode);
    }

    public String getBuyerSecurityDepositAsString() {
        return this.closedTradableFormatter.getBuyerSecurityDepositAsString(this.tradable);
    }

    public String getSellerSecurityDepositAsString() {
        return this.closedTradableFormatter.getSellerSecurityDepositAsString(this.tradable);
    }

    public String getDirectionLabel() {
        Offer offer = this.tradable.getOffer();
        OfferDirection direction = this.closedTradableManager.wasMyOffer(offer) || this.tradable instanceof ArbitratorTrade ? offer.getDirection() : offer.getMirroredDirection();
        String currencyCode = this.tradable.getOffer().getCounterCurrencyCode();
        return DisplayUtils.getDirectionWithCode(direction, currencyCode, offer.isPrivateOffer());
    }

    public Date getDate() {
        return this.tradable.getDate();
    }

    public String getDateAsString() {
        return DisplayUtils.formatDateTime(this.tradable.getDate());
    }

    public String getMarketLabel() {
        return CurrencyUtil.getCurrencyPair((String)this.tradable.getOffer().getCounterCurrencyCode());
    }

    public String getState() {
        return this.closedTradableFormatter.getStateAsString(this.tradable);
    }

    public int getNumPastTrades() {
        return this.closedTradableManager.getNumPastTrades(this.tradable);
    }

    @Override
    public boolean match(String filterString) {
        if (filterString.isEmpty()) {
            return true;
        }
        if (StringUtils.containsIgnoreCase((CharSequence)this.getDateAsString(), (CharSequence)filterString)) {
            return true;
        }
        if (StringUtils.containsIgnoreCase((CharSequence)this.getMarketLabel(), (CharSequence)filterString)) {
            return true;
        }
        if (StringUtils.containsIgnoreCase((CharSequence)this.getPriceAsString(), (CharSequence)filterString)) {
            return true;
        }
        if (StringUtils.containsIgnoreCase((CharSequence)this.getPriceDeviationAsString(), (CharSequence)filterString)) {
            return true;
        }
        if (StringUtils.containsIgnoreCase((CharSequence)this.getVolumeAsString(true), (CharSequence)filterString)) {
            return true;
        }
        if (StringUtils.containsIgnoreCase((CharSequence)this.getAmountAsString(), (CharSequence)filterString)) {
            return true;
        }
        if (StringUtils.containsIgnoreCase((CharSequence)this.getTradeFeeAsString(true), (CharSequence)filterString)) {
            return true;
        }
        if (StringUtils.containsIgnoreCase((CharSequence)this.getTxFeeAsString(), (CharSequence)filterString)) {
            return true;
        }
        if (StringUtils.containsIgnoreCase((CharSequence)this.getBuyerSecurityDepositAsString(), (CharSequence)filterString)) {
            return true;
        }
        if (StringUtils.containsIgnoreCase((CharSequence)this.getSellerSecurityDepositAsString(), (CharSequence)filterString)) {
            return true;
        }
        if (StringUtils.containsIgnoreCase((CharSequence)this.getState(), (CharSequence)filterString)) {
            return true;
        }
        if (StringUtils.containsIgnoreCase((CharSequence)this.getDirectionLabel(), (CharSequence)filterString)) {
            return true;
        }
        if (FilteringUtils.match(this.getTradable().getOffer(), filterString)) {
            return true;
        }
        return this.getTradable() instanceof Trade && FilteringUtils.match((Trade)this.getTradable(), filterString);
    }

    public Tradable getTradable() {
        return this.tradable;
    }
}

