/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.portfolio.closedtrades;

import com.google.inject.Inject;
import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.monetary.Price;
import haveno.core.monetary.Volume;
import haveno.core.provider.price.MarketPrice;
import haveno.core.provider.price.PriceFeedService;
import haveno.core.trade.ClosedTradableFormatter;
import haveno.core.trade.ClosedTradableManager;
import haveno.core.trade.ClosedTradableUtil;
import haveno.core.trade.Tradable;
import haveno.core.trade.Trade;
import haveno.core.trade.TradeManager;
import haveno.core.user.Preferences;
import haveno.core.util.PriceUtil;
import haveno.core.util.VolumeUtil;
import haveno.desktop.common.model.ActivatableDataModel;
import haveno.desktop.main.portfolio.closedtrades.ClosedTradesListItem;
import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;

class ClosedTradesDataModel
extends ActivatableDataModel {
    final ClosedTradableManager closedTradableManager;
    final ClosedTradableFormatter closedTradableFormatter;
    private final Preferences preferences;
    private final PriceFeedService priceFeedService;
    final AccountAgeWitnessService accountAgeWitnessService;
    private final ObservableList<ClosedTradesListItem> list = FXCollections.observableArrayList();
    private final ListChangeListener<Tradable> tradesListChangeListener;
    private final TradeManager tradeManager;

    @Inject
    public ClosedTradesDataModel(ClosedTradableManager closedTradableManager, ClosedTradableFormatter closedTradableFormatter, Preferences preferences, PriceFeedService priceFeedService, AccountAgeWitnessService accountAgeWitnessService, TradeManager tradeManager) {
        this.closedTradableManager = closedTradableManager;
        this.closedTradableFormatter = closedTradableFormatter;
        this.preferences = preferences;
        this.priceFeedService = priceFeedService;
        this.accountAgeWitnessService = accountAgeWitnessService;
        this.tradeManager = tradeManager;
        this.tradesListChangeListener = change -> this.applyList();
    }

    @Override
    protected void activate() {
        this.applyList();
        this.closedTradableManager.getObservableList().addListener(this.tradesListChangeListener);
    }

    @Override
    protected void deactivate() {
        this.closedTradableManager.getObservableList().removeListener(this.tradesListChangeListener);
    }

    ObservableList<ClosedTradesListItem> getList() {
        return this.list;
    }

    List<Tradable> getListAsTradables() {
        return this.list.stream().map(ClosedTradesListItem::getTradable).collect(Collectors.toList());
    }

    BigInteger getTotalAmount() {
        return ClosedTradableUtil.getTotalAmount(this.getListAsTradables());
    }

    Optional<Volume> getVolumeInUserFiatCurrency(BigInteger amount) {
        return this.getVolume(amount, this.preferences.getPreferredTradeCurrency().getCode());
    }

    Optional<Volume> getVolume(BigInteger amount, String currencyCode) {
        MarketPrice marketPrice = this.priceFeedService.getMarketPrice(currencyCode);
        if (marketPrice == null) {
            return Optional.empty();
        }
        Price price = PriceUtil.marketPriceToPrice((MarketPrice)marketPrice);
        return Optional.of(VolumeUtil.getVolume((BigInteger)amount, (Price)price));
    }

    BigInteger getTotalTxFee() {
        return ClosedTradableUtil.getTotalTxFee(this.getListAsTradables());
    }

    BigInteger getTotalTradeFee() {
        return this.closedTradableManager.getTotalTradeFee(this.getListAsTradables());
    }

    boolean isCurrencyForTradeFeeBtc(Tradable item) {
        return item != null;
    }

    private void applyList() {
        this.list.clear();
        this.list.addAll((Collection)this.closedTradableManager.getObservableList().stream().map(tradable -> new ClosedTradesListItem((Tradable)tradable, this.closedTradableFormatter, this.closedTradableManager)).collect(Collectors.toList()));
        this.list.sort((o1, o2) -> o2.getTradable().getDate().compareTo(o1.getTradable().getDate()));
    }

    public void onMoveTradeToPendingTrades(Trade trade) {
        this.tradeManager.onMoveClosedTradeToPendingTrades(trade);
    }
}

