/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.portfolio.cloneoffer;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import haveno.common.handlers.ErrorMessageHandler;
import haveno.common.handlers.ResultHandler;
import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.monetary.Price;
import haveno.core.offer.OfferUtil;
import haveno.core.offer.OpenOffer;
import haveno.core.payment.validation.FiatVolumeValidator;
import haveno.core.payment.validation.SecurityDepositValidator;
import haveno.core.payment.validation.XmrValidator;
import haveno.core.provider.price.PriceFeedService;
import haveno.core.user.Preferences;
import haveno.core.util.FormattingUtils;
import haveno.core.util.PriceUtil;
import haveno.core.util.coin.CoinFormatter;
import haveno.core.util.validation.AmountValidator4Decimals;
import haveno.core.util.validation.AmountValidator8Decimals;
import haveno.desktop.Navigation;
import haveno.desktop.main.offer.MutableOfferViewModel;
import haveno.desktop.main.offer.OfferViewUtil;
import haveno.desktop.main.portfolio.cloneoffer.CloneOfferDataModel;

class CloneOfferViewModel
extends MutableOfferViewModel<CloneOfferDataModel> {
    @Inject
    public CloneOfferViewModel(CloneOfferDataModel dataModel, FiatVolumeValidator fiatVolumeValidator, AmountValidator4Decimals priceValidator4Decimals, AmountValidator8Decimals priceValidator8Decimals, XmrValidator xmrValidator, SecurityDepositValidator securityDepositValidator, PriceFeedService priceFeedService, AccountAgeWitnessService accountAgeWitnessService, Navigation navigation, Preferences preferences, @Named(value="BTC") CoinFormatter btcFormatter, OfferUtil offerUtil) {
        super(dataModel, fiatVolumeValidator, priceValidator4Decimals, priceValidator8Decimals, xmrValidator, securityDepositValidator, priceFeedService, accountAgeWitnessService, navigation, preferences, btcFormatter, offerUtil);
        this.syncMinAmountWithAmount = false;
    }

    @Override
    public void activate() {
        super.activate();
        ((CloneOfferDataModel)this.dataModel).populateData();
        long triggerPriceAsLong = ((CloneOfferDataModel)this.dataModel).getTriggerPrice();
        ((CloneOfferDataModel)this.dataModel).setTriggerPrice(triggerPriceAsLong);
        if (triggerPriceAsLong > 0L) {
            this.triggerPrice.set((Object)PriceUtil.formatMarketPrice((long)triggerPriceAsLong, (String)((CloneOfferDataModel)this.dataModel).getCurrencyCode()));
        } else {
            this.triggerPrice.set((Object)"");
        }
        this.onTriggerPriceTextFieldChanged();
    }

    public void applyOpenOffer(OpenOffer openOffer) {
        ((CloneOfferDataModel)this.dataModel).reset();
        ((CloneOfferDataModel)this.dataModel).applyOpenOffer(openOffer);
    }

    public void onCloneOffer(ResultHandler resultHandler, ErrorMessageHandler errorMessageHandler) {
        ((CloneOfferDataModel)this.dataModel).onCloneOffer(resultHandler, errorMessageHandler);
    }

    public void onInvalidateMarketPriceMargin() {
        this.marketPriceMargin.set((Object)FormattingUtils.formatToPercent((double)((CloneOfferDataModel)this.dataModel).getMarketPriceMarginPct()));
    }

    public void onInvalidatePrice() {
        this.price.set((Object)FormattingUtils.formatPrice(null));
        this.price.set((Object)FormattingUtils.formatPrice((Price)((Price)((CloneOfferDataModel)this.dataModel).getPrice().get())));
    }

    public boolean isSecurityDepositValid() {
        return this.securityDepositValidator.validate((String)((String)this.securityDeposit.get())).isValid;
    }

    @Override
    public void triggerFocusOutOnAmountFields() {
    }

    public boolean isShownAsSellOffer() {
        return OfferViewUtil.isShownAsSellOffer(this.getTradeCurrency(), ((CloneOfferDataModel)this.dataModel).getDirection());
    }
}

