/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.portfolio.cloneoffer;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import haveno.common.UserThread;
import haveno.common.util.Tuple4;
import haveno.core.locale.CurrencyUtil;
import haveno.core.locale.Res;
import haveno.core.locale.TradeCurrency;
import haveno.core.offer.OpenOffer;
import haveno.core.payment.PaymentAccount;
import haveno.core.user.DontShowAgainLookup;
import haveno.core.user.Preferences;
import haveno.core.util.coin.CoinFormatter;
import haveno.desktop.Navigation;
import haveno.desktop.common.view.FxmlView;
import haveno.desktop.components.AutoTooltipButton;
import haveno.desktop.components.BusyAnimation;
import haveno.desktop.main.offer.MutableOfferView;
import haveno.desktop.main.overlays.popups.Popup;
import haveno.desktop.main.overlays.windows.OfferDetailsWindow;
import haveno.desktop.main.portfolio.cloneoffer.CloneOfferDataModel;
import haveno.desktop.main.portfolio.cloneoffer.CloneOfferViewModel;
import haveno.desktop.util.FormBuilder;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;

@FxmlView
public class CloneOfferView
extends MutableOfferView<CloneOfferViewModel> {
    private BusyAnimation busyAnimation;
    private Button cloneButton;
    private Button cancelButton;
    private Label spinnerInfoLabel;

    @Inject
    private CloneOfferView(CloneOfferViewModel model, Navigation navigation, Preferences preferences, OfferDetailsWindow offerDetailsWindow, @Named(value="BTC") CoinFormatter btcFormatter) {
        super(model, navigation, preferences, offerDetailsWindow, btcFormatter);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.addCloneGroup();
        this.renameAmountGroup();
    }

    private void renameAmountGroup() {
        this.amountTitledGroupBg.setText(Res.get((String)"editOffer.setPrice"));
    }

    @Override
    protected void doSetFocus() {
    }

    @Override
    protected void doActivate() {
        super.doActivate();
        this.addBindings();
        this.hideOptionsGroup();
        this.hideNextButtons();
        this.amountTextField.setDisable(true);
        this.amountBtcLabel.setDisable(true);
        this.minAmountTextField.setDisable(true);
        this.minAmountBtcLabel.setDisable(true);
        this.volumeTextField.setDisable(true);
        this.volumeCurrencyLabel.setDisable(true);
        this.gridPane.setPadding(new Insets(-20.0, 25.0, 25.0, 25.0));
        this.updatePriceToggle();
        this.updateElementsWithDirection();
        ((CloneOfferViewModel)this.model).isNextButtonDisabled.setValue(Boolean.valueOf(false));
        this.cancelButton.setDisable(false);
        ((CloneOfferViewModel)this.model).onInvalidateMarketPriceMargin();
        ((CloneOfferViewModel)this.model).onInvalidatePrice();
        this.onPaymentAccountsComboBoxSelected();
    }

    @Override
    protected void deactivate() {
        super.deactivate();
        this.removeBindings();
    }

    @Override
    public void onClose() {
    }

    public void applyOpenOffer(OpenOffer openOffer) {
        ((CloneOfferViewModel)this.model).applyOpenOffer(openOffer);
        this.initWithData(openOffer.getOffer().getDirection(), (TradeCurrency)CurrencyUtil.getTradeCurrency((String)openOffer.getOffer().getCounterCurrencyCode()).get(), false, null);
        if (!((CloneOfferViewModel)this.model).isSecurityDepositValid()) {
            ((Popup)((Popup)new Popup().warning(Res.get((String)"editOffer.invalidDeposit"))).onClose(() -> this.close())).show();
        }
    }

    private void addBindings() {
        this.cloneButton.disableProperty().bind((ObservableValue)((CloneOfferViewModel)this.model).isNextButtonDisabled);
    }

    private void removeBindings() {
        this.cloneButton.disableProperty().unbind();
    }

    @Override
    protected ObservableList<PaymentAccount> filterPaymentAccounts(ObservableList<PaymentAccount> paymentAccounts) {
        return paymentAccounts;
    }

    private void addCloneGroup() {
        Tuple4<Button, BusyAnimation, Label, HBox> tuple4 = FormBuilder.addButtonBusyAnimationLabelAfterGroup(this.gridPane, 6, Res.get((String)"cloneOffer.clone"));
        HBox hBox = (HBox)tuple4.fourth;
        hBox.setAlignment(Pos.CENTER_LEFT);
        GridPane.setHalignment((Node)hBox, (HPos)HPos.LEFT);
        this.cloneButton = (Button)tuple4.first;
        this.cloneButton.setMinHeight(40.0);
        this.cloneButton.setPadding(new Insets(0.0, 20.0, 0.0, 20.0));
        this.cloneButton.setGraphicTextGap(10.0);
        this.busyAnimation = (BusyAnimation)((Object)tuple4.second);
        this.spinnerInfoLabel = (Label)tuple4.third;
        this.cancelButton = new AutoTooltipButton(Res.get((String)"shared.cancel"));
        this.cancelButton.setDefaultButton(false);
        this.cancelButton.setOnAction(event -> this.close());
        hBox.getChildren().add((Object)this.cancelButton);
        this.cloneButton.setOnAction(e -> {
            this.cloneButton.requestFocus();
            this.onClone();
        });
    }

    private void onClone() {
        if (((CloneOfferDataModel)((CloneOfferViewModel)this.model).dataModel).hasConflictingClone()) {
            ((Popup)((Popup)((Popup)((Popup)new Popup().warning(Res.get((String)"cloneOffer.hasConflictingClone"))).actionButtonText(Res.get((String)"shared.yes"))).onAction(this::doClone)).closeButtonText(Res.get((String)"shared.no"))).show();
        } else {
            this.doClone();
        }
    }

    private void doClone() {
        if (((CloneOfferViewModel)this.model).isPriceInRange()) {
            ((CloneOfferViewModel)this.model).isNextButtonDisabled.setValue(Boolean.valueOf(true));
            this.cancelButton.setDisable(true);
            this.busyAnimation.play();
            this.spinnerInfoLabel.setText(Res.get((String)"cloneOffer.publishOffer"));
            ((CloneOfferViewModel)this.model).onCloneOffer(() -> UserThread.execute(() -> {
                String key = "cloneOfferSuccess";
                if (DontShowAgainLookup.showAgain((String)key)) {
                    ((Popup)((Popup)new Popup().feedback(Res.get((String)"cloneOffer.success"))).dontShowAgainId(key)).show();
                }
                this.spinnerInfoLabel.setText("");
                this.busyAnimation.stop();
                this.close();
            }), errorMessage -> UserThread.execute(() -> {
                this.log.error(errorMessage);
                this.spinnerInfoLabel.setText("");
                this.busyAnimation.stop();
                ((CloneOfferViewModel)this.model).isNextButtonDisabled.setValue(Boolean.valueOf(false));
                this.cancelButton.setDisable(false);
                ((Popup)new Popup().warning(errorMessage)).show();
            }));
        }
    }

    private void updateElementsWithDirection() {
        ImageView iconView = new ImageView();
        iconView.setId(((CloneOfferViewModel)this.model).isShownAsSellOffer() ? "image-sell-white" : "image-buy-white");
        this.cloneButton.setGraphic((Node)iconView);
        this.cloneButton.setId(((CloneOfferViewModel)this.model).isShownAsSellOffer() ? "sell-button-big" : "buy-button-big");
    }
}

