/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.portfolio.cloneoffer;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import haveno.common.handlers.ErrorMessageHandler;
import haveno.common.handlers.ResultHandler;
import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.locale.CurrencyUtil;
import haveno.core.locale.TradeCurrency;
import haveno.core.monetary.Price;
import haveno.core.offer.CreateOfferService;
import haveno.core.offer.Offer;
import haveno.core.offer.OfferDirection;
import haveno.core.offer.OfferUtil;
import haveno.core.offer.OpenOffer;
import haveno.core.offer.OpenOfferManager;
import haveno.core.payment.PaymentAccount;
import haveno.core.proto.CoreProtoResolver;
import haveno.core.proto.persistable.CorePersistenceProtoResolver;
import haveno.core.provider.price.PriceFeedService;
import haveno.core.trade.statistics.TradeStatisticsManager;
import haveno.core.user.Preferences;
import haveno.core.user.User;
import haveno.core.util.coin.CoinFormatter;
import haveno.core.xmr.wallet.XmrWalletService;
import haveno.desktop.Navigation;
import haveno.desktop.main.offer.MutableOfferDataModel;
import haveno.network.p2p.P2PService;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

class CloneOfferDataModel
extends MutableOfferDataModel {
    private final CorePersistenceProtoResolver corePersistenceProtoResolver;
    private OpenOffer sourceOpenOffer;

    @Inject
    CloneOfferDataModel(CreateOfferService createOfferService, OpenOfferManager openOfferManager, OfferUtil offerUtil, XmrWalletService xmrWalletService, Preferences preferences, User user, P2PService p2PService, PriceFeedService priceFeedService, AccountAgeWitnessService accountAgeWitnessService, @Named(value="BTC") CoinFormatter xmrFormatter, CorePersistenceProtoResolver corePersistenceProtoResolver, TradeStatisticsManager tradeStatisticsManager, Navigation navigation) {
        super(createOfferService, openOfferManager, offerUtil, xmrWalletService, preferences, user, p2PService, priceFeedService, accountAgeWitnessService, xmrFormatter, tradeStatisticsManager, navigation);
        this.corePersistenceProtoResolver = corePersistenceProtoResolver;
    }

    public void reset() {
        this.direction = null;
        this.tradeCurrency = null;
        this.tradeCurrencyCode.set(null);
        this.useMarketBasedPrice.set(false);
        this.amount.set(null);
        this.minAmount.set(null);
        this.price.set(null);
        this.volume.set(null);
        this.minVolume.set(null);
        this.securityDepositPct.set(0.0);
        this.paymentAccounts.clear();
        this.paymentAccount = null;
        this.marketPriceMarginPct = 0.0;
        this.sourceOpenOffer = null;
    }

    public void applyOpenOffer(OpenOffer openOffer) {
        this.sourceOpenOffer = openOffer;
        Offer offer = openOffer.getOffer();
        this.direction = offer.getDirection();
        CurrencyUtil.getTradeCurrency((String)offer.getCounterCurrencyCode()).ifPresent(c -> {
            this.tradeCurrency = c;
        });
        this.tradeCurrencyCode.set((Object)offer.getCounterCurrencyCode());
        PaymentAccount tmpPaymentAccount = this.user.getPaymentAccount(openOffer.getOffer().getMakerPaymentAccountId());
        Optional optionalTradeCurrency = CurrencyUtil.getTradeCurrency((String)openOffer.getOffer().getCounterCurrencyCode());
        if (optionalTradeCurrency.isPresent() && tmpPaymentAccount != null) {
            TradeCurrency selectedTradeCurrency = (TradeCurrency)optionalTradeCurrency.get();
            this.paymentAccount = PaymentAccount.fromProto((protobuf.PaymentAccount)tmpPaymentAccount.toProtoMessage(), (CoreProtoResolver)this.corePersistenceProtoResolver);
            if (this.paymentAccount.getSingleTradeCurrency() != null) {
                this.paymentAccount.setSingleTradeCurrency(selectedTradeCurrency);
            } else {
                this.paymentAccount.setSelectedTradeCurrency(selectedTradeCurrency);
            }
        }
        this.allowAmountUpdate = false;
    }

    public boolean initWithData(OfferDirection direction, TradeCurrency tradeCurrency) {
        try {
            return super.initWithData(direction, tradeCurrency, false);
        }
        catch (NullPointerException e) {
            if (e.getMessage().contains("tradeCurrency")) {
                throw new IllegalArgumentException("Offers of removed assets cannot be edited. You can only cancel it.", e);
            }
            return false;
        }
    }

    @Override
    protected Set<PaymentAccount> getUserPaymentAccounts() {
        return Objects.requireNonNull(this.user.getPaymentAccounts()).stream().filter(account -> !account.getPaymentMethod().isBsqSwap()).collect(Collectors.toSet());
    }

    @Override
    protected PaymentAccount getPreselectedPaymentAccount() {
        return this.paymentAccount;
    }

    public void populateData() {
        Offer offer = this.sourceOpenOffer.getOffer();
        this.setMinAmount(offer.getMinAmount());
        this.setAmount(offer.getAmount());
        this.setPrice(offer.getPrice());
        this.setVolume(offer.getVolume());
        this.setUseMarketBasedPrice(offer.isUseMarketBasedPrice());
        this.setTriggerPrice(this.sourceOpenOffer.getTriggerPrice());
        if (offer.isUseMarketBasedPrice()) {
            this.setMarketPriceMarginPct(offer.getMarketPriceMarginPct());
        }
        this.setBuyerAsTakerWithoutDeposit(offer.hasBuyerAsTakerWithoutDeposit());
        this.setSecurityDepositPct(this.getSecurityAsPercent(offer));
        this.setExtraInfo(offer.getOfferExtraInfo());
    }

    public void onCloneOffer(ResultHandler resultHandler, ErrorMessageHandler errorMessageHandler) {
        Offer clonedOffer = this.createClonedOffer();
        this.openOfferManager.placeOffer(clonedOffer, false, this.triggerPrice, false, true, this.sourceOpenOffer.getId(), transaction -> resultHandler.handleResult(), errorMessageHandler);
    }

    private Offer createClonedOffer() {
        return this.createOfferService.createClonedOffer(this.sourceOpenOffer.getOffer(), (String)this.tradeCurrencyCode.get(), this.useMarketBasedPrice.get() ? null : (Price)this.price.get(), this.useMarketBasedPrice.get(), this.useMarketBasedPrice.get() ? this.marketPriceMarginPct : 0.0, this.paymentAccount, (String)this.extraInfo.get());
    }

    public boolean hasConflictingClone() {
        Offer clonedOffer = this.createClonedOffer();
        return this.openOfferManager.hasConflictingClone(clonedOffer, this.sourceOpenOffer);
    }
}

