/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.portfolio;

import com.google.inject.Inject;
import haveno.common.UserThread;
import haveno.core.locale.Res;
import haveno.core.offer.OfferPayload;
import haveno.core.offer.OpenOffer;
import haveno.core.trade.failed.FailedTradesManager;
import haveno.desktop.Navigation;
import haveno.desktop.common.view.ActivatableView;
import haveno.desktop.common.view.CachingViewLoader;
import haveno.desktop.common.view.FxmlView;
import haveno.desktop.common.view.View;
import haveno.desktop.main.MainView;
import haveno.desktop.main.overlays.popups.Popup;
import haveno.desktop.main.portfolio.cloneoffer.CloneOfferView;
import haveno.desktop.main.portfolio.closedtrades.ClosedTradesView;
import haveno.desktop.main.portfolio.duplicateoffer.DuplicateOfferView;
import haveno.desktop.main.portfolio.editoffer.EditOfferView;
import haveno.desktop.main.portfolio.failedtrades.FailedTradesView;
import haveno.desktop.main.portfolio.openoffer.OpenOffersView;
import haveno.desktop.main.portfolio.pendingtrades.PendingTradesView;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.collections.ListChangeListener;
import javafx.fxml.FXML;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javax.annotation.Nullable;

@FxmlView
public class PortfolioView
extends ActivatableView<TabPane, Void> {
    @FXML
    Tab openOffersTab;
    @FXML
    Tab pendingTradesTab;
    @FXML
    Tab closedTradesTab;
    private Tab editOpenOfferTab;
    private Tab duplicateOfferTab;
    private Tab cloneOpenOfferTab;
    private final Tab failedTradesTab = new Tab(Res.get((String)"portfolio.tab.failed"));
    private Tab currentTab;
    private Navigation.Listener navigationListener;
    private ChangeListener<Tab> tabChangeListener;
    private ListChangeListener<Tab> tabListChangeListener;
    private final CachingViewLoader viewLoader;
    private final Navigation navigation;
    private final FailedTradesManager failedTradesManager;
    private EditOfferView editOfferView;
    private DuplicateOfferView duplicateOfferView;
    private CloneOfferView cloneOfferView;
    private boolean editOpenOfferViewOpen;
    private boolean cloneOpenOfferViewOpen;
    private OpenOffer openOffer;
    private OpenOffersView openOffersView;
    private boolean tabListChangeListenerAdded = false;

    @Inject
    public PortfolioView(CachingViewLoader viewLoader, Navigation navigation, FailedTradesManager failedTradesManager) {
        this.viewLoader = viewLoader;
        this.navigation = navigation;
        this.failedTradesManager = failedTradesManager;
    }

    @Override
    public void initialize() {
        ((TabPane)this.root).setTabClosingPolicy(TabPane.TabClosingPolicy.ALL_TABS);
        this.failedTradesTab.setClosable(false);
        this.openOffersTab.setText(Res.get((String)"portfolio.tab.openOffers"));
        this.pendingTradesTab.setText(Res.get((String)"portfolio.tab.pendingTrades"));
        this.closedTradesTab.setText(Res.get((String)"portfolio.tab.history"));
        this.navigationListener = (viewPath, data) -> {
            if (viewPath.size() == 3 && viewPath.indexOf(PortfolioView.class) == 1) {
                this.loadView(viewPath.tip(), data);
            }
        };
        this.tabChangeListener = (ov, oldValue, newValue) -> {
            if (newValue == this.openOffersTab) {
                this.navigation.navigateTo(MainView.class, PortfolioView.class, OpenOffersView.class);
            } else if (newValue == this.pendingTradesTab) {
                this.navigation.navigateTo(MainView.class, PortfolioView.class, PendingTradesView.class);
            } else if (newValue == this.closedTradesTab) {
                this.navigation.navigateTo(MainView.class, PortfolioView.class, ClosedTradesView.class);
            } else if (newValue == this.failedTradesTab) {
                this.navigation.navigateTo(MainView.class, PortfolioView.class, FailedTradesView.class);
            } else if (newValue == this.editOpenOfferTab) {
                this.navigation.navigateTo(MainView.class, PortfolioView.class, EditOfferView.class);
            } else if (newValue == this.duplicateOfferTab) {
                this.navigation.navigateTo(MainView.class, PortfolioView.class, DuplicateOfferView.class);
            } else if (newValue == this.cloneOpenOfferTab) {
                this.navigation.navigateTo(MainView.class, PortfolioView.class, CloneOfferView.class);
            }
            if (oldValue != null && oldValue == this.editOpenOfferTab) {
                this.editOfferView.onTabSelected(false);
            }
            if (oldValue != null && oldValue == this.duplicateOfferTab) {
                this.duplicateOfferView.onTabSelected(false);
            }
            if (oldValue != null && oldValue == this.cloneOpenOfferTab) {
                this.cloneOfferView.onTabSelected(false);
            }
        };
        this.tabListChangeListener = change -> {
            change.next();
            List removedTabs = change.getRemoved();
            if (removedTabs.size() == 1 && ((Tab)removedTabs.get(0)).equals(this.editOpenOfferTab)) {
                this.onEditOpenOfferRemoved();
            }
            if (removedTabs.size() == 1 && ((Tab)removedTabs.get(0)).equals(this.duplicateOfferTab)) {
                this.onDuplicateOfferRemoved();
            }
            if (removedTabs.size() == 1 && ((Tab)removedTabs.get(0)).equals(this.cloneOpenOfferTab)) {
                this.onCloneOpenOfferRemoved();
            }
        };
    }

    private void onEditOpenOfferRemoved() {
        this.editOpenOfferViewOpen = false;
        if (this.editOfferView != null) {
            this.editOfferView.onClose();
            this.editOfferView = null;
        }
        this.navigation.navigateTo(MainView.class, this.getClass(), OpenOffersView.class);
    }

    private void onDuplicateOfferRemoved() {
        if (this.duplicateOfferView != null) {
            this.duplicateOfferView.onClose();
            this.duplicateOfferView = null;
        }
        this.navigation.navigateTo(MainView.class, this.getClass(), OpenOffersView.class);
    }

    private void onCloneOpenOfferRemoved() {
        this.cloneOpenOfferViewOpen = false;
        if (this.cloneOfferView != null) {
            this.cloneOfferView.onClose();
            this.cloneOfferView = null;
        }
        this.navigation.navigateTo(MainView.class, this.getClass(), OpenOffersView.class);
    }

    @Override
    protected void activate() {
        this.failedTradesManager.getObservableList().addListener(c -> UserThread.execute(() -> {
            if (this.failedTradesManager.getObservableList().size() > 0 && ((TabPane)this.root).getTabs().size() == 3) {
                ((TabPane)this.root).getTabs().add((Object)this.failedTradesTab);
            }
        }));
        if (this.failedTradesManager.getObservableList().size() > 0 && ((TabPane)this.root).getTabs().size() == 3) {
            ((TabPane)this.root).getTabs().add((Object)this.failedTradesTab);
        }
        ((TabPane)this.root).getSelectionModel().selectedItemProperty().addListener(this.tabChangeListener);
        if (!this.tabListChangeListenerAdded) {
            ((TabPane)this.root).getTabs().addListener(this.tabListChangeListener);
            this.tabListChangeListenerAdded = true;
        }
        this.navigation.addListener(this.navigationListener);
        if (((TabPane)this.root).getSelectionModel().getSelectedItem() == this.openOffersTab) {
            this.navigation.navigateTo(MainView.class, PortfolioView.class, OpenOffersView.class);
        } else if (((TabPane)this.root).getSelectionModel().getSelectedItem() == this.pendingTradesTab) {
            this.navigation.navigateTo(MainView.class, PortfolioView.class, PendingTradesView.class);
        } else if (((TabPane)this.root).getSelectionModel().getSelectedItem() == this.closedTradesTab) {
            this.navigation.navigateTo(MainView.class, PortfolioView.class, ClosedTradesView.class);
        } else if (((TabPane)this.root).getSelectionModel().getSelectedItem() == this.failedTradesTab) {
            this.navigation.navigateTo(MainView.class, PortfolioView.class, FailedTradesView.class);
        } else if (((TabPane)this.root).getSelectionModel().getSelectedItem() == this.editOpenOfferTab) {
            this.navigation.navigateTo(MainView.class, PortfolioView.class, EditOfferView.class);
            if (this.editOfferView != null) {
                this.editOfferView.onTabSelected(true);
            }
        } else if (((TabPane)this.root).getSelectionModel().getSelectedItem() == this.duplicateOfferTab) {
            this.navigation.navigateTo(MainView.class, PortfolioView.class, DuplicateOfferView.class);
            if (this.duplicateOfferView != null) {
                this.duplicateOfferView.onTabSelected(true);
            }
        } else if (((TabPane)this.root).getSelectionModel().getSelectedItem() == this.cloneOpenOfferTab) {
            this.navigation.navigateTo(MainView.class, PortfolioView.class, CloneOfferView.class);
            if (this.cloneOfferView != null) {
                this.cloneOfferView.onTabSelected(true);
            }
        }
    }

    @Override
    protected void deactivate() {
        ((TabPane)this.root).getSelectionModel().selectedItemProperty().removeListener(this.tabChangeListener);
        this.navigation.removeListener(this.navigationListener);
        this.currentTab = null;
    }

    private void loadView(Class<? extends View> viewClass, @Nullable Object data) {
        View view;
        if (this.currentTab != null) {
            this.currentTab.setContent(null);
        }
        if ((view = this.viewLoader.load(viewClass)) instanceof OpenOffersView) {
            this.selectOpenOffersView((OpenOffersView)view);
        } else if (view instanceof PendingTradesView) {
            this.currentTab = this.pendingTradesTab;
        } else if (view instanceof ClosedTradesView) {
            this.currentTab = this.closedTradesTab;
        } else if (view instanceof FailedTradesView) {
            this.currentTab = this.failedTradesTab;
        } else if (view instanceof EditOfferView) {
            if (data instanceof OpenOffer) {
                this.openOffer = (OpenOffer)data;
            }
            if (this.openOffer != null) {
                if (this.editOfferView == null) {
                    this.editOfferView = (EditOfferView)view;
                    this.editOfferView.applyOpenOffer(this.openOffer);
                    this.editOpenOfferTab = new Tab(Res.get((String)"portfolio.tab.editOpenOffer").toUpperCase());
                    this.editOfferView.setCloseHandler(() -> UserThread.execute(() -> ((TabPane)this.root).getTabs().remove((Object)this.editOpenOfferTab)));
                    ((TabPane)this.root).getTabs().add((Object)this.editOpenOfferTab);
                }
                if (this.currentTab != this.editOpenOfferTab) {
                    this.editOfferView.onTabSelected(true);
                }
                this.currentTab = this.editOpenOfferTab;
            } else {
                view = this.viewLoader.load(OpenOffersView.class);
                this.selectOpenOffersView((OpenOffersView)view);
            }
        } else if (view instanceof DuplicateOfferView) {
            if (this.duplicateOfferView == null && data instanceof OfferPayload && data != null) {
                this.viewLoader.removeFromCache(viewClass);
                view = this.viewLoader.load(viewClass);
                this.duplicateOfferView = (DuplicateOfferView)view;
                this.duplicateOfferView.initWithData((OfferPayload)data);
                this.duplicateOfferTab = new Tab(Res.get((String)"portfolio.tab.duplicateOffer").toUpperCase());
                this.duplicateOfferView.setCloseHandler(() -> UserThread.execute(() -> ((TabPane)this.root).getTabs().remove((Object)this.duplicateOfferTab)));
                ((TabPane)this.root).getTabs().add((Object)this.duplicateOfferTab);
            }
            if (this.duplicateOfferView != null) {
                if (this.currentTab != this.duplicateOfferTab) {
                    this.duplicateOfferView.onTabSelected(true);
                }
                this.currentTab = this.duplicateOfferTab;
            } else {
                view = this.viewLoader.load(OpenOffersView.class);
                this.selectOpenOffersView((OpenOffersView)view);
            }
        } else if (view instanceof CloneOfferView) {
            if (data instanceof OpenOffer) {
                this.openOffer = (OpenOffer)data;
            }
            if (this.openOffer != null) {
                if (this.cloneOfferView == null) {
                    this.cloneOfferView = (CloneOfferView)view;
                    this.cloneOfferView.applyOpenOffer(this.openOffer);
                    this.cloneOpenOfferTab = new Tab(Res.get((String)"portfolio.tab.cloneOpenOffer").toUpperCase());
                    this.cloneOfferView.setCloseHandler(() -> ((TabPane)this.root).getTabs().remove((Object)this.cloneOpenOfferTab));
                    ((TabPane)this.root).getTabs().add((Object)this.cloneOpenOfferTab);
                }
                if (this.currentTab != this.cloneOpenOfferTab) {
                    this.cloneOfferView.onTabSelected(true);
                }
                this.currentTab = this.cloneOpenOfferTab;
            } else {
                view = this.viewLoader.load(OpenOffersView.class);
                this.selectOpenOffersView((OpenOffersView)view);
            }
        }
        this.currentTab.setContent(view.getRoot());
        ((TabPane)this.root).getSelectionModel().select((Object)this.currentTab);
    }

    private void selectOpenOffersView(OpenOffersView view) {
        this.openOffersView = view;
        this.currentTab = this.openOffersTab;
        EditOpenOfferHandler editOpenOfferHandler = openOffer -> {
            if (!this.editOpenOfferViewOpen) {
                this.editOpenOfferViewOpen = true;
                this.openOffer = openOffer;
                this.navigation.navigateTo(MainView.class, this.getClass(), EditOfferView.class);
            } else {
                ((Popup)new Popup().warning(Res.get((String)"editOffer.openTabWarning"))).show();
            }
        };
        this.openOffersView.setEditOpenOfferHandler(editOpenOfferHandler);
        CloneOpenOfferHandler cloneOpenOfferHandler = openOffer -> {
            if (!this.cloneOpenOfferViewOpen) {
                this.cloneOpenOfferViewOpen = true;
                this.openOffer = openOffer;
                this.navigation.navigateTo(MainView.class, this.getClass(), CloneOfferView.class);
            } else {
                ((Popup)new Popup().warning(Res.get((String)"cloneOffer.openTabWarning"))).show();
            }
        };
        this.openOffersView.setCloneOpenOfferHandler(cloneOpenOfferHandler);
    }

    public static interface EditOpenOfferHandler {
        public void onEditOpenOffer(OpenOffer var1);
    }

    public static interface CloneOpenOfferHandler {
        public void onCloneOpenOffer(OpenOffer var1);
    }
}

