/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.overlays.windows.downloadupdate;

import com.google.common.collect.Lists;
import haveno.desktop.main.overlays.windows.downloadupdate.HavenoInstaller;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Scanner;
import java.util.stream.Collectors;
import javafx.concurrent.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerifyTask
extends Task<List<HavenoInstaller.VerifyDescriptor>> {
    private static final Logger log = LoggerFactory.getLogger(VerifyTask.class);
    private final List<HavenoInstaller.FileDescriptor> fileDescriptors;

    public VerifyTask(List<HavenoInstaller.FileDescriptor> fileDescriptors) {
        this.fileDescriptors = fileDescriptors;
        log.info("Starting VerifyTask with files:{}", fileDescriptors);
    }

    protected List<HavenoInstaller.VerifyDescriptor> call() {
        log.debug("VerifyTask started...");
        Optional<HavenoInstaller.FileDescriptor> installer = this.fileDescriptors.stream().filter(fileDescriptor -> HavenoInstaller.DownloadType.INSTALLER.equals((Object)fileDescriptor.getType())).findFirst();
        if (!installer.isPresent()) {
            log.error("No installer file found.");
            return Lists.newArrayList();
        }
        Optional<HavenoInstaller.FileDescriptor> signingKeyOptional = this.fileDescriptors.stream().filter(fileDescriptor -> HavenoInstaller.DownloadType.SIGNING_KEY.equals((Object)fileDescriptor.getType())).findAny();
        ArrayList verifyDescriptors = Lists.newArrayList();
        if (signingKeyOptional.isPresent()) {
            HavenoInstaller.FileDescriptor signingKeyFD = signingKeyOptional.get();
            StringBuilder sb = new StringBuilder();
            try {
                Scanner scanner = new Scanner(new FileReader(signingKeyFD.getSaveFile()));
                while (scanner.hasNext()) {
                    sb.append(scanner.next());
                }
                scanner.close();
            }
            catch (Exception e) {
                log.error(e.toString());
                e.printStackTrace();
                HavenoInstaller.VerifyDescriptor.VerifyDescriptorBuilder verifyDescriptorBuilder = HavenoInstaller.VerifyDescriptor.builder();
                verifyDescriptorBuilder.verifyStatusEnum(HavenoInstaller.VerifyStatusEnum.FAIL);
                verifyDescriptors.add(verifyDescriptorBuilder.build());
                return verifyDescriptors;
            }
            String signingKey = sb.toString();
            List sigs = this.fileDescriptors.stream().filter(fileDescriptor -> HavenoInstaller.DownloadType.SIG.equals((Object)fileDescriptor.getType())).collect(Collectors.toList());
            for (HavenoInstaller.FileDescriptor sig : sigs) {
                HavenoInstaller.VerifyDescriptor.VerifyDescriptorBuilder verifyDescriptorBuilder = HavenoInstaller.VerifyDescriptor.builder().sigFile(sig.getSaveFile());
                List keys = this.fileDescriptors.stream().filter(keyDescriptor -> HavenoInstaller.DownloadType.KEY.equals((Object)keyDescriptor.getType())).filter(keyDescriptor -> sig.getId().equals(keyDescriptor.getId())).collect(Collectors.toList());
                for (HavenoInstaller.FileDescriptor key : keys) {
                    if (signingKey.equals(key.getId())) {
                        verifyDescriptorBuilder.keyFile(key.getSaveFile());
                        try {
                            verifyDescriptorBuilder.verifyStatusEnum(HavenoInstaller.verifySignature(key.getSaveFile(), sig.getSaveFile(), installer.get().getSaveFile()));
                            this.updateMessage(key.getFileName());
                        }
                        catch (Exception e) {
                            verifyDescriptorBuilder.verifyStatusEnum(HavenoInstaller.VerifyStatusEnum.FAIL);
                            log.error(e.toString());
                            e.printStackTrace();
                        }
                        verifyDescriptors.add(verifyDescriptorBuilder.build());
                        continue;
                    }
                    log.trace("key not matching the defined in signingKey. We try the next.");
                }
            }
        } else {
            log.error("signingKey is not found");
            HavenoInstaller.VerifyDescriptor.VerifyDescriptorBuilder verifyDescriptorBuilder = HavenoInstaller.VerifyDescriptor.builder();
            verifyDescriptorBuilder.verifyStatusEnum(HavenoInstaller.VerifyStatusEnum.FAIL);
            verifyDescriptors.add(verifyDescriptorBuilder.build());
        }
        return verifyDescriptors;
    }

    public List<HavenoInstaller.FileDescriptor> getFileDescriptors() {
        return this.fileDescriptors;
    }
}

