/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.overlays.windows.downloadupdate;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import haveno.common.util.Utilities;
import haveno.desktop.main.overlays.windows.downloadupdate.DownloadTask;
import haveno.desktop.main.overlays.windows.downloadupdate.VerifyTask;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.bc.BcPGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HavenoInstaller {
    private static final Logger log = LoggerFactory.getLogger(HavenoInstaller.class);
    private static final String FINGER_PRINT_MANFRED_KARRER = "F379A1C6";
    private static final String FINGER_PRINT_CHRIS_BEAMS = "5BC5ED73";
    private static final String FINGER_PRINT_CHRISTOPH_ATTENEDER = "29CDFD3B";
    private static final String PUB_KEY_HOSTING_URL = "https://haveno.exchange/pubkey/";
    private static final String DOWNLOAD_HOST_URL = "https://haveno.exchange/downloads/";

    public boolean isSupportedOS() {
        return Utilities.isOSX() || Utilities.isWindows() || Utilities.isDebianLinux() || Utilities.isRedHatLinux();
    }

    public Optional<DownloadTask> download(String version) {
        String partialUrl = "https://haveno.exchange/downloads/v" + version + "/";
        FileDescriptor installerFileDescriptor = this.getInstallerDescriptor(version, partialUrl);
        FileDescriptor signingKeyDescriptor = this.getSigningKeyDescriptor(partialUrl);
        FileDescriptor jarHashDescriptor = this.getJarHashDescriptor(version, partialUrl);
        List<FileDescriptor> keyFileDescriptors = this.getKeyFileDescriptors();
        List<FileDescriptor> sigFileDescriptors = this.getSigFileDescriptors(installerFileDescriptor, keyFileDescriptors);
        ArrayList allFiles = Lists.newArrayList();
        allFiles.add(installerFileDescriptor);
        allFiles.add(signingKeyDescriptor);
        allFiles.add(jarHashDescriptor);
        allFiles.addAll(keyFileDescriptors);
        allFiles.addAll(sigFileDescriptors);
        return this.getDownloadTask(allFiles);
    }

    public VerifyTask verify(List<FileDescriptor> fileDescriptors) {
        VerifyTask verifyTask = new VerifyTask(fileDescriptors);
        new Thread((Runnable)((Object)verifyTask), "HavenoInstaller VerifyTask").start();
        return verifyTask;
    }

    private Optional<DownloadTask> getDownloadTask(List<FileDescriptor> fileDescriptors) {
        try {
            return Optional.of(HavenoInstaller.downloadFiles(fileDescriptors, Utilities.getDownloadOfHomeDir()));
        }
        catch (IOException exception) {
            return Optional.empty();
        }
    }

    private static DownloadTask downloadFiles(List<FileDescriptor> fileDescriptors, String saveDir) throws IOException {
        if (saveDir == null) {
            saveDir = Utilities.getDownloadOfHomeDir();
        }
        DownloadTask task = new DownloadTask(fileDescriptors, saveDir);
        new Thread((Runnable)((Object)task), "HavenoInstaller DownloadTask").start();
        return task;
    }

    public static VerifyStatusEnum verifySignature(File pubKeyFile, File sigFile, File dataFile) throws Exception {
        int bytesRead;
        PGPSignature pgpSignature;
        InputStream inputStream = PGPUtil.getDecoderStream((InputStream)new FileInputStream(pubKeyFile));
        PGPPublicKeyRingCollection publicKeyRingCollection = new PGPPublicKeyRingCollection(inputStream, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
        inputStream.close();
        Iterator iterator = publicKeyRingCollection.getKeyRings();
        if (!iterator.hasNext()) {
            throw new PGPException("Could not find public keyring in provided key file");
        }
        PGPPublicKeyRing pgpPublicKeyRing = (PGPPublicKeyRing)iterator.next();
        inputStream = PGPUtil.getDecoderStream((InputStream)new FileInputStream(sigFile));
        PGPObjectFactory pgpObjectFactory = new PGPObjectFactory(inputStream, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
        Object o = pgpObjectFactory.nextObject();
        if (o instanceof PGPSignatureList) {
            PGPSignatureList signatureList = (PGPSignatureList)o;
            Preconditions.checkArgument((!signatureList.isEmpty() ? 1 : 0) != 0, (Object)"signatureList must not be empty");
            pgpSignature = signatureList.get(0);
        } else if (o instanceof PGPSignature) {
            pgpSignature = (PGPSignature)o;
        } else {
            throw new SignatureException("Could not find signature in provided signature file");
        }
        inputStream.close();
        log.debug("KeyID used in signature: %X\n", (Object)pgpSignature.getKeyID());
        PGPPublicKey publicKey = pgpPublicKeyRing.getPublicKey(pgpSignature.getKeyID());
        if (publicKey == null) {
            return VerifyStatusEnum.FAIL;
        }
        log.debug("The ID of the selected key is %X\n", (Object)publicKey.getKeyID());
        pgpSignature.init((PGPContentVerifierBuilderProvider)new BcPGPContentVerifierBuilderProvider(), publicKey);
        byte[] data = new byte[1024];
        inputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(dataFile)));
        while ((bytesRead = inputStream.read(data, 0, 1024)) != -1) {
            pgpSignature.update(data, 0, bytesRead);
        }
        inputStream.close();
        boolean result = pgpSignature.verify();
        return result ? VerifyStatusEnum.OK : VerifyStatusEnum.FAIL;
    }

    @NotNull
    private FileDescriptor getInstallerDescriptor(String version, String partialUrl) {
        String fileName;
        String prefix = "Haveno-";
        if (Utilities.isOSX()) {
            fileName = prefix + version + ".dmg";
        } else if (Utilities.isWindows()) {
            fileName = prefix + Utilities.getOSArchitecture() + "bit-" + version + ".exe";
        } else if (Utilities.isDebianLinux()) {
            fileName = prefix + Utilities.getOSArchitecture() + "bit-" + version + ".deb";
        } else if (Utilities.isRedHatLinux()) {
            fileName = prefix + Utilities.getOSArchitecture() + "bit-" + version + ".rpm";
        } else {
            throw new RuntimeException("No suitable install package available for your OS.");
        }
        return FileDescriptor.builder().type(DownloadType.INSTALLER).fileName(fileName).id(fileName).loadUrl(partialUrl.concat(fileName)).build();
    }

    @NotNull
    private FileDescriptor getSigningKeyDescriptor(String url) {
        String fileName = "signingkey.asc";
        return FileDescriptor.builder().type(DownloadType.SIGNING_KEY).fileName(fileName).id(fileName).loadUrl(url.concat(fileName)).build();
    }

    @NotNull
    private FileDescriptor getJarHashDescriptor(String version, String partialUrl) {
        String fileName = "Haveno-" + version + ".jar.txt";
        return FileDescriptor.builder().type(DownloadType.JAR_HASH).fileName(fileName).id(fileName).loadUrl(partialUrl.concat(fileName)).build();
    }

    private List<FileDescriptor> getKeyFileDescriptors() {
        ArrayList<FileDescriptor> list = new ArrayList<FileDescriptor>();
        list.add(this.getKeyFileDescriptor(FINGER_PRINT_MANFRED_KARRER));
        list.add(this.getLocalKeyFileDescriptor(FINGER_PRINT_MANFRED_KARRER));
        list.add(this.getKeyFileDescriptor(FINGER_PRINT_CHRIS_BEAMS));
        list.add(this.getLocalKeyFileDescriptor(FINGER_PRINT_CHRIS_BEAMS));
        list.add(this.getKeyFileDescriptor(FINGER_PRINT_CHRISTOPH_ATTENEDER));
        list.add(this.getLocalKeyFileDescriptor(FINGER_PRINT_CHRISTOPH_ATTENEDER));
        return list;
    }

    private FileDescriptor getKeyFileDescriptor(String fingerPrint) {
        String fileName = fingerPrint + ".asc";
        return FileDescriptor.builder().type(DownloadType.KEY).fileName(fileName).id(fingerPrint).loadUrl(PUB_KEY_HOSTING_URL + fileName).build();
    }

    private FileDescriptor getLocalKeyFileDescriptor(String fingerPrint) {
        return FileDescriptor.builder().type(DownloadType.KEY).fileName(fingerPrint + ".asc-local").id(fingerPrint).loadUrl(this.getClass().getResource("/keys/" + fingerPrint + ".asc").toExternalForm()).build();
    }

    public List<FileDescriptor> getSigFileDescriptors(FileDescriptor installerFileDescriptor, List<FileDescriptor> keys) {
        String suffix = ".asc";
        ArrayList result = Lists.newArrayList();
        for (FileDescriptor key : keys) {
            if (result.stream().noneMatch(e -> e.getId().equals(key.getId()))) {
                result.add(FileDescriptor.builder().type(DownloadType.SIG).fileName(installerFileDescriptor.getFileName().concat(suffix)).id(key.getId()).loadUrl(installerFileDescriptor.getLoadUrl().concat(suffix)).build());
                continue;
            }
            log.debug("We have already a file with the key: {}", (Object)key.getId());
        }
        return result;
    }

    public static class FileDescriptor {
        private String id;
        private DownloadType type;
        private String loadUrl;
        private String fileName;
        private File saveFile;
        private DownloadStatusEnum downloadStatus;

        private static DownloadStatusEnum $default$downloadStatus() {
            return DownloadStatusEnum.UNKNOWN;
        }

        FileDescriptor(String id, DownloadType type, String loadUrl, String fileName, File saveFile, DownloadStatusEnum downloadStatus) {
            this.id = id;
            this.type = type;
            this.loadUrl = loadUrl;
            this.fileName = fileName;
            this.saveFile = saveFile;
            this.downloadStatus = downloadStatus;
        }

        public static FileDescriptorBuilder builder() {
            return new FileDescriptorBuilder();
        }

        public String getId() {
            return this.id;
        }

        public DownloadType getType() {
            return this.type;
        }

        public String getLoadUrl() {
            return this.loadUrl;
        }

        public String getFileName() {
            return this.fileName;
        }

        public File getSaveFile() {
            return this.saveFile;
        }

        public DownloadStatusEnum getDownloadStatus() {
            return this.downloadStatus;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setType(DownloadType type) {
            this.type = type;
        }

        public void setLoadUrl(String loadUrl) {
            this.loadUrl = loadUrl;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public void setSaveFile(File saveFile) {
            this.saveFile = saveFile;
        }

        public void setDownloadStatus(DownloadStatusEnum downloadStatus) {
            this.downloadStatus = downloadStatus;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FileDescriptor)) {
                return false;
            }
            FileDescriptor other = (FileDescriptor)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            DownloadType this$type = this.getType();
            DownloadType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            String this$loadUrl = this.getLoadUrl();
            String other$loadUrl = other.getLoadUrl();
            if (this$loadUrl == null ? other$loadUrl != null : !this$loadUrl.equals(other$loadUrl)) {
                return false;
            }
            String this$fileName = this.getFileName();
            String other$fileName = other.getFileName();
            if (this$fileName == null ? other$fileName != null : !this$fileName.equals(other$fileName)) {
                return false;
            }
            File this$saveFile = this.getSaveFile();
            File other$saveFile = other.getSaveFile();
            if (this$saveFile == null ? other$saveFile != null : !((Object)this$saveFile).equals(other$saveFile)) {
                return false;
            }
            DownloadStatusEnum this$downloadStatus = this.getDownloadStatus();
            DownloadStatusEnum other$downloadStatus = other.getDownloadStatus();
            return !(this$downloadStatus == null ? other$downloadStatus != null : !((Object)((Object)this$downloadStatus)).equals((Object)other$downloadStatus));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FileDescriptor;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            DownloadType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            String $loadUrl = this.getLoadUrl();
            result = result * 59 + ($loadUrl == null ? 43 : $loadUrl.hashCode());
            String $fileName = this.getFileName();
            result = result * 59 + ($fileName == null ? 43 : $fileName.hashCode());
            File $saveFile = this.getSaveFile();
            result = result * 59 + ($saveFile == null ? 43 : ((Object)$saveFile).hashCode());
            DownloadStatusEnum $downloadStatus = this.getDownloadStatus();
            result = result * 59 + ($downloadStatus == null ? 43 : ((Object)((Object)$downloadStatus)).hashCode());
            return result;
        }

        public String toString() {
            return "HavenoInstaller.FileDescriptor(id=" + this.getId() + ", type=" + String.valueOf((Object)this.getType()) + ", loadUrl=" + this.getLoadUrl() + ", fileName=" + this.getFileName() + ", saveFile=" + String.valueOf(this.getSaveFile()) + ", downloadStatus=" + String.valueOf((Object)this.getDownloadStatus()) + ")";
        }

        public static class FileDescriptorBuilder {
            private String id;
            private DownloadType type;
            private String loadUrl;
            private String fileName;
            private File saveFile;
            private boolean downloadStatus$set;
            private DownloadStatusEnum downloadStatus$value;

            FileDescriptorBuilder() {
            }

            public FileDescriptorBuilder id(String id) {
                this.id = id;
                return this;
            }

            public FileDescriptorBuilder type(DownloadType type) {
                this.type = type;
                return this;
            }

            public FileDescriptorBuilder loadUrl(String loadUrl) {
                this.loadUrl = loadUrl;
                return this;
            }

            public FileDescriptorBuilder fileName(String fileName) {
                this.fileName = fileName;
                return this;
            }

            public FileDescriptorBuilder saveFile(File saveFile) {
                this.saveFile = saveFile;
                return this;
            }

            public FileDescriptorBuilder downloadStatus(DownloadStatusEnum downloadStatus) {
                this.downloadStatus$value = downloadStatus;
                this.downloadStatus$set = true;
                return this;
            }

            public FileDescriptor build() {
                DownloadStatusEnum downloadStatus$value = this.downloadStatus$value;
                if (!this.downloadStatus$set) {
                    downloadStatus$value = FileDescriptor.$default$downloadStatus();
                }
                return new FileDescriptor(this.id, this.type, this.loadUrl, this.fileName, this.saveFile, downloadStatus$value);
            }

            public String toString() {
                return "HavenoInstaller.FileDescriptor.FileDescriptorBuilder(id=" + this.id + ", type=" + String.valueOf((Object)this.type) + ", loadUrl=" + this.loadUrl + ", fileName=" + this.fileName + ", saveFile=" + String.valueOf(this.saveFile) + ", downloadStatus$value=" + String.valueOf((Object)this.downloadStatus$value) + ")";
            }
        }
    }

    public static enum VerifyStatusEnum {
        OK,
        FAIL,
        UNKNOWN;

    }

    public static enum DownloadType {
        INSTALLER,
        KEY,
        SIG,
        SIGNING_KEY,
        MISC,
        JAR_HASH;

    }

    public static enum DownloadStatusEnum {
        OK,
        FAIL,
        TIMEOUT,
        UNKNOWN;

    }

    public static class VerifyDescriptor {
        private File keyFile;
        private File sigFile;
        private VerifyStatusEnum verifyStatusEnum;

        private static VerifyStatusEnum $default$verifyStatusEnum() {
            return VerifyStatusEnum.UNKNOWN;
        }

        VerifyDescriptor(File keyFile, File sigFile, VerifyStatusEnum verifyStatusEnum) {
            this.keyFile = keyFile;
            this.sigFile = sigFile;
            this.verifyStatusEnum = verifyStatusEnum;
        }

        public static VerifyDescriptorBuilder builder() {
            return new VerifyDescriptorBuilder();
        }

        public File getKeyFile() {
            return this.keyFile;
        }

        public File getSigFile() {
            return this.sigFile;
        }

        public VerifyStatusEnum getVerifyStatusEnum() {
            return this.verifyStatusEnum;
        }

        public void setKeyFile(File keyFile) {
            this.keyFile = keyFile;
        }

        public void setSigFile(File sigFile) {
            this.sigFile = sigFile;
        }

        public void setVerifyStatusEnum(VerifyStatusEnum verifyStatusEnum) {
            this.verifyStatusEnum = verifyStatusEnum;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VerifyDescriptor)) {
                return false;
            }
            VerifyDescriptor other = (VerifyDescriptor)o;
            if (!other.canEqual(this)) {
                return false;
            }
            File this$keyFile = this.getKeyFile();
            File other$keyFile = other.getKeyFile();
            if (this$keyFile == null ? other$keyFile != null : !((Object)this$keyFile).equals(other$keyFile)) {
                return false;
            }
            File this$sigFile = this.getSigFile();
            File other$sigFile = other.getSigFile();
            if (this$sigFile == null ? other$sigFile != null : !((Object)this$sigFile).equals(other$sigFile)) {
                return false;
            }
            VerifyStatusEnum this$verifyStatusEnum = this.getVerifyStatusEnum();
            VerifyStatusEnum other$verifyStatusEnum = other.getVerifyStatusEnum();
            return !(this$verifyStatusEnum == null ? other$verifyStatusEnum != null : !((Object)((Object)this$verifyStatusEnum)).equals((Object)other$verifyStatusEnum));
        }

        protected boolean canEqual(Object other) {
            return other instanceof VerifyDescriptor;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            File $keyFile = this.getKeyFile();
            result = result * 59 + ($keyFile == null ? 43 : ((Object)$keyFile).hashCode());
            File $sigFile = this.getSigFile();
            result = result * 59 + ($sigFile == null ? 43 : ((Object)$sigFile).hashCode());
            VerifyStatusEnum $verifyStatusEnum = this.getVerifyStatusEnum();
            result = result * 59 + ($verifyStatusEnum == null ? 43 : ((Object)((Object)$verifyStatusEnum)).hashCode());
            return result;
        }

        public String toString() {
            return "HavenoInstaller.VerifyDescriptor(keyFile=" + String.valueOf(this.getKeyFile()) + ", sigFile=" + String.valueOf(this.getSigFile()) + ", verifyStatusEnum=" + String.valueOf((Object)this.getVerifyStatusEnum()) + ")";
        }

        public static class VerifyDescriptorBuilder {
            private File keyFile;
            private File sigFile;
            private boolean verifyStatusEnum$set;
            private VerifyStatusEnum verifyStatusEnum$value;

            VerifyDescriptorBuilder() {
            }

            public VerifyDescriptorBuilder keyFile(File keyFile) {
                this.keyFile = keyFile;
                return this;
            }

            public VerifyDescriptorBuilder sigFile(File sigFile) {
                this.sigFile = sigFile;
                return this;
            }

            public VerifyDescriptorBuilder verifyStatusEnum(VerifyStatusEnum verifyStatusEnum) {
                this.verifyStatusEnum$value = verifyStatusEnum;
                this.verifyStatusEnum$set = true;
                return this;
            }

            public VerifyDescriptor build() {
                VerifyStatusEnum verifyStatusEnum$value = this.verifyStatusEnum$value;
                if (!this.verifyStatusEnum$set) {
                    verifyStatusEnum$value = VerifyDescriptor.$default$verifyStatusEnum();
                }
                return new VerifyDescriptor(this.keyFile, this.sigFile, verifyStatusEnum$value);
            }

            public String toString() {
                return "HavenoInstaller.VerifyDescriptor.VerifyDescriptorBuilder(keyFile=" + String.valueOf(this.keyFile) + ", sigFile=" + String.valueOf(this.sigFile) + ", verifyStatusEnum$value=" + String.valueOf((Object)this.verifyStatusEnum$value) + ")";
            }
        }
    }
}

