/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.overlays.windows.downloadupdate;

import com.google.common.collect.Lists;
import haveno.common.file.FileUtil;
import haveno.desktop.main.overlays.windows.downloadupdate.HavenoInstaller;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.stream.Collectors;
import javafx.concurrent.Task;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadTask
extends Task<List<HavenoInstaller.FileDescriptor>> {
    private static final Logger log = LoggerFactory.getLogger(DownloadTask.class);
    private static final int EOF = -1;
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private String fileName = null;
    private final List<HavenoInstaller.FileDescriptor> fileDescriptors;
    private final String saveDir;

    public DownloadTask(HavenoInstaller.FileDescriptor fileDescriptor) {
        this(Lists.newArrayList((Object[])new HavenoInstaller.FileDescriptor[]{fileDescriptor}));
    }

    public DownloadTask(HavenoInstaller.FileDescriptor fileDescriptor, String saveDir) {
        this(Lists.newArrayList((Object[])new HavenoInstaller.FileDescriptor[]{fileDescriptor}), saveDir);
    }

    public DownloadTask(List<HavenoInstaller.FileDescriptor> fileDescriptors) {
        this(Lists.newArrayList(fileDescriptors), System.getProperty("java.io.tmpdir"));
    }

    public DownloadTask(List<HavenoInstaller.FileDescriptor> fileDescriptors, String saveDir) {
        this.fileDescriptors = fileDescriptors;
        this.saveDir = saveDir;
        log.info("Starting DownloadTask with file:{}, saveDir:{}, nr of files: {}", new Object[]{fileDescriptors, saveDir, fileDescriptors.size()});
    }

    protected List<HavenoInstaller.FileDescriptor> call() throws IOException {
        log.debug("DownloadTask started...");
        String partialSaveFilePath = this.saveDir + (this.saveDir.endsWith(File.separator) ? "" : File.separator);
        return this.fileDescriptors.stream().map(fileDescriptor -> {
            fileDescriptor.setSaveFile(new File(partialSaveFilePath + fileDescriptor.getFileName()));
            log.info("Downloading {}", (Object)fileDescriptor.getLoadUrl());
            try {
                this.updateMessage(fileDescriptor.getFileName());
                this.download(new URL(fileDescriptor.getLoadUrl()), fileDescriptor.getSaveFile());
                log.info("Download for {} done", (Object)fileDescriptor.getLoadUrl());
                fileDescriptor.setDownloadStatus(HavenoInstaller.DownloadStatusEnum.OK);
            }
            catch (Exception e) {
                fileDescriptor.setDownloadStatus(HavenoInstaller.DownloadStatusEnum.FAIL);
                log.error("Error downloading file:" + fileDescriptor.toString(), (Throwable)e);
                e.printStackTrace();
            }
            return fileDescriptor;
        }).collect(Collectors.toList());
    }

    private void download(URL url, File outputFile) throws IOException {
        if (outputFile.exists()) {
            log.info("We found an existing file and rename it as *.backup.");
            FileUtil.renameFile((File)outputFile, (File)new File(outputFile.getAbsolutePath() + ".backup"));
        }
        URLConnection urlConnection = url.openConnection();
        urlConnection.connect();
        int fileSize = urlConnection.getContentLength();
        this.copyInputStreamToFileNew(urlConnection.getInputStream(), outputFile, fileSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyInputStreamToFileNew(InputStream source, File destination, int fileSize) throws IOException {
        try {
            FileOutputStream output = FileUtils.openOutputStream((File)destination);
            try {
                int n;
                byte[] buffer = new byte[4096];
                long count = 0L;
                while (-1 != (n = source.read(buffer))) {
                    output.write(buffer, 0, n);
                    log.trace("Progress: {}/{}", (Object)(count += (long)n), (Object)fileSize);
                    this.updateProgress(count, fileSize);
                }
                output.close();
            }
            finally {
                IOUtils.closeQuietly((OutputStream)output);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)source);
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public List<HavenoInstaller.FileDescriptor> getFileDescriptors() {
        return this.fileDescriptors;
    }

    public String getSaveDir() {
        return this.saveDir;
    }
}

