/*
 * Decompiled with CFR 0.152.
 */
package haveno.desktop.main.overlays.windows.downloadupdate;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import haveno.common.config.Config;
import haveno.common.util.Utilities;
import haveno.core.alert.Alert;
import haveno.core.locale.Res;
import haveno.desktop.components.AutoTooltipButton;
import haveno.desktop.components.AutoTooltipLabel;
import haveno.desktop.components.BusyAnimation;
import haveno.desktop.main.overlays.Overlay;
import haveno.desktop.main.overlays.popups.Popup;
import haveno.desktop.main.overlays.windows.downloadupdate.DownloadTask;
import haveno.desktop.main.overlays.windows.downloadupdate.HavenoInstaller;
import haveno.desktop.main.overlays.windows.downloadupdate.VerifyTask;
import haveno.desktop.util.FormBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Scanner;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.Separator;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisplayUpdateDownloadWindow
extends Overlay<DisplayUpdateDownloadWindow> {
    private static final Logger log = LoggerFactory.getLogger(DisplayUpdateDownloadWindow.class);
    private final Alert alert;
    private final Config config;
    private Optional<DownloadTask> downloadTaskOptional;
    private VerifyTask verifyTask;
    private ProgressBar progressBar;
    private BusyAnimation busyAnimation;

    public DisplayUpdateDownloadWindow(Alert alert, Config config) {
        this.alert = alert;
        this.config = config;
        this.type = Overlay.Type.Attention;
    }

    @Override
    public void show() {
        this.width = 968.0;
        this.createGridPane();
        this.information("");
        this.headLine = Res.get((String)"displayUpdateDownloadWindow.headline");
        this.addHeadLine();
        this.addContent();
        this.addButtons();
        this.applyStyles();
        this.display();
    }

    private void addContent() {
        Preconditions.checkNotNull((Object)this.alert, (Object)"alertMessage must not be null");
        FormBuilder.addMultilineLabel(this.gridPane, ++this.rowIndex, this.alert.getMessage(), 10.0);
        Separator separator = new Separator();
        separator.setMouseTransparent(true);
        separator.setOrientation(Orientation.HORIZONTAL);
        separator.getStyleClass().add((Object)"separator");
        GridPane.setHalignment((Node)separator, (HPos)HPos.CENTER);
        GridPane.setRowIndex((Node)separator, (Integer)(++this.rowIndex));
        GridPane.setColumnSpan((Node)separator, (Integer)2);
        GridPane.setMargin((Node)separator, (Insets)new Insets(20.0, 0.0, 20.0, 0.0));
        this.gridPane.getChildren().add((Object)separator);
        AutoTooltipButton downloadButton = new AutoTooltipButton(Res.get((String)"displayUpdateDownloadWindow.button.label"));
        downloadButton.getStyleClass().add((Object)"action-button");
        downloadButton.setDefaultButton(true);
        this.busyAnimation = new BusyAnimation(false);
        AutoTooltipLabel statusLabel = new AutoTooltipLabel();
        statusLabel.managedProperty().bind((ObservableValue)statusLabel.visibleProperty());
        HBox hBox = new HBox();
        hBox.setSpacing(10.0);
        hBox.setAlignment(Pos.CENTER_LEFT);
        hBox.getChildren().addAll((Object[])new Node[]{downloadButton, this.busyAnimation, statusLabel});
        GridPane.setRowIndex((Node)hBox, (Integer)(++this.rowIndex));
        GridPane.setColumnIndex((Node)hBox, (Integer)0);
        GridPane.setColumnSpan((Node)hBox, (Integer)2);
        this.gridPane.getChildren().add((Object)hBox);
        Label downloadingFileLabel = FormBuilder.addLabel(this.gridPane, ++this.rowIndex, Res.get((String)"displayUpdateDownloadWindow.downloadingFile", (Object[])new Object[]{""}));
        downloadingFileLabel.setOpacity(0.2);
        GridPane.setHalignment((Node)downloadingFileLabel, (HPos)HPos.LEFT);
        this.progressBar = new ProgressBar(0.0);
        this.progressBar.setMaxHeight(4.0);
        this.progressBar.managedProperty().bind((ObservableValue)this.progressBar.visibleProperty());
        GridPane.setRowIndex((Node)this.progressBar, (Integer)(++this.rowIndex));
        GridPane.setHalignment((Node)this.progressBar, (HPos)HPos.LEFT);
        GridPane.setFillWidth((Node)this.progressBar, (Boolean)true);
        this.gridPane.getChildren().add((Object)this.progressBar);
        String downloadedFilesLabelTitle = Res.get((String)"displayUpdateDownloadWindow.downloadedFiles");
        Label downloadedFilesLabel = FormBuilder.addLabel(this.gridPane, ++this.rowIndex, downloadedFilesLabelTitle);
        GridPane.setColumnIndex((Node)downloadedFilesLabel, (Integer)0);
        GridPane.setHalignment((Node)downloadedFilesLabel, (HPos)HPos.LEFT);
        GridPane.setColumnSpan((Node)downloadedFilesLabel, (Integer)2);
        downloadedFilesLabel.setOpacity(0.2);
        String verifiedSigLabelTitle = Res.get((String)"displayUpdateDownloadWindow.verifiedSigs");
        Label verifiedSigLabel = FormBuilder.addLabel(this.gridPane, ++this.rowIndex, verifiedSigLabelTitle);
        GridPane.setColumnIndex((Node)verifiedSigLabel, (Integer)0);
        GridPane.setColumnSpan((Node)verifiedSigLabel, (Integer)2);
        GridPane.setHalignment((Node)verifiedSigLabel, (HPos)HPos.LEFT);
        verifiedSigLabel.setOpacity(0.2);
        Separator separator2 = new Separator();
        separator2.setMouseTransparent(true);
        separator2.setOrientation(Orientation.HORIZONTAL);
        separator2.getStyleClass().add((Object)"separator");
        GridPane.setHalignment((Node)separator2, (HPos)HPos.CENTER);
        GridPane.setRowIndex((Node)separator2, (Integer)(++this.rowIndex));
        GridPane.setColumnSpan((Node)separator2, (Integer)2);
        GridPane.setMargin((Node)separator2, (Insets)new Insets(20.0, 0.0, 20.0, 0.0));
        this.gridPane.getChildren().add((Object)separator2);
        HavenoInstaller installer = new HavenoInstaller();
        String downloadFailedString = Res.get((String)"displayUpdateDownloadWindow.download.failed");
        downloadButton.setOnAction(arg_0 -> this.lambda$addContent$8(installer, (Button)downloadButton, downloadedFilesLabel, downloadingFileLabel, statusLabel, downloadedFilesLabelTitle, downloadFailedString, verifiedSigLabel, verifiedSigLabelTitle, arg_0));
    }

    private void copyJarHashToDataDir(HavenoInstaller.FileDescriptor fileDescriptor) {
        StringBuilder sb = new StringBuilder();
        File sourceFile = fileDescriptor.getSaveFile();
        try (Scanner scanner = new Scanner(new FileReader(sourceFile));){
            while (scanner.hasNext()) {
                sb.append(scanner.next());
            }
            scanner.close();
            String hashOfJar = sb.toString();
            Path path = Paths.get(this.config.appDataDir.getPath(), fileDescriptor.getFileName());
            String target = path.toString();
            try (PrintWriter writer = new PrintWriter(target, "UTF-8");){
                writer.println(hashOfJar);
                writer.close();
                log.info("Copied hash of jar from {} to {}", (Object)sourceFile.getAbsolutePath(), (Object)target);
            }
            catch (Exception e) {
                log.error(e.toString());
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            log.error(e.toString());
            e.printStackTrace();
        }
    }

    @Override
    protected void addButtons() {
        this.closeButton = new AutoTooltipButton(Res.get((String)"displayUpdateDownloadWindow.button.ignoreDownload"));
        this.closeButton.setOnAction(event -> this.doClose());
        this.actionButton = new AutoTooltipButton(Res.get((String)"displayUpdateDownloadWindow.button.downloadLater"));
        this.actionButton.setDefaultButton(false);
        this.actionButton.setOnAction(event -> {
            this.cleanup();
            this.hide();
            this.actionHandlerOptional.ifPresent(Runnable::run);
        });
        HBox hBox = new HBox();
        hBox.setSpacing(10.0);
        hBox.getChildren().addAll((Object[])new Node[]{this.closeButton, this.actionButton});
        GridPane.setHalignment((Node)hBox, (HPos)HPos.LEFT);
        GridPane.setRowIndex((Node)hBox, (Integer)(++this.rowIndex));
        GridPane.setColumnSpan((Node)hBox, (Integer)2);
        GridPane.setMargin((Node)hBox, (Insets)new Insets(this.buttonDistance, 0.0, 0.0, 0.0));
        this.gridPane.getChildren().add((Object)hBox);
    }

    @Override
    protected void setupKeyHandler(Scene scene) {
        if (!this.hideCloseButton) {
            scene.setOnKeyPressed(e -> {
                if (e.getCode() == KeyCode.ESCAPE || e.getCode() == KeyCode.ENTER) {
                    e.consume();
                    this.cleanup();
                    this.hide();
                    this.actionHandlerOptional.ifPresent(Runnable::run);
                }
            });
        }
    }

    @Override
    protected void doClose() {
        super.doClose();
        this.cleanup();
        this.stopAnimations();
        this.hide();
        this.closeHandlerOptional.ifPresent(Runnable::run);
    }

    @Override
    protected void cleanup() {
        super.cleanup();
        if (this.verifyTask != null && this.verifyTask.isRunning()) {
            this.verifyTask.cancel();
        }
        if (this.downloadTaskOptional != null && this.downloadTaskOptional.isPresent() && this.downloadTaskOptional.get().isRunning()) {
            this.downloadTaskOptional.get().cancel();
        }
    }

    private void showErrorMessage(Button downloadButton, Label statusLabel, String errorMsg) {
        statusLabel.setText("");
        this.stopAnimations();
        downloadButton.setDisable(false);
        ((Popup)((Popup)((Popup)new Popup().headLine(Res.get((String)"displayUpdateDownloadWindow.download.failed.headline"))).feedback(errorMsg)).onClose(this::doClose)).show();
    }

    private void stopAnimations() {
        if (this.progressBar != null) {
            this.progressBar.progressProperty().unbind();
            this.progressBar.setProgress(0.0);
        }
        if (this.busyAnimation != null) {
            this.busyAnimation.stop();
        }
    }

    private /* synthetic */ void lambda$addContent$8(HavenoInstaller installer, Button downloadButton, Label downloadedFilesLabel, Label downloadingFileLabel, Label statusLabel, String downloadedFilesLabelTitle, String downloadFailedString, Label verifiedSigLabel, String verifiedSigLabelTitle, ActionEvent e) {
        if (installer.isSupportedOS()) {
            ArrayList downloadedFiles = new ArrayList();
            ArrayList verifiedSigs = new ArrayList();
            downloadButton.setDisable(true);
            this.progressBar.setVisible(true);
            downloadedFilesLabel.setOpacity(1.0);
            downloadingFileLabel.setOpacity(1.0);
            this.busyAnimation.play();
            statusLabel.setText(Res.get((String)"displayUpdateDownloadWindow.status.downloading"));
            this.downloadTaskOptional = installer.download(this.alert.getVersion());
            if (this.downloadTaskOptional.isPresent()) {
                DownloadTask downloadTask = this.downloadTaskOptional.get();
                ChangeListener downloadedFilesListener = (observable, oldValue, newValue) -> {
                    if (!newValue.endsWith("-local")) {
                        downloadingFileLabel.setText(Res.get((String)"displayUpdateDownloadWindow.downloadingFile", (Object[])new Object[]{newValue}));
                        downloadedFilesLabel.setText(downloadedFilesLabelTitle + " " + Joiner.on((String)", ").join((Iterable)downloadedFiles));
                        downloadedFiles.add(newValue);
                    }
                };
                downloadTask.messageProperty().addListener(downloadedFilesListener);
                this.progressBar.progressProperty().unbind();
                this.progressBar.progressProperty().bind((ObservableValue)downloadTask.progressProperty());
                downloadTask.setOnSucceeded(workerStateEvent -> {
                    downloadedFilesLabel.setText(downloadedFilesLabelTitle + " " + Joiner.on((String)", ").join((Iterable)downloadedFiles));
                    downloadTask.messageProperty().removeListener(downloadedFilesListener);
                    this.progressBar.setVisible(false);
                    downloadingFileLabel.setText("");
                    downloadingFileLabel.setOpacity(0.2);
                    statusLabel.setText(Res.get((String)"displayUpdateDownloadWindow.status.verifying"));
                    List downloadResults = (List)downloadTask.getValue();
                    Optional<HavenoInstaller.FileDescriptor> downloadFailed = downloadResults.stream().filter(fileDescriptor -> !HavenoInstaller.DownloadStatusEnum.OK.equals((Object)fileDescriptor.getDownloadStatus())).findFirst();
                    downloadedFilesLabel.getStyleClass().removeAll((Object[])new String[]{"error-text", "success-text"});
                    if (downloadResults == null || downloadResults.isEmpty() || downloadFailed.isPresent()) {
                        this.showErrorMessage(downloadButton, statusLabel, downloadFailedString);
                        downloadedFilesLabel.getStyleClass().add((Object)"error-text");
                    } else {
                        log.debug("Download completed successfully.");
                        downloadedFilesLabel.getStyleClass().add((Object)"success-text");
                        downloadTask.getFileDescriptors().stream().filter(fileDescriptor -> fileDescriptor.getType() == HavenoInstaller.DownloadType.JAR_HASH).findFirst().ifPresent(this::copyJarHashToDataDir);
                        this.verifyTask = installer.verify(downloadResults);
                        verifiedSigLabel.setOpacity(1.0);
                        ChangeListener verifiedSigLabelListener = (observable, oldValue, newValue) -> {
                            verifiedSigs.add(newValue);
                            verifiedSigLabel.setText(verifiedSigLabelTitle + " " + Joiner.on((String)", ").join((Iterable)verifiedSigs));
                        };
                        this.verifyTask.messageProperty().addListener(verifiedSigLabelListener);
                        this.verifyTask.setOnSucceeded(event -> {
                            this.verifyTask.messageProperty().removeListener(verifiedSigLabelListener);
                            statusLabel.setText("");
                            this.stopAnimations();
                            List verifyResults = (List)this.verifyTask.getValue();
                            Optional<HavenoInstaller.VerifyDescriptor> verifyFailed = verifyResults.stream().filter(verifyDescriptor -> !HavenoInstaller.VerifyStatusEnum.OK.equals((Object)verifyDescriptor.getVerifyStatusEnum())).findFirst();
                            if (verifyResults == null || verifyResults.isEmpty() || verifyFailed.isPresent()) {
                                this.showErrorMessage(downloadButton, statusLabel, Res.get((String)"displayUpdateDownloadWindow.verify.failed"));
                            } else {
                                verifiedSigLabel.getStyleClass().add((Object)"success-text");
                                ((Popup)((Popup)((Popup)((Popup)new Popup().feedback(Res.get((String)"displayUpdateDownloadWindow.success"))).actionButtonText(Res.get((String)"displayUpdateDownloadWindow.download.openDir"))).onAction(() -> {
                                    try {
                                        Utilities.openFile((File)new File(Utilities.getDownloadOfHomeDir()));
                                        this.doClose();
                                    }
                                    catch (IOException e2) {
                                        log.error(e2.getMessage());
                                        e2.printStackTrace();
                                    }
                                })).onClose(this::doClose)).show();
                                log.info("Download & verification succeeded.");
                            }
                        });
                    }
                });
            } else {
                this.showErrorMessage(downloadButton, statusLabel, downloadFailedString);
            }
        } else {
            this.showErrorMessage(downloadButton, statusLabel, Res.get((String)"displayUpdateDownloadWindow.installer.failed"));
        }
    }
}

